/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.rest.util;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ILoadRule;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.internal.load.LoadLocation;
import com.ibm.team.filesystem.client.internal.rest.CommonUtil;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.operations.ICollision;
import com.ibm.team.filesystem.client.operations.IInvalidLoadRequest;
import com.ibm.team.filesystem.client.operations.ILoadLocation;
import com.ibm.team.filesystem.client.operations.ILoadOperation;
import com.ibm.team.filesystem.client.operations.ILoadOverlap;
import com.ibm.team.filesystem.client.operations.IRemovedShare;
import com.ibm.team.filesystem.client.operations.IShareOutOfSync;
import com.ibm.team.filesystem.client.operations.IShareableToLoad;
import com.ibm.team.filesystem.client.operations.LoadDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsLoad;
import com.ibm.team.filesystem.client.rest.parameters.ParmsLoadRule;
import com.ibm.team.filesystem.client.rest.parameters.ParmsUnload;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspaceComponent;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.internal.rest.client.core.ShareDTO;
import com.ibm.team.filesystem.common.internal.rest.client.load.CollisionDTO;
import com.ibm.team.filesystem.common.internal.rest.client.load.FilesystemRestClientDTOloadFactory;
import com.ibm.team.filesystem.common.internal.rest.client.load.InvalidLoadRequestDTO;
import com.ibm.team.filesystem.common.internal.rest.client.load.LoadEvaluationDTO;
import com.ibm.team.filesystem.common.internal.rest.client.load.LoadLocationDTO;
import com.ibm.team.filesystem.common.internal.rest.client.load.LoadOverlapDTO;
import com.ibm.team.filesystem.common.internal.rest.client.load.RemovedShareDTO;
import com.ibm.team.filesystem.common.internal.rest.client.load.ShareToLoadDTO;
import com.ibm.team.filesystem.rcp.core.IEclipseFileSystemManager;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.CoreUtil;
import com.ibm.team.filesystem.rcp.core.operations.UnshareProjectsOperation;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadUtil {
    private static final String LOAD_REQUEST = "putLoadCFA";
    private static final String UNLOAD_REQUEST = "postUnloadCFA";
    private static final String EVALUATE_LOAD_REQUEST = "getLoadCFA";

    public static LoadEvaluationDTO evaluateLoad(ParmsLoad parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        parms.validate(EVALUATE_LOAD_REQUEST);
        ILoadOperation loadOperation = LoadUtil.prepareLoadRequest(EVALUATE_LOAD_REQUEST, parms, LoadDilemmaHandler.getDefault(), (IProgressMonitor)monitor.newChild(10));
        try {
            loadOperation.evaluateLoadRequests((IProgressMonitor)monitor.newChild(90));
        }
        catch (FileSystemClientException e) {
            throw new TeamRepositoryException(CommonUtil.getErrorMessage((FileSystemClientException)e), (Throwable)e);
        }
        LoadEvaluationDTO result = FilesystemRestClientDTOloadFactory.eINSTANCE.createLoadEvaluationDTO();
        LoadUtil.translateCollisions(result, loadOperation.getCollisions());
        LoadUtil.translateInvalidLoadRequests(result, loadOperation.getInvalidLoadRequests());
        LoadUtil.translateOverlaps(result, loadOperation.getLoadOverlaps());
        LoadUtil.translateNewShares(result, loadOperation.getNewSharesToLoad());
        LoadUtil.translateSharesOutOfSync(result, loadOperation.getSharesOutOfSync());
        LoadUtil.translateSharesToBeRemoved(result, loadOperation.getSharesToBeRemoved());
        return result;
    }

    private static void translateCollisions(LoadEvaluationDTO translation, Collection<ICollision> collisions) {
        for (ICollision collision : collisions) {
            CollisionDTO loadCollision = FilesystemRestClientDTOloadFactory.eINSTANCE.createCollisionDTO();
            loadCollision.setPath(CoreUtil.translatePath(collision.getShareable().getLocalFullPath()));
            loadCollision.setDetail(collision.getStatus().getMessage());
            loadCollision.setCollidedWithExistingContent(collision.collidedWithExistingContent());
            if (collision.collidedWithExistingContent() && collision.getShareable().getShare() != null) {
                loadCollision.setCollidedWithExistingShare(true);
            } else {
                loadCollision.setCollidedWithExistingShare(false);
            }
            for (ILoadLocation location : collision.getLocations()) {
                LoadLocationDTO loadLocation = FilesystemRestClientDTOloadFactory.eINSTANCE.createLoadLocationDTO();
                loadLocation.setRepositoryURL(((LoadLocation)location).getDescriptor().uri);
                loadLocation.setContextItemId(((LoadLocation)location).getDescriptor().connectionHandle.getItemId().getUuidValue());
                loadLocation.setIsWorkspaceContext(((LoadLocation)location).getDescriptor().connectionHandle instanceof IWorkspaceHandle);
                loadLocation.setComponentItemId(location.getComponent().getItemId().getUuidValue());
                loadLocation.setFolderItemId(location.getFolder().getItemId().getUuidValue());
                loadCollision.getLoadLocations().add(loadLocation);
            }
            translation.getCollisions().add(loadCollision);
        }
    }

    private static void translateInvalidLoadRequests(LoadEvaluationDTO translation, Collection<IInvalidLoadRequest> invalidLoadRequests) {
        for (IInvalidLoadRequest invalid : invalidLoadRequests) {
            InvalidLoadRequestDTO invalidRequest = FilesystemRestClientDTOloadFactory.eINSTANCE.createInvalidLoadRequestDTO();
            LoadLocationDTO location = FilesystemRestClientDTOloadFactory.eINSTANCE.createLoadLocationDTO();
            location.setRepositoryURL(invalid.getInvalidRequest().getConnection().teamRepository().getRepositoryURI());
            location.setContextItemId(invalid.getInvalidRequest().getConnection().getContextHandle().getItemId().getUuidValue());
            location.setIsWorkspaceContext(invalid.getInvalidRequest().getConnection().getContextHandle() instanceof IWorkspaceHandle);
            location.setComponentItemId(invalid.getInvalidRequest().getComponent().getItemId().getUuidValue());
            location.setFolderItemId(invalid.getInvalidRequest().getFolderToLoad().getItemId().getUuidValue());
            invalidRequest.setFolder(location);
            invalidRequest.setReason(invalid.getStatus().getMessage());
            translation.getInvalidLoadRequests().add(invalidRequest);
        }
    }

    private static void translateOverlaps(LoadEvaluationDTO translation, Collection<ILoadOverlap> overlaps) {
        for (ILoadOverlap overlap : overlaps) {
            LoadOverlapDTO loadOverlap = FilesystemRestClientDTOloadFactory.eINSTANCE.createLoadOverlapDTO();
            LoadLocationDTO loadLocation = FilesystemRestClientDTOloadFactory.eINSTANCE.createLoadLocationDTO();
            loadLocation.setContextItemId(overlap.getConnection().getContextHandle().getItemId().getUuidValue());
            loadLocation.setIsWorkspaceContext(overlap.getConnection().getContextHandle() instanceof IWorkspaceHandle);
            loadLocation.setRepositoryURL(overlap.getConnection().teamRepository().getRepositoryURI());
            loadLocation.setComponentItemId(overlap.getComponent().getItemId().getUuidValue());
            loadLocation.setFolderItemId(overlap.getFolder().getItemId().getUuidValue());
            loadOverlap.setFolder(loadLocation);
            loadOverlap.setFolderPath(CoreUtil.translatePath(overlap.getFolderPath()));
            for (IShare share : overlap.getOverlappingShares()) {
                ShareDTO overlappedShare = CoreUtil.translateShare(share);
                loadOverlap.getOverlappingShares().add(overlappedShare);
            }
            for (IFolderHandle folder : overlap.getOverlappingFolders()) {
                loadOverlap.getOverlappingFolderItemIds().add(folder.getItemId().getUuidValue());
            }
            for (String[] folderPath : overlap.getOverlappingFolderPaths()) {
                loadOverlap.getOverlappingFolderPaths().add(CoreUtil.translatePath(folderPath));
            }
            translation.getOverlappingLoadRequests().add(loadOverlap);
        }
    }

    private static void translateNewShares(LoadEvaluationDTO translation, Collection<IShareableToLoad> newSharesToLoad) {
        for (IShareableToLoad newShare : newSharesToLoad) {
            ShareToLoadDTO newShareToLoad = FilesystemRestClientDTOloadFactory.eINSTANCE.createShareToLoadDTO();
            newShareToLoad.setPath(CoreUtil.translatePath(newShare.getShareable().getLocalFullPath()));
            LoadLocationDTO loadLocation = FilesystemRestClientDTOloadFactory.eINSTANCE.createLoadLocationDTO();
            loadLocation.setRepositoryURL(((LoadLocation)newShare.getLoadLocation()).getDescriptor().uri);
            loadLocation.setContextItemId(((LoadLocation)newShare.getLoadLocation()).getDescriptor().connectionHandle.getItemId().getUuidValue());
            loadLocation.setIsWorkspaceContext(((LoadLocation)newShare.getLoadLocation()).getDescriptor().connectionHandle instanceof IWorkspaceHandle);
            loadLocation.setComponentItemId(newShare.getLoadLocation().getComponent().getItemId().getUuidValue());
            loadLocation.setFolderItemId(newShare.getLoadLocation().getFolder().getItemId().getUuidValue());
            newShareToLoad.setLoadLocation(loadLocation);
            translation.getNewSharesToLoad().add(newShareToLoad);
        }
    }

    private static void translateSharesOutOfSync(LoadEvaluationDTO translation, Collection<IShareOutOfSync> sharesOutOfSync) {
        for (IShareOutOfSync shareOutOfSync : sharesOutOfSync) {
            ShareDTO share = CoreUtil.translateShare(shareOutOfSync.getShare());
            translation.getSharesOutOfSync().add(share);
        }
    }

    private static void translateSharesToBeRemoved(LoadEvaluationDTO translation, Collection<IRemovedShare> sharesToBeRemoved) {
        for (IRemovedShare shareToBeRemoved : sharesToBeRemoved) {
            ShareDTO share = CoreUtil.translateShare(shareToBeRemoved.getShareable().getShare());
            RemovedShareDTO shareRemoved = FilesystemRestClientDTOloadFactory.eINSTANCE.createRemovedShareDTO();
            shareRemoved.setShare(share);
            shareRemoved.setUncommittedChangeCount(shareToBeRemoved.getUncommittedChangeCount());
            translation.getSharesToBeRemoved().add(shareRemoved);
        }
    }

    public static void unload(ParmsUnload parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        parms.validate(UNLOAD_REQUEST);
        try {
            UnshareProjectsOperation operation;
            int n;
            int n2;
            String[] stringArray;
            if (parms.projectNames != null) {
                ArrayList<IProject> projects = new ArrayList<IProject>();
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                stringArray = parms.projectNames;
                n2 = parms.projectNames.length;
                n = 0;
                while (n < n2) {
                    String projectName = stringArray[n];
                    IProject project = root.getProject(projectName);
                    if (project.exists()) {
                        projects.add(project);
                    }
                    ++n;
                }
                operation = new UnshareProjectsOperation(projects.toArray(new IProject[0]), (boolean)parms.deleteContent);
                operation.run((IProgressMonitor)monitor.newChild(50));
            }
            if (parms.unloadRequests != null) {
                ArrayList<ConfigurationDescriptor> descriptors = new ArrayList<ConfigurationDescriptor>();
                SubMonitor loopProgress = monitor.newChild(10).setWorkRemaining(parms.unloadRequests.length);
                stringArray = parms.unloadRequests;
                n2 = parms.unloadRequests.length;
                n = 0;
                while (n < n2) {
                    String component = stringArray[n];
                    IWorkspaceConnection workspaceConnection = ((ParmsWorkspaceComponent)component).workspace.getWorkspaceConnection((IProgressMonitor)loopProgress.newChild(1));
                    IComponentHandle componentHandle = component.getComponentHandle();
                    ConfigurationDescriptor descriptor = new ConfigurationDescriptor((IConnection)workspaceConnection, componentHandle);
                    descriptors.add(descriptor);
                    ++n;
                }
                operation = new UnshareProjectsOperation(descriptors, (boolean)parms.deleteContent);
                operation.run((IProgressMonitor)monitor.newChild(50));
            }
        }
        catch (FileSystemClientException e) {
            throw new TeamRepositoryException(CommonUtil.getErrorMessage((FileSystemClientException)e), (Throwable)e);
        }
    }

    public static void load(final ParmsLoad parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        parms.validate(LOAD_REQUEST);
        LoadDilemmaHandler loadDilemmaHandler = new LoadDilemmaHandler(){

            public int collision(Collection<ICollision> collisions, Collection<IRemovedShare> removedShares, Collection<IShareOutOfSync> sharesOutOfSync) {
                for (ICollision collision : collisions) {
                    if (collision.getLocations().size() > 1) {
                        return 2;
                    }
                    collision.setLoadLocation((ILoadLocation)collision.getLocations().iterator().next());
                }
                for (IRemovedShare removedShare : removedShares) {
                    removedShare.isToBeDeleted(parms.deleteRemovedShares == null ? false : parms.deleteRemovedShares);
                }
                return 0;
            }

            public int invalidLoadRequest(Collection<IInvalidLoadRequest> requests) {
                return 2;
            }

            public int newItemsToLoad(Collection<IShareableToLoad> sharesToLoad) {
                return super.newItemsToLoad(sharesToLoad);
            }

            public int overlappingLoadRequests(Collection<ILoadOverlap> foldersOverlapping) {
                return 2;
            }
        };
        ILoadOperation loadOperation = LoadUtil.prepareLoadRequest(LOAD_REQUEST, parms, loadDilemmaHandler, (IProgressMonitor)monitor.newChild(5));
        try {
            loadOperation.run((IProgressMonitor)monitor.newChild(95));
        }
        catch (FileSystemClientException e) {
            throw new TeamRepositoryException(CommonUtil.getErrorMessage((FileSystemClientException)e), (Throwable)e);
        }
    }

    private static ILoadOperation prepareLoadRequest(String request, ParmsLoad parms, LoadDilemmaHandler loadDilemmaHandler, IProgressMonitor progress) throws TeamRepositoryException {
        IWorkspaceConnection workspaceConnection;
        int n;
        int n2;
        ParmsWorkspaceComponent[] parmsWorkspaceComponentArray;
        SubMonitor subMonitor;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)300);
        ILoadOperation loadOperation = IEclipseFileSystemManager.instance.getLoadOperation(loadDilemmaHandler);
        if (parms.componentsToTrack != null) {
            subMonitor = monitor.newChild(100).setWorkRemaining(parms.componentsToTrack.length * 10);
            parmsWorkspaceComponentArray = parms.componentsToTrack;
            n2 = parms.componentsToTrack.length;
            n = 0;
            while (n < n2) {
                ParmsWorkspaceComponent plc = parmsWorkspaceComponentArray[n];
                workspaceConnection = plc.workspace.getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(10));
                loadOperation.requestLoad(workspaceConnection, plc.getComponentHandle(), (Collection)Collections.EMPTY_LIST);
                ++n;
            }
        }
        if (parms.componentFolders != null) {
            subMonitor = monitor.newChild(100).setWorkRemaining(parms.componentFolders.length * 10);
            parmsWorkspaceComponentArray = parms.componentFolders;
            n2 = parms.componentFolders.length;
            n = 0;
            while (n < n2) {
                Map exp;
                ParmsWorkspaceComponent componentFolders = parmsWorkspaceComponentArray[n];
                workspaceConnection = componentFolders.workspace.getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(9));
                IComponentHandle component = componentFolders.getComponentHandle();
                ArrayList<IFolderHandle> foldersToLoad = componentFolders.getFolderHandles();
                if ((foldersToLoad == null || foldersToLoad.isEmpty()) && (exp = workspaceConnection.configuration(component).childEntriesForRoot((IProgressMonitor)subMonitor.newChild(1))) != null) {
                    foldersToLoad = new ArrayList<IFolderHandle>(exp.size());
                    for (IVersionableHandle folderHandle : exp.values()) {
                        if (!(folderHandle instanceof IFolderHandle)) continue;
                        foldersToLoad.add((IFolderHandle)folderHandle);
                    }
                }
                loadOperation.requestLoad(workspaceConnection, component, (Collection)foldersToLoad);
                ++n;
            }
        }
        if (parms.loadRules != null && parms.loadRules.length > 0) {
            subMonitor = monitor.newChild(100).setWorkRemaining(10 + parms.loadRules.length * 20);
            ArrayList<ILoadRule> rules = new ArrayList<ILoadRule>(parms.loadRules.length);
            ParmsLoadRule[] parmsLoadRuleArray = parms.loadRules;
            int n3 = parms.loadRules.length;
            n2 = 0;
            while (n2 < n3) {
                ParmsLoadRule loadRules = parmsLoadRuleArray[n2];
                IWorkspaceConnection workspaceConnection2 = loadRules.workspace.getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(10));
                IComponentHandle component = loadRules.getComponentHandle();
                ILoadRule loadRule = ILoadRule.loadRuleFactory.createLoadRule(workspaceConnection2, component);
                IFileItemHandle loadRuleFileItem = loadRules.getLoadRuleFileItemHandle();
                if (loadRuleFileItem != null) {
                    loadRule.addLoadRules(loadRuleFileItem, (IProgressMonitor)subMonitor.newChild(10));
                } else {
                    loadRule.addLoadRules((InputStream)new ByteArrayInputStream(loadRules.loadRuleFileContents.getBytes()), "UTF-8", (IProgressMonitor)subMonitor.newChild(10));
                }
                rules.add(loadRule);
                ++n2;
            }
            loadOperation.requestLoad(rules, (IProgressMonitor)subMonitor.newChild(10));
        }
        return loadOperation;
    }
}

