/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.rest.util;

import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreEvent;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.restproxy.notification.IServerNotificationChannel;
import com.ibm.team.repository.client.util.IEvent;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.common.transport.IParameterWrapper;
import java.util.ArrayList;
import java.util.List;

public class IgnoredResourcesDTOUtil {
    public static void startIgnoredResourcesNotification(final IServerNotificationChannel notifier) {
        IListener listener = new IListener(){

            public void handleEvents(List events) {
                ArrayList<String> roots = null;
                for (IEvent event : events) {
                    if (!(event instanceof IIgnoreEvent)) continue;
                    IIgnoreEvent ignoreEvent = (IIgnoreEvent)event;
                    if (roots == null) {
                        roots = new ArrayList<String>(ignoreEvent.getRoots().size());
                    }
                    for (IShareable root : ignoreEvent.getRoots()) {
                        roots.add(root.getLocalFullPath().toPortableString());
                    }
                }
                if (roots != null) {
                    notifier.queueNotification("IgnoredResourcesDTORefreshNotification", IFilesystemRestClient.IgnoredResourcesDTORefreshEvent.TYPE, (IParameterWrapper)new IFilesystemRestClient.IgnoredResourcesDTORefreshEvent(roots.toArray(new String[roots.size()])));
                }
            }
        };
        SharingManager.getInstance().getIgnoreManager().addGenericListener((Object[])IIgnoreEvent.ALL_EVENTS, listener);
    }
}

