/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.rest.util;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.ILocalChangeManager;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.ignore.DefaultIgnoreProvider;
import com.ibm.team.filesystem.client.internal.ignore.IDefaultIgnoreProviderEvent;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreEvent;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreProvider;
import com.ibm.team.filesystem.client.internal.utils.IgnoreUtils;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.resources.LinkedResourceIgnoreProvider;
import com.ibm.team.filesystem.rcp.core.operations.IgnoreOperation;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.common.NotLoggedInException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.core.internal.LoggingHelper;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.osgi.framework.Bundle;

public class FSD_IgnoreManagerEventConnector {
    boolean running = false;
    private DefaultIgnoreProvider manager;
    private static FSD_IgnoreManagerEventConnector instance = new FSD_IgnoreManagerEventConnector(DefaultIgnoreProvider.getDefault());
    public IResourceChangeListener resourceChangeListener = new IResourceChangeListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resourceChanged(IResourceChangeEvent event) {
            block6: {
                if (!FSD_IgnoreManagerEventConnector.this.running) {
                    return;
                }
                Assert.isTrue((event.getType() == 1 ? 1 : 0) != 0);
                IResourceDelta delta = event.getDelta();
                final ArrayList ignoreFiles = new ArrayList();
                try {
                    delta.accept(new IResourceDeltaVisitor(){

                        public boolean visit(IResourceDelta delta) throws CoreException {
                            IPath path;
                            int kind = delta.getKind();
                            if (kind != 1 && kind != 4 && kind != 2) {
                                return true;
                            }
                            if (delta.getResource().isLinked()) {
                                LinkedResourceIgnoreProvider.getInstance().triggerCacheFlush();
                            }
                            if (".jazzignore".equals((path = delta.getFullPath()).lastSegment())) {
                                IResource resource = delta.getResource();
                                if (!resource.getProject().isOpen()) {
                                    return false;
                                }
                                IShareable shareable = (IShareable)resource.getAdapter(IShareable.class);
                                ignoreFiles.add(shareable);
                            }
                            return true;
                        }
                    });
                    if (ignoreFiles.size() <= 0) break block6;
                    Job job = FSD_IgnoreManagerEventConnector.this.ignoreFilesChangedJob;
                    synchronized (job) {
                        FSD_IgnoreManagerEventConnector.this.ignoreFilesChangeQueue.addAll(ignoreFiles);
                    }
                    FSD_IgnoreManagerEventConnector.this.ignoreFilesChangedJob.schedule();
                }
                catch (CoreException e) {
                    LoggingHelper.error((String)"com.ibm.team.filesystem.rcp.core", (String)Messages.FSD_IgnoreManagerEventConnector_0, (Throwable)e);
                }
            }
        }
    };
    private IListener ignoreFileChangedListener = new IListener(){

        public void handleEvents(List events) {
            FSD_IgnoreManagerEventConnector.this.refreshOnIgnoreChangeJob.addEvent(events);
        }
    };
    private List<IShareable> ignoreFilesChangeQueue = new LinkedList<IShareable>();
    private final Job ignoreFilesChangedJob = new Job(Messages.FSD_IgnoreManagerEventConnector_1){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor progress) {
            List ignoreFiles;
            3 var3_2 = this;
            synchronized (var3_2) {
                ignoreFiles = FSD_IgnoreManagerEventConnector.this.ignoreFilesChangeQueue;
                FSD_IgnoreManagerEventConnector.this.ignoreFilesChangeQueue = new ArrayList();
            }
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)2);
            IStatus filesChangedResult = FSD_IgnoreManagerEventConnector.this.manager.ignoreFilesChanged(ignoreFiles, (IProgressMonitor)monitor.newChild(1));
            if (!filesChangedResult.isOK()) {
                return filesChangedResult;
            }
            return Status.OK_STATUS;
        }
    };
    RefreshOnIgnoreChangeJob refreshOnIgnoreChangeJob = new RefreshOnIgnoreChangeJob(Messages.FSD_IgnoreManagerEventConnector_5);

    public static FSD_IgnoreManagerEventConnector getInstance() {
        return instance;
    }

    public FSD_IgnoreManagerEventConnector(DefaultIgnoreProvider manager) {
        this.manager = manager;
        this.ignoreFilesChangedJob.setSystem(true);
    }

    public void start() {
        Bundle ui = Platform.getBundle((String)"com.ibm.team.filesystem.ide.ui");
        if (ui != null && ui.getState() == 32) {
            return;
        }
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 1);
        SharingManager.getInstance().getIgnoreManager().addGenericListener((Object)"external_change", this.ignoreFileChangedListener);
        this.running = true;
    }

    public void stop() {
        this.running = false;
        SharingManager.getInstance().getIgnoreManager().purgeGenericListener(this.ignoreFileChangedListener);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RefreshOnIgnoreChangeJob
    extends Job {
        private LinkedList<IIgnoreEvent> events = new LinkedList();

        private RefreshOnIgnoreChangeJob(String name) {
            super(name);
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addEvent(List<IIgnoreEvent> newEvents) {
            LinkedList<IIgnoreEvent> linkedList = this.events;
            synchronized (linkedList) {
                this.events.addAll(newEvents);
            }
            this.schedule();
        }

        /*
         * Exception decompiling
         */
        protected IStatus run(IProgressMonitor progress) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[UNCONDITIONALDOLOOP]], but top level block is 6[MONITOR]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private boolean shouldProcessIgnoreEvent(IDefaultIgnoreProviderEvent dipe) {
            if (!"unknown".equals(dipe.getChangeType())) {
                return false;
            }
            IShareable file = dipe.getIgnoreFile();
            IResource resource = (IResource)file.getAdapter(IResource.class);
            return resource.getProject().isOpen();
        }

        private void processIgnoreEvent(IIgnoreEvent event, SubMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
            IWorkspaceConnection conn;
            IDefaultIgnoreProviderEvent dipe = (IDefaultIgnoreProviderEvent)event;
            if (!this.shouldProcessIgnoreEvent(dipe)) {
                return;
            }
            monitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
            ISharingDescriptor descriptor = dipe.getIgnoreFile().getShare().getSharingDescriptor();
            try {
                conn = RefreshOnIgnoreChangeJob.getContributorTeamPlace(descriptor, (IProgressMonitor)monitor.newChild(1));
            }
            catch (NotLoggedInException notLoggedInException) {
                return;
            }
            Collection rules = event.getRules();
            IgnoreOperation op = new IgnoreOperation();
            if (rules == null) {
                this.configureIgnoreOpForUnknownEventType(op, dipe);
            } else {
                op.setIgnoreRules(conn, descriptor.getComponent(), rules, true, (IProgressMonitor)monitor.newChild(1));
            }
            op.execute((IProgressMonitor)monitor.newChild(1));
            ILocalChangeManager lcm = FileSystemCore.getSharingManager().getLocalChangeManager();
            for (IShareable root : (List)event.getRoots()) {
                lcm.syncPendingChanges(descriptor.getConnectionHandle(), descriptor.getComponent(), root.getLocalFullPath());
            }
        }

        public static IWorkspaceConnection getContributorTeamPlace(ISharingDescriptor descriptor, IProgressMonitor monitor) throws TeamRepositoryException {
            IContextHandle connectable = descriptor.getConnectionHandle();
            if (connectable instanceof IWorkspaceHandle) {
                IWorkspaceHandle workspace = (IWorkspaceHandle)connectable;
                ITeamRepository server = RepositoryUtils.getTeamRepository((String)descriptor.getRepositoryUri(), (UUID)descriptor.getRepositoryId());
                IWorkspaceConnection connection = SCMPlatform.getWorkspaceManager((ITeamRepository)server).getWorkspaceConnection(workspace, monitor);
                return connection;
            }
            throw new IllegalArgumentException("Sharing descriptor must be shared with a workspace");
        }

        private void configureIgnoreOpForUnknownEventType(final IgnoreOperation op, IDefaultIgnoreProviderEvent dipe) throws FileSystemClientException {
            IgnoreUtils.IIgnoredForRuleController controller = new IgnoreUtils.IIgnoredForRuleController(){
                HashMap<IPath, IWorkspaceConnection> sharesToConnections = new HashMap();

                public void addIgnored(IIgnoreProvider.IIgnoreRule rule, IShareable shareable) {
                    IWorkspaceConnection conn;
                    block8: {
                        conn = null;
                        IPath shareRoot = shareable.getRoot();
                        if (this.sharesToConnections.containsKey(shareRoot)) {
                            conn = this.sharesToConnections.get(shareRoot);
                        } else {
                            try {
                                try {
                                    conn = RefreshOnIgnoreChangeJob.this.getConnectionFor(shareable);
                                }
                                catch (TeamRepositoryException e) {
                                    LoggingHelper.log((String)"com.ibm.team.filesystem.rcp.core", (IStatus)new Status(4, "com.ibm.team.filesystem.rcp.core", "", (Throwable)e));
                                    this.sharesToConnections.put(shareRoot, conn);
                                    break block8;
                                }
                            }
                            catch (Throwable throwable) {
                                this.sharesToConnections.put(shareRoot, conn);
                                throw throwable;
                            }
                            this.sharesToConnections.put(shareRoot, conn);
                        }
                    }
                    if (conn == null) {
                        return;
                    }
                    op.addIgnoreable(conn, shareable);
                }

                public boolean shouldSkip(IIgnoreProvider.IIgnoreRule rule, IShareable shareable) throws FileSystemClientException {
                    return false;
                }
            };
            IgnoreUtils.findIgnoresForEvent((IIgnoreEvent)dipe, (IgnoreUtils.IIgnoredForRuleController)controller);
        }

        private IWorkspaceConnection getConnectionFor(IShareable shareable) throws TeamRepositoryException {
            IShare share = shareable.getShare();
            if (share == null) {
                return null;
            }
            ISharingDescriptor desc = share.getSharingDescriptor();
            IContextHandle handle = share.getSharingDescriptor().getConnectionHandle();
            ITeamRepository repo = null;
            repo = RepositoryUtils.getTeamRepository((String)desc.getRepositoryUri(), (UUID)desc.getRepositoryId());
            IWorkspaceManager wsMan = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
            if (handle instanceof IWorkspaceHandle) {
                return wsMan.getWorkspaceConnection((IWorkspaceHandle)handle, null);
            }
            LoggingHelper.log((String)"com.ibm.team.filesystem.rcp.core", (IStatus)new Status(4, "com.ibm.team.filesystem.rcp.core", Messages.FSD_IgnoreManagerEventConnector_4));
            return null;
        }
    }
}

