/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.rest;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.daemon.IJSONReceiver;
import com.ibm.team.filesystem.client.daemon.IServerController;
import com.ibm.team.filesystem.client.daemon.JSONHandler;
import com.ibm.team.filesystem.client.internal.ClientConfigurationChangeFactory;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICorruptCopyFileAreaEvent;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICorruptCopyFileAreaListener;
import com.ibm.team.filesystem.client.internal.ignore.DefaultIgnoreProvider;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreRule;
import com.ibm.team.filesystem.client.internal.ignore.JazzIgnoreFile;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.operations.RebuildCFAOperation;
import com.ibm.team.filesystem.client.internal.rest.CommonUtil;
import com.ibm.team.filesystem.client.internal.snapshot.ComponentSyncReportFragment;
import com.ibm.team.filesystem.client.internal.snapshot.FlowType;
import com.ibm.team.filesystem.client.internal.snapshot.ISnapshot;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotId;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotSyncReport;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotSyncReportFragment;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsAcceptAsPatch;
import com.ibm.team.filesystem.client.rest.parameters.ParmsActivate;
import com.ibm.team.filesystem.client.rest.parameters.ParmsAutoMerge;
import com.ibm.team.filesystem.client.rest.parameters.ParmsChangeSetsBaseline;
import com.ibm.team.filesystem.client.rest.parameters.ParmsChangeSummary;
import com.ibm.team.filesystem.client.rest.parameters.ParmsCheckInChanges;
import com.ibm.team.filesystem.client.rest.parameters.ParmsCheckinPolicy;
import com.ibm.team.filesystem.client.rest.parameters.ParmsCombineDeleteAdd;
import com.ibm.team.filesystem.client.rest.parameters.ParmsCompareCE;
import com.ibm.team.filesystem.client.rest.parameters.ParmsCompleteChangeSets;
import com.ibm.team.filesystem.client.rest.parameters.ParmsComponentTarget;
import com.ibm.team.filesystem.client.rest.parameters.ParmsContentTransfer;
import com.ibm.team.filesystem.client.rest.parameters.ParmsContributorList;
import com.ibm.team.filesystem.client.rest.parameters.ParmsCorruptionListener;
import com.ibm.team.filesystem.client.rest.parameters.ParmsCreateBaselineSet;
import com.ibm.team.filesystem.client.rest.parameters.ParmsCreateBaselines;
import com.ibm.team.filesystem.client.rest.parameters.ParmsCreateChangeSet;
import com.ibm.team.filesystem.client.rest.parameters.ParmsDeactivate;
import com.ibm.team.filesystem.client.rest.parameters.ParmsDeallocateCE;
import com.ibm.team.filesystem.client.rest.parameters.ParmsDeleteFoldersInWorkspace;
import com.ibm.team.filesystem.client.rest.parameters.ParmsDeliver;
import com.ibm.team.filesystem.client.rest.parameters.ParmsDiscardChangeSets;
import com.ibm.team.filesystem.client.rest.parameters.ParmsEclipseWorkspacePaths;
import com.ibm.team.filesystem.client.rest.parameters.ParmsGetBaselineChangesCE;
import com.ibm.team.filesystem.client.rest.parameters.ParmsGetBaselines;
import com.ibm.team.filesystem.client.rest.parameters.ParmsGetChangeSets;
import com.ibm.team.filesystem.client.rest.parameters.ParmsGetChangedComponentCE;
import com.ibm.team.filesystem.client.rest.parameters.ParmsGetComponentsCE;
import com.ibm.team.filesystem.client.rest.parameters.ParmsGetIgnoredResourcesPaths;
import com.ibm.team.filesystem.client.rest.parameters.ParmsGetStructuralChangesCE;
import com.ibm.team.filesystem.client.rest.parameters.ParmsGetWorkspace;
import com.ibm.team.filesystem.client.rest.parameters.ParmsIgnoreLocationList;
import com.ibm.team.filesystem.client.rest.parameters.ParmsIgnoreRuleList;
import com.ibm.team.filesystem.client.rest.parameters.ParmsInputNameCE;
import com.ibm.team.filesystem.client.rest.parameters.ParmsLoad;
import com.ibm.team.filesystem.client.rest.parameters.ParmsLoadFileRequest;
import com.ibm.team.filesystem.client.rest.parameters.ParmsLoadFiles;
import com.ibm.team.filesystem.client.rest.parameters.ParmsLogin;
import com.ibm.team.filesystem.client.rest.parameters.ParmsLogout;
import com.ibm.team.filesystem.client.rest.parameters.ParmsMergePatch;
import com.ibm.team.filesystem.client.rest.parameters.ParmsMoveFoldersInWorkspace;
import com.ibm.team.filesystem.client.rest.parameters.ParmsMoveResources;
import com.ibm.team.filesystem.client.rest.parameters.ParmsOSPaths;
import com.ibm.team.filesystem.client.rest.parameters.ParmsOpenCE;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPendingPatches;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPostWorkspace;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPutComponent;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPutWorkspace;
import com.ibm.team.filesystem.client.rest.parameters.ParmsRefreshEclipseWorkspace;
import com.ibm.team.filesystem.client.rest.parameters.ParmsRelocateChanges;
import com.ibm.team.filesystem.client.rest.parameters.ParmsRemoveBaselineSet;
import com.ibm.team.filesystem.client.rest.parameters.ParmsRemoveSuspendedChangeSets;
import com.ibm.team.filesystem.client.rest.parameters.ParmsResolveAsMerged;
import com.ibm.team.filesystem.client.rest.parameters.ParmsResolveWithProposed;
import com.ibm.team.filesystem.client.rest.parameters.ParmsResourceProperties;
import com.ibm.team.filesystem.client.rest.parameters.ParmsResourcePropertyUpdates;
import com.ibm.team.filesystem.client.rest.parameters.ParmsResumeChangeSets;
import com.ibm.team.filesystem.client.rest.parameters.ParmsSetChangeSetComment;
import com.ibm.team.filesystem.client.rest.parameters.ParmsSetCurrentChangeSet;
import com.ibm.team.filesystem.client.rest.parameters.ParmsShare;
import com.ibm.team.filesystem.client.rest.parameters.ParmsSuspendChangeSets;
import com.ibm.team.filesystem.client.rest.parameters.ParmsSyncDescription;
import com.ibm.team.filesystem.client.rest.parameters.ParmsSyncSameOccurrences;
import com.ibm.team.filesystem.client.rest.parameters.ParmsSyncViewFilters;
import com.ibm.team.filesystem.client.rest.parameters.ParmsTeamRepository;
import com.ibm.team.filesystem.client.rest.parameters.ParmsUndoCheckedInChanges;
import com.ibm.team.filesystem.client.rest.parameters.ParmsUndoLocalChanges;
import com.ibm.team.filesystem.client.rest.parameters.ParmsUnload;
import com.ibm.team.filesystem.client.rest.parameters.ParmsUpdateBaseline;
import com.ibm.team.filesystem.client.rest.parameters.ParmsUpdateBaselineSet;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspaceTarget;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspaceUpdate;
import com.ibm.team.filesystem.client.restproxy.notification.IServerNotificationChannel;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.changemodel.ChangeDescription;
import com.ibm.team.filesystem.common.changemodel.ConfigurationChange;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.CheckInResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.CreateResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.DeliverResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.DiscardResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.FilesystemRestClientDTOchangesetFactory;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.ResumeResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.SuspendResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.UndoCheckedInChangesResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.UndoLocalChangesResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.WorkspaceUpdateResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.conflict.ResolveAsMergedResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.conflict.ResolveAutoMergeResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.conflict.ResolveWithProposedEvaluationDTO;
import com.ibm.team.filesystem.common.internal.rest.client.conflict.ResolveWithProposedResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.FilesystemRestClientDTOcoreFactory;
import com.ibm.team.filesystem.common.internal.rest.client.core.TeamRepositoriesDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.TeamRepositoryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceDetailsDTO;
import com.ibm.team.filesystem.common.internal.rest.client.corruption.FilesystemRestClientDTOcorruptionFactory;
import com.ibm.team.filesystem.common.internal.rest.client.corruption.RebuildCopyFileAreaDTO;
import com.ibm.team.filesystem.common.internal.rest.client.ignores.FilesystemRestClientDTOignoresFactory;
import com.ibm.team.filesystem.common.internal.rest.client.ignores.IgnoreRulesDTO;
import com.ibm.team.filesystem.common.internal.rest.client.ignores.IgnoredResourcesDTO;
import com.ibm.team.filesystem.common.internal.rest.client.load.FilesystemRestClientDTOloadFactory;
import com.ibm.team.filesystem.common.internal.rest.client.load.LoadEvaluationDTO;
import com.ibm.team.filesystem.common.internal.rest.client.load.LoadFileOperationResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.load.LoadFileResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.ChangeSummaryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.CheckinPolicyDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.ContentTransferDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.EclipseWorkspacePathsResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.FilesystemRestClientDTOresourceFactory;
import com.ibm.team.filesystem.common.internal.rest.client.resource.OSPathsResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.ResourcePropertyChangeResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.ResourcesDTO;
import com.ibm.team.filesystem.common.internal.rest.client.share.ShareResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.AcceptAsPatchDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.BaselineSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.CEBaselineSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.CEComponentSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.CESyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ChangeSetSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ContributorListSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ContributorSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.DescriptionSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.FilesystemRestClientDTOsyncFactory;
import com.ibm.team.filesystem.common.internal.rest.client.sync.GetBaselineSetsDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.GetBaselinesDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.MergePatchDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.PendingPatchesDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.SameOccurrencesSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.SyncViewDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.SyncViewFiltersDTO;
import com.ibm.team.filesystem.common.internal.rest.client.workspace.CreateBaselineResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.workspace.CreateBaselineSetResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.workspace.DeleteFoldersInWorkspaceResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.workspace.MoveFoldersInWorkspaceResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.workspace.PutWorkspaceResultDTO;
import com.ibm.team.filesystem.common.internal.util.ItemUtil;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.changes.ActiveWorkspaceManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ConfigurationChangeFactory;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.SnapshotPathResolver;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ComponentSyncModel;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.listeners.EventManager;
import com.ibm.team.filesystem.rcp.core.internal.operations.AcceptHunksOperation;
import com.ibm.team.filesystem.rcp.core.internal.operations.LoadFileRequest;
import com.ibm.team.filesystem.rcp.core.internal.patches.ParsedPatch;
import com.ibm.team.filesystem.rcp.core.internal.rest.ChangeExplorerRestState;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.BaselineUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.CommitUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.ConflictResolutionUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.CoreUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.DeliverUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.FSD_IgnoreManagerEventConnector;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.FolderManipulationUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.IgnoredResourcesDTOUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.IgnoresUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.LoadUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.Pair;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.RefreshUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.ResourceUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.SearchChangesUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.ShareUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.SuspendResumeDiscardChangeSetUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.SyncDescriptionUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.SyncViewDTOUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.UndoChangesUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.WorkspaceUpdateUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.WorkspaceUtil;
import com.ibm.team.filesystem.rcp.core.operations.IgnoreOperation;
import com.ibm.team.filesystem.rcp.core.patches.LocalFileOp;
import com.ibm.team.filesystem.rcp.core.patches.PatchModel;
import com.ibm.team.filesystem.rcp.core.patches.PatchedDirectory;
import com.ibm.team.filesystem.rcp.core.patches.PatchedFile;
import com.ibm.team.filesystem.rcp.core.patches.PendingContentChange;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.transport.IParameterWrapper;
import com.ibm.team.repository.rcp.common.collection.CollectionUtil;
import com.ibm.team.repository.rcp.core.utils.RealmUtil;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.ScmRestServiceUtil;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.StateId;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilesystemRestClient
implements IFilesystemRestClient,
IJSONReceiver {
    IServerNotificationChannel notifier;
    ConcurrentHashMap<String, ICorruptCopyFileAreaListener> corruptionListeners = new ConcurrentHashMap();

    public FilesystemRestClient() {
        boolean autoCheckin = new InstanceScope().getNode("com.ibm.team.filesystem.ide.ui").getBoolean("auto commit", false);
        ComponentSyncModel.getInstance().getLocalSynchronizationManager().setAutoSave(autoCheckin);
    }

    public void setController(IServerController controller, JSONHandler handler) {
        this.notifier = handler.getNotificationChannel();
        SyncViewDTOUtil.startSyncViewRefreshNotification(this.notifier);
        IgnoredResourcesDTOUtil.startIgnoredResourcesNotification(this.notifier);
        FSD_IgnoreManagerEventConnector.getInstance().start();
    }

    public TeamRepositoriesDTO getTeamRepositories(IProgressMonitor progress) {
        ITeamRepository[] repos = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        TeamRepositoriesDTO result = FilesystemRestClientDTOcoreFactory.eINSTANCE.createTeamRepositoriesDTO();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (String)Messages.FilesystemRestClient_GETTING_REPO_LIST, (int)repos.length);
        ITeamRepository[] iTeamRepositoryArray = repos;
        int n = repos.length;
        int n2 = 0;
        while (n2 < n) {
            ITeamRepository repo = iTeamRepositoryArray[n2];
            TeamRepositoryDTO repoDTO = FilesystemRestClientDTOcoreFactory.eINSTANCE.createTeamRepositoryDTO();
            repoDTO.setConnectionTimeout(repo.getConnectionTimeout());
            repoDTO.setErrorStateAuth(repo.getErrorState() == 2);
            repoDTO.setErrorStateIO(repo.getErrorState() == 1);
            repoDTO.setErrorStateNone(repo.getErrorState() == 0);
            if (repo.getLastError() != null) {
                repoDTO.setLastError(repo.getLastError().toString());
            }
            repoDTO.setName(repo.getName());
            if (repo.getId() != null) {
                repoDTO.setRepositoryItemIdId(repo.getId().getUuidValue());
            }
            repoDTO.setRepositoryURI(repo.getRepositoryURI());
            repoDTO.setStateLoggedIn(repo.getState() == 1);
            repoDTO.setStateLoggedOut(repo.getState() == 3);
            repoDTO.setStateLoggingIn(repo.getState() == 0);
            repoDTO.setStateLoggingOut(repo.getState() == 2);
            repoDTO.setUserId(repo.getUserId());
            IContributor contributor = repo.loggedInContributor();
            if (contributor != null) {
                repoDTO.setContributorItemIdLoggedInContributor(contributor.getItemId().getUuidValue());
            }
            result.getRepositories().add(repoDTO);
            monitor.worked(1);
            ++n2;
        }
        monitor.done();
        return result;
    }

    public TeamRepositoryDTO getTeamRepository(ParmsTeamRepository parms, IProgressMonitor progress) {
        parms.validate("getTeamRepository");
        ITeamRepository repo = TeamPlatform.getTeamRepositoryService().getTeamRepository(parms.repositoryUrl, 4);
        if (repo == null) {
            return null;
        }
        TeamRepositoryDTO repoDTO = FilesystemRestClientDTOcoreFactory.eINSTANCE.createTeamRepositoryDTO();
        repoDTO.setConnectionTimeout(repo.getConnectionTimeout());
        repoDTO.setErrorStateAuth(repo.getErrorState() == 2);
        repoDTO.setErrorStateIO(repo.getErrorState() == 1);
        repoDTO.setErrorStateNone(repo.getErrorState() == 0);
        if (repo.getLastError() != null) {
            repoDTO.setLastError(repo.getLastError().toString());
        }
        repoDTO.setName(repo.getName());
        if (repo.getId() != null) {
            repoDTO.setRepositoryItemIdId(repo.getId().getUuidValue());
        }
        repoDTO.setRepositoryURI(repo.getRepositoryURI());
        repoDTO.setStateLoggedIn(repo.getState() == 1);
        repoDTO.setStateLoggedOut(repo.getState() == 3);
        repoDTO.setStateLoggingIn(repo.getState() == 0);
        repoDTO.setStateLoggingOut(repo.getState() == 2);
        repoDTO.setUserId(repo.getUserId());
        IContributor contributor = repo.loggedInContributor();
        if (contributor != null) {
            repoDTO.setContributorItemIdLoggedInContributor(contributor.getItemId().getUuidValue());
        }
        return repoDTO;
    }

    public LoadFileOperationResultDTO postLoadFiles(ParmsLoadFiles parms, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (parms.toLoad == null) {
            throw new IllegalArgumentException("'toLoad' is missing");
        }
        parms.validate("postLoadFiles");
        ITeamRepository repo = CommonUtil.getTeamRepository((String)parms.repositoryUrl);
        SnapshotId context = SyncViewDTOUtil.getSnapshotId(repo, parms.pathResolver);
        HashSet<StateId<IFileItem>> toFetch = new HashSet<StateId<IFileItem>>();
        int i = 0;
        while (i < parms.toLoad.length) {
            ParmsLoadFileRequest next = parms.toLoad[i];
            StateId<IFileItem> stateId = this.getStateIdForLoadRequest(next);
            toFetch.add(stateId);
            ++i;
        }
        Map fetchedItems = RepoFetcher.fetchItems((ITeamRepository)repo, toFetch, (IProgressMonitor)progress.newChild(30));
        List<LoadFileRequest> toLoad = new ArrayList<LoadFileRequest>();
        int i2 = 0;
        while (i2 < parms.toLoad.length) {
            ParmsLoadFileRequest next = parms.toLoad[i2];
            StateId<IFileItem> stateId = this.getStateIdForLoadRequest(next);
            IFileItem nextItem = (IFileItem)fetchedItems.get(stateId);
            if (nextItem != null) {
                if (next.targetPath == null) {
                    UUID componentUuid = UUID.valueOf((String)next.componentItemId);
                    ItemId componentId = new ItemId(IComponent.ITEM_TYPE, componentUuid);
                    toLoad.add(LoadFileRequest.create(nextItem, (ItemId<IComponent>)componentId, repo));
                } else {
                    toLoad.add(LoadFileRequest.create(new Path(next.targetPath).makeAbsolute(), nextItem, repo));
                }
            }
            ++i2;
        }
        if (context != null) {
            SnapshotPathResolver pathResolver = SnapshotPathResolver.create(context);
            toLoad = LoadFileRequest.resolvePaths(toLoad, pathResolver, (IProgressMonitor)progress.newChild(30));
        }
        Map<LoadFileRequest, IStatus> results = LoadFileRequest.load(toLoad, (IProgressMonitor)progress.newChild(40));
        LoadFileOperationResultDTO result = FilesystemRestClientDTOloadFactory.eINSTANCE.createLoadFileOperationResultDTO();
        List fileResults = result.getFileResults();
        for (LoadFileRequest next : toLoad) {
            IStatus nextStatus = results.get(next);
            LoadFileResultDTO nextResult = FilesystemRestClientDTOloadFactory.eINSTANCE.createLoadFileResultDTO();
            if (nextStatus == null) {
                nextStatus = Status.OK_STATUS;
            }
            nextResult.setMessage(nextStatus.getMessage());
            nextResult.setSeverity(nextStatus.getSeverity());
            fileResults.add(nextResult);
        }
        return result;
    }

    private StateId<IFileItem> getStateIdForLoadRequest(ParmsLoadFileRequest next) {
        UUID nextItemId = UUID.valueOf((String)next.fileItemId);
        UUID nextStateId = UUID.valueOf((String)next.fileItemStateId);
        StateId stateId = new StateId(IFileItem.ITEM_TYPE, nextItemId, nextStateId);
        return stateId;
    }

    public void postLogin(final ParmsLogin parms, IProgressMonitor monitor) throws TeamRepositoryException {
        parms.validate("postLogin");
        ITeamRepository repo = TeamPlatform.getTeamRepositoryService().getTeamRepository(parms.repositoryUrl);
        repo.registerLoginHandler(new ITeamRepository.ILoginHandler(){

            public ITeamRepository.ILoginHandler.ILoginInfo challenge(ITeamRepository repository) {
                return new ITeamRepository.ILoginHandler.ILoginInfo(){

                    public String getUserId() {
                        return parms.userId;
                    }

                    public String getPassword() {
                        return parms.password;
                    }
                };
            }
        });
        if (parms.connectionTimeoutInSeconds != null) {
            repo.setConnectionTimeout(parms.connectionTimeoutInSeconds.intValue());
        }
        if (parms.proxyHost != null) {
            repo.setProxy(parms.proxyHost, parms.proxyPort.intValue(), parms.proxyUserName, parms.password);
        }
        repo.login(monitor);
        TeamPlatform.getTeamRepositoryService().addTeamRepository(repo);
    }

    public void postLogout(ParmsLogout parms, IProgressMonitor progress) throws TeamRepositoryException {
        parms.validate("postLogout");
        ITeamRepository repo = TeamPlatform.getTeamRepositoryService().getTeamRepository(parms.repositoryUrl);
        repo.logout();
        TeamPlatform.getTeamRepositoryService().removeTeamRepository(repo);
    }

    public void postActivate(ParmsActivate parms, IProgressMonitor progress) throws TeamRepositoryException {
        parms.validate("postActivate");
        ParmsWorkspace[] parmsWorkspaceArray = parms.workspaces;
        int n = parms.workspaces.length;
        int n2 = 0;
        while (n2 < n) {
            ParmsWorkspace workspace = parmsWorkspaceArray[n2];
            ActiveWorkspaceManager.getInstance().activate(workspace.getWorkspaceHandle());
            ++n2;
        }
    }

    public void postDeactivate(ParmsDeactivate parms, IProgressMonitor progress) throws TeamRepositoryException {
        parms.validate("postDeactivate");
        ParmsWorkspace[] parmsWorkspaceArray = parms.workspaces;
        int n = parms.workspaces.length;
        int n2 = 0;
        while (n2 < n) {
            ParmsWorkspace workspace = parmsWorkspaceArray[n2];
            ActiveWorkspaceManager.getInstance().deactivate(workspace.getWorkspaceHandle());
            ++n2;
        }
    }

    public void postSetWorkspaceTarget(ParmsWorkspaceTarget parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        parms.validate("postSetWorkspaceTarget");
        IWorkspaceHandle workspace = parms.activeWorkspace.getWorkspaceHandle();
        IWorkspaceHandle target = parms.targetWorkspace.getWorkspaceHandle();
        ActiveWorkspaceManager.getInstance().setWorkspaceCollaboration(workspace, target, true, (IProgressMonitor)monitor.newChild(90));
    }

    public void postSetComponentTarget(ParmsComponentTarget parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        parms.validate("postSetComponentTarget");
        IWorkspaceHandle workspace = parms.activeWorkspace.getWorkspaceHandle();
        List components = parms.getComponents();
        IWorkspaceHandle target = parms.targetWorkspace.getWorkspaceHandle();
        ActiveWorkspaceManager.getInstance().setComponentCollaboration(workspace, (Collection<? extends IComponentHandle>)components, target, true, (IProgressMonitor)monitor.newChild(90));
    }

    public SyncViewDTO getRefreshSyncView(IProgressMonitor progress) throws TeamRepositoryException {
        try {
            ComponentSyncModel.getInstance().refresh(true, progress);
        }
        catch (FileSystemClientException e) {
            throw new TeamRepositoryException(CommonUtil.getErrorMessage((FileSystemClientException)e), (Throwable)e);
        }
        return this.getSyncView(null);
    }

    public SyncViewDTO getSyncView(IProgressMonitor progress) {
        return SyncViewDTOUtil.getSyncView(ComponentSyncModel.getInstance());
    }

    public SyncViewDTO getJoinSyncView(IProgressMonitor progress) throws TeamRepositoryException {
        EventManager eventManager = ((ComponentSyncModel)ComponentSyncModel.getInstance()).getEventManager();
        while (eventManager.internalIsBusy()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.getSyncView(null);
    }

    public BaselineSyncDTO getChangeSetsBaseline(ParmsChangeSetsBaseline parms, IProgressMonitor progress) throws TeamRepositoryException {
        parms.validate("getChangeSetsBaseline");
        try {
            return SyncViewDTOUtil.getChangeSetsBaseline(ComponentSyncModel.getInstance(), parms, progress);
        }
        catch (FileSystemClientException e) {
            throw new TeamRepositoryException(CommonUtil.getErrorMessage((FileSystemClientException)e), (Throwable)e);
        }
    }

    public DescriptionSyncDTO getSyncDescription(ParmsSyncDescription parms) {
        parms.validate("getSyncDescription");
        return SyncDescriptionUtil.getDescription(parms);
    }

    public SameOccurrencesSyncDTO getSyncSameOccurrences(ParmsSyncSameOccurrences parms) {
        parms.validate("getSameOccurrences");
        return SearchChangesUtil.getSyncSameOccurrences(parms);
    }

    public ContributorListSyncDTO getContributorList(ParmsContributorList parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        parms.validate("getContributorList");
        ITeamRepository repo = parms.getTeamRepository();
        List itemHandles = parms.getContributorHandles();
        List contributors = repo.itemManager().fetchCompleteItems(itemHandles, 0, (IProgressMonitor)monitor.newChild(90));
        ContributorListSyncDTO result = FilesystemRestClientDTOsyncFactory.eINSTANCE.createContributorListSyncDTO();
        for (IContributor contributor : contributors) {
            ContributorSyncDTO csDTO = FilesystemRestClientDTOsyncFactory.eINSTANCE.createContributorSyncDTO();
            csDTO.setRepositoryUrl(parms.repositoryUrl);
            csDTO.setContributorItemId(contributor.getItemId().getUuidValue());
            csDTO.setEmailAddress(contributor.getEmailAddress());
            csDTO.setName(contributor.getName());
            csDTO.setUserId(contributor.getUserId());
            result.getContributors().add(csDTO);
        }
        return result;
    }

    public EclipseWorkspacePathsResultDTO getEclipseWorkspacePaths(ParmsEclipseWorkspacePaths parms, IProgressMonitor progress) throws TeamRepositoryException {
        return ResourceUtil.getEclipseWorkspacePaths(parms, progress);
    }

    public OSPathsResultDTO getOSPaths(ParmsOSPaths parms, IProgressMonitor monitor) {
        return ResourceUtil.getOSPaths(parms, monitor);
    }

    public ResourcesDTO getResourceProperties(ParmsResourceProperties parms, IProgressMonitor progress) throws TeamRepositoryException {
        return ResourceUtil.getResourceProperties(parms, progress);
    }

    public ResourcePropertyChangeResultDTO postResourceProperties(ParmsResourcePropertyUpdates parms, IProgressMonitor progress) throws TeamRepositoryException {
        return ResourceUtil.postResourceProperties(parms, progress);
    }

    public LoadEvaluationDTO getLoadCFA(ParmsLoad parms, IProgressMonitor progress) throws TeamRepositoryException {
        return LoadUtil.evaluateLoad(parms, progress);
    }

    public void postLoadCFA(ParmsLoad parms, IProgressMonitor progress) throws TeamRepositoryException {
        LoadUtil.load(parms, progress);
    }

    public void postUnloadCFA(ParmsUnload parms, IProgressMonitor progress) throws TeamRepositoryException {
        LoadUtil.unload(parms, progress);
    }

    public ShareResultDTO postShare(ParmsShare parms, IProgressMonitor progress) throws TeamRepositoryException {
        return ShareUtil.share(parms, progress);
    }

    public CreateResultDTO postCreateChangeSet(ParmsCreateChangeSet parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress);
        parms.validate("postCreateChangeSet");
        IWorkspaceConnection wc = parms.workspace.getWorkspaceConnection((IProgressMonitor)monitor.newChild(10));
        IComponentHandle componentHandle = parms.getComponentHandle();
        IChangeSetHandle changeSet = wc.createChangeSet(componentHandle, parms.comment, parms.current.booleanValue(), (IProgressMonitor)monitor.newChild(80));
        CreateResultDTO crDTO = FilesystemRestClientDTOchangesetFactory.eINSTANCE.createCreateResultDTO();
        crDTO.setChangeSetItemId(changeSet.getItemId().getUuidValue());
        return crDTO;
    }

    public void postSetCurrentChangeSet(ParmsSetCurrentChangeSet parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress);
        parms.validate("postSetCurrentChangeSet");
        IWorkspaceConnection wc = parms.workspace.getWorkspaceConnection((IProgressMonitor)monitor.newChild(10));
        IChangeSetHandle current = parms.getChangeSetHandle();
        wc.setCurrentChangeSet(current, (IProgressMonitor)monitor.newChild(80));
    }

    public void postSetChangeSetComment(ParmsSetChangeSetComment parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        parms.validate("postSetChangeSetComment");
        ITeamRepository repo = CommonUtil.getTeamRepository((String)parms.changeSet.repositoryUrl);
        IChangeSetHandle changeSetHandle = parms.changeSet.getChangeSetHandle();
        SCMPlatform.getWorkspaceManager((ITeamRepository)repo).setComment(changeSetHandle, parms.comment, (IProgressMonitor)monitor.newChild(90));
    }

    public void postCompleteChangeSets(ParmsCompleteChangeSets parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        parms.validate("postCompleteChangeSets");
        IWorkspaceConnection wc = parms.workspace.getWorkspaceConnection((IProgressMonitor)monitor.newChild(20));
        List changeSets = parms.getChangeSetHandles();
        wc.closeChangeSets((Collection)changeSets, (IProgressMonitor)monitor.newChild(70));
    }

    public WorkspaceDetailsDTO postWorkspace(ParmsPostWorkspace parms, IProgressMonitor progress) throws TeamRepositoryException {
        return WorkspaceUtil.postWorkspace(parms, progress);
    }

    public CheckInResultDTO postCheckInChanges(ParmsCheckInChanges parms, IProgressMonitor progress) throws TeamRepositoryException {
        return CommitUtil.checkInChanges(parms, progress);
    }

    public UndoCheckedInChangesResultDTO postUndoCheckedInChanges(ParmsUndoCheckedInChanges parms, IProgressMonitor progress) throws TeamRepositoryException {
        return UndoChangesUtil.undo(parms, progress);
    }

    public UndoLocalChangesResultDTO postUndoLocalChanges(ParmsUndoLocalChanges parms, IProgressMonitor progress) throws TeamRepositoryException {
        return UndoChangesUtil.undo(parms, progress);
    }

    public WorkspaceUpdateResultDTO postWorkspaceUpdate(ParmsWorkspaceUpdate parms, IProgressMonitor progress) throws TeamRepositoryException {
        return WorkspaceUpdateUtil.workspaceUpdate(parms, progress);
    }

    public DeliverResultDTO postDeliver(ParmsDeliver parms, IProgressMonitor progress) throws TeamRepositoryException {
        return DeliverUtil.deliver(parms, progress);
    }

    public ResolveAutoMergeResultDTO postAutoResolve(ParmsAutoMerge parms, IProgressMonitor monitor) throws TeamRepositoryException {
        return ConflictResolutionUtil.autoResolve(parms, monitor);
    }

    public ResolveAsMergedResultDTO postResolveAsMerged(ParmsResolveAsMerged parms, IProgressMonitor monitor) throws TeamRepositoryException {
        return ConflictResolutionUtil.resolveAsMerged(parms, monitor);
    }

    public ResolveWithProposedResultDTO postResolveWithProposed(ParmsResolveWithProposed parms, IProgressMonitor monitor) throws TeamRepositoryException {
        return ConflictResolutionUtil.resolveWithProposed(parms, monitor);
    }

    public ResolveWithProposedEvaluationDTO getResolveWithProposed(ParmsResolveWithProposed parms, IProgressMonitor monitor) throws TeamRepositoryException {
        return ConflictResolutionUtil.evaluateResolveWithProposed(parms, monitor);
    }

    public SuspendResultDTO postSuspendChangeSets(ParmsSuspendChangeSets parms, IProgressMonitor progress) throws TeamRepositoryException {
        return SuspendResumeDiscardChangeSetUtil.suspend(parms, progress);
    }

    public ResumeResultDTO postResumeChangeSets(ParmsResumeChangeSets parms, IProgressMonitor progress) throws TeamRepositoryException {
        return SuspendResumeDiscardChangeSetUtil.resume(parms, progress);
    }

    public DiscardResultDTO postDiscardChangeSets(ParmsDiscardChangeSets parms, IProgressMonitor progress) throws TeamRepositoryException {
        return SuspendResumeDiscardChangeSetUtil.discard(parms, progress);
    }

    public void postRemoveSuspendedChangeSets(ParmsRemoveSuspendedChangeSets parms, IProgressMonitor progress) throws TeamRepositoryException {
        SuspendResumeDiscardChangeSetUtil.removeSuspended(parms, progress);
    }

    public String postCompareCE(ParmsCompareCE parms, IProgressMonitor monitor) throws TeamRepositoryException {
        parms.validate("postCompareCE");
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ITeamRepository repo1 = CommonUtil.getTeamRepository((String)parms.context1.repositoryUrl);
        ITeamRepository repo2 = CommonUtil.getTeamRepository((String)parms.context2.repositoryUrl);
        SnapshotId snapshotId1 = SyncViewDTOUtil.getSnapshotId(repo1, parms.context1);
        SnapshotId snapshotId2 = SyncViewDTOUtil.getSnapshotId(repo2, parms.context2);
        ISnapshot snapshot1 = snapshotId1.getSnapshot((IProgressMonitor)progress.newChild(10));
        ISnapshot snapshot2 = snapshotId2.getSnapshot((IProgressMonitor)progress.newChild(10));
        SnapshotSyncReport comparison = snapshot1.compareTo(snapshot2, (IProgressMonitor)progress.newChild(70));
        String comparisonName = SyncViewDTOUtil.computeComparisonName(snapshot1, snapshot2);
        ChangeExplorerRestState.ChangeExplorerState state = ChangeExplorerRestState.createState(repo1, comparisonName, comparison);
        return state.getId().getUuidValue();
    }

    public String postOpenCE(ParmsOpenCE parms, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        parms.validate("postOpenCE");
        ITeamRepository repo = CommonUtil.getTeamRepository((String)parms.repositoryUrl);
        List itemIds = ScmRestServiceUtil.createItemIds((String[])parms.changeSetItemIds, (IItemType)IChangeSet.ITEM_TYPE);
        String comparisonName = SyncViewDTOUtil.computeChangeSetInputDescription(itemIds, repo, (IProgressMonitor)progress.newChild(30));
        SnapshotSyncReport comparison = SnapshotSyncReport.generateSyncReport((ITeamRepository)repo, (List)Collections.EMPTY_LIST, (List)itemIds, (IProgressMonitor)progress.newChild(40));
        ChangeExplorerRestState.ChangeExplorerState state = ChangeExplorerRestState.createState(repo, comparisonName, comparison);
        return state.getId().getUuidValue();
    }

    public void postDeallocateCE(ParmsDeallocateCE parms, IProgressMonitor monitor) throws TeamRepositoryException {
        parms.validate("postDeallocateCE");
        UUID uuid = UUID.valueOf((String)parms.inputID);
        ChangeExplorerRestState.deallocateState(uuid);
    }

    public WorkspaceDetailsDTO getWorkspaceDetails(ParmsGetWorkspace parms, IProgressMonitor progress) throws TeamRepositoryException {
        return WorkspaceUtil.getWorkspaceDetails(parms, progress);
    }

    public PutWorkspaceResultDTO postPutWorkspace(ParmsPutWorkspace parms, IProgressMonitor progress) throws TeamRepositoryException {
        return WorkspaceUtil.putWorkspace(parms, progress);
    }

    public void postDeleteWorkspace(ParmsWorkspace parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        parms.validate("", new Object[]{"postDeleteWorkspace"});
        ITeamRepository repo = CommonUtil.getTeamRepository((String)parms.repositoryUrl);
        IWorkspaceHandle workspaceHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)parms.workspaceItemId), null);
        IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
        wm.deleteWorkspace(workspaceHandle, (IProgressMonitor)monitor.newChild(100));
    }

    public void postPutComponent(ParmsPutComponent parms, IProgressMonitor progress) throws TeamRepositoryException {
        WorkspaceUtil.putComponent(parms, progress);
    }

    public String getCopyFileAreaRoot(IProgressMonitor progress) {
        return RefreshUtil.getCopyFileAreaRoot(progress);
    }

    public void getRefreshEclipseWorkspace(ParmsRefreshEclipseWorkspace parm, IProgressMonitor progress) throws TeamRepositoryException {
        RefreshUtil.refreshEclipseWorkspace(parm, progress);
    }

    public IgnoreRulesDTO getIgnorePatterns(ParmsIgnoreLocationList parms, IProgressMonitor progress) throws TeamRepositoryException {
        parms.validate("getIgnorePatterns");
        IgnoreRulesDTO toReturn = FilesystemRestClientDTOignoresFactory.eINSTANCE.createIgnoreRulesDTO();
        this.populateIgnoreRulesDTO(toReturn, parms.paths, parms.recurseIntoSubdirectories, progress);
        return toReturn;
    }

    private void populateIgnoreRulesDTO(IgnoreRulesDTO toReturn, String[] paths, boolean recurse, IProgressMonitor progress) throws TeamRepositoryException {
        DefaultIgnoreProvider dip = DefaultIgnoreProvider.getDefault();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (String)Messages.FilesystemRestClient_GET_IGNORE_RULES_TASKNAME, (int)(paths.length * (recurse ? 2 : 1)));
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            JazzIgnoreFile ignoreFile;
            String path = stringArray[n2];
            SubMonitor pathMonitor = monitor.newChild(1);
            pathMonitor.beginTask(NLS.bind((String)Messages.FilesystemRestClient_GET_IGNORE_RULES_RUNNING_ON_DIRECTORY, (Object)path), 1);
            IShareable shareable = ResourceUtil.findShareableFor(path);
            try {
                ignoreFile = dip.getIgnoreFileForFolder(shareable, shareable.getLocalFullPath(), false);
            }
            catch (FileSystemClientException e) {
                throw FilesystemRestClient.translate("Cannot find ignore file for " + path, (CoreException)((Object)e));
            }
            if (ignoreFile != null) {
                IResource r;
                for (IgnoreRule rule : ignoreFile.getRules()) {
                    toReturn.getRules().add(IgnoresUtil.translateRule(rule));
                }
                if (recurse && (r = ResourceUtil.findResourceFor(path)) instanceof IContainer) {
                    IResource[] members;
                    IContainer c = (IContainer)r;
                    try {
                        members = c.members();
                    }
                    catch (CoreException e) {
                        throw FilesystemRestClient.translate("Recurse failed. Cannot find listing of " + r.getFullPath().toPortableString(), e);
                    }
                    ArrayList<String> childPaths = new ArrayList<String>(members.length);
                    IResource[] iResourceArray = members;
                    int n3 = members.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IShareable memberAsShareable;
                        IResource member = iResourceArray[n4];
                        if (member instanceof IContainer && ((memberAsShareable = (IShareable)member.getAdapter(IShareable.class)) == null || !memberAsShareable.shouldBeIgnored())) {
                            childPaths.add(member.getFullPath().toPortableString());
                        }
                        ++n4;
                    }
                    this.populateIgnoreRulesDTO(toReturn, childPaths.toArray(new String[0]), true, (IProgressMonitor)pathMonitor.newChild(1));
                }
                pathMonitor.done();
            }
            ++n2;
        }
        monitor.done();
    }

    public void postAddIgnorePatterns(ParmsIgnoreRuleList parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(parms.rules.length + 2));
        IgnoresUtil.ValidatedIgnoreRuleList val = IgnoresUtil.validateIgnoreRuleList(parms, "postAddIgnorePatterns", (IProgressMonitor)monitor.newChild(1));
        IgnoreOperation op = new IgnoreOperation();
        try {
            op.setIgnoreRules(val.wc, val.compHandle, val.rules, (IProgressMonitor)monitor.newChild(1));
        }
        catch (FileSystemClientException e) {
            throw new TeamRepositoryException("Could not set ignore rules: " + CommonUtil.getErrorMessage((FileSystemClientException)e), (Throwable)e);
        }
        try {
            op.execute((IProgressMonitor)monitor);
        }
        catch (FileSystemClientException e) {
            throw new TeamRepositoryException("Failure running ignore operation: " + CommonUtil.getErrorMessage((FileSystemClientException)e), (Throwable)e);
        }
    }

    public void postRemoveIgnorePatterns(ParmsIgnoreRuleList parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(parms.rules.length + 1));
        IgnoresUtil.ValidatedIgnoreRuleList val = IgnoresUtil.validateIgnoreRuleList(parms, "postRemoveIgnorePatterns", (IProgressMonitor)monitor.newChild(1));
        try {
            DefaultIgnoreProvider.getDefault().removeIgnoreRules(val.rules, (IProgressMonitor)monitor);
        }
        catch (FileSystemClientException e) {
            throw new TeamRepositoryException("Failed to remove all ignore rules " + CommonUtil.getErrorMessage((FileSystemClientException)e), (Throwable)e);
        }
    }

    public void postMoveResources(ParmsMoveResources parms, IProgressMonitor progress) throws TeamRepositoryException {
        if (parms.moves == null || parms.moves.length == 0) {
            return;
        }
        parms.validate("postMoveResource");
        IResource[] sources = new IResource[parms.moves.length];
        IResource[] dests = new IResource[parms.moves.length];
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        int i = 0;
        while (i < parms.moves.length) {
            sources[i] = ResourceUtil.findResourceFor(parms.moves[i].source);
            if (sources[i] == null) {
                throw new IllegalArgumentException("Source does not exist at index " + i + ": " + parms.moves[i].source);
            }
            Path dest = new Path(parms.moves[i].dest);
            switch (sources[i].getType()) {
                case 1: {
                    dests[i] = root.getFile((IPath)dest);
                    break;
                }
                case 2: {
                    dests[i] = root.getFolder((IPath)dest);
                    break;
                }
                case 4: {
                    throw new IllegalArgumentException("Path refers to project at index " + i + ": " + parms.moves[i].source);
                }
                case 8: {
                    throw new IllegalArgumentException("Path refers to root at index " + i + ": " + parms.moves[i].source);
                }
                default: {
                    throw new IllegalArgumentException("Unknown resource type: " + sources[i].getType());
                }
            }
            ++i;
        }
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(parms.moves.length + 1));
        ISchedulingRule rule = FilesystemRestClient.createMoveRuleFor(sources, dests);
        try {
            Job.getJobManager().beginRule(rule, (IProgressMonitor)monitor.newChild(1));
            int i2 = 0;
            while (i2 < sources.length) {
                if (!sources[i2].exists()) {
                    throw new IllegalArgumentException("Source does not exist at index " + i2 + ": " + parms.moves[i2].source);
                }
                if (dests[i2].exists()) {
                    throw new IllegalArgumentException("Destination exists at index " + i2 + ": " + parms.moves[i2].dest);
                }
                if (!dests[i2].getParent().exists()) {
                    throw new IllegalArgumentException("Destination parent does not exist at index " + i2 + ": " + parms.moves[i2].dest);
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < sources.length) {
                try {
                    sources[i2].move(dests[i2].getFullPath(), true, (IProgressMonitor)monitor.newChild(1));
                }
                catch (CoreException coreException) {
                    throw new TeamRepositoryException("Failure running move " + i2 + ": " + sources[i2].getFullPath() + " to " + dests[i2].getFullPath());
                }
                ++i2;
            }
        }
        finally {
            Job.getJobManager().endRule(rule);
        }
    }

    public ChangeSetSyncDTO[] getChangeSets(ParmsGetChangeSets parms, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        parms.validate("getChangeSets");
        List itemIds = ScmRestServiceUtil.createItemIds((String[])parms.changeSetItemIds, (IItemType)IChangeSet.ITEM_TYPE);
        ITeamRepository repo = CommonUtil.getTeamRepository((String)parms.repositoryUrl);
        List<ChangeSetSyncDTO> result = SyncViewDTOUtil.createChangeSetDTOsFromChangeSets(repo, itemIds, parms.settings, (IProgressMonitor)progress.newChild(100));
        return result.toArray(new ChangeSetSyncDTO[result.size()]);
    }

    public String getInputNameCE(ParmsInputNameCE parms, IProgressMonitor monitor) throws TeamRepositoryException {
        parms.validate("getInputCE");
        UUID inputId = UUID.valueOf((String)parms.inputID);
        ChangeExplorerRestState.ChangeExplorerState state = ChangeExplorerRestState.getState(inputId);
        return state.getInputName();
    }

    public CESyncDTO getComponentsCE(ParmsGetComponentsCE parms, IProgressMonitor monitor) throws TeamRepositoryException {
        parms.validate("getComponentsCE");
        UUID inputId = UUID.valueOf((String)parms.inputId);
        ChangeExplorerRestState.ChangeExplorerState state = ChangeExplorerRestState.getState(inputId);
        CESyncDTO result = FilesystemRestClientDTOsyncFactory.eINSTANCE.createCESyncDTO();
        boolean incoming = parms.incoming;
        SnapshotSyncReport syncReport = state.getSyncReport();
        SnapshotSyncReportFragment incomingStuff = syncReport.get(this.getFlowType(incoming));
        Set additions = incomingStuff.getComponentChanges().getAdditions();
        Set removals = incomingStuff.getComponentChanges().getRemovals();
        result.getAddedComponents().addAll(ScmRestServiceUtil.getItemIdsAsStrings((Collection)additions));
        result.getRemovedComponents().addAll(ScmRestServiceUtil.getItemIdsAsStrings((Collection)removals));
        result.getChangedComponents().addAll(ScmRestServiceUtil.getItemIdsAsStrings((Collection)incomingStuff.getComponentModifications().keySet()));
        return result;
    }

    public CEComponentSyncDTO getChangedComponentCE(ParmsGetChangedComponentCE parms, IProgressMonitor monitor) throws TeamRepositoryException {
        if (parms == null) {
            throw new IllegalArgumentException("missing 'parms' argument");
        }
        parms.validate("getChangedComponentCE");
        CEComponentSyncDTO result = FilesystemRestClientDTOsyncFactory.eINSTANCE.createCEComponentSyncDTO();
        boolean incoming = parms.incoming;
        ChangeExplorerRestState.ChangeExplorerState state = ChangeExplorerRestState.getState(UUID.valueOf((String)parms.inputId));
        SnapshotSyncReportFragment syncReport = state.getSyncReport().get(this.getFlowType(incoming));
        ItemId componentId = new ItemId(IComponent.ITEM_TYPE, UUID.valueOf((String)parms.componentItemId));
        ComponentSyncReportFragment componentReport = (ComponentSyncReportFragment)syncReport.getComponentModifications().get(componentId);
        if (componentReport != null) {
            result.getChangeSets().addAll(ScmRestServiceUtil.getItemIdsAsStrings((Collection)componentReport.getChangeSets().getChangeSets()));
            result.getBaselines().addAll(ScmRestServiceUtil.getItemIdsAsStrings((Collection)componentReport.getBaselines()));
        }
        return result;
    }

    public CEBaselineSyncDTO getBaselineChangesCE(ParmsGetBaselineChangesCE parms, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (parms == null) {
            throw new IllegalArgumentException("missing 'parms' argument");
        }
        parms.validate("getBaselineChangesCE");
        CEBaselineSyncDTO result = FilesystemRestClientDTOsyncFactory.eINSTANCE.createCEBaselineSyncDTO();
        boolean incoming = parms.incoming;
        ChangeExplorerRestState.ChangeExplorerState state = ChangeExplorerRestState.getState(UUID.valueOf((String)parms.inputId));
        if (state == null) {
            throw new IllegalArgumentException("unknown change explorer state: " + parms.inputId);
        }
        SnapshotSyncReportFragment syncReport = state.getSyncReport().get(this.getFlowType(incoming));
        ItemId baselineId = new ItemId(IBaseline.ITEM_TYPE, UUID.valueOf((String)parms.baselineItemId));
        ITeamRepository repo = state.getRepository();
        IBaseline fetchedBaseline = (IBaseline)RepoFetcher.fetchCurrent((ITeamRepository)repo, (ItemId)baselineId, (IProgressMonitor)progress.newChild(50));
        ItemId component = ItemUtil.getComponent((IBaseline)fetchedBaseline);
        ComponentSyncReportFragment mods = (ComponentSyncReportFragment)syncReport.getComponentModifications().get(component);
        if (mods != null) {
            int index = mods.getBaselines().indexOf(baselineId);
            ItemId previousBaseline = mods.commonAncestor();
            if (index < mods.getBaselines().size() - 1) {
                previousBaseline = (ItemId)mods.getBaselines().get(index + 1);
            }
            HashSet<ItemId<IChangeSet>> allChangeSets = new HashSet<ItemId<IChangeSet>>();
            allChangeSets.addAll(mods.computeNetChange(repo, (IProgressMonitor)progress.newChild(10)).getChangeSets());
            List<ItemId<IChangeSet>> differentChangeSets = SyncViewDTOUtil.fetchDifferentChangeSets(repo, (ItemId<IBaseline>)baselineId, (ItemId<IBaseline>)previousBaseline, allChangeSets, progress.newChild(40));
            result.getChangeSets().addAll(ScmRestServiceUtil.getItemIdsAsStrings(differentChangeSets));
        }
        return result;
    }

    public ChangeSetSyncDTO getStructuralChangesCE(ParmsGetStructuralChangesCE parms, IProgressMonitor monitor) throws TeamRepositoryException {
        ChangeDescription description;
        ConfigurationChange change;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (parms == null) {
            throw new IllegalArgumentException("missing 'parms' argument");
        }
        parms.validate("getStructuralChangesCE");
        ChangeExplorerRestState.ChangeExplorerState state = ChangeExplorerRestState.getState(UUID.valueOf((String)parms.inputId));
        if (state == null) {
            throw new IllegalArgumentException("unknown change explorer state: " + parms.inputId);
        }
        ITeamRepository repo = state.getRepository();
        SnapshotSyncReportFragment syncReport = state.getSyncReport().get(this.getFlowType(parms.incoming));
        ItemId componentId = new ItemId(IComponent.ITEM_TYPE, UUID.valueOf((String)parms.componentItemId));
        ComponentSyncReportFragment componentSyncReport = (ComponentSyncReportFragment)syncReport.getComponentModifications().get(componentId);
        if (componentSyncReport == null) {
            change = new ConfigurationChange();
            description = new ChangeDescription();
        } else {
            List<IChangeSet> orderedChangeSets = SyncViewDTOUtil.getChangeSets(repo, componentSyncReport, false, (IProgressMonitor)progress.newChild(20));
            change = ClientConfigurationChangeFactory.createChange((ITeamRepository)repo, orderedChangeSets, (IProgressMonitor)progress.newChild(20));
            description = ConfigurationChangeFactory.getDescription(repo, orderedChangeSets, (IProgressMonitor)progress.newChild(20));
        }
        progress.setWorkRemaining(40);
        List<ChangeSetSyncDTO> dtos = SyncViewDTOUtil.createChangeSetDTOs(repo, Collections.singletonList(Pair.create(change, description)), parms.settings, (IProgressMonitor)progress.newChild(40));
        if (dtos.size() < 1) {
            throw new IllegalStateException("SyncViewDTOUtil.createChangeSetDTOs didn't return anything in its result");
        }
        return dtos.iterator().next();
    }

    public MergePatchDTO postMergePatch(ParmsMergePatch parms, IProgressMonitor monitor) throws TeamRepositoryException {
        int accepted;
        final HashSet<UUID> uuids = new HashSet<UUID>();
        parms.validate("postMergePatch");
        int i = 0;
        while (i < parms.pendingPatchIds.length) {
            String next = parms.pendingPatchIds[i];
            uuids.add(UUID.valueOf((String)next));
            ++i;
        }
        final PatchModel model = PatchModel.getDefault();
        Realm realm = model.getRealm();
        final ArrayList toDiscard = new ArrayList();
        final ArrayList<LocalFileOp> toAccept = new ArrayList<LocalFileOp>();
        RealmUtil.syncExec((Realm)realm, (Runnable)new Runnable(){

            public void run() {
                for (PendingContentChange next : model.getPatches()) {
                    if (!uuids.contains(next.getId())) continue;
                    Collection<LocalFileOp> fileOp = next.getAllOps();
                    toAccept.addAll(fileOp);
                    if (!fileOp.isEmpty()) continue;
                    toDiscard.add(next);
                }
            }
        });
        try {
            accepted = AcceptHunksOperation.acceptHunks(toAccept, monitor);
        }
        catch (FileSystemClientException e) {
            throw new TeamRepositoryException(CommonUtil.getErrorMessage((FileSystemClientException)e), (Throwable)e);
        }
        RealmUtil.syncExec((Realm)realm, (Runnable)new Runnable(){

            public void run() {
                model.removeAll(toDiscard);
            }
        });
        MergePatchDTO result = FilesystemRestClientDTOsyncFactory.eINSTANCE.createMergePatchDTO();
        result.setSomeHunksFailed(accepted < toAccept.size());
        result.setSomeHunksMatched(accepted > 0);
        return result;
    }

    public PendingPatchesDTO getPendingPatches(final ParmsPendingPatches parms, IProgressMonitor monitor) throws TeamRepositoryException {
        if (parms == null) {
            throw new IllegalArgumentException("missing 'parms'");
        }
        parms.validate("getPendingPatches");
        final TeamRepositoryException[] exception = new TeamRepositoryException[1];
        final ITeamRepository repo = CommonUtil.getTeamRepository((String)parms.repositoryUrl);
        final PendingPatchesDTO[] result = new PendingPatchesDTO[1];
        final PatchModel model = PatchModel.getDefault();
        Realm realm = model.getRealm();
        RealmUtil.syncExec((Realm)realm, (Runnable)new Runnable(){

            public void run() {
                PendingPatchesDTO nextDTO;
                result[0] = nextDTO = FilesystemRestClientDTOsyncFactory.eINSTANCE.createPendingPatchesDTO();
                IObservableSet contentChanges = model.getPatches();
                HashMap<UUID, ParsedPatch> patchMap = new HashMap<UUID, ParsedPatch>();
                for (PendingContentChange next : contentChanges) {
                    ParsedPatch pp = LocalFileOp.computePatch(FilesystemRestClient.getAllOps(next));
                    patchMap.put(next.getId(), pp);
                }
                List patches = nextDTO.getPatches();
                try {
                    List<ChangeSetSyncDTO> dto = SyncViewDTOUtil.createChangeSetDTOsFromPatches(repo, patchMap, parms.settings, null);
                    patches.addAll(dto);
                    result[0] = nextDTO;
                }
                catch (TeamRepositoryException e) {
                    exception[0] = e;
                }
                catch (CoreException e) {
                    exception[0] = new TeamRepositoryException((Throwable)e);
                }
            }
        });
        if (exception[0] != null) {
            throw new TeamRepositoryException((Throwable)exception[0]);
        }
        return result[0];
    }

    private static Collection<LocalFileOp> getAllOps(PendingContentChange nextChange) {
        ArrayList<LocalFileOp> result = new ArrayList<LocalFileOp>();
        for (PatchedDirectory nextDirectory : nextChange.getPatchedDirectories()) {
            for (PatchedFile nextFile : nextDirectory.getPatchedFiles()) {
                result.addAll((Collection<LocalFileOp>)nextFile.getOps());
            }
        }
        return result;
    }

    private FlowType getFlowType(boolean incoming) {
        return incoming ? FlowType.Incoming : FlowType.Outgoing;
    }

    private static ISchedulingRule createMoveRuleFor(IResource[] sources, IResource[] dests) {
        assert (sources.length == dests.length);
        ISchedulingRule[] rules = new ISchedulingRule[sources.length];
        int i = 0;
        while (i < rules.length) {
            rules[i] = sources[i].getWorkspace().getRuleFactory().moveRule(sources[i], dests[i]);
            ++i;
        }
        return MultiRule.combine((ISchedulingRule[])rules);
    }

    private static TeamRepositoryException translate(String message, CoreException e) {
        return new TeamRepositoryException(message, (Throwable)e);
    }

    public CreateBaselineResultDTO postCreateBaselines(ParmsCreateBaselines parms, IProgressMonitor progress) throws TeamRepositoryException {
        return BaselineUtil.createBaselines(parms, progress);
    }

    public void postUpdateBaseline(ParmsUpdateBaseline parms, IProgressMonitor progress) throws TeamRepositoryException {
        BaselineUtil.updateBaseline(parms, progress);
    }

    public CreateBaselineSetResultDTO postCreateBaselineSet(ParmsCreateBaselineSet parms, IProgressMonitor progress) throws TeamRepositoryException {
        return BaselineUtil.createBaselineSet(parms, progress);
    }

    public DeleteFoldersInWorkspaceResultDTO postDeleteFoldersInWorkspace(ParmsDeleteFoldersInWorkspace parms, IProgressMonitor progress) throws TeamRepositoryException {
        return FolderManipulationUtil.deleteFoldersInWorkspace(parms, progress);
    }

    public void postRemoveBaselineSet(ParmsRemoveBaselineSet parms, IProgressMonitor progress) throws TeamRepositoryException {
        BaselineUtil.removeBaselineSet(parms, progress);
    }

    public void postUpdateBaselineSet(ParmsUpdateBaselineSet parms, IProgressMonitor progress) throws TeamRepositoryException {
        BaselineUtil.updateBaselineSet(parms, progress);
    }

    public MoveFoldersInWorkspaceResultDTO postMoveFoldersInWorkspace(ParmsMoveFoldersInWorkspace parms, IProgressMonitor progress) throws TeamRepositoryException {
        return FolderManipulationUtil.moveFoldersInWorkspace(parms, progress);
    }

    public void postCorruptionListener(ParmsCorruptionListener parms, IProgressMonitor monitor) throws TeamRepositoryException {
        parms.validate("postCorruptionListener");
        final String key = parms.listenerKey;
        if (parms.addListener) {
            ICorruptCopyFileAreaListener listener = new ICorruptCopyFileAreaListener(){

                public void corrupt(ICorruptCopyFileAreaEvent event) {
                    FilesystemRestClient.this.notifier.queueNotification(key, IFilesystemRestClient.RestCorruptCopyFileAreaEvent.TYPE, (IParameterWrapper)new IFilesystemRestClient.RestCorruptCopyFileAreaEvent(event.getRoot().toPortableString(), event.isCorrupt()));
                }
            };
            ((SharingManager)FileSystemCore.getSharingManager()).addListener(listener);
            this.corruptionListeners.put(key, listener);
        } else {
            ICorruptCopyFileAreaListener listener = this.corruptionListeners.remove(key);
            if (listener == null) {
                throw new IllegalStateException("No corruption listener with key " + key);
            }
            ((SharingManager)FileSystemCore.getSharingManager()).removeListener(listener);
        }
    }

    public RebuildCopyFileAreaDTO postRebuildCopyFileArea(IProgressMonitor monitor) throws TeamRepositoryException {
        IPath path = SharingManager.getInstance().getDefaultCFARoot();
        final RebuildCopyFileAreaDTO dto = FilesystemRestClientDTOcorruptionFactory.eINSTANCE.createRebuildCopyFileAreaDTO();
        dto.setNoDescriptorsFound(false);
        dto.setIgnoredErrors(false);
        RebuildCFAOperation.RebuildOperationParticipant rop = new RebuildCFAOperation.RebuildOperationParticipant(){

            public void noDescriptorsFound() {
                dto.setNoDescriptorsFound(true);
            }

            public void ignoredErrors(IStatus status) throws FileSystemClientException {
                dto.setIgnoredErrors(true);
            }
        };
        try {
            RebuildCFAOperation.rebuildCFA((IPath)path, null, (RebuildCFAOperation.RebuildOperationParticipant)rop, (IProgressMonitor)monitor);
        }
        catch (FileSystemClientException e) {
            throw new TeamRepositoryException(CommonUtil.getErrorMessage((FileSystemClientException)e), (Throwable)e);
        }
        return dto;
    }

    public CheckinPolicyDTO getCheckinPolicy() {
        CheckinPolicyDTO dto = FilesystemRestClientDTOresourceFactory.eINSTANCE.createCheckinPolicyDTO();
        dto.setAutoCheckin(new InstanceScope().getNode("com.ibm.team.filesystem.ide.ui").getBoolean("auto commit", false));
        dto.setAutoCheckinDefault(false);
        return dto;
    }

    public void postCheckinPolicy(ParmsCheckinPolicy parms) {
        parms.validate("postCheckInPolicy");
        ComponentSyncModel.getInstance().getLocalSynchronizationManager().setAutoSave(parms.autoCheckin);
        new InstanceScope().getNode("com.ibm.team.filesystem.ide.ui").putBoolean("auto commit", parms.autoCheckin);
    }

    public SyncViewFiltersDTO getSyncViewFilters() {
        SyncViewFiltersDTO dto = FilesystemRestClientDTOsyncFactory.eINSTANCE.createSyncViewFiltersDTO();
        Preferences preferences = FileSystemResourcesPlugin.getDefault().getPluginPreferences();
        dto.setAllFlowTargets(preferences.getBoolean("show_all_flow_targets"));
        dto.setAllFlowTargetsDefault(false);
        dto.setHideEmptyBaselines(preferences.getBoolean("hide_empty_baselines"));
        dto.setHideEmptyBaselinesDefault(false);
        dto.setMaxNumberChangesShownInChangeSet(preferences.getInt("max_changes_per_change_set"));
        dto.setMaxNumberChangesShownInChangeSetDefault(1000);
        return dto;
    }

    public void postSyncViewFilters(ParmsSyncViewFilters parms) {
        parms.validate("postSyncViewFilters");
        Preferences preferences = FileSystemResourcesPlugin.getDefault().getPluginPreferences();
        preferences.setValue("show_all_flow_targets", parms.allFlowTargets);
        preferences.setValue("hide_empty_baselines", parms.hideEmptyBaselines);
        preferences.setValue("max_changes_per_change_set", parms.maxNumberChangesShownInChangeSet);
    }

    public ChangeSummaryDTO getChangeSummary(ParmsChangeSummary parms, IProgressMonitor monitor) throws TeamRepositoryException {
        return ResourceUtil.getChangeSummary(parms, monitor);
    }

    public AcceptAsPatchDTO postAcceptAsPatch(ParmsAcceptAsPatch parms, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        parms.validate("postAcceptAsPatch");
        ITeamRepository repo = CommonUtil.getTeamRepository((String)parms.repositoryUrl);
        boolean reverse = parms.reverse == null ? false : parms.reverse;
        boolean merge = parms.merge == null ? false : parms.merge;
        SnapshotId context = SyncViewDTOUtil.getSnapshotId(repo, parms.context);
        SnapshotPathResolver pathResolver = context == null ? null : SnapshotPathResolver.create(context);
        List itemIds = ScmRestServiceUtil.createItemIds((String[])parms.changeSetItemIds, (IItemType)IChangeSet.ITEM_TYPE);
        Map changeSets = RepoFetcher.fetchCurrents((ITeamRepository)repo, (Collection)itemIds, (IProgressMonitor)progress.newChild(20));
        Map changes = ClientConfigurationChangeFactory.createChanges((ITeamRepository)repo, changeSets.values(), (IProgressMonitor)progress.newChild(20));
        Map<ItemId<IChangeSet>, ChangeDescription> descriptions = ConfigurationChangeFactory.getDescriptions(repo, changeSets.values(), (IProgressMonitor)progress.newChild(20));
        ArrayList<ParsedPatch> toConvert = new ArrayList<ParsedPatch>();
        try {
            if (merge) {
                ConfigurationChange netChange = ConfigurationChange.merge(changes.values());
                if (reverse) {
                    netChange = netChange.reverse();
                }
                ChangeDescription netDescription = ChangeDescription.merge((List)CollectionUtil.reorderValues(descriptions, (List)itemIds));
                if (reverse) {
                    netDescription = netDescription.reverse();
                }
                ParsedPatch netPatch = ParsedPatch.createFromConfigurationChange(netDescription, netChange, pathResolver, (IProgressMonitor)progress.newChild(20));
                toConvert.add(netPatch);
            } else {
                SubMonitor loopProgress = progress.newChild(20).setWorkRemaining(itemIds.size());
                for (ItemId next : itemIds) {
                    SubMonitor iterationProgress = loopProgress.newChild(1).setWorkRemaining(100);
                    ConfigurationChange change = (ConfigurationChange)changes.get(next);
                    if (reverse) {
                        change = change.reverse();
                    }
                    ChangeDescription description = descriptions.get(next);
                    if (reverse) {
                        description = description.reverse();
                    }
                    ParsedPatch nextPatch = ParsedPatch.createFromConfigurationChange(description, change, pathResolver, (IProgressMonitor)iterationProgress.newChild(100));
                    toConvert.add(nextPatch);
                }
            }
        }
        catch (IOException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        PatchModel model = PatchModel.getDefault();
        List<PendingContentChange> contentChanges = model.syncAddPatch(toConvert, (IProgressMonitor)progress.newChild(10));
        ArrayList<String> ids = new ArrayList<String>();
        for (PendingContentChange next : contentChanges) {
            ids.add(next.getId().getUuidValue());
        }
        AcceptAsPatchDTO result = FilesystemRestClientDTOsyncFactory.eINSTANCE.createAcceptAsPatchDTO();
        result.getPendingPatchIds().addAll(ids);
        return result;
    }

    public ContentTransferDTO getContentTransfer() {
        ContentTransferDTO dto = FilesystemRestClientDTOresourceFactory.eINSTANCE.createContentTransferDTO();
        int maxThreadsDefault = TeamPlatform.getMaxContentThreads();
        dto.setMaxThreads(new InstanceScope().getNode("com.ibm.team.filesystem.ide.ui").getInt("content_threads", maxThreadsDefault));
        dto.setMaxThreadsDefault(maxThreadsDefault);
        dto.setMaxThreadsLimit(50);
        return dto;
    }

    public void postContentTransfer(ParmsContentTransfer parms) {
        parms.validate("postContentTransfer");
        TeamPlatform.setMaxContentThreads((int)parms.maxThreads);
        new InstanceScope().getNode("com.ibm.team.filesystem.ide.ui").putInt("content_threads", parms.maxThreads);
    }

    public void postRelocateChanges(ParmsRelocateChanges parms, IProgressMonitor progress) throws TeamRepositoryException {
        UndoChangesUtil.relocateChanges(parms, progress);
    }

    public GetBaselinesDTO getBaselines(ParmsGetBaselines parms, IProgressMonitor progress) throws TeamRepositoryException {
        return BaselineUtil.getBaselines(parms, progress);
    }

    public GetBaselineSetsDTO getBaselineSets(ParmsWorkspace parms, IProgressMonitor progress) throws TeamRepositoryException {
        return BaselineUtil.getBaselineSets(parms, progress);
    }

    public IgnoredResourcesDTO getIgnoredResources(ParmsGetIgnoredResourcesPaths parms, IProgressMonitor progress) throws TeamRepositoryException {
        return IgnoresUtil.getIgnoredResources(parms, progress);
    }

    public void postCombineDeleteAdd(ParmsCombineDeleteAdd parms, IProgressMonitor progress) throws TeamRepositoryException {
        ILocalChange[] changes;
        if (parms == null) {
            throw new IllegalArgumentException("Must specify parameters");
        }
        parms.validate("postCombineDeleteAdd");
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)progress, (String)Messages.FilesystemRestClient_COMBINE_STATUS, (int)4);
        IResource addResource = CoreUtil.findRoot(parms.addition, (IProgressMonitor)mon.newChild(1));
        IShareable addShareable = (IShareable)addResource.getAdapter(IShareable.class);
        IShare addShare = addShareable.getShare();
        if (addShare == null) {
            throw new IllegalStateException("Add target is not shared.");
        }
        addShare.syncChanges();
        Path delPath = new Path(parms.deletion);
        IResource delParent = CoreUtil.findRoot(delPath.removeLastSegments(1), (IProgressMonitor)mon.newChild(1));
        if (delParent == null) {
            throw new IllegalArgumentException("Missing parent for deletion path: " + delPath.toPortableString());
        }
        try {
            delParent.refreshLocal(2, (IProgressMonitor)mon);
        }
        catch (CoreException coreException) {
            throw new TeamRepositoryException("Error refreshing deletion parent " + delParent.getFullPath().toPortableString());
        }
        IShareable delShareable = SharingManager.getInstance().findShareable(SharingManager.getInstance().getDefaultCFARoot(), (IPath)delPath, addResource.getType() != 1);
        IShare delShare = delShareable.getShare();
        if (delShare == null) {
            throw new IllegalStateException("del target is not shared.");
        }
        delShare.syncChanges();
        ILocalChange add = addShareable.getChange();
        ILocalChange del = null;
        ILocalChange[] iLocalChangeArray = changes = LocalChangeManager.getInstance().getPendingChanges(new IShare[]{delShare});
        int n = changes.length;
        int n2 = 0;
        while (n2 < n) {
            ILocalChange change = iLocalChangeArray[n2];
            if (change.isType(4) && delPath.equals((Object)change.getOriginalPath())) {
                del = change;
                break;
            }
            ++n2;
        }
        if (del == null) {
            throw new IllegalArgumentException("Could not find deletion at " + delShareable.getLocalFullPath());
        }
        if (!add.isType(2)) {
            throw new IllegalArgumentException("Not an addition: " + addShareable + " is a " + add);
        }
        if (!del.isType(4)) {
            throw new IllegalArgumentException("Not a deletion: " + delShareable + " is a " + del);
        }
        try {
            SharingManager.getInstance().getLocalChangeManager().combineDeleteAdd(del, add, (IProgressMonitor)mon.newChild(2));
        }
        catch (FileSystemClientException e) {
            throw new TeamRepositoryException("Exception during combine", (Throwable)e);
        }
    }
}

