/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.resources.efs;

import com.ibm.team.filesystem.rcp.core.internal.resources.efs.ResourceFileStore;
import java.io.File;
import java.net.URI;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileSystem;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ResourceFileSystem
extends FileSystem {
    final boolean keepHistory;
    final boolean force;
    public static final String SCHEME_ID = "resource";

    public ResourceFileSystem(boolean keepHistory, boolean force) {
        this.keepHistory = keepHistory;
        this.force = force;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.force ? 1231 : 1237);
        result = 31 * result + (this.keepHistory ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ResourceFileSystem other = (ResourceFileSystem)((Object)obj);
        if (this.force != other.force) {
            return false;
        }
        return this.keepHistory == other.keepHistory;
    }

    public IFileStore getStore(URI uri) {
        return new ResourceFileStore(this, (IPath)new Path(uri.getSchemeSpecificPart()));
    }

    public boolean canDelete() {
        return true;
    }

    public boolean canWrite() {
        return true;
    }

    public IFileStore fromLocalFile(File file) {
        IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)new Path(file.getAbsolutePath()));
        if (files.length > 0) {
            return new ResourceFileStore(this, files[0].getFullPath().makeAbsolute());
        }
        return null;
    }
}

