/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.resources;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.rcp.core.internal.resources.ResourceShare;
import com.ibm.team.filesystem.rcp.core.internal.resources.ShareableResource;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class SharingUtils {
    public static List getShares(IWorkspaceHandle workspaceHandle, IComponentHandle component) {
        IShare[] shares;
        try {
            shares = FileSystemCore.getSharingManager().allShares();
        }
        catch (FileSystemClientException e) {
            StatusUtil.log((Object)"com.ibm.team.filesystem.rcp.core", (Throwable)e);
            return Collections.EMPTY_LIST;
        }
        ArrayList<IResource> projects = new ArrayList<IResource>();
        int i = 0;
        while (i < shares.length) {
            IShare share = shares[i];
            if (share instanceof ResourceShare) {
                ShareableResource shareable;
                IResource project;
                ResourceShare rShare = (ResourceShare)share;
                ISharingDescriptor sharingDescriptor = share.getSharingDescriptor();
                IComponentHandle componentHandle = sharingDescriptor.getComponent();
                IContextHandle connectionHandle = sharingDescriptor.getConnectionHandle();
                if (componentHandle.sameItemId((IItemHandle)component) && connectionHandle.sameItemId((IItemHandle)workspaceHandle) && (project = (shareable = (ShareableResource)rShare.getShareable(share.getPath(), true)).getResource()) instanceof IProject) {
                    projects.add(project);
                }
            }
            ++i;
        }
        return projects;
    }
}

