/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.resources;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.ManagedFileSystem;
import com.ibm.team.filesystem.client.internal.Share;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.rcp.core.internal.resources.ShareableResource;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.team.IMoveDeleteHook;
import org.eclipse.core.resources.team.IResourceTree;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class MoveDeleteHook
implements IMoveDeleteHook {
    public boolean deleteFile(IResourceTree tree, IFile file, int updateFlags, IProgressMonitor monitor) {
        return false;
    }

    public boolean deleteFolder(IResourceTree tree, IFolder folder, int updateFlags, IProgressMonitor monitor) {
        return false;
    }

    public boolean deleteProject(IResourceTree tree, IProject project, int updateFlags, IProgressMonitor monitor) {
        ShareableResource shareable = new ShareableResource((IResource)project);
        try {
            SharingManager.getInstance().forget((IShareable)shareable, monitor);
        }
        catch (FileSystemClientException e) {
            LoggingHelper.log((CoreException)((Object)e));
        }
        return false;
    }

    public boolean moveFile(IResourceTree tree, IFile source, IFile destination, int updateFlags, IProgressMonitor monitor) {
        return false;
    }

    public boolean moveFolder(IResourceTree tree, IFolder source, IFolder destination, int updateFlags, IProgressMonitor monitor) {
        return false;
    }

    public boolean moveProject(IResourceTree tree, IProject source, IProjectDescription description, int updateFlags, IProgressMonitor monitor) {
        URI intermediate;
        URI uri;
        IPath sharePath;
        IPath cfaPath;
        boolean managed;
        SharingManager sm = SharingManager.getInstance();
        URI src = source.getLocationURI();
        if (!"sourcecontrol".equals(src.getScheme())) {
            return false;
        }
        URI targetURI = description.getLocationURI();
        boolean equal = src.equals(targetURI);
        if (targetURI == null) {
            managed = false;
        } else {
            managed = "sourcecontrol".equals(targetURI.getScheme());
            if (!equal && managed) {
                return false;
            }
        }
        try {
            URI baseStoreURI;
            int numSegments;
            IFileStore rootStore = EFS.getStore((URI)ResourcesPlugin.getWorkspace().getRoot().getLocationURI());
            Path fullPath = new Path(src.getPath());
            if (fullPath.segment(0).equals("default")) {
                numSegments = 0;
                cfaPath = null;
            } else {
                numSegments = Integer.parseInt(fullPath.segment(0));
                cfaPath = fullPath.removeLastSegments(fullPath.segmentCount() - numSegments - 1).removeFirstSegments(1).makeUNC(fullPath.isUNC()).makeAbsolute();
                if (cfaPath.equals((Object)sm.getDefaultCFARoot())) {
                    cfaPath = null;
                }
            }
            sharePath = fullPath.removeFirstSegments(numSegments + 1);
            sharePath = sharePath.removeLastSegments(1).append(description.getName()).setDevice(null).makeUNC(false).makeAbsolute();
            URI intermediateBaseStoreURI = baseStoreURI = managed ? (targetURI.getQuery() == null ? null : new URI(targetURI.getQuery())) : targetURI;
            if (baseStoreURI == null || rootStore.isParentOf(EFS.getStore((URI)baseStoreURI))) {
                baseStoreURI = null;
                if (!managed) {
                    intermediateBaseStoreURI = rootStore.getChild(sharePath).toURI();
                }
            }
            uri = ManagedFileSystem.getManagedURI((IPath)cfaPath, (IPath)sharePath, (URI)baseStoreURI);
            intermediate = ManagedFileSystem.getManagedURI((IPath)cfaPath, (IPath)source.getFullPath(), (URI)intermediateBaseStoreURI);
        }
        catch (CoreException e) {
            LoggingHelper.log((CoreException)e);
            return true;
        }
        catch (URISyntaxException e) {
            LoggingHelper.error((String)"com.ibm.team.filesystem.client", (String)e.getMessage(), (Throwable)e);
            return true;
        }
        if (uri.equals(src)) {
            return true;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (!equal) {
            description.setLocationURI(uri);
        }
        sm.disableChangeMonitoring();
        try {
            tree.standardMoveProject(source, description, updateFlags, (IProgressMonitor)progress.newChild(50));
        }
        finally {
            sm.enableChangeMonitoring();
        }
        if (!source.getName().equals(description.getName())) {
            progress.setWorkRemaining(100);
            try {
                EFS.getStore((URI)intermediate).move(EFS.getStore((URI)uri), 0, (IProgressMonitor)progress.newChild(50));
            }
            catch (CoreException e) {
                LoggingHelper.log((CoreException)e);
                return true;
            }
        }
        IProject dest = source.getWorkspace().getRoot().getProject(description.getName());
        if (equal) {
            description.setLocationURI(uri);
            tree.movedProjectSubtree(dest, description);
        }
        if (sm.isChangeMonitoringEnabled()) {
            if (cfaPath == null) {
                cfaPath = sm.getDefaultCFARoot();
            }
            Share s = sm.getShare(cfaPath, sharePath);
            try {
                ISchedulingRule rule = s.lock((IProgressMonitor)progress.newChild(1));
                try {
                    s.getTracker().computePendingChanges(s.getShareable(sharePath, true), (IProgressMonitor)progress.newChild(48));
                }
                finally {
                    s.unlock(rule, (IProgressMonitor)progress.newChild(1));
                }
            }
            catch (FileSystemClientException e) {
                LoggingHelper.log((CoreException)((Object)e));
                return true;
            }
        }
        return true;
    }
}

