/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.resources;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingDescriptor;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.load.DeferredDownloadInformation;
import com.ibm.team.filesystem.client.internal.load.UpdateMutator;
import com.ibm.team.filesystem.client.internal.utils.SilentProgressMonitor;
import com.ibm.team.filesystem.client.operations.DilemmaHandler;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdateReport;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.resources.ShareableResource;
import com.ibm.team.filesystem.rcp.core.operations.IDownloadMonitor;
import com.ibm.team.repository.client.IDownloadHandler;
import com.ibm.team.repository.client.internal.ContentManager;
import com.ibm.team.repository.client.util.DownloadAdapter;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.LineDelimiter;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.model.Content;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.common.utils.HashCode;
import com.ibm.team.repository.common.utils.HashComputingInputStream;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IComponentStateSummary;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.util.Collection;
import java.util.zip.Checksum;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.team.core.RepositoryProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseWorkspaceMutator
extends UpdateMutator {
    private final IDownloadMonitor downloadMonitor;
    private final IConnection connection;
    private static final String COLLISION_RENAME = "#jazz";
    private String lastProject;
    private boolean projectWasOpen;

    public EclipseWorkspaceMutator(IConnection connection, Collection<IComponentStateSummary> componentStatesBefore, Collection<IComponentStateSummary> componentStatesAfter, FileAreaUpdateReport updates, DilemmaHandler problemHandler, IDownloadMonitor downloadMonitor) throws TeamRepositoryException {
        super(connection.teamRepository(), connection, componentStatesBefore, componentStatesAfter, updates, problemHandler);
        this.connection = connection;
        this.downloadMonitor = downloadMonitor;
    }

    public EclipseWorkspaceMutator(IConnection connection, Collection<IComponentStateSummary> componentStatesBefore, Collection<IComponentStateSummary> componentStatesAfter, FileAreaUpdateReport updates, DilemmaHandler problemHandler) throws TeamRepositoryException {
        this(connection, componentStatesBefore, componentStatesAfter, updates, problemHandler, null);
    }

    protected void updateMetaData(DeferredDownloadInformation downloadInfo, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        final SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Shareable shareable = downloadInfo.getShareable();
        if (shareable instanceof ShareableResource) {
            String name;
            IFolderHandle parent;
            final IResource file = ((ShareableResource)shareable).getResource();
            try {
                SharingManager.getInstance().doSilentChange(new SharingManager.CoreRunnable(){

                    public void run() throws CoreException {
                        file.refreshLocal(2, (IProgressMonitor)new SilentProgressMonitor((IProgressMonitor)progress.newChild(1)));
                    }
                });
            }
            catch (CoreException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor((int)4, (String)Messages.EclipseWorkspaceMutator_0, (Throwable)e));
            }
            long modificationStamp = file.getModificationStamp();
            Content content = (Content)downloadInfo.getContent();
            LineDelimiter lineDelimiter = content.getLineDelimiter();
            String contentType = content.getContentType();
            FileItemInfo oldInfo = this.getCopyFileArea().getItemInfo(shareable.getLocalFullPath());
            if (oldInfo == null) {
                parent = downloadInfo.getParent();
                name = downloadInfo.getName();
            } else {
                parent = oldInfo.getParent();
                name = oldInfo.getName();
            }
            FileItemInfo info = new FileItemInfo((IVersionableHandle)downloadInfo.getFileItem(), modificationStamp, parent, name, new HashCode(downloadInfo.getChecksum()), downloadInfo.getContentSize(), lineDelimiter, lineDelimiter, contentType, contentType, content.getContentId(), content.getDeltaPredecessor(), content.getContentLength(), content.getCharacterEncoding(), content.getChecksum(), content.getLineDelimiterCount(), downloadInfo.isExecutable(), downloadInfo.isExecutable());
            CopyFileAreaStore.getDefaultCopyFileArea().setItemInfo((IShareable)shareable, info, (IProgressMonitor)progress);
        }
        progress.done();
    }

    private static Checksum hashcodeToChecksum(final HashCode hashcode) {
        return new Checksum(){

            public long getValue() {
                return hashcode.getValue();
            }

            public void reset() {
                throw new IllegalStateException("not implemented");
            }

            public void update(int b) {
                throw new IllegalStateException("not implemented");
            }

            public void update(byte[] b, int off, int len) {
                throw new IllegalStateException("not implemented");
            }
        };
    }

    private static void read(InputStream in) throws IOException {
        byte[] b = new byte[16000];
        try {
            while (in.read(b) != -1) {
            }
        }
        catch (Throwable throwable) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            in.close();
        }
        catch (IOException iOException) {}
    }

    private void storeFileContent(final DeferredDownloadInformation downloadInfo, final IFile file) throws TeamRepositoryException, FileSystemClientException {
        final boolean skipWrite = this.skipUpdate(new ShareableResource((IResource)file));
        if (skipWrite && !this.repository.contentManager().convertDelimitersDuringRetrieval(downloadInfo.getContent())) {
            IContent content = downloadInfo.getContent();
            downloadInfo.setContentUpdated((Shareable)new ShareableResource((IResource)file), EclipseWorkspaceMutator.hashcodeToChecksum(content.getRawHashCode()), content.getRawLength());
            return;
        }
        if (file.exists()) {
            try {
                SharingManager.getInstance().doSilentChange(new SharingManager.CoreRunnable(){

                    public void run() throws CoreException {
                        file.appendContents((InputStream)new ByteArrayInputStream(new byte[0]), true, true, null);
                    }
                });
            }
            catch (CoreException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor((int)4, (String)NLS.bind((String)Messages.EclipseWorkspaceMutator_1, (Object[])new Object[]{file}), (Throwable)e));
            }
        }
        DownloadAdapter downloader = new DownloadAdapter(){

            public void downloadStreamAcquired(IContent content, InputStream in) throws TeamRepositoryException {
                final InputStream contentStream = in;
                try {
                    SharingManager.getInstance().doSilentChange(new SharingManager.CoreRunnable(){

                        public void run() throws CoreException {
                            SharingManager.getInstance().doSilentChange(new SharingManager.CoreRunnable(){

                                public void run() throws CoreException {
                                    try {
                                        File victim;
                                        if (EclipseWorkspaceMutator.this.downloadMonitor != null) {
                                            EclipseWorkspaceMutator.this.downloadMonitor.startDownload(file.getFullPath(), downloadInfo.getContent(), (IVersionableHandle)downloadInfo.getFileItem());
                                        }
                                        FileOutputStream out = null;
                                        if (!skipWrite) {
                                            out = new FileOutputStream(file.getLocation().toFile());
                                        }
                                        boolean completed = false;
                                        try {
                                            HashComputingInputStream inStream = new HashComputingInputStream(contentStream);
                                            if (out == null) {
                                                if (!$assertionsDisabled && !skipWrite) {
                                                    throw new AssertionError();
                                                }
                                                EclipseWorkspaceMutator.read((InputStream)inStream);
                                            } else {
                                                ContentManager.read((InputStream)inStream, (OutputStream)out);
                                            }
                                            downloadInfo.setContentUpdated((Shareable)new ShareableResource((IResource)file), inStream.getChecksum(), inStream.getContentSize());
                                            completed = true;
                                        }
                                        catch (Throwable throwable) {
                                            File victim2;
                                            try {
                                                if (out != null) {
                                                    ((OutputStream)out).close();
                                                }
                                            }
                                            catch (IOException iOException) {}
                                            if (!completed && !skipWrite && (victim2 = file.getLocation().toFile()).exists()) {
                                                victim2.delete();
                                            }
                                            throw throwable;
                                        }
                                        try {
                                            if (out != null) {
                                                ((OutputStream)out).close();
                                            }
                                        }
                                        catch (IOException iOException) {}
                                        if (!completed && !skipWrite && (victim = file.getLocation().toFile()).exists()) {
                                            victim.delete();
                                        }
                                    }
                                    catch (SocketException e) {
                                        IStatus status = FileSystemStatus.getStatusFor((int)4, (int)203, (String)NLS.bind((String)Messages.EclipseWorkspaceMutator_2, (Object[])new Object[]{file.getLocation().toFile()}), (Throwable)e);
                                        throw new CoreException(status);
                                    }
                                    catch (IOException e) {
                                        IStatus status = FileSystemStatus.getStatusFor((int)4, (int)203, (String)NLS.bind((String)Messages.EclipseWorkspaceMutator_3, (Object[])new Object[]{file.getLocation().toFile()}), (Throwable)e);
                                        throw new CoreException(status);
                                    }
                                }
                            });
                        }
                    });
                }
                catch (CoreException e) {
                    LoggingHelper.error((String)"com.ibm.team.filesystem.rcp.core", (String)Messages.EclipseWorkspaceMutator_4, (Throwable)e);
                    throw new TeamRepositoryException(Messages.EclipseWorkspaceMutator_5, (Throwable)e);
                }
            }

            public void downloadFailed(IContent content, TeamRepositoryException e) {
                downloadInfo.setFailure((Shareable)new ShareableResource((IResource)file), e);
            }
        };
        this.contentSession.retrieveContent(downloadInfo.getContent(), (IDownloadHandler)downloader);
    }

    private IResource getResourceFor(String componentName, IPath path, int type) throws FileSystemClientException {
        if (type == 1) {
            return ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        }
        if (type == 2) {
            return ResourcesPlugin.getWorkspace().getRoot().getFolder(path);
        }
        if (type == 4) {
            return ResourcesPlugin.getWorkspace().getRoot().getProject(path.lastSegment());
        }
        throw new FileSystemClientException((IStatus)new FileSystemStatus(4, 372, "unknown resource type " + type + "  Reload component " + componentName));
    }

    private void move(IComponent component, IComponentHandle previousComponent, IVersionableHandle itemState, boolean moveUpdate, final IResource sourceResource, final IResource targetResource, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        final SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            ShareableResource sourceShareable = new ShareableResource(sourceResource);
            if (!this.skipUpdate(sourceShareable)) {
                SharingManager.getInstance().doSilentChange(new SharingManager.CoreRunnable(){

                    public void run() throws CoreException {
                        sourceResource.move(targetResource.getFullPath(), 3, (IProgressMonitor)progress.newChild(50));
                    }
                });
            }
            ShareableResource targetShareable = new ShareableResource(targetResource);
            this.updateMetaDataAfterMove(component, previousComponent, itemState, moveUpdate, sourceShareable, targetShareable, sourceResource.getType() == 4, (IProgressMonitor)progress);
        }
        catch (CoreException e) {
            this.recordInconsistentShare(previousComponent, sourceResource.getFullPath().segment(0));
            this.recordInconsistentShare((IComponentHandle)component, targetResource.getFullPath().segment(0));
            this.collectStatus(FileSystemStatus.getStatusFor((int)4, (int)371, (String)NLS.bind((String)Messages.EclipseWorkspaceMutator_6, (Object[])new Object[]{sourceResource.getFullPath().toString(), component.getName()}), (Throwable)e));
        }
        progress.done();
    }

    protected boolean isPathValid(IComponentHandle component, IPath path, boolean newProjectAllowed) {
        if (path == null) {
            return super.isPathValid(component, path, newProjectAllowed);
        }
        String[] segments = path.segments();
        if (segments[0].equals(this.lastProject) && this.projectWasOpen) {
            return super.isPathValid(component, path, newProjectAllowed);
        }
        this.lastProject = segments[0];
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.lastProject);
        boolean bl = this.projectWasOpen = !project.exists() || project.isAccessible();
        return this.projectWasOpen && super.isPathValid(component, path, newProjectAllowed);
    }

    protected void preserve(IComponent component, Shareable shareable, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        Path destinationPath;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IResource resource = ((ShareableResource)shareable).getResource();
        String name = resource.getFullPath().toString();
        String extension = resource.getFileExtension();
        if (extension != null && name.length() > 1) {
            name = name.substring(0, name.length() - extension.length() - 1);
            extension = "." + extension;
        } else {
            extension = "";
        }
        name = String.valueOf(name) + COLLISION_RENAME;
        int count = 0;
        IResource destinationResource = null;
        do {
            String destination = String.valueOf(name) + count + extension;
            destinationPath = new Path(destination);
            ++count;
        } while ((destinationResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)destinationPath)) != null);
        IResource targetResource = this.getResourceFor(component.getName(), (IPath)destinationPath, resource.getType());
        this.move(component, (IComponentHandle)component, null, false, resource, targetResource, (IProgressMonitor)progress.newChild(100));
        progress.done();
    }

    protected void modifyFile(IComponent component, DeferredDownloadInformation downloadInfo, Shareable toModifyShareable, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        IResource resource = ((ShareableResource)toModifyShareable).getResource();
        if (resource.getType() != 1) {
            throw new FileSystemClientException((IStatus)new FileSystemStatus(4, 369, NLS.bind((String)Messages.EclipseWorkspaceMutator_7, (Object[])new Object[]{toModifyShareable.getLocalFullPath().toString(), component.getName()})));
        }
        IFile file = (IFile)resource;
        this.storeFileContent(downloadInfo, file);
    }

    protected void createFile(IComponent component, DeferredDownloadInformation downloadInfo, Shareable parentShareable, final IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        IPath path = parentShareable.getLocalFullPath().append(downloadInfo.getName());
        final IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        if (downloadInfo.getContent() != null) {
            if (!this.skipUpdate(downloadInfo.getFileItem().getItemId())) {
                this.storeFileContent(downloadInfo, file);
            }
        } else {
            try {
                SharingManager.getInstance().doSilentChange(new SharingManager.CoreRunnable(){

                    public void run() throws CoreException {
                        file.create((InputStream)new ByteArrayInputStream(new byte[0]), true, monitor);
                    }
                });
            }
            catch (CoreException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor((int)4, (int)367, (String)NLS.bind((String)Messages.EclipseWorkspaceMutator_8, (Object[])new Object[]{downloadInfo.getName(), component.getName()}), (Throwable)e));
            }
        }
    }

    protected void createFolder(IComponent component, IFolderHandle parent, Shareable parentShareable, String name, IFolderHandle folderItemState, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        try {
            FileItemInfo proxy;
            ShareableResource shareable;
            final SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            if (parentShareable == null) {
                progress.subTask(NLS.bind((String)Messages.EclipseWorkspaceMutator_13, (Object[])new Object[]{name}));
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
                if (!project.exists()) {
                    project.create((IProgressMonitor)progress.newChild(2));
                }
                if (!project.isOpen()) {
                    project.open((IProgressMonitor)progress.newChild(3));
                }
                RepositoryProvider.map((IProject)project, (String)"com.ibm.team.filesystem.rcp.core.provider");
                SharingDescriptor descriptor = new SharingDescriptor(this.repository.getRepositoryURI(), this.repository.getId(), this.connection, (IComponentHandle)component, component.getName(), folderItemState);
                shareable = new ShareableResource((IResource)project);
                if (shareable.getShare() == null) {
                    shareable.share((ISharingDescriptor)descriptor, true, (IProgressMonitor)progress.newChild(40));
                } else {
                    CopyFileAreaStore.getDefaultCopyFileArea().setSharingInfo((IShareable)shareable, (ISharingDescriptor)descriptor, (IProgressMonitor)progress.newChild(40));
                }
                proxy = new FileItemInfo(folderItemState, null, null);
            } else {
                IContainer parentResource = (IContainer)((ShareableResource)parentShareable).getResource();
                final IFolder targetResource = parentResource.getFolder((IPath)new Path(name));
                if (!this.skipUpdate(folderItemState.getItemId())) {
                    SharingManager.getInstance().doSilentChange(new SharingManager.CoreRunnable(){

                        public void run() throws CoreException {
                            targetResource.create(true, true, (IProgressMonitor)progress.newChild(50));
                        }
                    });
                }
                shareable = new ShareableResource((IResource)targetResource);
                proxy = new FileItemInfo(folderItemState, parent, name);
            }
            progress.setWorkRemaining(50);
            CopyFileAreaStore.getDefaultCopyFileArea().setItemInfo((IShareable)shareable, proxy, (IProgressMonitor)progress.newChild(50));
            progress.done();
        }
        catch (CoreException e) {
            LoggingHelper.log((CoreException)e);
            String fileName = parentShareable != null ? parentShareable.getLocalFullPath().append(name).toString() : name;
            throw new FileSystemClientException(FileSystemStatus.getStatusFor((int)4, (int)368, (String)NLS.bind((String)Messages.EclipseWorkspaceMutator_10, (Object[])new Object[]{fileName, component.getName()}), (Throwable)e));
        }
    }

    protected void deleteSubtree(IComponent component, Shareable toDeleteShareable, IProgressMonitor monitor) throws FileSystemClientException {
        final SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        final IResource resource = ((ShareableResource)toDeleteShareable).getResource();
        IVersionableHandle remote = toDeleteShareable.getRemote();
        if (remote == null || !this.skipUpdate(remote.getItemId())) {
            try {
                if (resource.getType() == 4) {
                    ((IProject)resource).clearHistory((IProgressMonitor)progress.newChild(10));
                    ((IProject)resource).delete(true, true, (IProgressMonitor)progress.newChild(40));
                } else if (resource.getType() == 2) {
                    SharingManager.getInstance().doSilentChange(new SharingManager.CoreRunnable(){

                        public void run() throws CoreException {
                            ((IFolder)resource).delete(true, true, (IProgressMonitor)progress.newChild(50));
                        }
                    });
                } else if (resource.getType() == 1) {
                    SharingManager.getInstance().doSilentChange(new SharingManager.CoreRunnable(){

                        public void run() throws CoreException {
                            ((IFile)resource).delete(true, true, (IProgressMonitor)progress.newChild(50));
                        }
                    });
                }
            }
            catch (CoreException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor((int)4, (int)370, (String)NLS.bind((String)Messages.EclipseWorkspaceMutator_11, (Object[])new Object[]{toDeleteShareable.getLocalFullPath().toString()}), (Throwable)e));
            }
        }
        progress.setWorkRemaining(50);
        if (resource.getType() == 4) {
            if (toDeleteShareable.getShare() != null) {
                toDeleteShareable.unshare((IProgressMonitor)progress.newChild(50));
            }
        } else {
            toDeleteShareable.forget((IProgressMonitor)progress.newChild(50));
        }
        progress.done();
    }

    protected Shareable getRootFolder(String newName) {
        return new ShareableResource((IResource)ResourcesPlugin.getWorkspace().getRoot().getProject(newName));
    }

    protected void move(IComponent component, IComponentHandle previousComponent, Shareable toMoveShareable, Shareable destinationParentShareable, IFolderHandle parent, String newName, IVersionableHandle itemState, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        Object destinationPath = destinationParentShareable == null ? new Path(newName) : destinationParentShareable.getLocalFullPath().append(newName);
        monitor.subTask(NLS.bind((String)Messages.EclipseWorkspaceMutator_12, (Object[])new Object[]{toMoveShareable.getLocalFullPath().toString(), destinationPath.toString()}));
        IResource sourceResource = ((ShareableResource)toMoveShareable).getResource();
        int type = sourceResource.getType();
        if (destinationParentShareable == null) {
            if (type == 1) {
                this.recordInconsistentShare(previousComponent, sourceResource.getFullPath().segment(0));
                this.collectStatus((IStatus)new FileSystemStatus(4, NLS.bind((String)Messages.EclipseWorkspaceMutator_14, (Object[])new Object[]{toMoveShareable.getLocalFullPath().toString(), component.getName()})));
                return;
            }
            if (type != 4) {
                this.recordInconsistentShare(previousComponent, sourceResource.getFullPath().segment(0));
                this.collectStatus((IStatus)new FileSystemStatus(4, NLS.bind((String)Messages.EclipseWorkspaceMutator_15, (Object[])new Object[]{toMoveShareable.getLocalFullPath().toString(), component.getName()})));
                return;
            }
        }
        IResource targetResource = this.getResourceFor(component.getName(), (IPath)destinationPath, type);
        this.move(component, previousComponent, itemState, true, sourceResource, targetResource, monitor);
    }

    protected CopyFileAreaStore getCopyFileArea() {
        return CopyFileAreaStore.getDefaultCopyFileArea();
    }

    protected Shareable getShareableFor(IPath path, boolean isFolder) {
        ShareableResource result = null;
        if (path != null) {
            result = new ShareableResource(path, isFolder);
        }
        return result;
    }
}

