/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.resources;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.load.MergeLoadMutator;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.NonCancellingProgressMonitor;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import com.ibm.team.filesystem.client.internal.utils.SilentProgressMonitor;
import com.ibm.team.filesystem.client.operations.DilemmaHandler;
import com.ibm.team.filesystem.common.internal.dto.LoadTree;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.resources.EclipseFileStorage;
import com.ibm.team.filesystem.rcp.core.internal.resources.ShareableResource;
import com.ibm.team.filesystem.rcp.core.operations.IDownloadMonitor;
import com.ibm.team.repository.client.IDownloadHandler;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.team.core.RepositoryProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseWorkspaceMergeLoadMutator
extends MergeLoadMutator {
    final IDownloadMonitor downloadMonitor;

    public EclipseWorkspaceMergeLoadMutator(IConnection connection, Map<ConfigurationDescriptor, Collection<IVersionableHandle>> shareRoots, Collection<String[]> subtreeRoots, LoadTree loadTree, DilemmaHandler problemHandler, IDownloadMonitor downloadMonitor) throws TeamRepositoryException {
        super(connection, shareRoots, loadTree, ResourcesPlugin.getWorkspace().getRoot().getLocation(), subtreeRoots, problemHandler);
        this.downloadMonitor = downloadMonitor;
    }

    public EclipseWorkspaceMergeLoadMutator(IConnection connection, Map<ConfigurationDescriptor, Collection<IVersionableHandle>> shareRoots, Collection<String[]> subtreeRoots, LoadTree loadTree, DilemmaHandler problemHandler) throws TeamRepositoryException {
        this(connection, shareRoots, subtreeRoots, loadTree, problemHandler, null);
    }

    protected boolean isSpecialCase(IShareable shareable) {
        IPath path = shareable.getLocalFullPath();
        return path.segmentCount() == 2 && path.lastSegment().equals(".project");
    }

    protected void storeFileContents(final IPath path, final IContent content, final IVersionableHandle fileItem, final InputStream in) throws TeamRepositoryException {
        try {
            SharingManager.getInstance().doSilentChange(new SharingManager.CoreRunnable(){

                public void run() throws CoreException {
                    EclipseWorkspaceMergeLoadMutator.this.recordDownload(path, content, fileItem);
                    try {
                        EclipseWorkspaceMergeLoadMutator.this.internalStoreFileContents(path, in);
                    }
                    catch (TeamRepositoryException e) {
                        throw new CoreException(FileSystemStatus.getStatusFor((Throwable)e));
                    }
                }
            });
        }
        catch (CoreException e) {
            throw new TeamRepositoryException(Messages.EclipseWorkspaceMergeLoadMutator_0, (Throwable)e);
        }
    }

    private void recordDownload(IPath path, IContent content, IVersionableHandle fileItem) {
        if (this.downloadMonitor != null) {
            this.downloadMonitor.startDownload(path, content, fileItem);
        }
    }

    protected void deleteIncompleteFile(final IPath path) throws TeamRepositoryException {
        try {
            SharingManager.getInstance().doSilentChange(new SharingManager.CoreRunnable(){

                public void run() throws CoreException {
                    try {
                        EclipseWorkspaceMergeLoadMutator.this.internalDeleteIncompleteFile(path);
                    }
                    catch (TeamRepositoryException e) {
                        throw new CoreException(FileSystemStatus.getStatusFor((int)370, (String)NLS.bind((String)Messages.EclipseWorkspaceMergeLoadMutator_1, (Object[])new Object[]{path}), (Throwable)e));
                    }
                }
            });
        }
        catch (CoreException e) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.EclipseWorkspaceMergeLoadMutator_2, (Object[])new Object[]{path}), (Throwable)e);
        }
    }

    protected IFileStorage pathToIFileStorage(IPath path) {
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        return new EclipseFileStorage((IResource)file);
    }

    protected List<IShareable> getChildren(IPath parentFolder) throws FileSystemClientException {
        Object folder = parentFolder.segmentCount() == 1 ? ResourcesPlugin.getWorkspace().getRoot().getProject(parentFolder.lastSegment()) : ResourcesPlugin.getWorkspace().getRoot().getFolder(parentFolder);
        if (folder.exists()) {
            IResource[] members;
            try {
                members = folder.members();
            }
            catch (CoreException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor((int)4, (int)205, (String)NLS.bind((String)Messages.EclipseWorkspaceMergeLoadMutator_3, (Object[])new Object[]{folder.getFullPath()}), (Throwable)e));
            }
            ArrayList<IShareable> result = new ArrayList<IShareable>(members.length);
            int i = 0;
            while (i < members.length) {
                result.add((IShareable)new ShareableResource(members[i]));
                ++i;
            }
            return result;
        }
        return Collections.EMPTY_LIST;
    }

    protected Shareable getShareable(IPath path) {
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        if (resource != null) {
            return new ShareableResource(resource);
        }
        return null;
    }

    protected void deleteSubtree(IPath path, final IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        final IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        try {
            SharingManager.getInstance().doSilentChange(new SharingManager.CoreRunnable(){

                public void run() throws CoreException {
                    if (resource.getType() == 4) {
                        ((IProject)resource).delete(true, true, monitor);
                    } else if (resource.getType() == 2) {
                        ((IFolder)resource).delete(true, true, monitor);
                    } else if (resource.getType() == 1) {
                        ((IFile)resource).delete(true, true, monitor);
                    }
                }
            });
        }
        catch (CoreException e) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor((int)4, (int)370, (String)NLS.bind((String)Messages.EclipseWorkspaceMergeLoadMutator_4, (Object[])new Object[]{path}), (Throwable)e));
        }
    }

    protected void updateMetaInfoForPath(IComponentHandle componentHandle, IVersionableHandle fileItem, MergeLoadMutator.DeferredUpdateInformation updateInfo, IProgressMonitor monitor) throws FileSystemClientException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        final SubMonitor progress = SubMonitor.convert((IProgressMonitor)new NonCancellingProgressMonitor(monitor), (int)100);
        final IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(updateInfo.getPath());
        try {
            SharingManager.getInstance().doSilentChange(new SharingManager.CoreRunnable(){

                public void run() throws CoreException {
                    file.refreshLocal(2, (IProgressMonitor)new SilentProgressMonitor((IProgressMonitor)progress.newChild(50)));
                }
            });
        }
        catch (CoreException e) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor((int)4, (String)NLS.bind((String)Messages.EclipseWorkspaceMergeLoadMutator_5, (Object[])new Object[]{updateInfo.getPath()}), (Throwable)e));
        }
        super.updateMetaInfoForPath(componentHandle, fileItem, updateInfo, (IProgressMonitor)progress.newChild(50));
        progress.done();
    }

    protected void createNewFile(IComponentHandle component, String[] stringPath, IVersionableHandle fileItemState, Date date, ITeamRepository repository, IContent content, MergeLoadMutator.DeferredUpdateInformation deferredUpdateInformation, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        IPath path = PathUtils.getPath((String[])stringPath);
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        Assert.isTrue((!file.exists() ? 1 : 0) != 0);
        if (content != null) {
            this.contentSession.retrieveContent(content, (IDownloadHandler)new MergeLoadMutator.DownloadHandler(deferredUpdateInformation, fileItemState, (MergeLoadMutator)this));
        } else {
            this.storeFileContents(path, content, fileItemState, new ByteArrayInputStream(new byte[0]));
        }
    }

    protected IFileStorage createNewFolder(IComponentHandle component, String[] stringPath, IVersionableHandle folderItem, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor progress;
        block8: {
            progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            progress.setTaskName(Messages.EclipseWorkspaceMergeLoadMutator_ProgressMessage);
            try {
                if (stringPath.length != 0) break block8;
                return null;
            }
            catch (CoreException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor((int)4, (int)368, (String)NLS.bind((String)Messages.EclipseWorkspaceMergeLoadMutator_9, (Object[])new Object[]{stringPath[stringPath.length - 1]}), (Throwable)e));
            }
        }
        IPath path = PathUtils.getPath((String[])stringPath);
        if (path.segmentCount() == 1) {
            progress.setTaskName(NLS.bind((String)Messages.EclipseWorkspaceMergeLoadMutator_7, (Object[])new Object[]{path.toString()}));
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
            if (!project.exists()) {
                project.create((IProgressMonitor)progress.newChild(50));
            }
            progress.setWorkRemaining(50);
            if (!project.isOpen()) {
                try {
                    project.open((IProgressMonitor)progress.newChild(45));
                }
                catch (CoreException coreException) {
                    project.delete(5, (IProgressMonitor)progress.newChild(3));
                    project.create((IProgressMonitor)progress.newChild(1));
                    project.open((IProgressMonitor)progress.newChild(1));
                }
            }
            RepositoryProvider.map((IProject)project, (String)"com.ibm.team.filesystem.rcp.core.provider");
            progress.done();
            return new EclipseFileStorage((IResource)project);
        }
        progress.subTask(NLS.bind((String)Messages.EclipseWorkspaceMergeLoadMutator_8, (Object[])new Object[]{path.toString()}));
        final IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(path);
        SharingManager.getInstance().doSilentChange(new SharingManager.CoreRunnable(){

            public void run() throws CoreException {
                folder.create(true, true, (IProgressMonitor)progress.newChild(100));
            }
        });
        return new EclipseFileStorage((IResource)folder);
    }

    protected void modifyFile(IComponentHandle component, IVersionableHandle fileItem, ITeamRepository repository, Date timestamp, MergeLoadMutator.DeferredUpdateInformation deferredUpdateInformation, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        final IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(deferredUpdateInformation.getPath());
        if (file.exists()) {
            try {
                SharingManager.getInstance().doSilentChange(new SharingManager.CoreRunnable(){

                    public void run() throws CoreException {
                        file.appendContents((InputStream)new ByteArrayInputStream(new byte[0]), true, true, null);
                    }
                });
            }
            catch (CoreException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor((int)4, (String)NLS.bind((String)Messages.EclipseWorkspaceMergeLoadMutator_10, (Object[])new Object[]{file}), (Throwable)e));
            }
        }
        this.contentSession.retrieveContent(deferredUpdateInformation.getContent(), (IDownloadHandler)new MergeLoadMutator.DownloadHandler(deferredUpdateInformation, fileItem, (MergeLoadMutator)this));
    }

    protected Shareable getNonExistantShareable(FileItemInfo infoForDeletedItem, IComponentHandle component, IContextHandle connection, IProgressMonitor monitor) throws FileSystemClientException {
        IPath path = CopyFileAreaStore.getDefaultCopyFileArea().getLocalPathFor(infoForDeletedItem.getVersionableHandle(), component, connection, monitor);
        Object resource = path.segmentCount() == 1 ? ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0)) : (infoForDeletedItem.getVersionableHandle() instanceof IFolderHandle ? ResourcesPlugin.getWorkspace().getRoot().getFolder(path) : ResourcesPlugin.getWorkspace().getRoot().getFile(path));
        return new ShareableResource((IResource)resource);
    }
}

