/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.resources;

import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.resources.ContentPropertiesPreference;
import com.ibm.team.repository.common.LineDelimiter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class ContentPropertiesPreferenceManager {
    public static final String FILE_NAMES_AND_EXTENSIONS = "File names and Extensions";
    private Map<String, ContentPropertiesPreference.IContentTypePreferences> map = new HashMap<String, ContentPropertiesPreference.IContentTypePreferences>();
    private ContentPropertiesPreference fileNamesAndExtensions;
    private Preferences preferences;
    public static IContentType ICONTENT_TYPE_TEXT = Platform.getContentTypeManager().getContentType("org.eclipse.core.runtime.text");

    Preferences getPreference() {
        if (this.preferences == null) {
            IEclipsePreferences prefs = new InstanceScope().getNode("com.ibm.team.filesystem.rcp.core");
            this.preferences = prefs.node(ContentPropertiesPreferenceManager.class.getName()).node("FileProperties");
        }
        return this.preferences;
    }

    public void populate() throws BackingStoreException {
        IContentType[] types = Platform.getContentTypeManager().getAllContentTypes();
        Preferences pref = this.getPreference();
        Object[] objectArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4;
            String[] stringArray;
            IContentType type = objectArray[n2];
            this.get(type, null);
            if (pref.nodeExists(type.getId())) {
                stringArray = pref.node(type.getId()).childrenNames();
                n4 = stringArray.length;
                n3 = 0;
                while (n3 < n4) {
                    String key = stringArray[n3];
                    this.get(type, key);
                    ++n3;
                }
            }
            stringArray = type.getFileSpecs(8);
            n4 = stringArray.length;
            n3 = 0;
            while (n3 < n4) {
                String extension = stringArray[n3];
                this.get(type, "*." + extension);
                ++n3;
            }
            stringArray = type.getFileSpecs(4);
            n4 = stringArray.length;
            n3 = 0;
            while (n3 < n4) {
                String filename = stringArray[n3];
                this.get(type, filename);
                ++n3;
            }
            ++n2;
        }
        this.getFileNamesAndExtensions();
        if (pref.nodeExists(FILE_NAMES_AND_EXTENSIONS)) {
            objectArray = pref.node(FILE_NAMES_AND_EXTENSIONS).childrenNames();
            n = objectArray.length;
            n2 = 0;
            while (n2 < n) {
                IContentType key = objectArray[n2];
                this.get(null, (String)key);
                ++n2;
            }
        }
    }

    public ContentPropertiesPreference get(IContentType contentType, String filename) {
        if (contentType != null) {
            ContentPropertiesPreference.IContentTypePreferences pref = this.map.get(contentType.getId());
            if (pref == null) {
                ContentPropertiesPreference.IContentTypePreferences parent;
                pref = contentType.getId().equals("org.eclipse.core.runtime.text") ? new TextTypePreference(this, contentType) : new ContentPropertiesPreference.IContentTypePreferences(this, contentType);
                this.map.put(contentType.getId(), pref);
                if (contentType.getBaseType() != null && (parent = this.map.get(contentType.getBaseType().getId())) != null) {
                    parent.addChild(pref);
                }
                for (ContentPropertiesPreference.IContentTypePreferences possibleChild : this.map.values()) {
                    IContentType possibleChildType = possibleChild.getIContentType();
                    if (possibleChildType.getBaseType() == null || !possibleChildType.getBaseType().getId().equals(contentType.getId())) continue;
                    pref.addChild(possibleChild);
                }
            }
            if (filename != null) {
                return pref.get(filename);
            }
            return pref;
        }
        if (filename == null) {
            return null;
        }
        ContentPropertiesPreference pref = this.getFileNamesAndExtensions();
        return pref.get(filename);
    }

    ContentPropertiesPreference getFileNamesAndExtensions() {
        if (this.fileNamesAndExtensions == null) {
            this.fileNamesAndExtensions = new FileNameEandExtensionRoot(this, FILE_NAMES_AND_EXTENSIONS, FILE_NAMES_AND_EXTENSIONS, null);
        }
        return this.fileNamesAndExtensions;
    }

    public ContentPropertiesPreference[] getChildren() {
        ArrayList<ContentPropertiesPreference> list = new ArrayList<ContentPropertiesPreference>();
        for (ContentPropertiesPreference.IContentTypePreferences pref : this.map.values()) {
            if (pref.getIContentType().getBaseType() != null) continue;
            list.add(pref);
        }
        if (this.fileNamesAndExtensions != null) {
            list.add(this.fileNamesAndExtensions);
        }
        return list.toArray(new ContentPropertiesPreference[list.size()]);
    }

    public boolean isDirty() {
        ContentPropertiesPreference[] contentPropertiesPreferenceArray = this.getChildren();
        int n = contentPropertiesPreferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            ContentPropertiesPreference pref = contentPropertiesPreferenceArray[n2];
            if (this.isDirty(pref)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isDirty(ContentPropertiesPreference pref) {
        if (pref.isDirty()) {
            return true;
        }
        ContentPropertiesPreference[] contentPropertiesPreferenceArray = pref.getChildren();
        int n = contentPropertiesPreferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            ContentPropertiesPreference child = contentPropertiesPreferenceArray[n2];
            if (this.isDirty(child)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void flush() throws BackingStoreException {
        ContentPropertiesPreference[] contentPropertiesPreferenceArray = this.getChildren();
        int n = contentPropertiesPreferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            ContentPropertiesPreference pref = contentPropertiesPreferenceArray[n2];
            pref.flush();
            ++n2;
        }
    }

    public void refresh() throws BackingStoreException {
        ContentPropertiesPreference[] contentPropertiesPreferenceArray = this.getChildren();
        int n = contentPropertiesPreferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            ContentPropertiesPreference pref = contentPropertiesPreferenceArray[n2];
            pref.refresh();
            ++n2;
        }
    }

    private final class FileNameEandExtensionRoot
    extends ContentPropertiesPreference.FilenameFilePropertyPreference {
        private FileNameEandExtensionRoot(ContentPropertiesPreferenceManager manager, String parentKey, String filename, ContentPropertiesPreference parent) {
            super(manager, parentKey, filename, parent);
            super.setLineDelimiter(LineDelimiter.LINE_DELIMITER_NONE);
            super.setMimeType("application/unknown");
        }

        public LineDelimiter getLineDelimiter() {
            return LineDelimiter.LINE_DELIMITER_NONE;
        }

        public String getMimeType() {
            return "application/unknown";
        }

        public void setLineDelimiter(LineDelimiter lineDelimiter) {
        }

        public void setMimeType(String mimeType) {
        }

        protected Preferences getPreference() {
            return ContentPropertiesPreferenceManager.this.getPreference();
        }

        public boolean preferenceExists() {
            return true;
        }

        public String getName() {
            return Messages.ContentPropertiesPreferenceManager_FileNamesAndExtensions;
        }
    }

    private final class TextTypePreference
    extends ContentPropertiesPreference.IContentTypePreferences {
        private TextTypePreference(ContentPropertiesPreferenceManager manager, IContentType contentType) {
            super(manager, contentType);
            super.setLineDelimiter(LineDelimiter.LINE_DELIMITER_PLATFORM);
            super.setMimeType("text/plain");
        }

        public LineDelimiter getLineDelimiter() {
            return LineDelimiter.LINE_DELIMITER_PLATFORM;
        }

        public String getMimeType() {
            return "text/plain";
        }

        public boolean preferenceExists() {
            return true;
        }

        public void setLineDelimiter(LineDelimiter lineDelimiter) {
        }

        public void setMimeType(String mimeType) {
        }
    }
}

