/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.patches;

import com.ibm.team.filesystem.common.changemodel.VersionablePath;
import com.ibm.team.filesystem.rcp.core.internal.InternalPreferencesUtil;
import com.ibm.team.filesystem.rcp.core.patches.PatchOp;
import com.ibm.team.repository.rcp.core.preferences.IPrefSerializable;
import com.ibm.team.repository.rcp.core.preferences.PrefSerializableUtil;
import com.ibm.team.repository.rcp.core.preferences.PreferencesUtil;
import com.ibm.team.repository.rcp.core.preferences.SerializationContext;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatchResult
implements IPrefSerializable {
    private static final String ATTR_PROBLEMS = "problems";
    private static final String ATTR_OPERATION = "operation";
    private Map<VersionablePath, Map<PatchOp, IStatus>> resultCode = new HashMap<VersionablePath, Map<PatchOp, IStatus>>();

    public PatchResult() {
    }

    public PatchResult(SerializationContext context, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Preferences prefs = context.getPrefs();
        int count = 0;
        try {
            String nodeName;
            SubMonitor loopProgress = progress.newChild(100).setWorkRemaining(prefs.childrenNames().length);
            while (prefs.nodeExists(nodeName = "" + count++)) {
                Preferences bw = prefs.node(nodeName);
                VersionablePath next = InternalPreferencesUtil.getVersionablePath(bw);
                Preferences problemsNode = bw.node(ATTR_PROBLEMS);
                int opCount = 0;
                HashMap<PatchOp, IStatus> opMap = new HashMap<PatchOp, IStatus>();
                SubMonitor iterationProgress = loopProgress.newChild(1).setWorkRemaining(problemsNode.childrenNames().length);
                while (true) {
                    String nextName;
                    SubMonitor opProgress = iterationProgress.newChild(1).setWorkRemaining(100);
                    if (!problemsNode.nodeExists(nextName = "" + opCount++)) break;
                    Preferences whereToLoad = problemsNode.node(nextName);
                    PatchOp nextOp = (PatchOp)PrefSerializableUtil.loadNode((SerializationContext)new SerializationContext(whereToLoad.node(ATTR_OPERATION), context.getFileStore()), PatchOp.class, (IProgressMonitor)opProgress.newChild(100));
                    IStatus status = PreferencesUtil.getStatus((Preferences)whereToLoad);
                    opMap.put(nextOp, status);
                }
                this.resultCode.put(next, opMap);
            }
        }
        catch (BackingStoreException e) {
            throw new CoreException(StatusUtil.newStatus(PatchResult.class, (Throwable)e));
        }
    }

    public void addResult(VersionablePath path, PatchOp patchOp, IStatus resultStatus) {
        Map<PatchOp, IStatus> resultsForThisPath = this.resultCode.get(path);
        if (resultsForThisPath == null) {
            resultsForThisPath = new HashMap<PatchOp, IStatus>();
            this.resultCode.put(path, resultsForThisPath);
        }
        resultsForThisPath.put(patchOp, resultStatus);
    }

    public IStatus getResult(VersionablePath path, PatchOp op) {
        Map<PatchOp, IStatus> resultsForThisPath = this.resultCode.get(path);
        if (resultsForThisPath == null) {
            return null;
        }
        return resultsForThisPath.get(op);
    }

    public Collection<VersionablePath> getAffectedPaths() {
        return this.resultCode.keySet();
    }

    public Collection<PatchOp> getOpsForPath(VersionablePath toQuery) {
        Map<PatchOp, IStatus> resultsForThisPath = this.resultCode.get(toQuery);
        if (resultsForThisPath == null) {
            return Collections.emptySet();
        }
        return resultsForThisPath.keySet();
    }

    public void dispose() {
        for (Map<PatchOp, IStatus> nextMap : this.resultCode.values()) {
            for (PatchOp next : nextMap.keySet()) {
                next.dispose();
            }
        }
        this.resultCode.clear();
    }

    public int getSuccessfulOpCount() {
        int count = 0;
        for (Map<PatchOp, IStatus> nextMap : this.resultCode.values()) {
            for (IStatus next : nextMap.values()) {
                if (!next.isOK()) continue;
                ++count;
            }
        }
        return count;
    }

    public void save(SerializationContext context, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Preferences prefs = context.getPrefs();
        int count = 0;
        SubMonitor loopProgress = progress.newChild(100).setWorkRemaining(this.resultCode.size());
        for (VersionablePath next : this.resultCode.keySet()) {
            SubMonitor iterationProgress = loopProgress.newChild(1);
            Preferences bw = prefs.node("" + count++);
            InternalPreferencesUtil.putVersionablePath(bw, next);
            Preferences problemsNode = bw.node(ATTR_PROBLEMS);
            int opCount = 0;
            Map<PatchOp, IStatus> opMap = this.resultCode.get(next);
            iterationProgress.setWorkRemaining(opMap.size());
            for (PatchOp op : opMap.keySet()) {
                Preferences whereToSave = problemsNode.node("" + opCount++);
                PrefSerializableUtil.saveNode((SerializationContext)new SerializationContext(whereToSave.node(ATTR_OPERATION), context.getFileStore()), (IPrefSerializable)op, (IProgressMonitor)iterationProgress.newChild(1));
                PreferencesUtil.putStatus((Preferences)whereToSave, (IStatus)opMap.get(op));
            }
        }
    }

    public boolean isOK() {
        for (Map<PatchOp, IStatus> next : this.resultCode.values()) {
            for (IStatus stat : next.values()) {
                if (stat.isOK()) continue;
                return false;
            }
        }
        return true;
    }
}

