/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.patches;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.changemodel.ChangeDescription;
import com.ibm.team.filesystem.common.changemodel.VersionablePath;
import com.ibm.team.filesystem.common.changemodel.VersionablePathSegment;
import com.ibm.team.filesystem.common.internal.patch.CreatePatchUtil;
import com.ibm.team.filesystem.rcp.core.internal.patches.ClearFileContentsOp;
import com.ibm.team.filesystem.rcp.core.internal.patches.CreateEmptyFileOp;
import com.ibm.team.filesystem.rcp.core.internal.patches.CreateFolderOp;
import com.ibm.team.filesystem.rcp.core.internal.patches.DeleteFolderOp;
import com.ibm.team.filesystem.rcp.core.internal.patches.FilePatch;
import com.ibm.team.filesystem.rcp.core.internal.patches.FilePatchFactory;
import com.ibm.team.filesystem.rcp.core.internal.patches.Hunk;
import com.ibm.team.filesystem.rcp.core.internal.patches.MoveFileOp;
import com.ibm.team.filesystem.rcp.core.internal.patches.ParsedFilePatch;
import com.ibm.team.filesystem.rcp.core.internal.patches.ParsedPatch;
import com.ibm.team.filesystem.rcp.core.internal.streams.InputStreamStorage;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.utils.IInputStreamProvider;
import com.ibm.team.repository.rcp.common.NullUtil;
import com.ibm.team.repository.rcp.common.collection.CollectionUtil;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.NewCollection;
import com.ibm.team.scm.common.internal.util.SiloedItemId;
import com.ibm.team.scm.common.internal.util.StateId;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.CharBuffer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PatchParser {
    public static final String TOKEN_END_METADATA = "#---";
    public static final String ECLIPSE_PATCH_HEADER_PREFIX = "### Eclipse Workspace Patch";

    PatchParser() {
    }

    public static String[] tokenizeLine(String nextLine) throws ParseException {
        ArrayList tokens = NewCollection.arrayList();
        char[] chars = new char[nextLine.length()];
        nextLine.getChars(0, nextLine.length(), chars, 0);
        CharBuffer buffer = CharBuffer.allocate(chars.length);
        int index = 1;
        int tokenStart = 0;
        while (index < chars.length) {
            char ch = chars[index];
            if (Character.isWhitespace(ch)) break;
            buffer.put(ch);
            ++index;
        }
        tokens.add(new String(buffer.array(), tokenStart, buffer.position()));
        tokenStart = buffer.position();
        int mode = 1;
        while (index < chars.length) {
            char ch = chars[index];
            block0 : switch (mode) {
                case 1: {
                    if (ch == '\"') {
                        mode = 2;
                        break;
                    }
                    if (Character.isWhitespace(ch)) break;
                    throw new ParseException("Unexpected character following whitespace. Expected '\"' or whitespace.", index);
                }
                case 2: {
                    if (ch == '\\') {
                        mode = 3;
                        break;
                    }
                    if (ch == '\"') {
                        mode = 1;
                        tokens.add(new String(buffer.array(), tokenStart, buffer.position() - tokenStart));
                        tokenStart = buffer.position();
                        break;
                    }
                    buffer.append(ch);
                    break;
                }
                case 3: {
                    switch (ch) {
                        case '\"': 
                        case '\'': 
                        case '\\': 
                        case 'b': 
                        case 'n': 
                        case 'r': 
                        case 't': {
                            buffer.append(ch);
                            mode = 2;
                            break block0;
                        }
                    }
                    throw new ParseException("Unknown escape sequence", index);
                }
            }
            ++index;
        }
        if (mode == 2 || mode == 3) {
            throw new ParseException("Unterminated string literal", index);
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    public static UUID getUUID(String[] tokens, int i) throws ParseException {
        String first = PatchParser.getString(tokens, 0);
        try {
            return UUID.valueOf((String)PatchParser.getString(tokens, i));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParseException(NLS.bind((String)"{0} invalid UUID \"{1}\"", (Object)first, (Object)tokens[i]), 0);
        }
    }

    private static String getString(String[] tokens, int i) throws ParseException {
        if (tokens.length < 1) {
            throw new ParseException("Expecting one or more tokens on this line", 0);
        }
        String first = tokens[0];
        if (tokens.length < i + 1) {
            throw new ParseException(NLS.bind((String)"{0} expecting at least {1} arguments", (Object)first, (Object)("" + (i - 1))), 0);
        }
        return tokens[i];
    }

    public static PatchMetadata parseMetadata(InputStream patchStream) throws IOException {
        PatchMetadata result = new PatchMetadata();
        InputStreamReader inputStreamReader = new InputStreamReader(patchStream);
        BufferedReader reader = new BufferedReader(inputStreamReader);
        List moves = NewCollection.arrayList();
        String comment = "";
        List changeSets = NewCollection.arrayList();
        ItemId component = ItemId.getNullItem((IItemType)IComponent.ITEM_TYPE);
        Set emptyFile = NewCollection.hashSet();
        Set folderCreates = NewCollection.hashSet();
        Set folderDeletes = NewCollection.hashSet();
        Collection workItems = NewCollection.hashSet();
        Date date = new Date();
        boolean knownVersion = false;
        String firstLine = NullUtil.safeString((String)reader.readLine());
        if (firstLine.startsWith("### Jazz Patch")) {
            result.setPatchType(ParsedPatch.PATCH_TYPE_JAZZ);
            String versionNumber = firstLine.substring("### Jazz Patch".length(), firstLine.length()).trim();
            if (versionNumber.equals("1.0")) {
                knownVersion = true;
            }
        } else if (firstLine.startsWith(ECLIPSE_PATCH_HEADER_PREFIX)) {
            result.setPatchType(ParsedPatch.PATCH_TYPE_ECLIPSE);
        } else {
            result.setPatchType(ParsedPatch.PATCH_TYPE_NORMAL);
        }
        if (result.getPatchType() == ParsedPatch.PATCH_TYPE_JAZZ) {
            boolean isMetadata = true;
            do {
                String nextLine;
                if ((nextLine = NullUtil.safeString((String)reader.readLine())).startsWith("#")) {
                    try {
                        StateId stateId;
                        IPath thePath;
                        String[] tokens;
                        if (nextLine.startsWith("#comment:")) {
                            tokens = PatchParser.tokenizeLine(nextLine);
                            if (tokens.length < 2) {
                                throw new ParseException("#comment: should be followed by a comment string", 0);
                            }
                            comment = tokens[1];
                        } else if (nextLine.startsWith("#changeset:")) {
                            tokens = PatchParser.tokenizeLine(nextLine);
                            changeSets.add(new ItemId(IChangeSet.ITEM_TYPE, PatchParser.getUUID(tokens, 1)));
                        } else if (nextLine.startsWith("#changeset:")) {
                            tokens = PatchParser.tokenizeLine(nextLine);
                            changeSets.add(new ItemId(IChangeSet.ITEM_TYPE, PatchParser.getUUID(tokens, 1)));
                        } else if (nextLine.startsWith("#move:")) {
                            tokens = PatchParser.tokenizeLine(nextLine);
                            if (tokens.length < 3) {
                                throw new ParseException("#move: should be followed by two or more arguments", 0);
                            }
                            moves.add(new MoveInfo(tokens[1], tokens[2]));
                        } else if (nextLine.startsWith("#create_folder:")) {
                            tokens = PatchParser.tokenizeLine(nextLine);
                            folderCreates.add(PatchParser.getPath(tokens, 1));
                        } else if (nextLine.startsWith("#delete_folder:")) {
                            tokens = PatchParser.tokenizeLine(nextLine);
                            folderDeletes.add(PatchParser.getPath(tokens, 1));
                        } else if (nextLine.startsWith("#itemid:")) {
                            tokens = PatchParser.tokenizeLine(nextLine);
                            if (tokens.length < 3) {
                                throw new ParseException("#itemid: should be followed by three arguments", 0);
                            }
                            thePath = PatchParser.getPath(tokens, 1);
                            SiloedItemId item = new SiloedItemId(IFileItem.ITEM_TYPE, PatchParser.getUUID(tokens, 2), PatchParser.getUUID(tokens, 3));
                            result.putItemId(thePath, item);
                        } else if (nextLine.startsWith("#before_state:")) {
                            tokens = PatchParser.tokenizeLine(nextLine);
                            if (tokens.length < 3) {
                                throw new ParseException("#before_state: should be followed by three arguments", 0);
                            }
                            thePath = PatchParser.getPath(tokens, 1);
                            stateId = new StateId(IFileItem.ITEM_TYPE, PatchParser.getUUID(tokens, 2), PatchParser.getUUID(tokens, 3));
                            result.putBeforeState(thePath, stateId);
                        } else if (nextLine.startsWith("#after_state:")) {
                            tokens = PatchParser.tokenizeLine(nextLine);
                            if (tokens.length < 3) {
                                throw new ParseException("#after_state: should be followed by three arguments", 0);
                            }
                            thePath = PatchParser.getPath(tokens, 1);
                            stateId = new StateId(IFileItem.ITEM_TYPE, PatchParser.getUUID(tokens, 2), PatchParser.getUUID(tokens, 3));
                            result.putAfterState(thePath, stateId);
                        } else if (nextLine.startsWith("#work_item:")) {
                            String namespace;
                            tokens = PatchParser.tokenizeLine(nextLine);
                            UUID itemId = PatchParser.getUUID(tokens, 1);
                            String itemType = PatchParser.getString(tokens, 2);
                            IItemType type = IItemType.IRegistry.INSTANCE.getItemType(itemType, namespace = PatchParser.getString(tokens, 3));
                            if (type != null) {
                                workItems.add(new ItemId(type, itemId));
                            }
                        } else if (nextLine.startsWith("#component:")) {
                            tokens = PatchParser.tokenizeLine(nextLine);
                            component = new ItemId(IComponent.ITEM_TYPE, PatchParser.getUUID(tokens, 1));
                        } else if (nextLine.startsWith("#date:")) {
                            tokens = PatchParser.tokenizeLine(nextLine);
                            date = CreatePatchUtil.DIFF_DATE_FORMAT.parse(tokens[1]);
                        } else if (nextLine.startsWith("#emptyfile:")) {
                            tokens = PatchParser.tokenizeLine(nextLine);
                            emptyFile.add(PatchParser.getPath(tokens, 1));
                        } else if (nextLine.equals(TOKEN_END_METADATA)) {
                            isMetadata = false;
                        } else if (!nextLine.trim().equals("#") && knownVersion) {
                            throw new ParseException(NLS.bind((String)"Unknown token: {0}", (Object)nextLine), 0);
                        }
                    }
                    catch (ParseException e) {
                        StatusUtil.log(PatchParser.class, (Throwable)e);
                    }
                    continue;
                }
                isMetadata = false;
            } while (isMetadata);
        }
        result.setDescription(new ChangeDescription(comment, workItems, component, (Collection)changeSets, date));
        result.setMoves(moves);
        result.setEmptyFiles(emptyFile);
        result.setDeletedDirectories(folderDeletes);
        result.setNewDirectories(folderCreates);
        return result;
    }

    private static IPath getPath(String[] tokens, int i) throws ParseException {
        String first = PatchParser.getString(tokens, i);
        try {
            return new Path(tokens[i]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParseException(NLS.bind((String)"{0} invalid Path \"{1}\"", (Object)first, (Object)tokens[i]), 0);
        }
    }

    public static ParsedPatch createPatch(PatchMetadata metadata, List<FilePatch> body, int segmentsToRemove, IPath prefixToAdd, IProgressMonitor monitor) throws CoreException {
        ParsedFilePatch patch;
        VersionablePath nextVPath;
        ParsedFilePatch patch2;
        Object nextVPath2;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ParsedPatch result = ParsedPatch.create(metadata.getDescription(), Collections.emptySet());
        result.setPatchType(metadata.getPatchType());
        Map map = NewCollection.hashMap();
        for (FilePatch nextFilePatch : body) {
            CollectionUtil.addToMapOfLists((Map)map, (Object)nextFilePatch.getTargetPath(), (Object)nextFilePatch);
        }
        for (IPath nextEmpty : metadata.getEmptyFiles()) {
            nextVPath2 = metadata.getVersionablePath(nextEmpty, segmentsToRemove, prefixToAdd);
            patch2 = result.createPatchFor((VersionablePath)nextVPath2);
            List associatedFileDiff = (List)map.get(nextEmpty);
            if (associatedFileDiff == null) {
                patch2.addOp(new CreateEmptyFileOp());
                continue;
            }
            patch2.addOp(new ClearFileContentsOp());
        }
        for (IPath nextFolderDelete : metadata.getDeletedDirectories()) {
            nextVPath2 = metadata.getVersionablePath(nextFolderDelete, segmentsToRemove, prefixToAdd);
            patch2 = result.createPatchFor((VersionablePath)nextVPath2);
            patch2.addOp(new DeleteFolderOp());
        }
        for (IPath nextFolderCreate : metadata.getNewDirectories()) {
            nextVPath2 = metadata.getVersionablePath(nextFolderCreate, segmentsToRemove, prefixToAdd);
            patch2 = result.createPatchFor((VersionablePath)nextVPath2);
            patch2.addOp(new CreateFolderOp((VersionablePath)nextVPath2));
        }
        int moveIdx = 0;
        for (MoveInfo move : metadata.getMoves()) {
            Path beforePath = new Path(move.getBeforePath());
            VersionablePath beforeVersionablePath = metadata.getVersionablePath((IPath)beforePath, segmentsToRemove, prefixToAdd);
            ParsedFilePatch patch3 = result.createPatchFor(beforeVersionablePath);
            Path afterPath = new Path(move.getAfterPath());
            VersionablePath afterFolder = metadata.getVersionablePath(afterPath.removeLastSegments(1), segmentsToRemove, prefixToAdd);
            VersionablePath afterVersionablePath = afterFolder.append(afterPath.lastSegment(), SiloedItemId.create((ItemId)ItemId.getNullItem((IItemType)IFolder.ITEM_TYPE), (ItemId)afterFolder.getSiloedItemId().getComponent()));
            patch3.addOp(new MoveFileOp(afterVersionablePath, moveIdx++));
        }
        for (IPath nextFile : metadata.getBeforeStates().keySet()) {
            nextVPath = metadata.getVersionablePath(nextFile, segmentsToRemove, prefixToAdd);
            patch = result.createPatchFor(nextVPath);
            StateId beforeState = metadata.getBeforeStates().get(nextFile);
            patch.setBeforeState(beforeState);
        }
        for (IPath nextFile : metadata.getAfterStates().keySet()) {
            nextVPath = metadata.getVersionablePath(nextFile, segmentsToRemove, prefixToAdd);
            patch = result.createPatchFor(nextVPath);
            StateId afterState = metadata.getAfterStates().get(nextFile);
            patch.setAfterState(afterState);
        }
        SubMonitor hunkProgress = progress.newChild(100).setWorkRemaining(map.size());
        for (Map.Entry entry : map.entrySet()) {
            SubMonitor iterationProgress = hunkProgress.newChild(1).setWorkRemaining(100);
            IPath path = (IPath)entry.getKey();
            if (metadata.getEmptyFiles().contains(path)) continue;
            VersionablePath nextVPath3 = metadata.getVersionablePath(path, segmentsToRemove, prefixToAdd);
            ParsedFilePatch patch4 = result.createPatchFor(nextVPath3);
            for (FilePatch nextPatch : (List)entry.getValue()) {
                List<Hunk> hunks = Hunk.getHunks(nextPatch, (IProgressMonitor)iterationProgress.newChild(10));
                patch4.addHunks(hunks);
            }
        }
        return result;
    }

    public static ParsedPatch parse(IInputStreamProvider patchData, int segmentsToRemove, IPath prefixToAdd, IProgressMonitor monitor) throws FileSystemClientException {
        ParsedPatch parsedPatch;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        InputStreamStorage storage = new InputStreamStorage(patchData);
        FilePatch[] filePatches = FilePatchFactory.getFactory().parsePatch(storage);
        InputStream patchStream = patchData.getInputStream((IProgressMonitor)progress.newChild(5));
        try {
            PatchMetadata metadata = PatchParser.parseMetadata(patchStream);
            parsedPatch = PatchParser.createPatch(metadata, Arrays.asList(filePatches), segmentsToRemove, prefixToAdd, (IProgressMonitor)progress.newChild(95));
        }
        catch (Throwable throwable) {
            try {
                try {
                    patchStream.close();
                    throw throwable;
                }
                catch (IOException e) {
                    throw new FileSystemClientException(StatusUtil.newStatus(PatchParser.class, (Throwable)e));
                }
            }
            catch (CoreException e) {
                throw new FileSystemClientException(StatusUtil.newStatus(PatchParser.class, (Throwable)e));
            }
        }
        patchStream.close();
        return parsedPatch;
    }

    public static final class MoveInfo {
        private String beforePath;
        private String afterPath;

        public MoveInfo(String beforePath, String afterPath) {
            this.beforePath = beforePath;
            this.afterPath = afterPath;
        }

        public String getBeforePath() {
            return this.beforePath;
        }

        public String getAfterPath() {
            return this.afterPath;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class PatchMetadata {
        private ChangeDescription description = new ChangeDescription();
        private Object patchType = ParsedPatch.PATCH_TYPE_NORMAL;
        private List<MoveInfo> moves = NewCollection.arrayList();
        private Map<IPath, SiloedItemId> itemIdMap = NewCollection.hashMap();
        private Set<IPath> emptyFiles = NewCollection.hashSet();
        private Set<IPath> newDirectories = NewCollection.hashSet();
        private Set<IPath> oldDirectories = NewCollection.hashSet();
        private Map<IPath, StateId> beforeStateMap = NewCollection.hashMap();
        private Map<IPath, StateId> afterStateMap = NewCollection.hashMap();

        public Set<IPath> getNewDirectories() {
            return Collections.unmodifiableSet(this.newDirectories);
        }

        public Set<IPath> getDeletedDirectories() {
            return Collections.unmodifiableSet(this.oldDirectories);
        }

        public Set<IPath> getEmptyFiles() {
            return this.emptyFiles;
        }

        public void setNewDirectories(Set<IPath> directoriesToCreate) {
            this.newDirectories = directoriesToCreate;
        }

        public void setDeletedDirectories(Set<IPath> directoriesToDelete) {
            this.oldDirectories = directoriesToDelete;
        }

        public void setEmptyFiles(Set<IPath> emptyFiles) {
            this.emptyFiles = emptyFiles;
        }

        public Map<IPath, StateId> getBeforeStates() {
            return this.beforeStateMap;
        }

        public Map<IPath, StateId> getAfterStates() {
            return this.afterStateMap;
        }

        public Map<IPath, SiloedItemId> getItemIds() {
            return this.itemIdMap;
        }

        public List<MoveInfo> getMoves() {
            return this.moves;
        }

        public void putItemId(IPath path, SiloedItemId id) {
            this.itemIdMap.put(path, id);
        }

        public void putBeforeState(IPath path, StateId id) {
            this.beforeStateMap.put(path, id);
        }

        public void putAfterState(IPath path, StateId id) {
            this.afterStateMap.put(path, id);
        }

        public void setDescription(ChangeDescription description) {
            this.description = description;
        }

        public Object getPatchType() {
            return this.patchType;
        }

        public void setPatchType(Object patchType) {
            this.patchType = patchType;
        }

        public ChangeDescription getDescription() {
            return this.description;
        }

        public void setMoves(List<MoveInfo> moves) {
            this.moves = moves;
        }

        public VersionablePath getVersionablePath(IPath patchPath, int segmentsToRemove, IPath prefixToAdd) {
            SiloedItemId targetId = this.lookupItem(patchPath);
            LinkedList<VersionablePathSegment> segments = new LinkedList<VersionablePathSegment>();
            ItemId lastComponent = targetId.getComponent();
            ItemId rootItem = ItemId.getNullItem((IItemType)IFolder.ITEM_TYPE);
            boolean isResolved = true;
            if (patchPath.segmentCount() > 1 && patchPath.segment(0).equals("unresolved")) {
                String uuidSegment = patchPath.segment(1);
                try {
                    UUID theUUID = UUID.valueOf((String)uuidSegment);
                    rootItem = new ItemId(IFolder.ITEM_TYPE, theUUID);
                    isResolved = false;
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            IPath current = patchPath;
            if (!isResolved) {
                current = current.removeFirstSegments(2);
            }
            while (!current.isEmpty()) {
                IPath parentPath = current.removeLastSegments(1);
                SiloedItemId siloedParentId = this.lookupItem(parentPath);
                if (lastComponent.isNull() && !siloedParentId.getComponent().isNull()) {
                    lastComponent = siloedParentId.getComponent();
                }
                ItemId parentId = siloedParentId.getItemId();
                if (parentPath.isEmpty() && !isResolved && parentId.isNull()) {
                    parentId = rootItem;
                }
                String segmentName = current.lastSegment();
                segments.addFirst(VersionablePathSegment.create((ItemId)parentId, (String)segmentName));
                current = parentPath;
            }
            int count = 0;
            while (count < segmentsToRemove) {
                if (!segments.isEmpty()) {
                    segments.removeFirst();
                }
                ++count;
            }
            if (!prefixToAdd.isEmpty()) {
                int idx = prefixToAdd.segmentCount() - 1;
                while (idx >= 0) {
                    segments.addFirst(VersionablePathSegment.create((ItemId)ItemId.getNullItem((IItemType)IFolder.ITEM_TYPE), (String)prefixToAdd.segment(idx)));
                    --idx;
                }
            }
            VersionablePath vp = VersionablePath.create(segments, (SiloedItemId)targetId, (boolean)isResolved);
            return vp;
        }

        private SiloedItemId lookupItem(IPath toQuery) {
            SiloedItemId result = this.itemIdMap.get(toQuery);
            if (result != null) {
                return result;
            }
            return SiloedItemId.getNullItem((IItemType)IFolder.ITEM_TYPE);
        }

        public Collection<ItemId<IAuditable>> getWorkItems() {
            return this.description.getWorkItems();
        }
    }
}

