/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.patches;

import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.changemodel.VersionablePath;
import com.ibm.team.filesystem.rcp.core.internal.CoreShareablesUtil;
import com.ibm.team.filesystem.rcp.core.internal.patches.ApplyHunkOp;
import com.ibm.team.filesystem.rcp.core.internal.patches.ApplyStateChangeOp;
import com.ibm.team.filesystem.rcp.core.internal.patches.FilePatch;
import com.ibm.team.filesystem.rcp.core.internal.patches.FilePatchResult;
import com.ibm.team.filesystem.rcp.core.internal.patches.Hunk;
import com.ibm.team.filesystem.rcp.core.internal.streams.InputStreamStorage;
import com.ibm.team.filesystem.rcp.core.internal.streams.PatchResultInputStreamProvider;
import com.ibm.team.filesystem.rcp.core.internal.streams.ResourceInputStreamProvider;
import com.ibm.team.filesystem.rcp.core.patches.PatchOp;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.utils.IInputStreamProvider;
import com.ibm.team.repository.common.utils.TemporaryOutputStream;
import com.ibm.team.repository.rcp.core.utils.StreamReference;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.NewCollection;
import com.ibm.team.scm.common.internal.util.StateId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParsedFilePatch {
    private VersionablePath path;
    private List<PatchOp> operations;
    private List<Hunk> hunks = new ArrayList<Hunk>();
    public static final StateId UNKNOWN_STATE = StateId.getDeletedState((IItemType)IFileItem.ITEM_TYPE, (UUID)ItemId.getNullItemUUID());
    private StateId beforeState = UNKNOWN_STATE;
    private StateId afterState = UNKNOWN_STATE;

    public ParsedFilePatch(VersionablePath path) {
        this.path = path;
        this.operations = NewCollection.arrayList();
    }

    public ParsedFilePatch(VersionablePath path, List<PatchOp> operations) {
        this.path = path;
        this.operations = PatchOp.copyOps(operations);
    }

    public IPath getPath() {
        return this.path.toPath();
    }

    public VersionablePath getVersionablePath() {
        return this.path;
    }

    public void addHunks(List<Hunk> hunks) {
        this.hunks.addAll(hunks);
    }

    public List<Hunk> getHunks() {
        return this.hunks;
    }

    public List<PatchOp> getNonHunks() {
        return this.operations;
    }

    public List<PatchOp> getNonMods() {
        ArrayList<PatchOp> result = new ArrayList<PatchOp>();
        for (PatchOp next : this.operations) {
            if (next.isModify()) continue;
            result.add(next);
        }
        return result;
    }

    public void addOp(PatchOp toAdd) {
        this.operations.add(toAdd);
    }

    public void setBeforeState(StateId beforeState) {
        this.beforeState = beforeState;
    }

    public void setAfterState(StateId afterState) {
        this.afterState = afterState;
    }

    public StateId getAfterState() {
        return this.afterState;
    }

    public StateId getBeforeState() {
        return this.beforeState;
    }

    public void dispose() {
        for (PatchOp next : this.operations) {
            next.dispose();
        }
        this.operations.clear();
    }

    public void addOps(List<PatchOp> ops) {
        this.operations.addAll(PatchOp.copyOps(ops));
    }

    public ParsedFilePatch withAlternateMods(PatchOp patchOp) {
        ParsedFilePatch result = new ParsedFilePatch(this.path);
        result.addOps(this.getNonMods());
        result.setBeforeState(this.beforeState);
        result.setAfterState(this.afterState);
        result.addOp(patchOp);
        return result;
    }

    public ParsedFilePatch copy() {
        ParsedFilePatch result = new ParsedFilePatch(this.path);
        result.addOps(this.getNonHunks());
        result.addHunks(this.getHunks());
        result.setBeforeState(this.beforeState);
        result.setAfterState(this.afterState);
        return result;
    }

    public boolean containsHunks() {
        return !this.hunks.isEmpty();
    }

    public void removeAllHunks() {
        this.hunks.clear();
    }

    public List<PatchOp> getAllOps(IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        ArrayList<PatchOp> result = new ArrayList<PatchOp>();
        result.addAll(this.getNonHunks());
        progress.setWorkRemaining(this.hunks.size());
        for (Hunk next : this.hunks) {
            result.add(new ApplyHunkOp(next, this.getVersionablePath(), (IProgressMonitor)progress.newChild(1)));
        }
        return result;
    }

    public ParsedFilePatch mergeHunks(IProgressMonitor monitor) {
        ParsedFilePatch nextResult;
        ParsedFilePatch next;
        block11: {
            SubMonitor iterationProgress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            next = this;
            nextResult = null;
            VersionablePath path = next.getVersionablePath();
            if (next.containsHunks()) {
                try {
                    Hunk firstHunk;
                    IResource resource = CoreShareablesUtil.getResourceFor(path, (IProgressMonitor)iterationProgress.newChild(100));
                    List<Hunk> hunks = next.getHunks();
                    boolean isDeletion = false;
                    if (hunks.size() == 1 && Hunk.isDeletion(firstHunk = hunks.iterator().next(), null)) {
                        isDeletion = true;
                    }
                    IPath rawPath = path.toPath();
                    FilePatch fp = Hunk.createFilePatch(rawPath, rawPath, new Date(), new Date(), hunks, "", null);
                    if (!(resource instanceof IFile) || isDeletion) break block11;
                    IFile theFile = (IFile)resource;
                    StreamReference beforeStream = StreamReference.create((IInputStreamProvider)TemporaryOutputStream.createLocalBuffer((IInputStreamProvider)new ResourceInputStreamProvider(theFile), null));
                    try {
                        FilePatchResult patchResult = fp.apply(new InputStreamStorage((IInputStreamProvider)beforeStream), null);
                        if (!patchResult.hasMatches()) break block11;
                        StreamReference afterStream = StreamReference.create((IInputStreamProvider)new PatchResultInputStreamProvider(patchResult, true));
                        try {
                            ApplyStateChangeOp patchOp = new ApplyStateChangeOp(next.getBeforeState(), next.getAfterState(), beforeStream, theFile.getCharset(), afterStream, patchResult.getCharset(), path);
                            nextResult = next.copy();
                            nextResult.addOp(patchOp);
                            nextResult.removeAllHunks();
                            nextResult.addHunks(Arrays.asList(patchResult.getRejects()));
                        }
                        finally {
                            afterStream.dispose();
                        }
                    }
                    finally {
                        beforeStream.dispose();
                    }
                }
                catch (Exception exception) {}
            }
        }
        if (nextResult == null) {
            nextResult = next.copy();
        }
        return nextResult;
    }
}

