/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.patches;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.changemodel.VersionablePath;
import com.ibm.team.filesystem.rcp.core.internal.CoreShareablesUtil;
import com.ibm.team.filesystem.rcp.core.internal.InternalPreferencesUtil;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.patches.MovableResource;
import com.ibm.team.filesystem.rcp.core.patches.PatchConflictException;
import com.ibm.team.filesystem.rcp.core.patches.PatchOp;
import com.ibm.team.filesystem.rcp.core.patches.PatchPath;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.preferences.SerializationContext;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.NewCollection;
import com.ibm.team.scm.common.internal.util.SiloedItemId;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.osgi.service.prefs.Preferences;

public class MoveFileOp
extends PatchOp {
    private static final String ATTR_TARGETPATH = "targetpath";
    private static final String ATTR_ORDER = "order";
    private VersionablePath targetPath;
    private int order;

    public MoveFileOp(VersionablePath targetPath, int order) {
        VersionablePath path;
        this.order = order;
        VersionablePath originalPath = targetPath;
        List segments = NewCollection.arrayList();
        int idx = 0;
        while (idx < originalPath.segmentCount()) {
            segments.add(originalPath.segment(idx));
            ++idx;
        }
        this.targetPath = path = VersionablePath.create((List)segments, (SiloedItemId)SiloedItemId.create((ItemId)ItemId.getNullItem((IItemType)IFileItem.ITEM_TYPE), (ItemId)originalPath.getSiloedItemId().getComponent()), (boolean)originalPath.isAbsolute());
    }

    public int getOrder() {
        return this.order;
    }

    public MoveFileOp(SerializationContext savedState, IProgressMonitor monitor) throws CoreException {
        Preferences prefs = savedState.getPrefs();
        this.targetPath = PatchPath.loadVersionablePath(prefs.node(ATTR_TARGETPATH));
        this.order = prefs.getInt(ATTR_ORDER, 0);
    }

    public void autoResolve(MovableResource moveResource, IProgressMonitor monitor) throws FileSystemClientException, PatchConflictException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IResource targetResource = this.doVerify(moveResource);
        try {
            CoreShareablesUtil.createFolder(targetResource.getParent(), this.targetPath.removeLastSegments(1), (IProgressMonitor)progress.newChild(20));
            moveResource.move(targetResource.getFullPath(), false, (IProgressMonitor)progress.newChild(70));
        }
        catch (CoreException e) {
            throw new FileSystemClientException(StatusUtil.newStatus((Object)this, (Throwable)e));
        }
    }

    private IResource doVerify(MovableResource moveResource) throws PatchConflictException, FileSystemClientException {
        IResource targetResource;
        try {
            targetResource = CoreShareablesUtil.getResourceFor(this.targetPath, null);
        }
        catch (TeamRepositoryException e) {
            StatusUtil.log((Object)this, (Throwable)e);
            throw new PatchConflictException(StatusUtil.newStatus((Object)this, (String)Messages.MoveFileOp_1));
        }
        if (targetResource == null) {
            throw new PatchConflictException(StatusUtil.newStatus((Object)this, (String)Messages.MoveFileOp_2));
        }
        if (!moveResource.getResource().exists()) {
            throw new PatchConflictException(StatusUtil.newStatus((Object)this, (String)Messages.MoveFileOp_3));
        }
        if (targetResource.exists()) {
            throw new PatchConflictException(StatusUtil.newStatus((Object)this, (String)Messages.MoveFileOp_4));
        }
        if (targetResource instanceof IProject && !(targetResource instanceof IProject)) {
            throw new PatchConflictException(StatusUtil.newStatus((Object)this, (String)Messages.MoveFileOp_5));
        }
        return targetResource;
    }

    public PatchPath getTargetPath() {
        return new PatchPath(this.targetPath);
    }

    public VersionablePath getTargetVersionablePath() {
        return this.targetPath;
    }

    public void save(SerializationContext whereToSave, IProgressMonitor monitor) throws CoreException {
        Preferences prefs = whereToSave.getPrefs();
        InternalPreferencesUtil.putVersionablePath(prefs.node(ATTR_TARGETPATH), this.targetPath);
        prefs.putInt(ATTR_ORDER, this.order);
    }

    public IStatus verify(MovableResource path, IProgressMonitor monitor) {
        try {
            this.doVerify(path);
        }
        catch (PatchConflictException e) {
            return e.getStatus();
        }
        catch (FileSystemClientException e) {
            StatusUtil.log((Object)this, (Throwable)e);
            return StatusUtil.newStatus((Object)this, (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    public PatchOp copy() {
        return new MoveFileOp(this.targetPath, this.order);
    }

    public void dispose() {
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.order;
        result = 31 * result + (this.targetPath == null ? 0 : this.targetPath.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MoveFileOp other = (MoveFileOp)obj;
        if (this.order != other.order) {
            return false;
        }
        return !(this.targetPath == null ? other.targetPath != null : !this.targetPath.equals((Object)other.targetPath));
    }
}

