/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.patches;

import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.ClientFileStateFactory;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.filesystem.common.changemodel.VersionablePathSegment;
import com.ibm.team.filesystem.rcp.core.internal.resources.ContentProperties;
import com.ibm.team.filesystem.rcp.core.internal.resources.EclipseFileStorage;
import com.ibm.team.filesystem.rcp.core.internal.resources.ResourceUtil;
import com.ibm.team.filesystem.rcp.core.internal.streams.ResourceInputStreamProvider;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.LineDelimiter;
import com.ibm.team.repository.common.utils.IInputStreamProvider;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.StateId;
import java.util.Date;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class FileStateFactory {
    public static FileState create(IResource resource) throws CoreException {
        VersionablePathSegment path = FileStateFactory.currentPath(resource);
        Date date = new Date(resource.getLocalTimeStamp());
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            ContentProperties contentProperties = ResourceUtil.getContentPropertiesNotNull(file);
            return FileState.create((VersionablePathSegment)path, (Date)date, (IInputStreamProvider)new ResourceInputStreamProvider(file), (boolean)new EclipseFileStorage(resource).isExecutable(), (String)contentProperties.mimeType, (LineDelimiter)contentProperties.lineDelimiter, (boolean)contentProperties.isText, (String)contentProperties.encoding, (!file.exists() ? 1 : 0) != 0, (StateId)FileState.NO_STATE);
        }
        return FileState.createFolderState((VersionablePathSegment)path, (Date)date, (!resource.exists() ? 1 : 0) != 0, (StateId)FileState.NO_STATE);
    }

    private static VersionablePathSegment currentPath(IResource resource) {
        IContainer parent = resource.getParent();
        IShareable parentShareable = (IShareable)Adapters.getAdapter((Object)parent, IShareable.class);
        ItemId parentFolder = parentShareable != null && parentShareable.getVersionable() != null ? ItemId.create((IItemHandle)parentShareable.getVersionable()) : ItemId.getNullItem((IItemType)IFolder.ITEM_TYPE);
        return VersionablePathSegment.create((ItemId)parentFolder, (String)resource.getName());
    }

    public static FileState create(ITeamRepository repo, IVersionable verAfter) {
        return ClientFileStateFactory.create((ITeamRepository)repo, (IVersionable)verAfter);
    }
}

