/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.patches;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.patches.AbstractTrivialOp;
import com.ibm.team.filesystem.rcp.core.internal.patches.MovableResource;
import com.ibm.team.filesystem.rcp.core.patches.PatchConflictException;
import com.ibm.team.internal.repository.rcp.streams.EmptyInputStreamProvider;
import com.ibm.team.repository.common.utils.IInputStreamProvider;
import com.ibm.team.repository.rcp.core.preferences.SerializationContext;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class ClearFileContentsOp
extends AbstractTrivialOp {
    public ClearFileContentsOp() {
    }

    public ClearFileContentsOp(SerializationContext savedState, IProgressMonitor monitor) throws CoreException {
    }

    public void autoResolve(MovableResource moveResource, IProgressMonitor monitor) throws FileSystemClientException, PatchConflictException {
        IResource resource = moveResource.getResource();
        this.doVerify(moveResource);
        IFile theFile = (IFile)resource;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            theFile.setContents(EmptyInputStreamProvider.getDefault().getInputStream((IProgressMonitor)progress.newChild(50)), false, true, (IProgressMonitor)progress.newChild(50));
        }
        catch (Exception e) {
            throw new FileSystemClientException(StatusUtil.newStatus((Object)this, (Throwable)e));
        }
    }

    private void doVerify(MovableResource moveResource) throws PatchConflictException {
        IResource resource = moveResource.getResource();
        if (!(resource instanceof IFile)) {
            throw new PatchConflictException(StatusUtil.newStatus((Object)this, (String)NLS.bind((String)Messages.ClearFileContentsOp_0, (Object)resource.getFullPath().toString())));
        }
        if (!resource.exists()) {
            throw new PatchConflictException(StatusUtil.newStatus((Object)this, (String)NLS.bind((String)Messages.ClearFileContentsOp_1, (Object)resource.getFullPath().toString())));
        }
    }

    public IStatus verify(MovableResource path, IProgressMonitor monitor) {
        try {
            this.doVerify(path);
        }
        catch (PatchConflictException e) {
            return e.getStatus();
        }
        return Status.OK_STATUS;
    }

    public boolean isModify() {
        return true;
    }

    public IInputStreamProvider getAfterStream(IProgressMonitor monitor) throws FileSystemClientException {
        return EmptyInputStreamProvider.getDefault();
    }

    public IInputStreamProvider getBeforeStream(IProgressMonitor monitor) throws FileSystemClientException {
        return EmptyInputStreamProvider.getDefault();
    }
}

