/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.patches;

import com.ibm.team.filesystem.common.changemodel.VersionablePath;
import com.ibm.team.filesystem.rcp.core.internal.InternalPreferencesUtil;
import com.ibm.team.filesystem.rcp.core.internal.patches.AbstractStateChangeOp;
import com.ibm.team.filesystem.rcp.core.patches.PatchOp;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.utils.IInputStreamProvider;
import com.ibm.team.repository.rcp.core.preferences.PreferencesUtil;
import com.ibm.team.repository.rcp.core.preferences.SerializationContext;
import com.ibm.team.repository.rcp.core.preferences.StreamStore;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.core.utils.StreamReference;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.StateId;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.osgi.service.prefs.Preferences;

public class ApplyStateChangeOp
extends AbstractStateChangeOp {
    private static final String ATTR_AFTER_CHARSET = "afterCharset";
    private static final String ATTR_BEFORE_CHARSET = "beforeCharset";
    private static final String ATTR_AFTER = "after";
    private static final String ATTR_BEFORE = "before";
    private static final String ATTR_BEFORE_STATE_FILE = "beforeFile";
    private static final String ATTR_AFTER_STATE_FILE = "afterFile";
    private static final String ATTR_PATH = "path";
    private StateId beforeState;
    private StateId afterState;
    private StreamReference beforeStream;
    private StreamReference afterStream;
    private String beforeCharset;
    private String afterCharset;

    public ApplyStateChangeOp(StateId beforeState, StateId afterState, StreamReference beforeStream, String beforeCharset, StreamReference afterStream, String afterCharset, VersionablePath knownPathSegments) {
        super(knownPathSegments);
        this.beforeState = beforeState;
        this.afterState = afterState;
        this.beforeStream = beforeStream != null ? beforeStream.incRef() : null;
        this.afterStream = afterStream != null ? afterStream.incRef() : null;
        this.beforeCharset = beforeCharset;
        this.afterCharset = afterCharset;
    }

    public ApplyStateChangeOp(SerializationContext ctxt, IProgressMonitor monitor) throws CoreException {
        super(VersionablePath.getNullPath());
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Preferences savedState = ctxt.getPrefs();
        StreamStore fileStore = ctxt.getFileStore();
        this.beforeState = InternalPreferencesUtil.getStateId(savedState, ATTR_BEFORE);
        this.afterState = InternalPreferencesUtil.getStateId(savedState, ATTR_AFTER);
        this.beforeCharset = PreferencesUtil.getString((Preferences)savedState, (String)ATTR_BEFORE_CHARSET);
        this.afterCharset = PreferencesUtil.getString((Preferences)savedState, (String)ATTR_AFTER_CHARSET);
        String beforeStateFile = PreferencesUtil.getString((Preferences)savedState, (String)ATTR_BEFORE_STATE_FILE);
        String afterStateFile = PreferencesUtil.getString((Preferences)savedState, (String)ATTR_AFTER_STATE_FILE);
        this.beforeStream = StreamReference.create((IInputStreamProvider)fileStore.loadStream(beforeStateFile, (IProgressMonitor)progress.newChild(50)));
        this.afterStream = StreamReference.create((IInputStreamProvider)fileStore.loadStream(afterStateFile, (IProgressMonitor)progress.newChild(50)));
        VersionablePath knownSegments = InternalPreferencesUtil.getVersionablePath(savedState, ATTR_PATH, VersionablePath.getUnresolvedPath((ItemId)this.afterState.getItemId()));
        this.setKnownPathSegments(knownSegments);
    }

    public void save(SerializationContext context, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Preferences whereToSave = context.getPrefs();
        InternalPreferencesUtil.putStateId(whereToSave, ATTR_BEFORE, this.beforeState);
        InternalPreferencesUtil.putStateId(whereToSave, ATTR_AFTER, this.afterState);
        whereToSave.put(ATTR_BEFORE_CHARSET, this.beforeCharset);
        whereToSave.put(ATTR_AFTER_CHARSET, this.afterCharset);
        String beforeHandle = context.getFileStore().saveStream((IInputStreamProvider)this.beforeStream, (IProgressMonitor)progress.newChild(50));
        String afterHandle = context.getFileStore().saveStream((IInputStreamProvider)this.afterStream, (IProgressMonitor)progress.newChild(50));
        whereToSave.put(ATTR_BEFORE_STATE_FILE, beforeHandle);
        whereToSave.put(ATTR_AFTER_STATE_FILE, afterHandle);
        InternalPreferencesUtil.putVersionablePath(whereToSave, ATTR_PATH, this.getKnownPathSegments());
    }

    public StateId getBeforeState() {
        return this.beforeState;
    }

    public StateId getAfterState() {
        return this.afterState;
    }

    public IInputStreamProvider getBeforeStream(IProgressMonitor monitor) {
        return this.beforeStream;
    }

    public IInputStreamProvider getAfterStream(IProgressMonitor monitor) {
        return this.afterStream;
    }

    public String getBeforeCharset() {
        return this.beforeCharset;
    }

    public String getAfterCharset() {
        return this.afterCharset;
    }

    public String getAfterCharset(IProgressMonitor monitor) throws TeamRepositoryException {
        return this.afterCharset;
    }

    public String getBeforeCharset(IProgressMonitor monitor) throws TeamRepositoryException {
        return this.beforeCharset;
    }

    public PatchOp copy() {
        return new ApplyStateChangeOp(this.beforeState, this.afterState, this.beforeStream, this.beforeCharset, this.afterStream, this.afterCharset, this.getKnownPathSegments());
    }

    public void dispose() {
        try {
            if (this.beforeStream != null) {
                this.beforeStream.dispose();
            }
            if (this.afterStream != null) {
                this.afterStream.dispose();
            }
        }
        catch (IOException e) {
            StatusUtil.log((Object)this, (Throwable)e);
        }
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.afterCharset == null ? 0 : this.afterCharset.hashCode());
        result = 31 * result + (this.afterState == null ? 0 : this.afterState.hashCode());
        result = 31 * result + (this.afterStream == null ? 0 : this.afterStream.hashCode());
        result = 31 * result + (this.beforeCharset == null ? 0 : this.beforeCharset.hashCode());
        result = 31 * result + (this.beforeState == null ? 0 : this.beforeState.hashCode());
        result = 31 * result + (this.beforeStream == null ? 0 : this.beforeStream.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ApplyStateChangeOp other = (ApplyStateChangeOp)obj;
        if (this.afterCharset == null ? other.afterCharset != null : !this.afterCharset.equals(other.afterCharset)) {
            return false;
        }
        if (this.afterState == null ? other.afterState != null : !this.afterState.equals((Object)other.afterState)) {
            return false;
        }
        if (this.afterStream == null ? other.afterStream != null : !this.afterStream.equals((Object)other.afterStream)) {
            return false;
        }
        if (this.beforeCharset == null ? other.beforeCharset != null : !this.beforeCharset.equals(other.beforeCharset)) {
            return false;
        }
        if (this.beforeState == null ? other.beforeState != null : !this.beforeState.equals((Object)other.beforeState)) {
            return false;
        }
        return !(this.beforeStream == null ? other.beforeStream != null : !this.beforeStream.equals((Object)other.beforeStream));
    }

    public int getStartLine(IProgressMonitor monitor) {
        return 0;
    }
}

