/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.patches;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.common.changemodel.VersionablePath;
import com.ibm.team.filesystem.rcp.core.internal.CoreShareablesUtil;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.operations.merge.FileContentMerger;
import com.ibm.team.filesystem.rcp.core.internal.patches.MovableResource;
import com.ibm.team.filesystem.rcp.core.internal.patches.ParsedFilePatch;
import com.ibm.team.filesystem.rcp.core.internal.streams.InputStreamStorage;
import com.ibm.team.filesystem.rcp.core.patches.PatchConflictException;
import com.ibm.team.filesystem.rcp.core.patches.PatchOp;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.utils.IInputStreamProvider;
import com.ibm.team.repository.common.utils.TemporaryOutputStream;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.internal.util.StateId;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.team.core.mapping.IStorageMerger;

public abstract class AbstractStateChangeOp
extends PatchOp {
    private VersionablePath knownPathSegments;

    protected AbstractStateChangeOp(VersionablePath knownPathSegments) {
        this.knownPathSegments = knownPathSegments;
    }

    protected final void setKnownPathSegments(VersionablePath knownSegments) {
        this.knownPathSegments = knownSegments;
    }

    protected VersionablePath getKnownPathSegments() {
        return this.knownPathSegments;
    }

    public void autoResolve(MovableResource path, IProgressMonitor monitor) throws FileSystemClientException, PatchConflictException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        StateId beforeState = this.getBeforeState();
        StateId afterState = this.getAfterState();
        IResource resource = path.getResource();
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            try {
                if (!afterState.equals((Object)ParsedFilePatch.UNKNOWN_STATE) && afterState.isDeleted()) {
                    if (!file.exists()) {
                        return;
                    }
                    file.delete(2, (IProgressMonitor)progress.newChild(100));
                    return;
                }
                if (!beforeState.equals((Object)ParsedFilePatch.UNKNOWN_STATE) && beforeState.isDeleted()) {
                    CoreShareablesUtil.createFile(file, this.getAfterStream(null), this.knownPathSegments, (IProgressMonitor)progress.newChild(20));
                    return;
                }
                IInputStreamProvider mergeResult = this.doMerge(path, (IProgressMonitor)progress);
                InputStream input = mergeResult.getInputStream((IProgressMonitor)progress.newChild(1));
                try {
                    try {
                        file.setContents(input, 2, (IProgressMonitor)progress.newChild(4));
                    }
                    catch (CoreException e) {
                        throw new FileSystemClientException(StatusUtil.newStatus((Object)this, (Throwable)e));
                    }
                }
                finally {
                    input.close();
                }
            }
            catch (IOException e) {
                throw new FileSystemClientException(StatusUtil.newStatus((Object)this, (Throwable)e));
            }
            catch (PatchConflictException e) {
                throw e;
            }
            catch (CoreException e) {
                throw new FileSystemClientException(StatusUtil.newStatus((Object)this, (Throwable)e));
            }
        }
    }

    private IInputStreamProvider doMerge(MovableResource path, IProgressMonitor monitor) throws FileSystemClientException, PatchConflictException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            IResource resource = path.getResource();
            StateId beforeState = this.getBeforeState();
            StateId afterState = this.getAfterState();
            if (resource instanceof IFile) {
                IFile file = (IFile)resource;
                if (!beforeState.equals((Object)ParsedFilePatch.UNKNOWN_STATE)) {
                    StateId remoteState;
                    IVersionableHandle remoteHandle;
                    if (beforeState.isDeleted()) {
                        if (!file.exists()) {
                            return this.getAfterStream(null);
                        }
                        throw new PatchConflictException(StatusUtil.newStatus((Object)this, (String)Messages.AbstractStateChangeOp_0));
                    }
                    IShareable shareable = (IShareable)Adapters.getAdapter((Object)resource, IShareable.class);
                    if (!shareable.isLocallyModified() && (remoteHandle = shareable.getRemote()) != null && (remoteState = new StateId((IItemHandle)remoteHandle)).equals((Object)beforeState)) {
                        return this.getAfterStream(null);
                    }
                }
                if (!afterState.equals((Object)ParsedFilePatch.UNKNOWN_STATE) && afterState.isDeleted()) {
                    return this.getAfterStream(null);
                }
                if (!file.exists()) {
                    throw new PatchConflictException(StatusUtil.newStatus((Object)this, (String)Messages.ApplyStateChangeOp_6));
                }
                try {
                    IStatus status;
                    TemporaryOutputStream outputStream = TemporaryOutputStream.getEstimatedSizeTemporaryOutputStream((long)-1L);
                    try {
                        try {
                            IStorageMerger storageMerger = FileContentMerger.getStorageMerger(file, null, true);
                            if (storageMerger == null) {
                                throw new PatchConflictException(StatusUtil.newStatus((Object)this, (String)Messages.ApplyStateChangeOp_7));
                            }
                            status = FileContentMerger.performMerge(storageMerger, (OutputStream)outputStream, file.getCharset(), new InputStreamStorage(this.getBeforeStream(null), this.getBeforeCharset(null)), (IEncodedStorage)file, new InputStreamStorage(this.getAfterStream(null), this.getAfterCharset(null)), progress.newChild(50));
                        }
                        catch (CoreException e) {
                            if (e instanceof PatchConflictException) {
                                throw (PatchConflictException)e;
                            }
                            throw new FileSystemClientException(StatusUtil.newStatus((Object)this, (Throwable)e));
                        }
                    }
                    finally {
                        outputStream.close();
                    }
                    if (!status.isOK()) {
                        throw new PatchConflictException(StatusUtil.newStatus((Object)this, (String)Messages.ApplyStateChangeOp_8));
                    }
                    return outputStream;
                }
                catch (IOException e) {
                    throw new FileSystemClientException(StatusUtil.newStatus((Object)this, (Throwable)e));
                }
            }
            throw new PatchConflictException(StatusUtil.newStatus((Object)this, (String)Messages.ApplyStateChangeOp_9));
        }
        catch (TeamRepositoryException e) {
            throw new PatchConflictException(StatusUtil.newStatus((Object)this, (Throwable)e));
        }
    }

    public boolean isDelete() {
        StateId afterState = this.getAfterState();
        return !afterState.equals((Object)ParsedFilePatch.UNKNOWN_STATE) && afterState.isDeleted();
    }

    public boolean isCreate() {
        StateId beforeState = this.getBeforeState();
        return !beforeState.equals((Object)ParsedFilePatch.UNKNOWN_STATE) && beforeState.isDeleted();
    }

    public abstract StateId getBeforeState();

    public abstract StateId getAfterState();

    public abstract String getAfterCharset(IProgressMonitor var1) throws TeamRepositoryException;

    public abstract String getBeforeCharset(IProgressMonitor var1) throws TeamRepositoryException;

    public IStatus verify(MovableResource path, IProgressMonitor monitor) {
        try {
            this.doMerge(path, monitor);
            return Status.OK_STATUS;
        }
        catch (CoreException e) {
            return StatusUtil.newStatus((Object)this, (Throwable)e);
        }
    }

    public boolean isModify() {
        return true;
    }
}

