/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.operations.share;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileSystemManager;
import com.ibm.team.filesystem.client.internal.FileSystemServiceProxy;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.CopyFileAreaLockUtil;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.DilemmaHandler;
import com.ibm.team.filesystem.common.internal.dto.FilesystemDTOFactory;
import com.ibm.team.filesystem.common.internal.dto.OverlapDescription;
import com.ibm.team.filesystem.common.internal.dto.OverlapRequest;
import com.ibm.team.filesystem.common.internal.dto.OverlapResponse;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.operations.share.ReshareProject;
import com.ibm.team.filesystem.rcp.core.internal.operations.share.ShareOverlap;
import com.ibm.team.filesystem.rcp.core.internal.operations.share.ShareProjects;
import com.ibm.team.filesystem.rcp.core.operations.IShareProjectsOperation;
import com.ibm.team.filesystem.rcp.core.operations.ShareDilemmaHandler;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShareProjectsOperation
extends FileSystemOperation
implements IShareProjectsOperation {
    private ShareDilemmaHandler problemHandler;
    private HashMap<IWorkspaceConnection, HashMap<ConfigurationDescriptor, List<ShareRequest>>> shareRequests = new HashMap();
    private HashSet<String> projectNames = new HashSet();
    private HashMap<ConfigurationDescriptor, List<ReshareProject>> reshares;
    private HashMap<ConfigurationDescriptor, List<ShareProjects>> shares;
    private HashMap<UUID, IChangeSetHandle> changeSetsCommitted;

    public ShareProjectsOperation(ShareDilemmaHandler problemHandler) {
        super((DilemmaHandler)problemHandler);
        this.problemHandler = problemHandler == null ? ShareDilemmaHandler.getDefault() : problemHandler;
        this.changeSetsCommitted = new HashMap();
    }

    @Override
    public void share(IWorkspaceConnection workspace, IChangeSetHandle changeSet, IComponentHandle component, List<IProject> projects, boolean overwrite) {
        this.addShareRequest(workspace, changeSet, component, null, new String[0], projects, overwrite);
    }

    @Override
    public void share(IWorkspaceConnection workspace, IChangeSetHandle changeSet, IComponentHandle component, IFolderHandle parentFolder, String[] newFolderUnderParent, List<IProject> projects, boolean overwrite) {
        if (parentFolder == null) {
            throw new IllegalArgumentException();
        }
        if (newFolderUnderParent == null) {
            throw new IllegalArgumentException();
        }
        this.addShareRequest(workspace, changeSet, component, parentFolder, newFolderUnderParent, projects, overwrite);
    }

    @Override
    public void share(IWorkspaceConnection workspace, String componentName, String[] newFolderUnderRoot, List<IProject> projects, boolean overwrite) {
        Object descriptor;
        List<ShareRequest> requests;
        if (workspace == null) {
            throw new IllegalArgumentException();
        }
        if (componentName == null) {
            throw new IllegalArgumentException();
        }
        if (newFolderUnderRoot == null) {
            throw new IllegalArgumentException();
        }
        String[] stringArray = newFolderUnderRoot;
        int n = newFolderUnderRoot.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (name == null) {
                throw new IllegalArgumentException();
            }
            ++n2;
        }
        if (projects == null) {
            throw new IllegalArgumentException();
        }
        for (IProject project : projects) {
            if (project == null) {
                throw new IllegalArgumentException("Project can not be null");
            }
            if (this.projectNames.add(project.getName())) continue;
            throw new IllegalArgumentException("Project " + project.getName() + " is already being requested to be shared");
        }
        HashMap<Object, List<ShareRequest>> requestsByConnection = this.shareRequests.get(workspace);
        if (requestsByConnection == null) {
            requestsByConnection = new HashMap();
            this.shareRequests.put(workspace, requestsByConnection);
        }
        if ((requests = requestsByConnection.get(descriptor = null)) == null) {
            requests = new ArrayList<ShareRequest>();
            requestsByConnection.put(descriptor, requests);
        }
        requests.add(new ShareRequest(workspace, componentName, newFolderUnderRoot, projects, overwrite));
    }

    private void addShareRequest(IWorkspaceConnection workspace, IChangeSetHandle changeSet, IComponentHandle component, IFolderHandle parentFolder, String[] newFolderUnderParent, List<IProject> projects, boolean overwrite) {
        ConfigurationDescriptor descriptor;
        List<ShareRequest> requests;
        if (workspace == null) {
            throw new IllegalArgumentException();
        }
        if (component == null) {
            throw new IllegalArgumentException();
        }
        if (newFolderUnderParent == null) {
            throw new IllegalArgumentException();
        }
        String[] stringArray = newFolderUnderParent;
        int n = newFolderUnderParent.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (name == null) {
                throw new IllegalArgumentException();
            }
            ++n2;
        }
        if (projects == null) {
            throw new IllegalArgumentException();
        }
        for (IProject project : projects) {
            if (project == null) {
                throw new IllegalArgumentException("Project can not be null");
            }
            if (!project.exists()) {
                throw new IllegalArgumentException("Project " + project.getName() + " does not exist");
            }
            if (this.projectNames.add(project.getName())) continue;
            throw new IllegalArgumentException("Project " + project.getName() + " is already being requested to be shared");
        }
        HashMap<Object, List<ShareRequest>> requestsByConnection = this.shareRequests.get(workspace);
        if (requestsByConnection == null) {
            requestsByConnection = new HashMap();
            this.shareRequests.put(workspace, requestsByConnection);
        }
        if ((requests = requestsByConnection.get(descriptor = new ConfigurationDescriptor((IConnection)workspace, component))) == null) {
            requests = new ArrayList<ShareRequest>();
            requestsByConnection.put(descriptor, requests);
        }
        requests.add(new ShareRequest(workspace, changeSet, component, parentFolder, newFolderUnderParent, projects, overwrite));
    }

    protected void execute(IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        monitor.setTaskName(Messages.ShareProjectsOperation_4);
        if (this.shareRequests.isEmpty()) {
            throw new IllegalStateException();
        }
        final HashSet<ConfigurationDescriptor> configurations = new HashSet<ConfigurationDescriptor>();
        ArrayList<IContextHandle> contexts = new ArrayList<IContextHandle>();
        this.getAffectedConfigurations(configurations, contexts);
        FlowNodeLock workspaceLock = WorkspaceLockUtil.acquireWrite(configurations, contexts, (Collection)Collections.EMPTY_LIST);
        try {
            try {
                final TeamRepositoryException[] repositoryException = new TeamRepositoryException[1];
                ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                    /*
                     * WARNING - void declaration
                     */
                    public void run(IProgressMonitor monitor) throws CoreException {
                        SubMonitor reporter = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                        SubMonitor subProgress = reporter.newChild(5);
                        subProgress.setWorkRemaining(ShareProjectsOperation.this.shareRequests.size() * 100);
                        try {
                            for (Map.Entry entryByConnection : ShareProjectsOperation.this.shareRequests.entrySet()) {
                                List sharesForNewComponents = (List)((HashMap)entryByConnection.getValue()).remove(null);
                                if (sharesForNewComponents == null) continue;
                                SubMonitor subMonitor = subProgress.newChild(90);
                                subMonitor.setWorkRemaining(sharesForNewComponents.size());
                                ArrayList componentOps = new ArrayList(sharesForNewComponents.size());
                                IWorkspaceConnection workspace = (IWorkspaceConnection)entryByConnection.getKey();
                                IWorkspaceManager manager = SCMPlatform.getWorkspaceManager((ITeamRepository)workspace.teamRepository());
                                for (ShareRequest request : sharesForNewComponents) {
                                    IContributorHandle owner = RepositoryUtils.getLoggedInContributor((ITeamRepository)workspace.teamRepository());
                                    request.component = (IComponentHandle)manager.createComponent(request.componentName, (IAuditableHandle)owner, (IProgressMonitor)subMonitor.newChild(1));
                                    componentOps.add(workspace.componentOpFactory().addComponent(request.component, false));
                                }
                                workspace.applyComponentOperations(componentOps, (IProgressMonitor)subProgress.newChild(10));
                                for (ShareRequest request : sharesForNewComponents) {
                                    ArrayList<ShareRequest> requests = new ArrayList<ShareRequest>(1);
                                    requests.add(request);
                                    ConfigurationDescriptor configuration = new ConfigurationDescriptor((IConnection)workspace, request.component);
                                    ((HashMap)entryByConnection.getValue()).put(configuration, requests);
                                    configurations.add(configuration);
                                }
                            }
                            ISchedulingRule cfaLock = CopyFileAreaLockUtil.getWorkspaceComponentLock((CopyFileAreaStore)CopyFileAreaStore.getDefaultCopyFileArea(), (Collection)configurations, (IProgressMonitor)reporter.newChild(1));
                            try {
                                void var7_14;
                                HashMap organizedShares = ShareProjectsOperation.this.organizeShares();
                                ShareProjectsOperation.this.reshares = new HashMap();
                                ShareProjectsOperation.this.shares = new HashMap();
                                HashMap<String, ShareOverlap> overlaps = new HashMap<String, ShareOverlap>();
                                subProgress = reporter.newChild(5);
                                subProgress.setWorkRemaining(ShareProjectsOperation.this.shareRequests.size() * 10);
                                for (Map.Entry entry : ShareProjectsOperation.this.shareRequests.entrySet()) {
                                    IWorkspaceConnection connection = (IWorkspaceConnection)entry.getKey();
                                    ArrayList<OverlapRequest> overlapRequests = new ArrayList<OverlapRequest>(((HashMap)entry.getValue()).size());
                                    SubMonitor subSubProgress = subProgress.newChild(9);
                                    subSubProgress.setWorkRemaining(((HashMap)entry.getValue()).size());
                                    for (Map.Entry entry2 : ((HashMap)entry.getValue()).entrySet()) {
                                        ConfigurationDescriptor descriptor = (ConfigurationDescriptor)entry2.getKey();
                                        List requests = (List)entry2.getValue();
                                        ShareProjectsOperation.this.determineReshares((IConnection)connection, descriptor.componentHandle, requests, (IProgressMonitor)subSubProgress.newChild(1));
                                        overlapRequests.add(ShareProjectsOperation.this.buildOverlapRequest((IConnection)connection, descriptor, organizedShares, overlaps));
                                    }
                                    subSubProgress.done();
                                    FileSystemManager fileSystemManager = (FileSystemManager)FileSystemCore.getFileSystemManager((ITeamRepository)connection.teamRepository());
                                    FileSystemServiceProxy fss = fileSystemManager.getFileSystemService();
                                    List overlapResults = fss.detectOverlap(overlapRequests, null, (IProgressMonitor)subProgress.newChild(1));
                                    ShareProjectsOperation.this.recordOverlaps(connection, organizedShares, overlapResults, overlaps);
                                }
                                subProgress.done();
                                if (!overlaps.isEmpty()) {
                                    int n = ShareProjectsOperation.this.problemHandler.overlappingShareRequests(overlaps.values());
                                    if (n == 1) {
                                        throw new OperationCanceledException();
                                    }
                                    if (n != 0) {
                                        throw new FileSystemClientException((IStatus)new FileSystemStatus(4, Messages.ShareProjectsOperation_0));
                                    }
                                    this.updateSharesToDo(overlaps);
                                }
                                subProgress = reporter.newChild(88);
                                boolean bl = false;
                                for (List ls : ShareProjectsOperation.this.shares.values()) {
                                    for (ShareProjects s : ls) {
                                        var7_13 += s.getProjectCount();
                                    }
                                }
                                for (List s : ShareProjectsOperation.this.reshares.values()) {
                                    var7_14 += s.size();
                                }
                                subProgress.setWorkRemaining((int)var7_14);
                                HashMap<ConfigurationDescriptor, Map<UUID, Map<String, IFolder>>> newFolders = new HashMap<ConfigurationDescriptor, Map<UUID, Map<String, IFolder>>>();
                                for (Map.Entry sharesEntry : ShareProjectsOperation.this.shares.entrySet()) {
                                    List pendingShareProjects = (List)sharesEntry.getValue();
                                    ConfigurationDescriptor configurationDescriptor = (ConfigurationDescriptor)sharesEntry.getKey();
                                    for (ShareProjects shareProjects : pendingShareProjects) {
                                        Map<String, IFolder> foldersCreated = this.getNewFoldersCreatedUnderParent(configurationDescriptor, shareProjects, newFolders);
                                        Collection<IChangeSetHandle> csCommitted = shareProjects.share(foldersCreated, (IProgressMonitor)subProgress.newChild(shareProjects.getProjectCount()));
                                        for (IChangeSetHandle changeSet : csCommitted) {
                                            ShareProjectsOperation.this.changeSetsCommitted.put(changeSet.getItemId(), changeSet);
                                        }
                                    }
                                }
                                for (List pendingReshareProjects : ShareProjectsOperation.this.reshares.values()) {
                                    for (ReshareProject reshareProject : pendingReshareProjects) {
                                        reshareProject.reShare((IProgressMonitor)subProgress.newChild(1));
                                    }
                                }
                                subProgress.done();
                            }
                            finally {
                                CopyFileAreaStore.getDefaultCopyFileArea().release(cfaLock, (IProgressMonitor)reporter.newChild(1));
                            }
                        }
                        catch (TeamRepositoryException e) {
                            repositoryException[0] = e;
                        }
                    }

                    private Map<String, IFolder> getNewFoldersCreatedUnderParent(ConfigurationDescriptor descriptor, ShareProjects shareProjects, Map<ConfigurationDescriptor, Map<UUID, Map<String, IFolder>>> newFolders) {
                        Map<String, IFolder> foldersCreated;
                        if (shareProjects.newFolderUnderParent.length > 0) {
                            Map<UUID, Map<String, IFolder>> newFoldersUnderParents = newFolders.get(descriptor);
                            if (newFoldersUnderParents == null) {
                                newFoldersUnderParents = new HashMap<UUID, Map<String, IFolder>>();
                                newFolders.put(descriptor, newFoldersUnderParents);
                            }
                            if ((foldersCreated = newFoldersUnderParents.get(shareProjects.parentFolder.getItemId())) == null) {
                                foldersCreated = new HashMap<String, IFolder>();
                                newFoldersUnderParents.put(shareProjects.parentFolder.getItemId(), foldersCreated);
                            }
                        } else {
                            foldersCreated = Collections.EMPTY_MAP;
                        }
                        return foldersCreated;
                    }

                    private void updateSharesToDo(HashMap<String, ShareOverlap> overlaps) {
                        for (ShareOverlap shareOverlap : overlaps.values()) {
                            List pendingShares;
                            ConfigurationDescriptor descriptor = new ConfigurationDescriptor(shareOverlap.getConnection(), shareOverlap.getComponent());
                            IProject project = shareOverlap.getProject();
                            List pendingReshares = (List)ShareProjectsOperation.this.reshares.get(descriptor);
                            if (pendingReshares != null) {
                                Iterator i = pendingReshares.iterator();
                                while (i.hasNext()) {
                                    ReshareProject reshareProject = (ReshareProject)i.next();
                                    if (!reshareProject.localProject.equals((Object)project)) continue;
                                    i.remove();
                                }
                            }
                            if ((pendingShares = (List)ShareProjectsOperation.this.shares.get(descriptor)) == null) continue;
                            for (ShareProjects shareProjects : pendingShares) {
                                shareProjects.removeProject(project);
                            }
                        }
                    }
                }, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 1, monitor);
                if (repositoryException[0] != null) {
                    throw repositoryException[0];
                }
            }
            catch (CoreException e) {
                this.collectStatus(FileSystemStatus.getStatusFor((Throwable)e));
                WorkspaceLockUtil.release((FlowNodeLock)workspaceLock);
            }
        }
        finally {
            WorkspaceLockUtil.release((FlowNodeLock)workspaceLock);
        }
    }

    public OverlapRequest buildOverlapRequest(IConnection connection, ConfigurationDescriptor descriptor, HashMap<ConfigurationDescriptor, HashMap<UUID, IShare>> organizedShares, HashMap<String, ShareOverlap> overlaps) {
        List<ReshareProject> pendingReshareProject;
        OverlapRequest overlapRequest = FilesystemDTOFactory.eINSTANCE.createOverlapRequest();
        overlapRequest.setContext(descriptor.connectionHandle);
        overlapRequest.setComponent(descriptor.componentHandle);
        List toVerfiyForOverlap = overlapRequest.getGroup();
        HashMap<UUID, IShare> existingShares = organizedShares.get(descriptor);
        List<ShareProjects> pendingShareProjects = this.shares.get(descriptor);
        if (pendingShareProjects != null) {
            for (ShareProjects shareProjects : pendingShareProjects) {
                ISharingDescriptor sharingDescriptor;
                IShare share;
                toVerfiyForOverlap.add(shareProjects.parentFolder);
                if (existingShares == null || (share = existingShares.get(shareProjects.parentFolder.getItemId())) == null || !(sharingDescriptor = share.getSharingDescriptor()).isAssociatedWithConnection(connection) || !sharingDescriptor.getComponent().sameItemId((IItemHandle)descriptor.componentHandle)) continue;
                for (IProject project : shareProjects.getProjects()) {
                    ShareOverlap overlap = overlaps.get(project.getName());
                    if (overlap == null) {
                        overlap = new ShareOverlap(connection, descriptor.componentHandle, project);
                        overlaps.put(project.getName(), overlap);
                    }
                    overlap.addShareOverlap(share);
                }
            }
        }
        if ((pendingReshareProject = this.reshares.get(descriptor)) != null) {
            for (ReshareProject reshareProject : pendingReshareProject) {
                toVerfiyForOverlap.add(reshareProject.remoteProject);
            }
        }
        if (existingShares != null) {
            for (IShare share : existingShares.values()) {
                toVerfiyForOverlap.add(share.getSharingDescriptor().getRootFolder());
            }
        }
        return overlapRequest;
    }

    public void recordOverlaps(IWorkspaceConnection connection, HashMap<ConfigurationDescriptor, HashMap<UUID, IShare>> organizedShares, List<OverlapResponse> overlapResults, HashMap<String, ShareOverlap> overlaps) {
        for (OverlapResponse response : overlapResults) {
            ConfigurationDescriptor descriptor = new ConfigurationDescriptor((IConnection)connection, response.getComponent());
            HashMap<UUID, IShare> existingShares = organizedShares.get(descriptor);
            for (OverlapDescription overlapDescription : response.getOverlapDescriptions()) {
                IShare share;
                ShareOverlap overlap2;
                Collection<ShareProjects> sharesForParent;
                ShareOverlap overlap22;
                IProject p;
                IProject project = this.getResharedProject(descriptor, overlapDescription.getElement());
                if (project != null) {
                    ShareOverlap overlap = overlaps.get(project.getName());
                    if (overlap == null) {
                        overlap = new ShareOverlap((IConnection)connection, response.getComponent(), project);
                        overlaps.put(project.getName(), overlap);
                    }
                    for (IVersionableHandle versionableOverlapped : overlapDescription.getOverlappedChildren()) {
                        p = this.getResharedProject(descriptor, versionableOverlapped);
                        if (p != null) {
                            overlap.addProjectOverlap(p);
                            overlap22 = overlaps.get(p.getName());
                            if (overlap22 == null) {
                                overlap22 = new ShareOverlap((IConnection)connection, response.getComponent(), p);
                                overlaps.put(p.getName(), overlap22);
                            }
                            overlap22.addProjectOverlap(project);
                        }
                        sharesForParent = this.getSharesForParent(descriptor, versionableOverlapped);
                        for (ShareProjects shareProjects : sharesForParent) {
                            for (IProject p2 : shareProjects.getProjects()) {
                                overlap.addProjectOverlap(p2);
                                overlap2 = overlaps.get(p2.getName());
                                if (overlap2 == null) {
                                    overlap2 = new ShareOverlap((IConnection)connection, response.getComponent(), p2);
                                    overlaps.put(p2.getName(), overlap2);
                                }
                                overlap2.addProjectOverlap(project);
                            }
                        }
                        IShare share2 = existingShares.get(versionableOverlapped);
                        if (share2 == null) continue;
                        overlap.addShareOverlap(share2);
                    }
                    continue;
                }
                if (existingShares == null || (share = existingShares.get(overlapDescription.getElement().getItemId())) == null) continue;
                for (IVersionableHandle versionableOverlapped : overlapDescription.getOverlappedChildren()) {
                    p = this.getResharedProject(descriptor, versionableOverlapped);
                    if (p != null) {
                        overlap22 = overlaps.get(p.getName());
                        if (overlap22 == null) {
                            overlap22 = new ShareOverlap((IConnection)connection, response.getComponent(), p);
                            overlaps.put(p.getName(), overlap22);
                        }
                        overlap22.addShareOverlap(share);
                    }
                    sharesForParent = this.getSharesForParent(descriptor, versionableOverlapped);
                    for (ShareProjects shareProjects : sharesForParent) {
                        for (IProject p2 : shareProjects.getProjects()) {
                            overlap2 = overlaps.get(p2.getName());
                            if (overlap2 == null) {
                                overlap2 = new ShareOverlap((IConnection)connection, response.getComponent(), p2);
                                overlaps.put(p2.getName(), overlap2);
                            }
                            overlap2.addShareOverlap(share);
                        }
                    }
                }
            }
        }
    }

    private Collection<ShareProjects> getSharesForParent(ConfigurationDescriptor descriptor, IVersionableHandle versionableOverlapped) {
        ArrayList<ShareProjects> result = new ArrayList<ShareProjects>();
        List<ShareProjects> currentShares = this.shares.get(descriptor);
        if (currentShares != null) {
            for (ShareProjects shareProjects : currentShares) {
                if (!shareProjects.parentFolder.sameItemId((IItemHandle)versionableOverlapped)) continue;
                result.add(shareProjects);
            }
        }
        return result;
    }

    private IProject getResharedProject(ConfigurationDescriptor descriptor, IVersionableHandle versionable) {
        List<ReshareProject> currentReshares = this.reshares.get(descriptor);
        if (currentReshares != null) {
            for (ReshareProject reshareProject : currentReshares) {
                if (!reshareProject.remoteProject.sameItemId((IItemHandle)versionable)) continue;
                return reshareProject.localProject;
            }
        }
        return null;
    }

    private void determineReshares(IConnection connection, IComponentHandle component, List<ShareRequest> requests, IProgressMonitor progress) throws TeamRepositoryException, FileSystemClientException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        IComponent fullComponent = (IComponent)connection.teamRepository().itemManager().fetchCompleteItem((IItemHandle)component, 0, (IProgressMonitor)monitor.newChild(2));
        ArrayList<IFolderHandle> foldersToRetrieve = new ArrayList<IFolderHandle>(requests.size());
        for (ShareRequest request : requests) {
            IFolderHandle parentFolderForShare = request.parentFolder;
            if (parentFolderForShare == null) {
                parentFolderForShare = fullComponent.getRootFolder();
            }
            foldersToRetrieve.add(parentFolderForShare);
        }
        IConfiguration configuration = connection instanceof IWorkspaceConnection ? ((IWorkspaceConnection)connection).configuration(component) : ((IBaselineConnection)connection).configuration();
        ConfigurationDescriptor descriptor = new ConfigurationDescriptor(connection, component);
        List folderChildren = configuration.childEntries(foldersToRetrieve, (IProgressMonitor)monitor);
        int i = 0;
        while (i < requests.size()) {
            Map children = (Map)folderChildren.get(i);
            if (children == null) {
                throw new FileSystemClientException((IStatus)new FileSystemStatus(4, Messages.ShareProjectsOperation_1));
            }
            ShareRequest request = requests.get(i);
            IFolderHandle parentFolderForShare = request.parentFolder;
            if (parentFolderForShare == null) {
                parentFolderForShare = fullComponent.getRootFolder();
            }
            if (request.newFolderUnderParent.length > 0 && children.get(request.newFolderUnderParent[0]) != null) {
                throw new FileSystemClientException((IStatus)new FileSystemStatus(4, NLS.bind((String)Messages.ShareProjectsOperation_2, (Object[])new Object[]{PathUtils.getString((String[])request.newFolderUnderParent)})));
            }
            ShareProjects shareProjects = new ShareProjects(request.workspace, request.changeSet, fullComponent, parentFolderForShare, request.newFolderUnderParent, request.overwrite, this.problemHandler);
            for (IProject project : request.projects) {
                if (request.newFolderUnderParent.length > 0) {
                    shareProjects.addProject(project);
                    continue;
                }
                IVersionableHandle child = (IVersionableHandle)children.get(project.getName());
                if (child == null) {
                    shareProjects.addProject(project);
                    continue;
                }
                if (child instanceof IFolderHandle) {
                    List<ReshareProject> currentReshares = this.reshares.get(descriptor);
                    if (currentReshares == null) {
                        currentReshares = new ArrayList<ReshareProject>();
                        this.reshares.put(descriptor, currentReshares);
                    }
                    currentReshares.add(new ReshareProject(connection, fullComponent, (IFolderHandle)child, project, request.overwrite));
                    continue;
                }
                throw new FileSystemClientException((IStatus)new FileSystemStatus(4, NLS.bind((String)Messages.ShareProjectsOperation_3, (Object[])new Object[]{project.getName()})));
            }
            if (shareProjects.getProjectCount() != 0) {
                List<ShareProjects> currentShares = this.shares.get(descriptor);
                if (currentShares == null) {
                    currentShares = new ArrayList<ShareProjects>();
                    this.shares.put(descriptor, currentShares);
                }
                currentShares.add(shareProjects);
            }
            ++i;
        }
    }

    private Set<ConfigurationDescriptor> getAffectedConfigurations(Set<ConfigurationDescriptor> configurations, Collection<IContextHandle> contexts) {
        for (Map.Entry<IWorkspaceConnection, HashMap<ConfigurationDescriptor, List<ShareRequest>>> sharesByConnection : this.shareRequests.entrySet()) {
            IWorkspaceConnection workspace = sharesByConnection.getKey();
            HashMap<ConfigurationDescriptor, List<ShareRequest>> shares = sharesByConnection.getValue();
            for (Map.Entry<ConfigurationDescriptor, List<ShareRequest>> requestsByConfiguration : shares.entrySet()) {
                List<ShareRequest> requests = requestsByConfiguration.getValue();
                for (ShareRequest request : requests) {
                    configurations.addAll(request.getConfigurationAffected());
                }
                if (requestsByConfiguration.getKey() != null) continue;
                contexts.add(workspace.getContextHandle());
            }
        }
        return configurations;
    }

    private HashMap<ConfigurationDescriptor, HashMap<UUID, IShare>> organizeShares() throws FileSystemClientException {
        HashMap<ConfigurationDescriptor, HashMap<UUID, IShare>> result = new HashMap<ConfigurationDescriptor, HashMap<UUID, IShare>>();
        IShare[] iShareArray = SharingManager.getInstance().allShares();
        int n = iShareArray.length;
        int n2 = 0;
        while (n2 < n) {
            IShare share = iShareArray[n2];
            if (share.getSharingDescriptor() != null) {
                ISharingDescriptor shareDesc = share.getSharingDescriptor();
                ConfigurationDescriptor descriptor = new ConfigurationDescriptor(shareDesc.getRepositoryId(), shareDesc.getRepositoryUri(), shareDesc.getConnectionHandle(), shareDesc.getComponent());
                HashMap<Object, Object> shares = result.get(descriptor);
                if (shares == null) {
                    shares = new HashMap();
                    result.put(descriptor, shares);
                }
                shares.put(shareDesc.getRootFolder().getItemId(), share);
            }
            ++n2;
        }
        return result;
    }

    @Override
    public Collection<IChangeSetHandle> getCommittedChangeSets() {
        return this.changeSetsCommitted.values();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ShareRequest {
        private final IWorkspaceConnection workspace;
        private final IChangeSetHandle changeSet;
        private IComponentHandle component;
        private String componentName;
        private IFolderHandle parentFolder;
        private String[] newFolderUnderParent;
        private final boolean overwrite;
        private final List<IProject> projects;

        ShareRequest(IWorkspaceConnection workspace, IChangeSetHandle changeSet, IComponentHandle component, IFolderHandle parentFolder, String[] newFolderUnderParent, List<IProject> projects, boolean overwrite) {
            this.workspace = workspace;
            this.changeSet = changeSet;
            this.component = component;
            this.parentFolder = parentFolder;
            this.newFolderUnderParent = newFolderUnderParent;
            this.projects = projects;
            this.overwrite = overwrite;
        }

        public ShareRequest(IWorkspaceConnection workspace, String componentName, String[] newFolderUnderRoot, List<IProject> projects, boolean overwrite) {
            this.workspace = workspace;
            this.changeSet = null;
            this.componentName = componentName;
            this.parentFolder = null;
            this.newFolderUnderParent = newFolderUnderRoot;
            this.projects = projects;
            this.overwrite = overwrite;
        }

        Collection<ConfigurationDescriptor> getConfigurationAffected() {
            if (!this.overwrite) {
                if (this.component == null) {
                    return Collections.EMPTY_LIST;
                }
                ConfigurationDescriptor configuration = new ConfigurationDescriptor((IConnection)this.workspace, this.component);
                return Collections.singletonList(configuration);
            }
            ArrayList<ConfigurationDescriptor> configurations = new ArrayList<ConfigurationDescriptor>(2);
            if (this.component != null) {
                ConfigurationDescriptor configuration = new ConfigurationDescriptor((IConnection)this.workspace, this.component);
                configurations.add(configuration);
            }
            for (IProject project : this.projects) {
                IShareable shareable = (IShareable)project.getAdapter(IShareable.class);
                IShare share = shareable.getShare();
                if (share == null) continue;
                ISharingDescriptor descriptor = share.getSharingDescriptor();
                configurations.add(new ConfigurationDescriptor(descriptor.getRepositoryId(), descriptor.getRepositoryUri(), descriptor.getConnectionHandle(), descriptor.getComponent()));
            }
            return configurations;
        }

        String getComponentName() {
            return this.componentName;
        }
    }
}

