/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.operations.merge;

import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.operations.merge.EmptyStorage;
import com.ibm.team.filesystem.rcp.core.internal.operations.merge.FileContentStorage;
import com.ibm.team.filesystem.rcp.core.internal.resources.ContentProperties;
import com.ibm.team.filesystem.rcp.core.internal.resources.ResourceUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.LineDelimiter;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.utils.IInputStreamProvider;
import com.ibm.team.repository.common.utils.TemporaryOutputStream;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.Team;
import org.eclipse.team.core.mapping.IStorageMerger;

public class FileContentMerger {
    public static final int NO_HANDLER_AVAILABLE = 1001;
    public static final int CONTENT_TYPE_UNKNOWN = 1002;

    public static IStatus performAutoMerge(ITeamRepository repository, IFileItem commonAncestorItem, IFileItem proposedItem, IFile file, String contentTypeForMerge, SubMonitor progress) throws CoreException, IOException, TeamRepositoryException {
        IStorageMerger storageMerger = FileContentMerger.getStorageMerger(file, contentTypeForMerge);
        if (storageMerger == null) {
            ContentProperties properties = ResourceUtil.getContentProperties(file);
            IContentType contentType = properties.contentType;
            if (contentType == null && properties.isDefaultBinary) {
                return new FileSystemStatus(4, 1002, NLS.bind((String)Messages.FileContentMerger_0, (Object)file.getFullPath()));
            }
            return new FileSystemStatus(4, 1001, NLS.bind((String)Messages.FileContentMerger_1, (Object)file.getFullPath()));
        }
        return FileContentMerger.performAutoMerge(repository, commonAncestorItem, proposedItem, file, storageMerger, progress);
    }

    public static IStorageMerger getStorageMerger(IFile file, String contentTypeForMerge) throws CoreException {
        return FileContentMerger.getStorageMerger(file, contentTypeForMerge, false);
    }

    public static IStorageMerger getStorageMerger(IFile file, String contentTypeForMerge, boolean fallbackToText) throws CoreException {
        IStorageMerger storageMerger;
        IStorageMerger storageMerger2;
        ContentProperties properties = ResourceUtil.getContentPropertiesNotNull(file);
        IContentType contentType = contentTypeForMerge != null ? Platform.getContentTypeManager().getContentType(contentTypeForMerge) : properties.contentType;
        if (contentType != null && (storageMerger2 = new Team().createStorageMerger(contentType)) != null) {
            return storageMerger2;
        }
        String type = file.getFileExtension();
        if (type != null && (storageMerger = new Team().createStorageMerger(type)) != null) {
            return storageMerger;
        }
        if ((properties.isText || fallbackToText) && (storageMerger = new Team().createStorageMerger(contentType = Platform.getContentTypeManager().getContentType("org.eclipse.core.runtime.text"))) != null) {
            return storageMerger;
        }
        return null;
    }

    private static IStatus performAutoMerge(ITeamRepository repository, IFileItem commonAncestorItem, IFileItem proposedItem, IFile file, IStorageMerger storageMerger, SubMonitor progress) throws CoreException, IOException {
        OutputStream outputStream = FileContentMerger.getTempOutputStream(file, proposedItem.getContent().getRawLength());
        try {
            IStatus mergeResult;
            try {
                mergeResult = FileContentMerger.performAutoMerge(repository, outputStream, storageMerger, file, commonAncestorItem, proposedItem, progress);
            }
            finally {
                outputStream.close();
            }
            if (mergeResult.getSeverity() == 0) {
                InputStream newContents = FileContentMerger.getTempInputStream(outputStream, file, (IProgressMonitor)progress.newChild(1));
                try {
                    file.setContents(newContents, 2, (IProgressMonitor)progress.newChild(5));
                }
                catch (Throwable throwable) {
                    try {
                        newContents.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    newContents.close();
                }
                catch (IOException iOException) {}
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            IStatus iStatus = mergeResult;
            return iStatus;
        }
        finally {
            FileContentMerger.cleanUpTempStreams(outputStream, file);
        }
    }

    private static OutputStream getTempOutputStream(IFile file, long estimatedSize) {
        try {
            return TemporaryOutputStream.getEstimatedSizeTemporaryOutputStream((long)estimatedSize);
        }
        catch (IOException e) {
            StatusUtil.log((Object)"com.ibm.team.filesystem.rcp.core", (Throwable)e);
            return new ByteArrayOutputStream();
        }
    }

    private static InputStream getTempInputStream(OutputStream out, IFile file, IProgressMonitor monitor) throws IOException {
        if (out instanceof ByteArrayOutputStream) {
            ByteArrayOutputStream baos = (ByteArrayOutputStream)out;
            baos.close();
            return new ByteArrayInputStream(baos.toByteArray());
        }
        if (out instanceof IInputStreamProvider) {
            IInputStreamProvider isp = (IInputStreamProvider)out;
            return isp.getInputStream(monitor);
        }
        throw new IllegalStateException();
    }

    private static void cleanUpTempStreams(OutputStream outputStream, IFile file) {
        if (outputStream instanceof TemporaryOutputStream) {
            TemporaryOutputStream tos = (TemporaryOutputStream)outputStream;
            try {
                tos.dispose();
            }
            catch (IOException e) {
                StatusUtil.log((Object)"com.ibm.team.filesystem.rcp.core", (Throwable)e);
            }
        }
    }

    private static IStatus performAutoMerge(ITeamRepository repo, OutputStream outputStream, IStorageMerger storageMerger, IFile file, IFileItem commonAncestorItem, IFileItem proposedItem, SubMonitor progress) throws CoreException {
        progress.setWorkRemaining(100);
        IContent proposedContent = proposedItem.getContent();
        LineDelimiter lineDelimeter = proposedContent.getLineDelimiter();
        IShareable shareableFile = (IShareable)file.getAdapter(IShareable.class);
        if (shareableFile != null) {
            lineDelimeter = shareableFile.getLineDelimiter();
        }
        IPath path = file.getFullPath();
        PlatformObject ancestorStorage = commonAncestorItem != null ? new FileContentStorage(repo, commonAncestorItem.getContent(), path, (IProgressMonitor)progress.newChild(1)) : new EmptyStorage(path);
        FileContentStorage otherStorage = new FileContentStorage(repo, proposedContent, path, lineDelimeter, (IProgressMonitor)progress.newChild(1));
        return FileContentMerger.performMerge(storageMerger, outputStream, file.getCharset(), (IStorage)ancestorStorage, (IEncodedStorage)file, otherStorage, progress);
    }

    public static IStatus performMerge(IStorageMerger storageMerger, OutputStream outputStream, String charset, IStorage ancestorStorage, IEncodedStorage file, IEncodedStorage otherStorage, SubMonitor progress) throws CoreException {
        return storageMerger.merge(outputStream, charset, ancestorStorage, (IStorage)file, (IStorage)otherStorage, (IProgressMonitor)progress);
    }
}

