/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.operations;

import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.changemodel.IPathResolver;
import com.ibm.team.filesystem.common.changemodel.VersionablePath;
import com.ibm.team.filesystem.rcp.core.internal.CoreShareablesUtil;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.CopyFileAreaPathResolver;
import com.ibm.team.filesystem.rcp.core.internal.operations.FilesystemUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadFileRequest {
    private VersionablePath path;
    private IFileItem file;
    private ITeamRepository repo;

    private LoadFileRequest(VersionablePath path, IFileItem file, ITeamRepository repo) {
        this.path = path;
        this.file = file;
        this.repo = repo;
    }

    public static LoadFileRequest create(VersionablePath path, IFileItem file, ITeamRepository repo) {
        return new LoadFileRequest(path, file, repo);
    }

    public static LoadFileRequest create(IPath path, IFileItem file, ITeamRepository repo) {
        return LoadFileRequest.create(VersionablePath.create((IPath)path.makeAbsolute()), file, repo);
    }

    public static LoadFileRequest create(IFileItem file, ItemId<IComponent> component, ITeamRepository repo) {
        return LoadFileRequest.create(VersionablePath.getUnresolvedPath((IVersionable)file, component), file, repo);
    }

    public VersionablePath getPath() {
        return this.path;
    }

    public IFileItem getFile() {
        return this.file;
    }

    public ITeamRepository getRepo() {
        return this.repo;
    }

    public static IStatus loadFile(LoadFileRequest toLoad, IProgressMonitor monitor) throws TeamRepositoryException {
        IStatus result = LoadFileRequest.load((Collection<LoadFileRequest>)Collections.singleton(toLoad), monitor).get(toLoad);
        if (result == null) {
            result = Status.OK_STATUS;
        }
        return result;
    }

    public static Map<LoadFileRequest, IStatus> load(Collection<LoadFileRequest> requestedFiles, IProgressMonitor monitor) throws TeamRepositoryException, OperationCanceledException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        CopyFileAreaPathResolver pathResolver = CopyFileAreaPathResolver.create();
        Map<VersionablePath, VersionablePath> resolvedPaths = FilesystemUtil.resolvePaths(pathResolver, LoadFileRequest.getPaths(requestedFiles), (IProgressMonitor)progress.newChild(20));
        HashMap<LoadFileRequest, IStatus> failures = new HashMap<LoadFileRequest, IStatus>();
        SubMonitor loopProgress = progress.newChild(70).setWorkRemaining(requestedFiles.size());
        for (LoadFileRequest next : requestedFiles) {
            IStatus status;
            SubMonitor iterationProgress = loopProgress.newChild(1).setWorkRemaining(100);
            IFileItem file = next.getFile();
            VersionablePath path = next.getPath();
            if (resolvedPaths.containsKey(path)) {
                path = resolvedPaths.get(path);
            }
            if (file == null) {
                failures.put(next, StatusUtil.newStatus(LoadFileRequest.class, (String)Messages.LoadFileUtil_0));
                continue;
            }
            try {
                IResource resource;
                if (!path.isAbsolute()) {
                    failures.put(next, StatusUtil.newStatus(LoadFileRequest.class, (int)2, (String)Messages.LoadFileUtil_1));
                }
                if ((resource = CoreShareablesUtil.getResourceFor(path, (IProgressMonitor)iterationProgress.newChild(20))) == null) {
                    failures.put(next, StatusUtil.newStatus(LoadFileRequest.class, (String)NLS.bind((String)Messages.LoadFileUtil_2, (Object)path.toString())));
                    continue;
                }
                if (!(resource instanceof IFile)) {
                    failures.put(next, StatusUtil.newStatus(LoadFileRequest.class, (String)NLS.bind((String)Messages.LoadFileUtil_3, (Object)path.toString())));
                    continue;
                }
                FilesystemUtil.createFile(resource.getFullPath(), next.getRepo(), path.getSiloedItemId().getComponentHandle(), file, (IProgressMonitor)iterationProgress.newChild(80));
            }
            catch (TeamRepositoryException e) {
                status = StatusUtil.newStatus(LoadFileRequest.class, (Throwable)e);
                StatusUtil.log((IStatus)status);
                failures.put(next, status);
            }
            catch (CoreException e) {
                status = StatusUtil.newStatus(LoadFileRequest.class, (Throwable)e);
                StatusUtil.log((IStatus)status);
                failures.put(next, status);
            }
        }
        return failures;
    }

    private static Collection<VersionablePath> getPaths(Collection<LoadFileRequest> requestedFiles) {
        ArrayList<VersionablePath> result = new ArrayList<VersionablePath>();
        for (LoadFileRequest next : requestedFiles) {
            result.add(next.getPath());
        }
        return result;
    }

    public static List<LoadFileRequest> resolvePaths(Collection<LoadFileRequest> requestedFiles, IPathResolver pathResolver, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Map<VersionablePath, VersionablePath> resolvedPaths = FilesystemUtil.resolvePaths(pathResolver, LoadFileRequest.getPaths(requestedFiles), (IProgressMonitor)progress.newChild(20));
        ArrayList<LoadFileRequest> result = new ArrayList<LoadFileRequest>();
        for (LoadFileRequest next : requestedFiles) {
            VersionablePath resolved = resolvedPaths.get(next.getPath());
            result.add(new LoadFileRequest(resolved, next.getFile(), next.getRepo()));
        }
        return result;
    }
}

