/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.DilemmaHandler;
import com.ibm.team.filesystem.client.operations.ICollision;
import com.ibm.team.filesystem.client.operations.IRemovedShare;
import com.ibm.team.filesystem.client.operations.IShareOutOfSync;
import com.ibm.team.filesystem.client.operations.IShareableToLoad;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.operations.ChangeSetChooser;
import com.ibm.team.filesystem.rcp.core.operations.EclipseWorkspaceUpdateOperation;
import com.ibm.team.filesystem.rcp.core.operations.EclipseWorkspaceVerifySharesOperation;
import com.ibm.team.filesystem.rcp.core.operations.IRestoreOperation;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IVersionableManager;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseWorkspaceRestoreOperation
extends FileSystemOperation
implements IRestoreOperation {
    private final UpdateDilemmaHandler updateDilemmaHandler;
    private final HashMap<IWorkspaceConnection, HashSet<RestoreRequest>> restoreRequests;
    private final HashMap<IWorkspaceConnection, List<IVersionableHandle>> statesToRestore;

    public EclipseWorkspaceRestoreOperation(UpdateDilemmaHandler dilemmaHandler) {
        super((DilemmaHandler)(dilemmaHandler == null ? UpdateDilemmaHandler.getDefault() : dilemmaHandler));
        this.updateDilemmaHandler = dilemmaHandler == null ? UpdateDilemmaHandler.getDefault() : dilemmaHandler;
        this.restoreRequests = new HashMap();
        this.statesToRestore = new HashMap();
    }

    @Override
    public void addToRestore(IWorkspaceConnection workspace, IComponentHandle component, IChangeSetHandle defaultChangeSet, String newChangeSetComment, IVersionableHandle itemStateToRestore) {
        if (workspace == null) {
            throw new IllegalArgumentException();
        }
        if (component == null) {
            throw new IllegalArgumentException();
        }
        if (defaultChangeSet == null && newChangeSetComment == null) {
            throw new IllegalArgumentException();
        }
        if (itemStateToRestore == null) {
            throw new IllegalArgumentException();
        }
        if (!itemStateToRestore.hasStateId()) {
            throw new IllegalArgumentException();
        }
        RestoreRequest request = new RestoreRequest(workspace, component, defaultChangeSet, newChangeSetComment, itemStateToRestore);
        this.recordRequest(workspace, itemStateToRestore, request);
    }

    @Override
    public void addToRestore(IWorkspaceConnection workspace, IComponentHandle component, IChangeSetHandle defaultChangeSet, String newChangeSetComment, IFolderHandle parent, String name, IVersionableHandle itemStateToRestore) {
        if (workspace == null) {
            throw new IllegalArgumentException();
        }
        if (component == null) {
            throw new IllegalArgumentException();
        }
        if (defaultChangeSet == null && newChangeSetComment == null) {
            throw new IllegalArgumentException();
        }
        if (parent == null) {
            throw new IllegalArgumentException();
        }
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (itemStateToRestore == null) {
            throw new IllegalArgumentException();
        }
        if (!itemStateToRestore.hasStateId()) {
            throw new IllegalArgumentException();
        }
        RestoreRequest request = new RestoreRequest(workspace, component, defaultChangeSet, newChangeSetComment, parent, name, itemStateToRestore);
        this.recordRequest(workspace, itemStateToRestore, request);
    }

    @Override
    public void addToRestore(IWorkspaceConnection workspace, IComponentHandle component, IChangeSetHandle defaultChangeSet, String newChangeSetComment, IShareable parent, String name, IVersionableHandle itemStateToRestore) {
        if (workspace == null) {
            throw new IllegalArgumentException();
        }
        if (component == null) {
            throw new IllegalArgumentException();
        }
        if (defaultChangeSet == null && newChangeSetComment == null) {
            throw new IllegalArgumentException();
        }
        if (parent == null) {
            throw new IllegalArgumentException();
        }
        IVersionableHandle parentHandle = parent.getRemote();
        if (parentHandle == null) {
            throw new IllegalArgumentException();
        }
        if (!(parentHandle instanceof IFolderHandle)) {
            throw new IllegalArgumentException();
        }
        this.addToRestore(workspace, component, defaultChangeSet, newChangeSetComment, (IFolderHandle)parent.getRemote(), name, itemStateToRestore);
    }

    private void recordRequest(IWorkspaceConnection workspace, IVersionableHandle itemStateToRestore, RestoreRequest request) {
        HashSet<RestoreRequest> requests = this.restoreRequests.get(workspace);
        if (requests == null) {
            requests = new HashSet();
            this.restoreRequests.put(workspace, requests);
        } else if (requests.contains(request)) {
            throw new IllegalArgumentException();
        }
        requests.add(request);
        List<IVersionableHandle> states = this.statesToRestore.get(workspace);
        if (states == null) {
            states = new ArrayList<IVersionableHandle>();
            this.statesToRestore.put(workspace, states);
        }
        states.add(itemStateToRestore);
    }

    protected void execute(IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        ThreadCheck.checkLongOpsAllowed();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.EclipseWorkspaceRestoreOperation_0, (int)150);
        Collection<ConfigurationDescriptor> affectedConfigurations = this.getAffectedConfigurations();
        FlowNodeLock workspaceLock = WorkspaceLockUtil.acquireWrite(affectedConfigurations);
        try {
            if (this.verifyInSyncEnabled() && !this.updateDilemmaHandler.willIgnoreAllSharesOutOfSync()) {
                EclipseWorkspaceVerifySharesOperation verifyOp = new EclipseWorkspaceVerifySharesOperation((OutOfSyncDilemmaHandler)this.updateDilemmaHandler);
                for (ConfigurationDescriptor configurationDescriptor : affectedConfigurations) {
                    verifyOp.addToVerify((IConnection)((IWorkspaceConnection)configurationDescriptor.getConnection(null)), configurationDescriptor.componentHandle);
                }
                verifyOp.run((IProgressMonitor)progress.newChild(10));
            }
            this.checkCancelled((IProgressMonitor)progress);
            HashMap<UUID, IVersionable> versionableMap = new HashMap<UUID, IVersionable>();
            for (Map.Entry<IWorkspaceConnection, HashSet<RestoreRequest>> entry : this.restoreRequests.entrySet()) {
                IWorkspaceConnection workspaceConnection = entry.getKey();
                IVersionableManager versionableManager = SCMPlatform.getWorkspaceManager((ITeamRepository)workspaceConnection.teamRepository()).versionableManager();
                List versionables = versionableManager.fetchCompleteStates(this.statesToRestore.get(workspaceConnection), (IProgressMonitor)progress.newChild(15));
                versionableMap = new HashMap();
                for (IVersionable versionable : versionables) {
                    if (versionable == null) {
                        throw new FileSystemClientException((IStatus)new FileSystemStatus(4, Messages.EclipseWorkspaceRestoreOperation_1));
                    }
                    versionableMap.put(versionable.getItemId(), versionable);
                }
                versionables = null;
                this.checkCancelled((IProgressMonitor)progress);
                ArrayList<IAuditable> determinants = new ArrayList<IAuditable>();
                workspaceLock.addDeterminants(determinants);
                IWorkspaceConnection.IConfigurationOpFactory factory = workspaceConnection.configurationOpFactory();
                SubMonitor iterProgress = progress.newChild(5);
                iterProgress.setWorkRemaining(entry.getValue().size());
                ChangeSetChooser organizer = new ChangeSetChooser(workspaceConnection, determinants);
                for (RestoreRequest request : entry.getValue()) {
                    IVersionable toRestore = (IVersionable)versionableMap.get(request.stateToRestore.getItemId());
                    toRestore = (IVersionable)toRestore.getWorkingCopy();
                    if (request.parentHandle != null) {
                        toRestore.setParent(request.parentHandle);
                        toRestore.setName(request.name);
                    }
                    organizer.toCommit(request.configurationDescriptor.componentHandle, (IVersionableHandle)toRestore, (IWorkspaceConnection.IConfigurationOp)factory.save(toRestore), request.defaultChangeSet, request.newChangeSetComment, (IProgressMonitor)iterProgress.newChild(1));
                }
                this.checkCancelled((IProgressMonitor)progress);
                IUpdateReport report = organizer.commit((IProgressMonitor)progress.newChild(50));
                UpdateDilemmaHandler ignoreSyncs = new UpdateDilemmaHandler(){

                    public int outOfSync(Collection<IShareOutOfSync> sharesOutOfSync) {
                        return 0;
                    }

                    public boolean willIgnoreAllSharesOutOfSync() {
                        return true;
                    }

                    public int collision(Collection<ICollision> collisions, Collection<IRemovedShare> removedShares, Collection<IShareOutOfSync> sharesOutOfSync) {
                        return EclipseWorkspaceRestoreOperation.this.updateDilemmaHandler.collision(collisions, removedShares, sharesOutOfSync);
                    }

                    public int newItemsToLoad(Collection<IShareableToLoad> sharesToLoad) {
                        return EclipseWorkspaceRestoreOperation.this.updateDilemmaHandler.newItemsToLoad(sharesToLoad);
                    }
                };
                EclipseWorkspaceUpdateOperation op = new EclipseWorkspaceUpdateOperation(workspaceConnection, Collections.singletonList(report), 3, ignoreSyncs);
                op.run((IProgressMonitor)progress.newChild(50));
            }
        }
        finally {
            WorkspaceLockUtil.release((FlowNodeLock)workspaceLock);
        }
    }

    private Collection<ConfigurationDescriptor> getAffectedConfigurations() throws TeamRepositoryException {
        HashSet<ConfigurationDescriptor> affectedConfigurations = new HashSet<ConfigurationDescriptor>();
        for (HashSet<RestoreRequest> requests : this.restoreRequests.values()) {
            for (RestoreRequest request : requests) {
                affectedConfigurations.add(request.configurationDescriptor);
            }
        }
        return affectedConfigurations;
    }

    private class RestoreRequest {
        public final ConfigurationDescriptor configurationDescriptor;
        public final IVersionableHandle stateToRestore;
        public final String name;
        public final IFolderHandle parentHandle;
        public final IChangeSetHandle defaultChangeSet;
        public final String newChangeSetComment;

        public RestoreRequest(IWorkspaceConnection workspaceConnection, IComponentHandle component, IChangeSetHandle defaultChangeSet, String newChangeSetComment, IVersionableHandle itemStateToRestore) {
            this(workspaceConnection, component, defaultChangeSet, newChangeSetComment, null, null, itemStateToRestore);
        }

        public RestoreRequest(IWorkspaceConnection workspaceConnection, IComponentHandle component, IChangeSetHandle defaultChangeSet, String newChangeSetComment, IFolderHandle parent, String name, IVersionableHandle itemStateToRestore) {
            this.configurationDescriptor = new ConfigurationDescriptor((IConnection)workspaceConnection, component);
            this.stateToRestore = itemStateToRestore;
            this.name = name;
            this.parentHandle = parent;
            this.defaultChangeSet = defaultChangeSet;
            this.newChangeSetComment = newChangeSetComment;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.configurationDescriptor == null ? 0 : this.configurationDescriptor.hashCode());
            result = 31 * result + (this.stateToRestore == null ? 0 : this.stateToRestore.getItemId().hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RestoreRequest other = (RestoreRequest)obj;
            if (this.configurationDescriptor == null ? other.configurationDescriptor != null : !this.configurationDescriptor.equals((Object)other.configurationDescriptor)) {
                return false;
            }
            return !(this.stateToRestore == null ? other.stateToRestore != null : !this.stateToRestore.sameItemId((IItemHandle)other.stateToRestore));
        }
    }
}

