/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.operations.ChangeHistoryChangeSetsDilemmaHandler;
import com.ibm.team.filesystem.client.internal.operations.ChangeHistoryChangeSetsOperation;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.LoadedConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IFileSystemOperation;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.operations.ChangeSetChooser;
import com.ibm.team.filesystem.rcp.core.operations.EclipseWorkspaceUpdateOperation;
import com.ibm.team.filesystem.rcp.core.operations.EclipseWorkspaceVerifySharesOperation;
import com.ibm.team.filesystem.rcp.core.operations.IMoveFoldersOperation;
import com.ibm.team.filesystem.rcp.core.operations.MoveFoldersDilemmaHandler;
import com.ibm.team.filesystem.rcp.core.operations.NewCheckInOperation;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseWorkspaceMoveFoldersOperation
extends ChangeHistoryChangeSetsOperation
implements IMoveFoldersOperation {
    private List<MoveRequest> moveRequests;
    private Map<IWorkspaceConnection, List<RenameRequest>> renameRequests;
    private MoveFoldersDilemmaHandler moveDilemmaHandler;

    public EclipseWorkspaceMoveFoldersOperation(MoveFoldersDilemmaHandler dilemmaHandler) {
        super((ChangeHistoryChangeSetsDilemmaHandler)(dilemmaHandler == null ? MoveFoldersDilemmaHandler.getDefault() : dilemmaHandler));
        this.moveDilemmaHandler = dilemmaHandler == null ? MoveFoldersDilemmaHandler.getDefault() : dilemmaHandler;
        this.moveRequests = new ArrayList<MoveRequest>();
        this.renameRequests = new HashMap<IWorkspaceConnection, List<RenameRequest>>();
    }

    protected void execute(IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        ThreadCheck.checkLongOpsAllowed();
        monitor.setTaskName(Messages.EclipseWorkspaceMoveFoldersOperation_0);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.EclipseWorkspaceMoveAcrossComponent_ProgressMessage, (int)100);
        final Collection<ConfigurationDescriptor> affectedConfigurations = this.getAffectedConfigurations();
        FlowNodeLock workspaceLock = WorkspaceLockUtil.acquireWrite(affectedConfigurations);
        try {
            try {
                final TeamRepositoryException[] teamRepoException = new TeamRepositoryException[1];
                IWorkspaceRunnable workspaceOp = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        try {
                            EclipseWorkspaceMoveFoldersOperation.this.processRequests(affectedConfigurations, monitor);
                        }
                        catch (TeamRepositoryException e) {
                            teamRepoException[0] = e;
                        }
                    }
                };
                ResourcesPlugin.getWorkspace().run(workspaceOp, (IProgressMonitor)progress.newChild(90));
                if (teamRepoException[0] != null) {
                    throw teamRepoException[0];
                }
            }
            catch (FileSystemClientException e) {
                throw e;
            }
            catch (CoreException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor((Throwable)e));
            }
        }
        finally {
            WorkspaceLockUtil.release((FlowNodeLock)workspaceLock);
        }
    }

    private Collection<ConfigurationDescriptor> getAffectedConfigurations() {
        HashSet<ConfigurationDescriptor> configurations = new HashSet<ConfigurationDescriptor>();
        for (MoveRequest moveRequest : this.moveRequests) {
            configurations.add(new ConfigurationDescriptor((IConnection)moveRequest.workspaceConnection, moveRequest.sourceComponent));
            configurations.add(new ConfigurationDescriptor((IConnection)moveRequest.workspaceConnection, moveRequest.targetComponent));
        }
        for (List list : this.renameRequests.values()) {
            for (RenameRequest request : list) {
                configurations.add(new ConfigurationDescriptor((IConnection)request.workspaceConnection, request.component));
            }
        }
        return configurations;
    }

    @Override
    public void addMoveWithinComponentRequest(IWorkspaceConnection workspaceConnection, IComponentHandle component, IFolderHandle[] foldersToMove, IFolderHandle[] toDestinationFolders, String changeSetComment) {
        IFolderHandle folder;
        if (workspaceConnection == null) {
            throw new IllegalArgumentException();
        }
        if (component == null) {
            throw new IllegalArgumentException();
        }
        if (foldersToMove == null) {
            throw new IllegalArgumentException();
        }
        IFolderHandle[] iFolderHandleArray = foldersToMove;
        int n = foldersToMove.length;
        int n2 = 0;
        while (n2 < n) {
            folder = iFolderHandleArray[n2];
            if (folder == null) {
                throw new IllegalArgumentException();
            }
            ++n2;
        }
        if (toDestinationFolders == null) {
            throw new IllegalArgumentException();
        }
        iFolderHandleArray = toDestinationFolders;
        n = toDestinationFolders.length;
        n2 = 0;
        while (n2 < n) {
            folder = iFolderHandleArray[n2];
            if (folder == null) {
                throw new IllegalArgumentException();
            }
            ++n2;
        }
        if (foldersToMove.length != toDestinationFolders.length) {
            throw new IllegalArgumentException();
        }
        MoveRequest request = new MoveRequest(workspaceConnection, component, foldersToMove, component, toDestinationFolders, changeSetComment, changeSetComment);
        this.moveRequests.add(request);
    }

    @Override
    public void addRenameRequest(IWorkspaceConnection workspaceConnection, IComponentHandle component, IFolderHandle[] foldersToRename, String[] newFolderName, String changeSetComment) {
        if (workspaceConnection == null) {
            throw new IllegalArgumentException("WorkspaceConnection must be supplied for rename request");
        }
        if (component == null) {
            throw new IllegalArgumentException("Component must be supplied for rename request");
        }
        if (foldersToRename == null) {
            throw new IllegalArgumentException("Folders to be renamed must be supplied for rename request");
        }
        if (newFolderName == null) {
            throw new IllegalArgumentException("New folder names must be supplied");
        }
        if (foldersToRename.length != newFolderName.length) {
            throw new IllegalArgumentException("There must be a new name for each and every folder");
        }
        RenameRequest request = new RenameRequest(workspaceConnection, component, foldersToRename, newFolderName, changeSetComment);
        List<RenameRequest> requestsForWorkspace = this.renameRequests.get(workspaceConnection);
        if (requestsForWorkspace == null) {
            requestsForWorkspace = new ArrayList<RenameRequest>();
            this.renameRequests.put(workspaceConnection, requestsForWorkspace);
        }
        requestsForWorkspace.add(request);
    }

    @Override
    public void addMoveAcrossComponentRequest(IWorkspaceConnection workspaceConnection, IComponentHandle sourceComponent, IFolderHandle[] foldersToMove, IComponentHandle targetComponent, IFolderHandle[] toDestinationFolders, String sourceChangeSetComment, String targetChangeSetComment) {
        if (workspaceConnection == null) {
            throw new IllegalArgumentException();
        }
        if (sourceComponent == null) {
            throw new IllegalArgumentException();
        }
        if (targetComponent == null) {
            throw new IllegalArgumentException();
        }
        if (sourceComponent.sameItemId((IItemHandle)targetComponent)) {
            throw new IllegalArgumentException();
        }
        if (foldersToMove == null) {
            throw new IllegalArgumentException();
        }
        IFolderHandle[] iFolderHandleArray = foldersToMove;
        int n = foldersToMove.length;
        int n2 = 0;
        while (n2 < n) {
            IFolderHandle folder = iFolderHandleArray[n2];
            if (folder == null) {
                throw new IllegalArgumentException();
            }
            ++n2;
        }
        if (toDestinationFolders == null) {
            throw new IllegalArgumentException();
        }
        if (foldersToMove.length != toDestinationFolders.length) {
            throw new IllegalArgumentException();
        }
        MoveRequest request = new MoveRequest(workspaceConnection, sourceComponent, foldersToMove, targetComponent, toDestinationFolders, sourceChangeSetComment, targetChangeSetComment);
        this.moveRequests.add(request);
    }

    private void processRequests(Collection<ConfigurationDescriptor> affectedConfigurations, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(10 + 100 * this.moveRequests.size()));
        if (this.verifyInSyncEnabled() && !this.moveDilemmaHandler.willIgnoreAllSharesOutOfSync()) {
            EclipseWorkspaceVerifySharesOperation verifyOp = new EclipseWorkspaceVerifySharesOperation((OutOfSyncDilemmaHandler)this.moveDilemmaHandler);
            for (ConfigurationDescriptor configurationDescriptor : affectedConfigurations) {
                verifyOp.addToVerify((IConnection)((IWorkspaceConnection)configurationDescriptor.getConnection(null)), configurationDescriptor.componentHandle);
            }
            verifyOp.run((IProgressMonitor)progress.newChild(10));
        }
        this.checkCancelled((IProgressMonitor)progress);
        this.checkinPendingChanges(affectedConfigurations, this.moveDilemmaHandler, (IProgressMonitor)progress.newChild(30));
        this.checkCancelled((IProgressMonitor)progress);
        HashSet<ConfigurationDescriptor> loadedComponents = this.getLoadedComponents((IProgressMonitor)progress.newChild(10));
        for (MoveRequest moveRequest : this.moveRequests) {
            IUpdateReport report;
            if (moveRequest.sourceComponent.sameItemId((IItemHandle)moveRequest.targetComponent)) {
                report = this.moveFoldersWithinComponent(moveRequest, (IProgressMonitor)progress.newChild(50));
            } else {
                if (loadedComponents.contains(new ConfigurationDescriptor((IConnection)moveRequest.workspaceConnection, moveRequest.sourceComponent)) && !loadedComponents.contains(new ConfigurationDescriptor((IConnection)moveRequest.workspaceConnection, moveRequest.targetComponent))) {
                    IComponent component = (IComponent)moveRequest.workspaceConnection.teamRepository().itemManager().fetchCompleteItem((IItemHandle)moveRequest.targetComponent, 0, (IProgressMonitor)progress.newChild(1));
                    CopyFileAreaStore.getDefaultCopyFileArea().componentLoaded(new LoadedConfigurationDescriptor((IConnection)moveRequest.workspaceConnection, component), (IProgressMonitor)progress.newChild(1));
                } else {
                    progress.worked(2);
                }
                report = moveRequest.workspaceConnection.moveFoldersBetweenComponents(moveRequest.sourceComponent, moveRequest.targetComponent, moveRequest.foldersToMove, moveRequest.toDestinationFolders, moveRequest.sourceChangeSetComment, moveRequest.targetChangeSetComment, (IProgressMonitor)progress.newChild(48));
            }
            this.checkCancelled((IProgressMonitor)progress);
            EclipseWorkspaceUpdateOperation op = new EclipseWorkspaceUpdateOperation(moveRequest.workspaceConnection, Collections.singletonList(report), 3, (UpdateDilemmaHandler)this.moveDilemmaHandler);
            this.disableVerifyInSync((IFileSystemOperation)op);
            progress.subTask(Messages.EclipseWorkspaceMoveFoldersOperation_PROGRESS_UPDATES);
            op.run((IProgressMonitor)progress.newChild(50));
        }
        for (Map.Entry entry : this.renameRequests.entrySet()) {
            this.processRenames((IWorkspaceConnection)entry.getKey(), (List)entry.getValue(), (IProgressMonitor)progress.newChild(100));
        }
    }

    private IUpdateReport moveFoldersWithinComponent(MoveRequest moveRequest, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        List<IFolderHandle> toMove = Arrays.asList(moveRequest.foldersToMove);
        List fullToMove = moveRequest.workspaceConnection.configuration(moveRequest.sourceComponent).fetchCompleteItems(toMove, (IProgressMonitor)monitor.newChild(10));
        ChangeSetChooser changeSetChooser = new ChangeSetChooser(moveRequest.workspaceConnection, null);
        int i = 0;
        SubMonitor iterProgress = monitor.newChild(5);
        iterProgress.setWorkRemaining(fullToMove.size());
        for (IFolder folder : fullToMove) {
            folder = (IFolder)folder.getWorkingCopy();
            folder.setParent(moveRequest.toDestinationFolders[i]);
            IWorkspaceConnection.ISaveOp op = moveRequest.workspaceConnection.configurationOpFactory().save((IVersionable)folder);
            changeSetChooser.toCommit(moveRequest.sourceComponent, (IVersionableHandle)folder, (IWorkspaceConnection.IConfigurationOp)op, null, moveRequest.sourceChangeSetComment, (IProgressMonitor)iterProgress.newChild(1));
        }
        return changeSetChooser.commit((IProgressMonitor)monitor.newChild(85));
    }

    private void processRenames(IWorkspaceConnection workspaceConnection, List<RenameRequest> renames, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(100 + 15 * renames.size()));
        ChangeSetChooser changeSetChooser = new ChangeSetChooser(workspaceConnection, null);
        for (RenameRequest request : renames) {
            List<IFolderHandle> toRename = Arrays.asList(request.foldersToRename);
            List fullToRename = workspaceConnection.configuration(request.component).fetchCompleteItems(toRename, (IProgressMonitor)progress.newChild(10));
            int i = 0;
            SubMonitor iterProgress = progress.newChild(5);
            iterProgress.setWorkRemaining(fullToRename.size());
            for (IFolder folder : fullToRename) {
                folder = (IFolder)folder.getWorkingCopy();
                folder.setName(request.newNames[i]);
                ++i;
                IWorkspaceConnection.ISaveOp op = workspaceConnection.configurationOpFactory().save((IVersionable)folder);
                changeSetChooser.toCommit(request.component, (IVersionableHandle)folder, (IWorkspaceConnection.IConfigurationOp)op, null, request.changeSetComment, (IProgressMonitor)iterProgress.newChild(1));
            }
        }
        IUpdateReport report = changeSetChooser.commit((IProgressMonitor)progress.newChild(50));
        this.checkCancelled((IProgressMonitor)progress);
        EclipseWorkspaceUpdateOperation op = new EclipseWorkspaceUpdateOperation(workspaceConnection, Collections.singletonList(report), 3, (UpdateDilemmaHandler)this.moveDilemmaHandler);
        this.disableVerifyInSync((IFileSystemOperation)op);
        progress.subTask(Messages.EclipseWorkspaceMoveFoldersOperation_PROGRESS_UPDATES);
        op.run((IProgressMonitor)progress.newChild(50));
    }

    private HashSet<ConfigurationDescriptor> getLoadedComponents(IProgressMonitor monitor) throws FileSystemClientException {
        HashSet<ConfigurationDescriptor> result = new HashSet<ConfigurationDescriptor>();
        Collection loadedComponents = CopyFileAreaStore.getDefaultCopyFileArea().allLoadedComponents(monitor);
        for (LoadedConfigurationDescriptor loadedComponent : loadedComponents) {
            result.add(new ConfigurationDescriptor(loadedComponent.id, loadedComponent.uri, loadedComponent.connectionHandle, loadedComponent.componentHandle));
        }
        return result;
    }

    public IFileSystemOperation getCheckInOperation(IWorkspaceConnection connection, IComponentHandle componentHandle, ILocalChange[] changes, String comment, CommitDilemmaHandler commitDilemmaHandler) {
        return new NewCheckInOperation(connection, componentHandle, changes, comment, commitDilemmaHandler);
    }

    private class MoveRequest {
        final IWorkspaceConnection workspaceConnection;
        final IComponentHandle sourceComponent;
        final IFolderHandle[] foldersToMove;
        final IComponentHandle targetComponent;
        final IFolderHandle[] toDestinationFolders;
        final String sourceChangeSetComment;
        final String targetChangeSetComment;

        public MoveRequest(IWorkspaceConnection workspaceConnection, IComponentHandle sourceComponent, IFolderHandle[] foldersToMove, IComponentHandle targetComponent, IFolderHandle[] toDestinationFolders, String sourceChangeSetComment, String targetChangeSetComment) {
            this.workspaceConnection = workspaceConnection;
            this.sourceComponent = sourceComponent;
            this.foldersToMove = foldersToMove;
            this.targetComponent = targetComponent;
            this.toDestinationFolders = toDestinationFolders;
            this.sourceChangeSetComment = sourceChangeSetComment;
            this.targetChangeSetComment = targetChangeSetComment;
        }
    }

    private class RenameRequest {
        final IWorkspaceConnection workspaceConnection;
        final IComponentHandle component;
        final IFolderHandle[] foldersToRename;
        final String[] newNames;
        final String changeSetComment;

        public RenameRequest(IWorkspaceConnection workspaceConnection, IComponentHandle component, IFolderHandle[] foldersToRename, String[] newFolderNames, String changeSetComment) {
            this.workspaceConnection = workspaceConnection;
            this.component = component;
            this.foldersToRename = foldersToRename;
            this.newNames = newFolderNames;
            this.changeSetComment = changeSetComment;
        }
    }
}

