/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.load.MergeLoadMutator;
import com.ibm.team.filesystem.client.internal.operations.LoadOperation;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.DilemmaHandler;
import com.ibm.team.filesystem.client.operations.IVerifyInSyncOperation;
import com.ibm.team.filesystem.client.operations.LoadDilemmaHandler;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.common.internal.dto.LoadTree;
import com.ibm.team.filesystem.rcp.core.IEclipseFileSystemManager;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.resources.EclipseWorkspaceMergeLoadMutator;
import com.ibm.team.filesystem.rcp.core.internal.resources.ShareableResource;
import com.ibm.team.filesystem.rcp.core.operations.IDownloadMonitor;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseWorkspaceMergeLoadOperation
extends LoadOperation {
    IDownloadMonitor downloadMonitor = null;

    public EclipseWorkspaceMergeLoadOperation(LoadDilemmaHandler problemHandler) {
        super(problemHandler);
    }

    protected void execute(IProgressMonitor reporter) throws FileSystemClientException, TeamRepositoryException {
        final TeamRepositoryException[] teamRepoException = new TeamRepositoryException[1];
        final FileSystemClientException[] fileSystemException = new FileSystemClientException[1];
        if (reporter != null && reporter instanceof IDownloadMonitor) {
            this.downloadMonitor = (IDownloadMonitor)reporter;
            reporter = this.downloadMonitor.getProgressMonitor();
        }
        IWorkspaceRunnable workspaceOp = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                try {
                    EclipseWorkspaceMergeLoadOperation.super.doLoad(monitor);
                }
                catch (FileSystemClientException e) {
                    fileSystemException[0] = e;
                }
                catch (TeamRepositoryException e) {
                    teamRepoException[0] = e;
                }
            }
        };
        FlowNodeLock jazzWorkspaceLock = WorkspaceLockUtil.acquireRead((Collection)this.getAffectedConfigurations());
        try {
            try {
                ResourcesPlugin.getWorkspace().run(workspaceOp, reporter);
            }
            catch (FileSystemClientException e) {
                throw e;
            }
            catch (CoreException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor((Throwable)e));
            }
        }
        finally {
            WorkspaceLockUtil.release((FlowNodeLock)jazzWorkspaceLock);
        }
        if (teamRepoException[0] != null) {
            throw teamRepoException[0];
        }
        if (fileSystemException[0] != null) {
            throw fileSystemException[0];
        }
    }

    protected MergeLoadMutator getLoadMutator(IConnection connection, IComponentHandle component, Collection<IVersionableHandle> shareRoots, Collection<String[]> subtreeRoots, LoadTree loadTree, LoadDilemmaHandler problemHandler) throws TeamRepositoryException {
        Map<ConfigurationDescriptor, Collection<IVersionableHandle>> roots = Collections.singletonMap(new ConfigurationDescriptor(connection, component), shareRoots);
        return new EclipseWorkspaceMergeLoadMutator(connection, roots, subtreeRoots, loadTree, (DilemmaHandler)problemHandler, this.downloadMonitor);
    }

    protected IShareable getShareable(String child) {
        return new ShareableResource((IResource)ResourcesPlugin.getWorkspace().getRoot().getProject(child));
    }

    protected boolean existsOnMirror(String child) {
        if (ResourcesPlugin.getWorkspace().getRoot().getProject(child).exists()) {
            return true;
        }
        IPath path = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        if (path != null) {
            return path.append(child).toFile().exists();
        }
        return false;
    }

    protected CopyFileAreaStore getCopyFileArea() {
        return CopyFileAreaStore.getDefaultCopyFileArea();
    }

    protected void deleteShare(IShareable toDeleteShareable, IProgressMonitor monitor) throws FileSystemClientException {
        final SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        final IResource resource = ((ShareableResource)toDeleteShareable).getResource();
        try {
            if (resource.getType() == 4) {
                ((IProject)resource).delete(true, true, (IProgressMonitor)progress.newChild(50));
            } else if (resource.getType() == 2) {
                SharingManager.getInstance().doSilentChange(new SharingManager.CoreRunnable(){

                    public void run() throws CoreException {
                        ((IFolder)resource).delete(true, true, (IProgressMonitor)progress.newChild(50));
                    }
                });
            } else if (resource.getType() == 1) {
                SharingManager.getInstance().doSilentChange(new SharingManager.CoreRunnable(){

                    public void run() throws CoreException {
                        ((IFile)resource).delete(true, true, (IProgressMonitor)progress.newChild(50));
                    }
                });
            }
        }
        catch (CoreException e) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor((int)4, (int)370, (String)NLS.bind((String)Messages.EclipseWorkspaceMergeLoadOperation_0, (Object[])new Object[]{toDeleteShareable.getLocalFullPath().toString()}), (Throwable)e));
        }
        ShareableResource shareable = new ShareableResource(resource);
        if (resource.getType() == 4) {
            if (shareable.getShare() != null) {
                shareable.unshare((IProgressMonitor)progress.newChild(50));
            }
        } else {
            shareable.forget((IProgressMonitor)progress.newChild(50));
        }
        progress.done();
    }

    protected IShare[] getAllShares() throws FileSystemClientException {
        return SharingManager.getInstance().allShares();
    }

    protected IVerifyInSyncOperation getVerifyInSyncOperation(OutOfSyncDilemmaHandler outOfSyncDilemmaHandler) {
        return IEclipseFileSystemManager.instance.getVerifyInSyncOperation(outOfSyncDilemmaHandler);
    }
}

