/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ILocalChangeManager;
import com.ibm.team.filesystem.client.ISharingManager;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.operations.MarkAsMergedOperation;
import com.ibm.team.filesystem.client.internal.operations.VerifySharesOperation;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.MarkAsMergedDilemmaHandler;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ILogicalChange;
import com.ibm.team.filesystem.common.ILogicalConflictReport;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.operations.EclipseWorkspaceUpdateOperation;
import com.ibm.team.filesystem.rcp.core.operations.EclipseWorkspaceVerifySharesOperation;
import com.ibm.team.filesystem.rcp.core.operations.NewCheckInOperation;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IItemConflictReport;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseWorkspaceMarkAsMergedOperation
extends MarkAsMergedOperation {
    public EclipseWorkspaceMarkAsMergedOperation(IWorkspaceConnection connection, ILogicalConflictReport conflictReport, Collection changes, MarkAsMergedDilemmaHandler dilemmaHandler) throws FileSystemClientException {
        super(connection, conflictReport, changes, dilemmaHandler);
    }

    protected void updateCopyFileArea(List<IUpdateReport> updateReports, UpdateDilemmaHandler problemHandler, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        new EclipseWorkspaceUpdateOperation(this.connection, updateReports, 3, problemHandler).run(monitor);
    }

    protected VerifySharesOperation getVerifyOperation(OutOfSyncDilemmaHandler problemHandler) {
        return new EclipseWorkspaceVerifySharesOperation(problemHandler);
    }

    protected void checkinPendingChanges(Map<ConfigurationDescriptor, Map<UUID, ILogicalChange>> changes, MarkAsMergedDilemmaHandler problemHandler, IProgressMonitor progress) throws TeamRepositoryException, FileSystemClientException {
        ArrayList<ILocalChange> pendingChanges = new ArrayList<ILocalChange>();
        HashMap<UUID, ArrayList<ILocalChange>> checkin = new HashMap<UUID, ArrayList<ILocalChange>>();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        for (Map.Entry<ConfigurationDescriptor, Map<UUID, ILogicalChange>> entry : changes.entrySet()) {
            ILocalChange[] localChanges;
            ConfigurationDescriptor descriptor = entry.getKey();
            Map<UUID, ILogicalChange> toMarkAsMerged = entry.getValue();
            ILocalChangeManager lcm = FileSystemCore.getSharingManager().getLocalChangeManager();
            CopyFileAreaStore cfa = CopyFileAreaStore.getDefaultCopyFileArea();
            ISchedulingRule cfaLock = cfa.lock(descriptor.componentHandle, descriptor.connectionHandle, (IProgressMonitor)monitor.newChild(1));
            try {
                lcm.syncPendingChanges(descriptor.connectionHandle, descriptor.componentHandle, FileSystemCore.getSharingManager().getDefaultCFARoot());
            }
            finally {
                cfa.release(cfaLock, (IProgressMonitor)monitor.newChild(1));
            }
            ILocalChange[] iLocalChangeArray = localChanges = lcm.getPendingChanges(descriptor.connectionHandle, descriptor.componentHandle, FileSystemCore.getSharingManager().getDefaultCFARoot());
            int n = localChanges.length;
            int n2 = 0;
            while (n2 < n) {
                ILocalChange localChange = iLocalChangeArray[n2];
                if (toMarkAsMerged.containsKey(localChange.getTarget().getItemId())) {
                    pendingChanges.add(localChange);
                    ArrayList<ILocalChange> changesToCheckin = (ArrayList<ILocalChange>)checkin.get(localChange.getComponent().getItemId());
                    if (changesToCheckin == null) {
                        changesToCheckin = new ArrayList<ILocalChange>();
                        checkin.put(localChange.getComponent().getItemId(), changesToCheckin);
                    }
                    changesToCheckin.add(localChange);
                }
                ++n2;
            }
        }
        if (!pendingChanges.isEmpty()) {
            int result = problemHandler.uncheckedInChanges(pendingChanges);
            if (result == 0) {
                monitor.setWorkRemaining(checkin.size());
                for (Map.Entry entry : checkin.entrySet()) {
                    Collection changesToCheckin = (Collection)entry.getValue();
                    if (changesToCheckin.isEmpty()) continue;
                    IComponentHandle component = ((ILocalChange)changesToCheckin.iterator().next()).getComponent();
                    new NewCheckInOperation(this.connection, component, changesToCheckin.toArray(new ILocalChange[changesToCheckin.size()]), Messages.EclipseWorkspaceMarkAsMergedOperation_ChangeSetDefaultComment, (CommitDilemmaHandler)problemHandler).run((IProgressMonitor)monitor.newChild(1));
                }
            } else {
                if (result == 1) {
                    throw new OperationCanceledException();
                }
                throw new FileSystemClientException((IStatus)new FileSystemStatus(4, Messages.EclipseWorkspaceMarkAsMergedOperation_1));
            }
        }
        monitor.done();
    }

    protected void verifyChangesMerged(Map<ConfigurationDescriptor, Map<UUID, ILogicalChange>> organizedChanges, MarkAsMergedDilemmaHandler problemHandler, IProgressMonitor progress) throws TeamRepositoryException, FileSystemClientException {
        int result;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        ArrayList<ILogicalChange> unmergedChanges = new ArrayList<ILogicalChange>();
        IUpdateReport conflictReport = this.connection.conflictReport();
        for (IItemConflictReport conflict : conflictReport.conflicts()) {
            ILogicalChange change;
            ConfigurationDescriptor descriptor;
            Map<UUID, ILogicalChange> changesToMarkAsMerged;
            boolean wasMerged = false;
            IVersionableHandle selectedContributorState = conflict.getSelectedContributorState();
            IVersionableHandle proposedContributorState = conflict.getProposedContributorState();
            IVersionableHandle originalSelectedContributorState = conflict.getOriginalSelectedContributorState();
            if (selectedContributorState == null && originalSelectedContributorState != null) {
                wasMerged = true;
            } else if (selectedContributorState != null && originalSelectedContributorState == null) {
                wasMerged = true;
            } else if (selectedContributorState == null && originalSelectedContributorState == null) {
                if (proposedContributorState == null) {
                    wasMerged = true;
                }
            } else if (!selectedContributorState.sameStateId((IItemHandle)originalSelectedContributorState)) {
                wasMerged = true;
            }
            if (wasMerged || (changesToMarkAsMerged = organizedChanges.get(descriptor = new ConfigurationDescriptor((IConnection)this.connection, conflict.getComponent()))) == null || !changesToMarkAsMerged.containsKey(conflict.item().getItemId()) || this.isEvilTwin(conflict, change = changesToMarkAsMerged.get(conflict.item().getItemId()), (IProgressMonitor)monitor)) continue;
            unmergedChanges.add(change);
        }
        if (!unmergedChanges.isEmpty() && (result = problemHandler.unmergedChanges(unmergedChanges)) != 0) {
            if (result == 1) {
                throw new OperationCanceledException();
            }
            throw new FileSystemClientException((IStatus)new FileSystemStatus(4, Messages.EclipseWorkspaceMarkAsMergedOperation_2));
        }
    }

    private boolean isEvilTwin(IItemConflictReport conflict, ILogicalChange change, IProgressMonitor progress) throws FileSystemClientException {
        IVersionableHandle selectedContributorState = conflict.getSelectedContributorState();
        IVersionableHandle proposedContributorState = conflict.getProposedContributorState();
        IVersionableHandle originalSelectedContributorState = conflict.getOriginalSelectedContributorState();
        if (selectedContributorState == null && originalSelectedContributorState == null && proposedContributorState != null) {
            ISharingManager sharingManager = FileSystemCore.getSharingManager();
            IPath fullName = (IPath)sharingManager.getPathRelativeToShares(sharingManager.getDefaultCFARoot(), this.connection.getContextHandle(), conflict.getComponent(), Collections.singletonList(change.getAncestorPathHint()), progress).get(0);
            IResource resource = null;
            if (fullName != null) {
                resource = ResourcesPlugin.getWorkspace().getRoot().findMember(fullName);
            }
            if (resource != null && (resource.getType() == 1 && conflict.item() instanceof IFileItemHandle || conflict.item() instanceof IFolderHandle && (resource.getType() == 2 || resource.getType() == 4))) {
                return true;
            }
        }
        return false;
    }
}

