/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.ConnectionDescriptor;
import com.ibm.team.filesystem.client.internal.utils.CopyFileAreaLockUtil;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.DilemmaHandler;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.resources.ShareableResource;
import com.ibm.team.filesystem.rcp.core.operations.EclipseWorkspaceVerifySharesOperation;
import com.ibm.team.filesystem.rcp.core.operations.IDeleteFoldersOperation;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IComponentStateSummary;
import com.ibm.team.scm.common.dto.ISyncTime;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseWorkspaceDeleteOperation
extends FileSystemOperation
implements IDeleteFoldersOperation {
    private int totalToDelete;
    private Set<ConfigurationDescriptor> affectedConfigurations;
    private Map<ConnectionDescriptor, Map<UUID, Collection<IShareable>>> toDelete;
    private boolean deleteContent;
    private final CommitDilemmaHandler problemHandler;

    public EclipseWorkspaceDeleteOperation(CommitDilemmaHandler problemHandler) {
        super((DilemmaHandler)(problemHandler == null ? CommitDilemmaHandler.getDefault() : problemHandler));
        this.problemHandler = problemHandler == null ? CommitDilemmaHandler.getDefault() : problemHandler;
        this.toDelete = new HashMap<ConnectionDescriptor, Map<UUID, Collection<IShareable>>>();
        this.affectedConfigurations = new HashSet<ConfigurationDescriptor>();
        this.totalToDelete = 0;
    }

    @Override
    public void addDeleteRequest(IShareable[] shareables) throws TeamRepositoryException {
        if (shareables == null) {
            throw new IllegalArgumentException("Shareables must be supplied");
        }
        IShareable[] iShareableArray = shareables;
        int n = shareables.length;
        int n2 = 0;
        while (n2 < n) {
            Collection<IShareable> foldersToDelete;
            IShareable shareable = iShareableArray[n2];
            if (shareable == null) {
                throw new IllegalArgumentException("List of shareables must not contain null");
            }
            IShare share = shareable.getShare();
            if (share == null) {
                throw new TeamRepositoryException(NLS.bind((String)Messages.DeleteOperation_0, (Object[])new Object[]{shareable.getLocalFullPath().toString()}));
            }
            ISharingDescriptor sharingDescriptor = shareable.getShare().getSharingDescriptor();
            if (!(sharingDescriptor.getConnectionHandle() instanceof IWorkspaceHandle)) {
                throw new TeamRepositoryException(NLS.bind((String)Messages.DeleteOperation_1, (Object[])new Object[]{shareable.getLocalFullPath().toString()}));
            }
            ConfigurationDescriptor configurationDescriptor = new ConfigurationDescriptor(sharingDescriptor.getRepositoryId(), sharingDescriptor.getRepositoryUri(), sharingDescriptor.getConnectionHandle(), sharingDescriptor.getComponent());
            this.affectedConfigurations.add(configurationDescriptor);
            ConnectionDescriptor descriptor = new ConnectionDescriptor(sharingDescriptor.getRepositoryId(), sharingDescriptor.getRepositoryUri(), sharingDescriptor.getConnectionHandle());
            Map<UUID, Collection<IShareable>> components = this.toDelete.get(descriptor);
            if (components == null) {
                components = new HashMap<UUID, Collection<IShareable>>();
                this.toDelete.put(descriptor, components);
            }
            if ((foldersToDelete = components.get(sharingDescriptor.getComponent().getItemId())) == null) {
                foldersToDelete = new ArrayList<IShareable>();
                components.put(sharingDescriptor.getComponent().getItemId(), foldersToDelete);
            }
            foldersToDelete.add(shareable);
            ++this.totalToDelete;
            ++n2;
        }
    }

    @Override
    public void setDeleteContent(boolean shouldDeleteContent) {
        this.deleteContent = shouldDeleteContent;
    }

    protected void execute(IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.DeleteOperation_MainProgressMessage, (int)(10 + this.toDelete.size() * 2 + this.totalToDelete));
        FlowNodeLock workspaceLock = WorkspaceLockUtil.acquireWrite(this.affectedConfigurations);
        try {
            try {
                this.verifyInSync(progress.newChild(10));
                final TeamRepositoryException[] teamRepoException = new TeamRepositoryException[1];
                IWorkspaceRunnable workspaceOp = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                        CopyFileAreaStore cfa = CopyFileAreaStore.getDefaultCopyFileArea();
                        ISchedulingRule cfaLock = CopyFileAreaLockUtil.getCopyFileAreaLock((CopyFileAreaStore)cfa, (Collection)EclipseWorkspaceDeleteOperation.this.affectedConfigurations, (IProgressMonitor)progress.newChild(1));
                        try {
                            try {
                                try {
                                    EclipseWorkspaceDeleteOperation.this.delete((IProgressMonitor)progress.newChild(98));
                                }
                                catch (TeamRepositoryException e) {
                                    teamRepoException[0] = e;
                                    cfa.sync();
                                }
                            }
                            finally {
                                cfa.sync();
                            }
                        }
                        finally {
                            cfa.release(cfaLock, (IProgressMonitor)progress.newChild(1));
                        }
                    }
                };
                ResourcesPlugin.getWorkspace().run(workspaceOp, (IProgressMonitor)progress.newChild(90));
                if (teamRepoException[0] != null) {
                    throw teamRepoException[0];
                }
            }
            catch (CoreException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor((Throwable)e));
            }
        }
        finally {
            WorkspaceLockUtil.release((FlowNodeLock)workspaceLock);
        }
    }

    private void verifyInSync(SubMonitor progress) throws TeamRepositoryException, FileSystemClientException {
        if (this.verifyInSyncEnabled() && !this.problemHandler.willIgnoreAllSharesOutOfSync()) {
            EclipseWorkspaceVerifySharesOperation verifyOp = new EclipseWorkspaceVerifySharesOperation((OutOfSyncDilemmaHandler)this.problemHandler);
            boolean verify = false;
            for (Map.Entry<ConnectionDescriptor, Map<UUID, Collection<IShareable>>> entry : this.toDelete.entrySet()) {
                HashMap<String, IShare> toVerify = new HashMap<String, IShare>();
                for (Collection<IShareable> shareablesToDelete : entry.getValue().values()) {
                    for (IShareable shareable : shareablesToDelete) {
                        IShare share = shareable.getShare();
                        if (share == null) continue;
                        toVerify.put(share.getPath().toString(), share);
                    }
                }
                if (toVerify.isEmpty()) continue;
                verifyOp.addToVerify(entry.getKey().getConnection((IProgressMonitor)progress.newChild(1)), toVerify.values());
                verify = true;
            }
            if (verify) {
                verifyOp.run((IProgressMonitor)progress.newChild(1));
            }
        }
    }

    private void delete(IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.totalToDelete + this.toDelete.size()));
        for (Map.Entry<ConnectionDescriptor, Map<UUID, Collection<IShareable>>> entry : this.toDelete.entrySet()) {
            IWorkspaceConnection connection = (IWorkspaceConnection)entry.getKey().getConnection((IProgressMonitor)progress.newChild(1));
            ArrayList<IChangeSetHandle> changeSets = new ArrayList<IChangeSetHandle>();
            ArrayList<Collection<? extends IWorkspaceConnection.IConfigurationOp>> configurationOps = new ArrayList<Collection<? extends IWorkspaceConnection.IConfigurationOp>>();
            Map<UUID, Collection<IShareable>> shareablesByComponent = entry.getValue();
            this.prepareCommitArgs(connection, shareablesByComponent, changeSets, configurationOps, progress);
            try {
                if (!configurationOps.isEmpty()) {
                    IUpdateReport updateReport = connection.commit(changeSets, configurationOps, (IProgressMonitor)progress.newChild(100));
                    HashMap<UUID, ISyncTime> beforeStates = new HashMap<UUID, ISyncTime>();
                    for (IComponentStateSummary summary : updateReport.getComponentStatesBefore()) {
                        beforeStates.put(summary.getComponent().getItemId(), summary.getConfigurationTime());
                    }
                    CopyFileAreaStore cfa = CopyFileAreaStore.getDefaultCopyFileArea();
                    for (IComponentStateSummary summary : updateReport.getComponentStatesAfter()) {
                        ISyncTime beforeState = (ISyncTime)beforeStates.get(summary.getComponent().getItemId());
                        cfa.setConfigurationState((IContextHandle)connection.getResolvedWorkspace(), summary.getComponent(), beforeState, summary.getConfigurationTime(), null);
                    }
                }
                this.deleteFromCFA(shareablesByComponent, (IProgressMonitor)progress.newChild(100));
            }
            catch (TeamRepositoryException e) {
                this.collectStatus(FileSystemStatus.getStatusFor((int)4, (String)"com.ibm.team.filesystem.client", (int)0, (String)Messages.DeleteOperation_ErrorFromServer, (Throwable)e));
            }
        }
    }

    private void deleteFromCFA(Map<UUID, Collection<IShareable>> shareablesByComponent, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(shareablesByComponent.size() * 100));
        String action = this.deleteContent ? Messages.DeleteOperation_SubProgressActionName : Messages.DeleteOperation_SubProgressActionNameAlt;
        int i = 0;
        for (Collection<IShareable> shareables : shareablesByComponent.values()) {
            ++i;
            final SubMonitor subProgress = progress.newChild(100);
            subProgress.setWorkRemaining(shareables.size() * 50);
            for (IShareable shareable : shareables) {
                IPath path = shareable.getLocalFullPath();
                subProgress.setTaskName(NLS.bind((String)Messages.DeleteOperation_ActionNumbers, (Object[])new Object[]{action, path, i, this.totalToDelete}));
                try {
                    ((Shareable)shareable).forget((IProgressMonitor)subProgress.newChild(25));
                    if (!this.deleteContent || !(shareable instanceof ShareableResource)) continue;
                    final IResource resource = ((ShareableResource)shareable).getResource();
                    if (resource.getType() == 4) {
                        ((IProject)resource).delete(true, true, (IProgressMonitor)subProgress.newChild(25));
                        continue;
                    }
                    if (resource.getType() == 2) {
                        SharingManager.getInstance().doSilentChange(new SharingManager.CoreRunnable(){

                            public void run() throws CoreException {
                                ((IFolder)resource).delete(true, true, (IProgressMonitor)subProgress.newChild(25));
                            }
                        });
                        continue;
                    }
                    if (resource.getType() != 1) continue;
                    SharingManager.getInstance().doSilentChange(new SharingManager.CoreRunnable(){

                        public void run() throws CoreException {
                            ((IFile)resource).delete(true, true, (IProgressMonitor)subProgress.newChild(25));
                        }
                    });
                }
                catch (FileSystemClientException e) {
                    this.collectStatus(FileSystemStatus.getStatusFor((int)4, (String)"com.ibm.team.filesystem.client", (int)0, (String)NLS.bind((String)Messages.DeleteOperation_ErrorFromClientDelete, (Object[])new Object[]{path}), (Throwable)e));
                }
                catch (CoreException e) {
                    this.collectStatus(FileSystemStatus.getStatusFor((int)4, (String)"com.ibm.team.filesystem.client", (int)0, (String)NLS.bind((String)Messages.DeleteOperation_ErrorFromFileSystemDelete, (Object[])new Object[]{path}), (Throwable)e));
                }
            }
            subProgress.done();
        }
    }

    private void prepareCommitArgs(IWorkspaceConnection connection, Map<UUID, Collection<IShareable>> shareablesForConnection, ArrayList<IChangeSetHandle> changeSets, ArrayList<Collection<? extends IWorkspaceConnection.IConfigurationOp>> configurationOps, SubMonitor progress) throws TeamRepositoryException {
        for (Map.Entry<UUID, Collection<IShareable>> shareablesByComponent : shareablesForConnection.entrySet()) {
            Collection<IShareable> shareables = shareablesByComponent.getValue();
            ArrayList<Object> configurationOpsForComponent = new ArrayList<Object>(shareables.size());
            for (IShareable shareable : shareables) {
                IVersionableHandle versionable = shareable.getRemote();
                if (versionable instanceof IFolderHandle) {
                    configurationOpsForComponent.add(connection.configurationOpFactory().deleteSubtree((IFolderHandle)versionable));
                    continue;
                }
                if (!(versionable instanceof IFileItemHandle)) continue;
                configurationOpsForComponent.add(connection.configurationOpFactory().delete(versionable));
            }
            if (progress.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (configurationOpsForComponent.isEmpty()) continue;
            IComponentHandle componentHandle = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle((Object)connection, shareablesByComponent.getKey(), null);
            IChangeSetHandle cs = connection.getCurrentChangeSet(componentHandle);
            if (cs == null) {
                cs = connection.createChangeSet(componentHandle, Messages.DeleteOperation_2, true, (IProgressMonitor)progress.newChild(1));
            }
            changeSets.add(cs);
            configurationOps.add(configurationOpsForComponent);
        }
    }
}

