/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingManager;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.ApplyAcceptedDilemmaHandler;
import com.ibm.team.filesystem.client.operations.DilemmaHandler;
import com.ibm.team.filesystem.client.operations.IFileSystemOperation;
import com.ibm.team.filesystem.client.operations.IShareOutOfSync;
import com.ibm.team.filesystem.client.operations.MarkAsMergedDilemmaHandler;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ILogicalChange;
import com.ibm.team.filesystem.common.ILogicalConflict;
import com.ibm.team.filesystem.common.ILogicalConflictReport;
import com.ibm.team.filesystem.rcp.core.IEclipseFileSystemManager;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.operations.EclipseWorkspaceApplyAcceptedOperation;
import com.ibm.team.filesystem.rcp.core.internal.operations.EclipseWorkspaceMarkAsMergedOperation;
import com.ibm.team.filesystem.rcp.core.internal.operations.FailedAutoResolveRequest;
import com.ibm.team.filesystem.rcp.core.internal.operations.merge.FileContentMerger;
import com.ibm.team.filesystem.rcp.core.internal.resources.ShareableResource;
import com.ibm.team.filesystem.rcp.core.operations.AutoResolveConflictsDilemmaHandler;
import com.ibm.team.filesystem.rcp.core.operations.ChangePropertiesDilemmaHandler;
import com.ibm.team.filesystem.rcp.core.operations.EclipseWorkspaceVerifySharesOperation;
import com.ibm.team.filesystem.rcp.core.operations.IAutoResolveConflictsOperation;
import com.ibm.team.filesystem.rcp.core.operations.IChangeFilePropertiesOperation;
import com.ibm.team.filesystem.rcp.core.operations.IChangePropertiesRequest;
import com.ibm.team.filesystem.rcp.core.operations.IFailedAutoResolveRequest;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.LineDelimiter;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IItemConflictReport;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseWorkspaceAutoResolveOperation
extends FileSystemOperation
implements IAutoResolveConflictsOperation {
    private final AutoResolveConflictsDilemmaHandler problemHandler;
    private ApplyAcceptedDilemmaHandler applyAcceptedDilemmaHandler;
    private MarkAsMergedDilemmaHandler markAsMergedDilemmaHandler;
    private ChangePropertiesDilemmaHandler changePropertiesDilemmaHandler;
    private OutOfSyncDilemmaHandler outOfSyncDilemmaHandler;
    private int conflictsResolvedCount;
    private final HashMap<UUID, HashMap<ILogicalConflictReport, List<AutoResolveRequest>>> contentConflicts;
    private final HashMap<UUID, HashMap<ILogicalConflictReport, List<AutoResolveRequest>>> autoMergeableConflicts;

    public EclipseWorkspaceAutoResolveOperation(AutoResolveConflictsDilemmaHandler dilemmaHandler) {
        super((DilemmaHandler)(dilemmaHandler == null ? AutoResolveConflictsDilemmaHandler.getDefault() : dilemmaHandler));
        this.problemHandler = dilemmaHandler == null ? AutoResolveConflictsDilemmaHandler.getDefault() : dilemmaHandler;
        this.applyAcceptedDilemmaHandler = this.problemHandler.getApplyAcceptedDilemmaHandler();
        if (this.problemHandler.getApplyAcceptedDilemmaHandler() == null) {
            this.applyAcceptedDilemmaHandler = ApplyAcceptedDilemmaHandler.getDefault();
        }
        this.markAsMergedDilemmaHandler = this.problemHandler.getMarkAsMergedDilemmaHandler();
        if (this.markAsMergedDilemmaHandler == null) {
            this.markAsMergedDilemmaHandler = MarkAsMergedDilemmaHandler.getDefault();
        }
        this.changePropertiesDilemmaHandler = this.problemHandler.getChangePropertiesDilemmaHandler();
        if (this.changePropertiesDilemmaHandler == null) {
            this.changePropertiesDilemmaHandler = ChangePropertiesDilemmaHandler.getDefault();
        }
        this.outOfSyncDilemmaHandler = this.problemHandler.getOutOfSyncDilemmaHandler();
        if (this.outOfSyncDilemmaHandler == null) {
            this.outOfSyncDilemmaHandler = OutOfSyncDilemmaHandler.getDefault();
        }
        this.contentConflicts = new HashMap();
        this.autoMergeableConflicts = new HashMap();
    }

    protected void execute(IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        final Collection<ConfigurationDescriptor> affectedConfigurations = this.getAffectedConfigurations();
        FlowNodeLock workspaceLock = WorkspaceLockUtil.acquireWrite(affectedConfigurations);
        try {
            try {
                final TeamRepositoryException[] teamRepositoryExceptions = new TeamRepositoryException[1];
                ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                        try {
                            if (EclipseWorkspaceAutoResolveOperation.this.verifyInSyncEnabled() && !EclipseWorkspaceAutoResolveOperation.this.outOfSyncDilemmaHandler.willIgnoreAllSharesOutOfSync()) {
                                EclipseWorkspaceVerifySharesOperation verifyOp = new EclipseWorkspaceVerifySharesOperation(EclipseWorkspaceAutoResolveOperation.this.outOfSyncDilemmaHandler);
                                for (ConfigurationDescriptor configuration : affectedConfigurations) {
                                    verifyOp.addToVerify(configuration.getConnection(null), configuration.componentHandle);
                                }
                                verifyOp.run((IProgressMonitor)progress.newChild(10));
                            }
                            EclipseWorkspaceAutoResolveOperation.this.conflictsResolvedCount = EclipseWorkspaceAutoResolveOperation.this.performAutoMerge((IProgressMonitor)progress.newChild(90));
                        }
                        catch (TeamRepositoryException e) {
                            teamRepositoryExceptions[0] = e;
                        }
                    }
                }, monitor);
                if (teamRepositoryExceptions[0] != null) {
                    throw teamRepositoryExceptions[0];
                }
            }
            catch (FileSystemClientException e) {
                throw e;
            }
            catch (CoreException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor((Throwable)e));
            }
        }
        finally {
            WorkspaceLockUtil.release((FlowNodeLock)workspaceLock);
        }
    }

    private Collection<ConfigurationDescriptor> getAffectedConfigurations() throws FileSystemClientException {
        HashSet<ConfigurationDescriptor> configurations = new HashSet<ConfigurationDescriptor>();
        this.getAffectedConfigurations(this.contentConflicts, configurations);
        this.getAffectedConfigurations(this.autoMergeableConflicts, configurations);
        return configurations;
    }

    private void getAffectedConfigurations(HashMap<UUID, HashMap<ILogicalConflictReport, List<AutoResolveRequest>>> requests, HashSet<ConfigurationDescriptor> configurations) {
        for (HashMap<ILogicalConflictReport, List<AutoResolveRequest>> requestByContext : requests.values()) {
            for (List<AutoResolveRequest> requestByReport : requestByContext.values()) {
                for (AutoResolveRequest request : requestByReport) {
                    configurations.add(request.getAffectedConfiguation());
                }
            }
        }
    }

    @Override
    public int numberOfConflictsResolved() {
        return this.conflictsResolvedCount;
    }

    private int performAutoMerge(IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.contentConflicts.size() + this.autoMergeableConflicts.size()));
        int mergeCount = 0;
        mergeCount += this.performStructuralAutoMerge((IProgressMonitor)progress.newChild(this.autoMergeableConflicts.size()));
        for (HashMap<ILogicalConflictReport, List<AutoResolveRequest>> requestsByContext : this.contentConflicts.values()) {
            SubMonitor itemProgress;
            SubMonitor contextProgress = progress.newChild(1);
            ArrayList<IFileItemHandle> toFetch = new ArrayList<IFileItemHandle>();
            ArrayList<IFolderHandle> foldersToFetch = new ArrayList<IFolderHandle>();
            IWorkspaceConnection wc = null;
            int workRemaining = 0;
            for (List<AutoResolveRequest> requests : requestsByContext.values()) {
                for (AutoResolveRequest request : requests) {
                    if (wc == null) {
                        wc = request.connection;
                    }
                    if (request.getCommonAncestorState() instanceof IFileItemHandle) {
                        toFetch.add((IFileItemHandle)request.getCommonAncestorState());
                    }
                    if (request.getProposedContributorState() instanceof IFileItemHandle) {
                        toFetch.add((IFileItemHandle)request.getProposedContributorState());
                    }
                    if (this.isQualifyingFolderAddAddConflict(request.logicalChange)) {
                        IFolderHandle handle = (IFolderHandle)request.getCommonAncestorState();
                        if (handle != null) {
                            foldersToFetch.add(handle);
                        }
                        if ((handle = (IFolderHandle)request.getProposedContributorState()) != null) {
                            foldersToFetch.add(handle);
                        }
                        if ((handle = (IFolderHandle)request.getSelectedContributorState()) != null) {
                            foldersToFetch.add(handle);
                        }
                    }
                    ++workRemaining;
                }
            }
            contextProgress.setWorkRemaining(workRemaining * 3);
            Map<UUID, IVersionable> fetched = this.fetchItems(wc, toFetch, foldersToFetch, (IProgressMonitor)progress.newChild(workRemaining));
            ArrayList<FailedAutoResolveRequest> unknownTypes = new ArrayList<FailedAutoResolveRequest>();
            ArrayList<FailedAutoResolveRequest> itemsWithNoHandlers = new ArrayList<FailedAutoResolveRequest>();
            HashMap<ILogicalConflictReport, List<ILogicalChange>> resolvedConflicts = new HashMap<ILogicalConflictReport, List<ILogicalChange>>();
            for (Map.Entry<ILogicalConflictReport, List<AutoResolveRequest>> entry : requestsByContext.entrySet()) {
                ArrayList<ILogicalChange> resolvedItems = new ArrayList<ILogicalChange>();
                resolvedConflicts.put(entry.getKey(), resolvedItems);
                for (AutoResolveRequest autoResolveRequest : entry.getValue()) {
                    IVersionable proposedItem;
                    itemProgress = contextProgress.newChild(1).setWorkRemaining(100);
                    IVersionableHandle commonAncestor = autoResolveRequest.getCommonAncestorState();
                    IVersionableHandle proposed = autoResolveRequest.getProposedContributorState();
                    if (proposed == null) continue;
                    IVersionable commonAncestorItem = null;
                    if (commonAncestor != null) {
                        commonAncestorItem = fetched.get(commonAncestor.getStateId());
                    }
                    if ((proposedItem = fetched.get(proposed.getStateId())) == null) continue;
                    try {
                        ISharingManager sharingManager = FileSystemCore.getSharingManager();
                        IShareable shareable = sharingManager.findShareable(sharingManager.getDefaultCFARoot(), autoResolveRequest.logicalChange.item(), ((AutoResolveRequest)autoResolveRequest).configurationDescriptor.componentHandle, autoResolveRequest.connection.getContextHandle(), (IProgressMonitor)itemProgress.newChild(5));
                        if (!(shareable instanceof ShareableResource)) continue;
                        IResource resource = ((ShareableResource)shareable).getResource();
                        if (resource instanceof IProject || resource instanceof IFolder) {
                            if (!this.isQualifyingFolderAddAddConflict(autoResolveRequest.logicalChange)) continue;
                            boolean success = false;
                            IVersionable selectedItem = fetched.get(autoResolveRequest.getSelectedContributorState().getStateId());
                            if (selectedItem != null && selectedItem.getName().equals(proposedItem.getName()) && resource.getName().equals(proposedItem.getName()) && selectedItem.getParent().sameItemId((IItemHandle)proposedItem.getParent())) {
                                if (resource instanceof IFolder) {
                                    if (proposedItem.getParent().sameItemId((IItemHandle)((ShareableResource)shareable).getFileStorage().getParent().getRemote())) {
                                        success = true;
                                    }
                                } else {
                                    success = true;
                                }
                            }
                            if (!success) continue;
                            resolvedItems.add(autoResolveRequest.logicalChange);
                            continue;
                        }
                        if (!(resource instanceof IFile)) continue;
                        AutoResolveState resolveState = new AutoResolveState();
                        resolveState.executableMerged = this.performExecutablePropertyMerge((IFileItem)commonAncestorItem, (IFileItem)proposedItem, shareable, (IProgressMonitor)itemProgress.newChild(1));
                        IFile file = (IFile)resource;
                        resolveState.propertiesMerged = this.performPropertyAutoMerge((IFileItem)commonAncestorItem, (IFileItem)proposedItem, file, itemProgress.newChild(5));
                        if (autoResolveRequest.logicalChange.isChangeType(4) && !autoResolveRequest.logicalChange.isModificationChange(4)) {
                            resolveState.contentMerged = true;
                        }
                        if (!autoResolveRequest.logicalChange.isChangeType(1)) {
                            resolveState.addMerged = true;
                        }
                        if (!(!resolveState.propertiesMerged || resolveState.contentMerged && resolveState.addMerged)) {
                            IStatus status = FileContentMerger.performAutoMerge(wc.teamRepository(), (IFileItem)commonAncestorItem, (IFileItem)proposedItem, file, null, itemProgress.newChild(90));
                            if (status.isOK()) {
                                resolveState.contentMerged = true;
                            } else if (status.getCode() == 1002) {
                                unknownTypes.add(new FailedAutoResolveRequest(autoResolveRequest, shareable, true, resolveState));
                            } else if (status.getCode() == 1001) {
                                itemsWithNoHandlers.add(new FailedAutoResolveRequest(autoResolveRequest, shareable, true, resolveState));
                            }
                        }
                        if (this.isQualifyingAddAddChange(autoResolveRequest.logicalChange) && proposedItem.getName().equals(file.getName()) && proposedItem.getParent().sameItemId((IItemHandle)((ShareableResource)shareable).getFileStorage().getParent().getRemote())) {
                            resolveState.addMerged = true;
                        }
                        if (!resolveState.isMerged()) continue;
                        resolvedItems.add(autoResolveRequest.logicalChange);
                    }
                    catch (Exception e) {
                        this.collectStatus(FileSystemStatus.getStatusFor((Throwable)e));
                    }
                }
            }
            if (!itemsWithNoHandlers.isEmpty() || !unknownTypes.isEmpty()) {
                FailedAutoResolveRequest failedRequest;
                int n = this.problemHandler.missingStorageMerger(Collections.unmodifiableCollection(unknownTypes), Collections.unmodifiableCollection(itemsWithNoHandlers));
                if (n == 2) {
                    throw new FileSystemClientException((IStatus)new FileSystemStatus(4, Messages.EclipseWorkspaceAutoResolveOperation_0));
                }
                if (n == 1) {
                    throw new OperationCanceledException();
                }
                ITeamRepository teamRepository = wc.teamRepository();
                for (IFailedAutoResolveRequest iFailedAutoResolveRequest : unknownTypes) {
                    itemProgress = contextProgress.newChild(1).setWorkRemaining(100);
                    failedRequest = (FailedAutoResolveRequest)iFailedAutoResolveRequest;
                    if (!failedRequest.isRetryMerge()) continue;
                    this.retryMerge(teamRepository, failedRequest, fetched, resolvedConflicts, itemProgress);
                }
                for (IFailedAutoResolveRequest iFailedAutoResolveRequest : itemsWithNoHandlers) {
                    itemProgress = contextProgress.newChild(1).setWorkRemaining(100);
                    failedRequest = (FailedAutoResolveRequest)iFailedAutoResolveRequest;
                    if (!failedRequest.isRetryMerge()) continue;
                    this.retryMerge(teamRepository, failedRequest, fetched, resolvedConflicts, itemProgress);
                }
            }
            contextProgress.setWorkRemaining(resolvedConflicts.size());
            for (Map.Entry<Object, List<AutoResolveRequest>> entry : resolvedConflicts.entrySet()) {
                try {
                    EclipseWorkspaceMarkAsMergedOperation eclipseWorkspaceMarkAsMergedOperation = new EclipseWorkspaceMarkAsMergedOperation(wc, (ILogicalConflictReport)entry.getKey(), entry.getValue(), this.markAsMergedDilemmaHandler);
                    this.disableVerifyInSync((IFileSystemOperation)eclipseWorkspaceMarkAsMergedOperation);
                    eclipseWorkspaceMarkAsMergedOperation.run((IProgressMonitor)contextProgress.newChild(1));
                    mergeCount += entry.getValue().size();
                }
                catch (Exception exception) {
                    this.collectStatus(FileSystemStatus.getStatusFor((Throwable)exception));
                }
            }
        }
        return mergeCount;
    }

    private boolean isQualifyingFolderAddAddConflict(ILogicalChange change) {
        return change.item() instanceof IFolderHandle && this.isQualifyingAddAddChange(change);
    }

    private boolean isQualifyingAddAddChange(ILogicalChange change) {
        IVersionableHandle versionableConflictedWith;
        ILogicalConflict conflict;
        return change.kind() == 1 && ((ILogicalConflict)change).conflictType() == 1 && (conflict = (ILogicalConflict)change).conflictingItems().size() == 1 && (versionableConflictedWith = (IVersionableHandle)conflict.conflictingItems().iterator().next()).sameItemId((IItemHandle)conflict.item());
    }

    private boolean performExecutablePropertyMerge(IFileItem commonAncestorItem, IFileItem proposedItem, IShareable selectedItem, IProgressMonitor progress) {
        if (proposedItem.isExecutable() == ((Shareable)selectedItem).getFileStorage().isExecutable()) {
            return true;
        }
        if (commonAncestorItem == null) {
            return false;
        }
        if (proposedItem.isExecutable() == commonAncestorItem.isExecutable()) {
            return true;
        }
        return ((Shareable)selectedItem).getFileStorage().setExecutable(proposedItem.isExecutable(), progress);
    }

    private void retryMerge(ITeamRepository teamRepository, FailedAutoResolveRequest request, Map<UUID, IVersionable> fetched, HashMap<ILogicalConflictReport, List<ILogicalChange>> resolvedConflicts, SubMonitor itemProgress) {
        AutoResolveRequest modModConflict = request.getRequest();
        IVersionableHandle commonAncestor = modModConflict.getCommonAncestorState();
        IVersionableHandle proposed = modModConflict.getProposedContributorState();
        if (!(modModConflict.logicalChange.item() instanceof IFileItemHandle)) {
            return;
        }
        IFileItem commonAncestorItem = (IFileItem)fetched.get(commonAncestor.getStateId());
        IFileItem proposedItem = (IFileItem)fetched.get(proposed.getStateId());
        if (proposedItem == null) {
            return;
        }
        try {
            IFile file;
            IStatus status;
            IResource resource;
            IShareable shareable = request.getConflictedShareable();
            if (shareable instanceof ShareableResource && (resource = ((ShareableResource)shareable).getResource()) instanceof IFile && (status = FileContentMerger.performAutoMerge(teamRepository, commonAncestorItem, proposedItem, file = (IFile)resource, request.getDefaultContentTypeMerger(), itemProgress.newChild(95))).isOK()) {
                request.getResolveState().contentMerged = true;
                if (request.getResolveState().isMerged()) {
                    List<ILogicalChange> resolvedItems = resolvedConflicts.get(modModConflict.conflictReport);
                    resolvedItems.add(modModConflict.logicalChange);
                }
            }
        }
        catch (Exception e) {
            this.collectStatus(FileSystemStatus.getStatusFor((Throwable)e));
        }
    }

    private int performStructuralAutoMerge(IProgressMonitor progress) {
        int mergeCount = 0;
        for (HashMap<ILogicalConflictReport, List<AutoResolveRequest>> requestByContext : this.autoMergeableConflicts.values()) {
            IWorkspaceConnection wc = null;
            for (Map.Entry<ILogicalConflictReport, List<AutoResolveRequest>> autoMergeable : requestByContext.entrySet()) {
                ILogicalConflictReport conflictReport = autoMergeable.getKey();
                ArrayList<ILogicalChange> conflictsToAutoResolve = new ArrayList<ILogicalChange>();
                for (AutoResolveRequest request : autoMergeable.getValue()) {
                    if (wc == null) {
                        wc = request.connection;
                    }
                    conflictsToAutoResolve.add(request.logicalChange);
                }
                try {
                    EclipseWorkspaceApplyAcceptedOperation op = new EclipseWorkspaceApplyAcceptedOperation(wc, conflictReport, conflictsToAutoResolve, this.applyAcceptedDilemmaHandler);
                    this.disableVerifyInSync((IFileSystemOperation)op);
                    op.run(progress);
                    mergeCount += conflictsToAutoResolve.size();
                }
                catch (Exception e) {
                    this.collectStatus(FileSystemStatus.getStatusFor((int)4, (String)Messages.EclipseWorkspaceAutoResolveOperation_1, (Throwable)e));
                }
            }
        }
        return mergeCount;
    }

    private Map<UUID, IVersionable> fetchItems(IWorkspaceConnection wc, List<IFileItemHandle> toFetch, ArrayList<IFolderHandle> foldersToFetch, IProgressMonitor progress) throws TeamRepositoryException {
        List fetched;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(toFetch.size() + foldersToFetch.size()));
        HashMap<UUID, IVersionable> result = new HashMap<UUID, IVersionable>();
        IWorkspaceManager manager = SCMPlatform.getWorkspaceManager((ITeamRepository)wc.teamRepository());
        if (!toFetch.isEmpty()) {
            fetched = manager.versionableManager().fetchCompleteStates(toFetch, (IProgressMonitor)monitor.newChild(toFetch.size()));
            for (IVersionable item : fetched) {
                result.put(item.getStateId(), item);
            }
        }
        if (!foldersToFetch.isEmpty()) {
            fetched = manager.versionableManager().fetchCompleteStates(foldersToFetch, (IProgressMonitor)monitor.newChild(foldersToFetch.size()));
            for (IVersionable item : fetched) {
                result.put(item.getStateId(), item);
            }
        }
        return result;
    }

    private boolean performPropertyAutoMerge(IFileItem commonAncestorItem, IFileItem proposedItem, IFile file, SubMonitor progress) throws FileSystemClientException, TeamRepositoryException {
        final boolean[] success = new boolean[]{true};
        ChangePropertiesDilemmaHandler changePropertiesDilemmaHandler = new ChangePropertiesDilemmaHandler(){

            public boolean willIgnoreAllSharesOutOfSync() {
                return true;
            }

            public int outOfSync(Collection<IShareOutOfSync> sharesOutOfSync) {
                return 0;
            }

            @Override
            public int inconsistentLineDelimiters(List<IChangePropertiesRequest> inconsistentDelimiters) {
                success[0] = false;
                return EclipseWorkspaceAutoResolveOperation.this.problemHandler.getChangePropertiesDilemmaHandler().inconsistentLineDelimiters(inconsistentDelimiters);
            }
        };
        IChangeFilePropertiesOperation op = null;
        IShareable shareableFile = (IShareable)file.getAdapter(IShareable.class);
        IContent proposedContent = proposedItem.getContent();
        IContent commonAncestorContent = null;
        if (commonAncestorItem != null) {
            commonAncestorContent = commonAncestorItem.getContent();
        }
        String currentContentType = shareableFile.getContentType();
        String proposedContentType = proposedContent.getContentType();
        String commonAncestorContentType = "";
        if (commonAncestorContent != null) {
            commonAncestorContentType = commonAncestorContent.getContentType();
        }
        if (!commonAncestorContentType.equals(proposedContentType)) {
            if (currentContentType == null || currentContentType.equals(commonAncestorContentType)) {
                op = IEclipseFileSystemManager.instance.getChangeFilePropertiesOperation(changePropertiesDilemmaHandler);
                op.setContentType(shareableFile, proposedContentType);
            } else if (!currentContentType.equals(proposedContentType)) {
                success[0] = false;
            }
        }
        LineDelimiter currentLineDelimiter = shareableFile.getLineDelimiter();
        LineDelimiter proposedLineDelimiter = proposedContent.getLineDelimiter();
        LineDelimiter commonAncestorLineDelimiter = null;
        if (commonAncestorContent != null) {
            commonAncestorLineDelimiter = commonAncestorContent.getLineDelimiter();
        }
        if (success[0] && commonAncestorLineDelimiter != proposedLineDelimiter) {
            if (currentLineDelimiter == null || currentLineDelimiter == commonAncestorLineDelimiter) {
                if (op == null) {
                    op = IEclipseFileSystemManager.instance.getChangeFilePropertiesOperation(changePropertiesDilemmaHandler);
                }
                op.setLineDelimiter(shareableFile, proposedLineDelimiter);
            } else if (currentLineDelimiter != proposedLineDelimiter) {
                success[0] = false;
            }
        }
        if (success[0] && op != null) {
            this.disableVerifyInSync(op);
            op.run((IProgressMonitor)progress.newChild(10));
        }
        return success[0];
    }

    @Override
    public void autoResolveConflict(IWorkspaceConnection connection, ILogicalConflictReport conflictReport, ILogicalChange logicalChange) {
        AutoResolveRequest request = new AutoResolveRequest(connection, conflictReport, logicalChange);
        if (request.isContentConflict()) {
            this.addRequest(this.contentConflicts, request);
        } else {
            this.addRequest(this.autoMergeableConflicts, request);
        }
    }

    private void addRequest(HashMap<UUID, HashMap<ILogicalConflictReport, List<AutoResolveRequest>>> requests, AutoResolveRequest request) {
        List<AutoResolveRequest> requestsForReport;
        IContextHandle context = request.getAffectedConfiguation().connectionHandle;
        HashMap<Object, List<AutoResolveRequest>> requestsForContext = requests.get(context.getItemId());
        if (requestsForContext == null) {
            requestsForContext = new HashMap();
            requests.put(context.getItemId(), requestsForContext);
            requestsForReport = new ArrayList<AutoResolveRequest>();
            requestsForContext.put(request.conflictReport, requestsForReport);
        } else {
            requestsForReport = requestsForContext.get(request.conflictReport);
            if (requestsForReport == null) {
                requestsForReport = new ArrayList<AutoResolveRequest>();
                requestsForContext.put(request.conflictReport, requestsForReport);
            }
        }
        requestsForReport.add(request);
    }

    public final class AutoResolveRequest {
        private final IItemConflictReport conflict;
        private final ILogicalChange logicalChange;
        private final ILogicalConflictReport conflictReport;
        private IWorkspaceConnection connection;
        private final ConfigurationDescriptor configurationDescriptor;

        public AutoResolveRequest(IWorkspaceConnection workspaceConnection, ILogicalConflictReport conflictReport, ILogicalChange logicalChange) {
            if (conflictReport == null) {
                throw new IllegalArgumentException();
            }
            if (logicalChange == null) {
                throw new IllegalArgumentException();
            }
            if (workspaceConnection == null) {
                throw new IllegalArgumentException();
            }
            IUpdateReport report = conflictReport.conflictReport();
            IItemConflictReport conflictFound = null;
            for (IItemConflictReport conflictedItem : report.conflicts()) {
                if (!conflictedItem.item().sameItemId((IItemHandle)logicalChange.item())) continue;
                conflictFound = conflictedItem;
            }
            if (conflictFound == null) {
                throw new IllegalArgumentException();
            }
            this.conflict = conflictFound;
            this.logicalChange = logicalChange;
            this.conflictReport = conflictReport;
            this.connection = workspaceConnection;
            this.configurationDescriptor = new ConfigurationDescriptor((IConnection)workspaceConnection, logicalChange.component());
        }

        public ConfigurationDescriptor getAffectedConfiguation() {
            return this.configurationDescriptor;
        }

        public IVersionableHandle getProposedContributorState() {
            return this.conflict.getProposedContributorState();
        }

        public IVersionableHandle getCommonAncestorState() {
            return this.conflict.getCommonAncestorState();
        }

        public IVersionableHandle getSelectedContributorState() {
            return this.conflict.getSelectedContributorState();
        }

        public boolean isContentConflict() {
            return this.logicalChange == null || this.logicalChange.kind() != 2;
        }
    }

    public final class AutoResolveState {
        boolean executableMerged = false;
        boolean propertiesMerged = false;
        boolean contentMerged = false;
        boolean addMerged = false;

        boolean isMerged() {
            return this.executableMerged && this.propertiesMerged && this.contentMerged && this.addMerged;
        }
    }
}

