/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.operations;

import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeSetChooser {
    private final IWorkspaceConnection workspace;
    private final Collection<IAuditable> determinants;
    private HashMap<UUID, HashMap<UUID, IChangeSetHandle>> openChangeSets;
    private HashMap<UUID, IChangeSetHandle> defaultCS;
    private HashMap<UUID, IChangeSetHandle> changeSetsToCommit;
    private HashMap<UUID, List<IWorkspaceConnection.IConfigurationOp>> changesToCommit;
    private HashMap<UUID, String> changeSetComments;
    private HashMap<UUID, List<IWorkspaceConnection.IConfigurationOp>> newChangesToCommit;

    public ChangeSetChooser(IWorkspaceConnection workspace, Collection<IAuditable> determinants) {
        this.workspace = workspace;
        this.determinants = determinants == null ? new ArrayList<IAuditable>() : determinants;
        this.changeSetsToCommit = new HashMap();
        this.changesToCommit = new HashMap();
        this.changeSetComments = new HashMap();
        this.newChangesToCommit = new HashMap();
        this.openChangeSets = new HashMap();
        this.defaultCS = new HashMap();
    }

    private void init(IComponentHandle component, IProgressMonitor progress) throws TeamRepositoryException {
        HashMap<UUID, IChangeSetHandle> openChangeSetsForComponent = this.openChangeSets.get(component.getItemId());
        if (openChangeSetsForComponent == null) {
            openChangeSetsForComponent = this.getOpenChangeSets(component, progress);
            this.openChangeSets.put(component.getItemId(), openChangeSetsForComponent);
            this.defaultCS.put(component.getItemId(), this.workspace.getCurrentChangeSet(component));
        }
    }

    private HashMap<UUID, IChangeSetHandle> getOpenChangeSets(IComponentHandle component, IProgressMonitor progress) throws TeamRepositoryException {
        HashMap<UUID, IChangeSetHandle> result = new HashMap<UUID, IChangeSetHandle>();
        List activeCS = this.workspace.activeChangeSets(component);
        if (!activeCS.isEmpty()) {
            List changeSets = this.workspace.teamRepository().itemManager().fetchCompleteItems(activeCS, 0, progress);
            this.determinants.addAll(changeSets);
            for (IChangeSet changeSet : changeSets) {
                for (IChange change : changeSet.changes()) {
                    result.put(change.item().getItemId(), (IChangeSetHandle)changeSet);
                }
            }
        }
        return result;
    }

    public IChangeSetHandle getBestChangeSet(IComponentHandle component, IVersionableHandle changedItem, IChangeSetHandle preferredChangeSet, IProgressMonitor progress) throws TeamRepositoryException {
        IChangeSetHandle result = preferredChangeSet;
        if (result == null) {
            this.init(component, progress);
            result = this.openChangeSets.get(component.getItemId()).get(changedItem.getItemId());
            if (result == null) {
                result = this.defaultCS.get(component.getItemId());
            }
        }
        return result;
    }

    public void toCommit(IComponentHandle component, IVersionableHandle versionable, IWorkspaceConnection.IConfigurationOp op, IChangeSetHandle preferredChangeSet, String newChangeSetComment, IProgressMonitor progress) throws TeamRepositoryException {
        List<IWorkspaceConnection.IConfigurationOp> configurationOps;
        IChangeSetHandle bestChangeSet = this.getBestChangeSet(component, versionable, preferredChangeSet, progress);
        if (bestChangeSet != null) {
            UUID key = bestChangeSet.getItemId();
            this.changeSetsToCommit.put(key, bestChangeSet);
            configurationOps = this.changesToCommit.get(key);
            if (configurationOps == null) {
                configurationOps = new ArrayList<IWorkspaceConnection.IConfigurationOp>();
                this.changesToCommit.put(key, configurationOps);
            }
        } else {
            if (newChangeSetComment != null) {
                this.changeSetComments.put(component.getItemId(), newChangeSetComment);
            }
            if ((configurationOps = this.newChangesToCommit.get(component.getItemId())) == null) {
                configurationOps = new ArrayList<IWorkspaceConnection.IConfigurationOp>();
                this.newChangesToCommit.put(component.getItemId(), configurationOps);
            }
        }
        configurationOps.add(op);
    }

    public IUpdateReport commit(IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(10 * this.newChangesToCommit.size() + 100));
        for (Map.Entry<UUID, List<IWorkspaceConnection.IConfigurationOp>> entry : this.newChangesToCommit.entrySet()) {
            String csComment = this.changeSetComments.get(entry.getKey());
            if (csComment == null) {
                csComment = "";
            }
            IChangeSetHandle cs = this.workspace.createChangeSet((IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(entry.getKey(), null), csComment, true, (IProgressMonitor)progress.newChild(10));
            this.changeSetsToCommit.put(cs.getItemId(), cs);
            this.changesToCommit.put(cs.getItemId(), entry.getValue());
        }
        this.newChangesToCommit.clear();
        this.changeSetComments.clear();
        ArrayList<IChangeSetHandle> changeSets = new ArrayList<IChangeSetHandle>(this.changesToCommit.size());
        ArrayList<Collection> ops = new ArrayList<Collection>(this.changesToCommit.size());
        for (Map.Entry<UUID, List<IWorkspaceConnection.IConfigurationOp>> entry : this.changesToCommit.entrySet()) {
            IChangeSetHandle cs = this.changeSetsToCommit.get(entry.getKey());
            changeSets.add(cs);
            ops.add(entry.getValue());
        }
        this.changeSetsToCommit.clear();
        this.changesToCommit.clear();
        return this.workspace.commit(changeSets, ops, (IProgressMonitor)progress.newChild(100));
    }
}

