/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.Share;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeTracker;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.operations.EclipseWorkspaceUpdateOperation;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.LineDelimiter;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CancelRemoteChangesOperation {
    List<Cancelable> toCancel = new LinkedList<Cancelable>();
    private final IRepositoryResolver resolver;

    public CancelRemoteChangesOperation(IRepositoryResolver resolver) {
        this.resolver = resolver;
    }

    public CancelRemoteChangesOperation() {
        this(null);
    }

    public void execute(IProgressMonitor progress) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (String)Messages.CancelRemoteChangesOperation_0, (int)2);
        this.cancelChanges(monitor.newChild(1));
        this.refreshFilesystem(monitor.newChild(1));
        monitor.done();
    }

    private void cancelChanges(SubMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        monitor.beginTask(Messages.CancelRemoteChangesOperation_0, 100);
        HashMap groupedIgnoreables = new HashMap();
        for (Cancelable cancelable : this.toCancel) {
            IWorkspaceConnection connection;
            if (!cancelable.shouldCancelChange() || (connection = cancelable.getConnection()) == null) continue;
            if (!groupedIgnoreables.containsKey(connection)) {
                groupedIgnoreables.put(connection, new ArrayList(1));
            }
            ((List)groupedIgnoreables.get(connection)).add(cancelable);
        }
        try {
            for (Map.Entry entry : groupedIgnoreables.entrySet()) {
                this.cancelChange((IWorkspaceConnection)entry.getKey(), (List)entry.getValue(), monitor.newChild(1));
            }
        }
        finally {
            monitor.done();
        }
    }

    private void cancelChange(IWorkspaceConnection connection, List<Cancelable> ignoreables, SubMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        if (connection == null) {
            throw new IllegalArgumentException("Connection may not be null");
        }
        monitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(ignoreables.size() * 6));
        monitor.setTaskName(Messages.CancelRemoteChangesOperation_0);
        HashMap<UUID, IChangeSetHandle> uuidToChangeSetHandle = new HashMap<UUID, IChangeSetHandle>();
        HashMap changes = new HashMap();
        HashMap<IPath, ShareableProperties> props = new HashMap<IPath, ShareableProperties>();
        for (Cancelable cancelable : ignoreables) {
            ShareableProperties sp;
            IShareable shareable = cancelable.getShareable((IProgressMonitor)monitor.newChild(1));
            if (shareable != null) {
                this.cancelPendingChanges(shareable);
            }
            if (!cancelable.shouldCancelChange()) continue;
            ChangeSetUndoList undo = cancelable.getUndoList(monitor.newChild(1));
            if (undo.handle == null) continue;
            this.ensureActive(connection, cancelable, undo, monitor.newChild(1));
            IChangeSetHandle handle = (IChangeSetHandle)uuidToChangeSetHandle.get(undo.handle.getItemId());
            if (handle == null) {
                handle = undo.handle;
                uuidToChangeSetHandle.put(handle.getItemId(), handle);
            }
            if (!changes.containsKey(handle)) {
                changes.put(handle, new ArrayList());
            }
            ((List)changes.get(handle)).addAll(undo.toUndo);
            if (shareable == null || (sp = ShareableProperties.create(shareable)) == null) continue;
            props.put(shareable.getLocalFullPath(), sp);
        }
        ArrayList<IChangeSetHandle> changeSets = new ArrayList<IChangeSetHandle>(changes.size());
        ArrayList configOps = new ArrayList(changes.size());
        for (Map.Entry entry : changes.entrySet()) {
            changeSets.add((IChangeSetHandle)entry.getKey());
            ArrayList<IWorkspaceConnection.IUndoOp> ops = new ArrayList<IWorkspaceConnection.IUndoOp>(((List)entry.getValue()).size());
            configOps.add(ops);
            for (IVersionableHandle toUndo : (List)entry.getValue()) {
                ops.add(connection.configurationOpFactory().undo(toUndo));
            }
        }
        if (!changeSets.isEmpty()) {
            IUpdateReport updateReport = connection.commit(changeSets, configOps, (IProgressMonitor)monitor.newChild(ignoreables.size()));
            this.processUndoUpdates(connection, ignoreables, updateReport, monitor.newChild(ignoreables.size()));
            for (Cancelable cancelable : ignoreables) {
                ShareableProperties sp;
                IShareable shareable = cancelable.getShareable((IProgressMonitor)monitor.newChild(1));
                if (shareable == null || (sp = (ShareableProperties)props.get(shareable.getLocalFullPath())) == null) continue;
                this.unsetLocalModificationStamp(shareable, sp, monitor.newChild(1));
            }
        }
        monitor.done();
    }

    private void unsetLocalModificationStamp(IShareable shareable, ShareableProperties props, SubMonitor monitor) throws FileSystemClientException {
        SharingManager sm = SharingManager.getInstance();
        FileItemInfo oldInfo = sm.getItemInfo(shareable);
        if (oldInfo == null) {
            return;
        }
        FileItemInfo newInfo = new FileItemInfo(oldInfo.getVersionableHandle(), -1L, oldInfo.getParent(), oldInfo.getName(), oldInfo.getHash(), oldInfo.getContentLength(), oldInfo.getOriginalLineDelimiter(), props.currentLineDelim, oldInfo.getOriginalContentType(), props.contentType, oldInfo.getStoredContentId(), oldInfo.getStoredDeltaPredecessor(), oldInfo.getStoredSize(), props.encoding, oldInfo.getStoredChecksum(), oldInfo.getStoredNumLineDelimiters(), props.executable, oldInfo.isOriginalExecutable());
        sm.setItemInfo(shareable, newInfo, (IProgressMonitor)monitor);
    }

    private void processUndoUpdates(IWorkspaceConnection connection, List<Cancelable> cancelables, IUpdateReport updateReport, SubMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        EclipseWorkspaceUpdateOperation op = new EclipseWorkspaceUpdateOperation(connection, Collections.singletonList(updateReport), 3, null);
        HashSet<UUID> toIgnore = new HashSet<UUID>(1);
        for (Cancelable ignoreable : cancelables) {
            toIgnore.add(ignoreable.getUUID());
        }
        op.setIgnoreList(toIgnore);
        op.run((IProgressMonitor)monitor);
    }

    private void ensureActive(IWorkspaceConnection connection, Cancelable ignoreable, ChangeSetUndoList undo, SubMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        List activeChangeSets = connection.activeChangeSets(undo.component);
        for (IChangeSetHandle active : activeChangeSets) {
            if (!active.sameItemId((IItemHandle)undo.handle)) continue;
            return;
        }
        IShareable shareable = ignoreable.getShareable((IProgressMonitor)(monitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1)));
        String path = shareable == null ? Messages.CancelRemoteChangesOperation_6 : shareable.getLocalFullPath().toString();
        throw new FileSystemClientException((IStatus)new Status(4, "com.ibm.team.filesystem.rcp.core", NLS.bind((String)Messages.CancelRemoteChangesOperation_3, (Object[])new Object[]{path})));
    }

    private void cancelPendingChanges(IShareable shareable) throws FileSystemClientException {
        LocalChangeTracker tracker = ((Share)shareable.getShare()).getTracker();
        tracker.cancelChanges(shareable);
    }

    private void refreshFilesystem(SubMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        monitor.beginTask(Messages.CancelRemoteChangesOperation_4, this.toCancel.size() * 2);
        for (Cancelable cancelable : this.toCancel) {
            Collection<IShareable> toRefresh = cancelable.getRefreshShareables((IProgressMonitor)monitor.newChild(1));
            SubMonitor ignoreableMon = monitor.newChild(1);
            try {
                ignoreableMon.beginTask(null, toRefresh.size());
                for (IShareable shareable : toRefresh) {
                    ((Share)shareable.getShare()).refreshChanges(shareable, (IProgressMonitor)monitor.newChild(1));
                }
            }
            finally {
                ignoreableMon.done();
            }
        }
        monitor.done();
    }

    public void addCancelable(IWorkspaceConnection conn, IShareable shareable) {
        if (shareable.getRemote() == null) {
            this.toCancel.add(new CancelablePendingShareable(conn, shareable));
        } else {
            this.toCancel.add(new CancelableVersionedShareable(this.resolver, conn, shareable));
        }
    }

    public void addCancelables(List<? extends Cancelable> toCancel) {
        this.toCancel.addAll(toCancel);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Cancelable {
        public boolean shouldCancelChange();

        public IWorkspaceConnection getConnection();

        public IShareable getShareable(IProgressMonitor var1) throws FileSystemClientException, TeamRepositoryException;

        public ChangeSetUndoList getUndoList(SubMonitor var1) throws TeamRepositoryException;

        public UUID getUUID();

        public Collection<IShareable> getRefreshShareables(IProgressMonitor var1) throws FileSystemClientException, TeamRepositoryException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CancelablePendingShareable
    implements Cancelable {
        private IShareable shareable;
        private IWorkspaceConnection connection;

        public CancelablePendingShareable(IWorkspaceConnection connection, IShareable shareable) {
            this.connection = connection;
            this.shareable = shareable;
        }

        @Override
        public IWorkspaceConnection getConnection() {
            return this.connection;
        }

        @Override
        public IShareable getShareable(IProgressMonitor mon) throws FileSystemClientException, TeamRepositoryException {
            return this.shareable;
        }

        @Override
        public UUID getUUID() {
            throw new UnsupportedOperationException("Must be committed");
        }

        @Override
        public ChangeSetUndoList getUndoList(SubMonitor monitor) throws TeamRepositoryException {
            throw new UnsupportedOperationException("Must be committed");
        }

        @Override
        public Collection<IShareable> getRefreshShareables(IProgressMonitor progress) throws FileSystemClientException, TeamRepositoryException {
            return Collections.singletonList(this.getShareable(progress));
        }

        @Override
        public boolean shouldCancelChange() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class CancelableVersionedShareable
    implements Cancelable {
        final IRepositoryResolver resolver;
        final IWorkspaceConnection wsConn;
        final IShareable shareable;
        final IVersionableHandle remote;

        public CancelableVersionedShareable(IRepositoryResolver resolver, final IWorkspaceConnection wsConn, IShareable shareable) {
            if (resolver == null) {
                resolver = new IRepositoryResolver(){

                    public ITeamRepository getRepoFor(String uri, UUID id) {
                        return wsConn.teamRepository();
                    }
                };
            }
            this.resolver = resolver;
            this.wsConn = wsConn;
            this.shareable = shareable;
            this.remote = shareable.getVersionable();
        }

        @Override
        public IWorkspaceConnection getConnection() {
            return this.wsConn;
        }

        @Override
        public Collection<IShareable> getRefreshShareables(IProgressMonitor newChild) {
            return Collections.singletonList(this.shareable);
        }

        @Override
        public IShareable getShareable(IProgressMonitor newChild) {
            return this.shareable;
        }

        @Override
        public UUID getUUID() {
            return this.shareable.getVersionable().getItemId();
        }

        @Override
        public ChangeSetUndoList getUndoList(SubMonitor monitor) throws TeamRepositoryException {
            Share share = (Share)this.shareable.getShare();
            IContextHandle cHandle = share.getSharingDescriptor().getConnectionHandle();
            IComponentHandle component = share.getSharingDescriptor().getComponent();
            ITeamRepository repo = this.resolver.getRepoFor(share.getSharingDescriptor().getRepositoryUri(), share.getSharingDescriptor().getRepositoryId());
            IWorkspaceManager wsMan = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
            IWorkspaceConnection connection = wsMan.getWorkspaceConnection((IWorkspaceHandle)cHandle, null);
            List changesets = connection.activeChangeSets();
            monitor.setWorkRemaining(changesets.size() + 10);
            monitor.subTask(Messages.CancelRemoteChangesOperation_5);
            IChangeSet changesetHandle = null;
            LinkedList<IVersionableHandle> toUndo = new LinkedList<IVersionableHandle>();
            block0: for (IChangeSetHandle csHandle : changesets) {
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                IChangeSet changeSet = (IChangeSet)connection.teamRepository().itemManager().fetchCompleteItem((IItemHandle)csHandle, 0, (IProgressMonitor)monitor.newChild(1));
                monitor.worked(1);
                for (IChange c : changeSet.changes()) {
                    if (!this.remote.getItemId().equals((Object)c.item().getItemId())) continue;
                    toUndo.add(c.item());
                    changesetHandle = changeSet;
                    continue block0;
                }
            }
            return new ChangeSetUndoList(component, (IChangeSetHandle)changesetHandle, (List<IVersionableHandle>)toUndo);
        }

        @Override
        public boolean shouldCancelChange() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeSetUndoList {
        public final IComponentHandle component;
        public final IChangeSetHandle handle;
        public final List<IVersionableHandle> toUndo;

        public ChangeSetUndoList(IComponentHandle component, IChangeSetHandle handle, List<IVersionableHandle> toUndo) {
            if (handle == null && !toUndo.isEmpty()) {
                throw new IllegalArgumentException("Cannot have an undo list without a change set");
            }
            if (component == null) {
                throw new IllegalArgumentException("component may not be null");
            }
            this.component = component;
            this.handle = handle;
            this.toUndo = toUndo;
        }
    }

    private static class ShareableProperties {
        private final boolean executable;
        private final LineDelimiter currentLineDelim;
        private final String encoding;
        private final String contentType;

        public static ShareableProperties create(IShareable shareable) {
            IShare share = shareable.getShare();
            assert (share != null);
            IVersionableHandle versionableHandle = shareable.getVersionable();
            if (versionableHandle == null) {
                return null;
            }
            FileItemInfo info = SharingManager.getInstance().getItemInfo(shareable);
            if (info == null) {
                return null;
            }
            return new ShareableProperties(info);
        }

        public ShareableProperties(FileItemInfo info) {
            this.executable = info.isExecutable();
            this.currentLineDelim = info.getLineDelimiter();
            this.encoding = info.getStoredEncoding();
            this.contentType = info.getContentType();
        }
    }
}

