/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.patches.ParsedPatch;
import com.ibm.team.filesystem.rcp.core.internal.patches.PatchResult;
import com.ibm.team.filesystem.rcp.core.patches.LocalFileOp;
import com.ibm.team.filesystem.rcp.core.patches.PatchModel;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceptHunksOperation {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int acceptHunks(final List<LocalFileOp> hunks, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        final int[] resolvedCount = new int[1];
        final TeamRepositoryException[] teamRepositoryExceptions = new TeamRepositoryException[1];
        final FileSystemClientException[] clientExceptions = new FileSystemClientException[1];
        final boolean[] finished = new boolean[1];
        final Object semaphore = new Object();
        final PatchModel model = PatchModel.getDefault();
        model.getRealm().asyncExec(new Runnable(){

            public void run() {
                final ParsedPatch parsedPatch = LocalFileOp.computePatch(hunks);
                Job newJob = new Job(Messages.AcceptHunksOperation_0){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void run(IProgressMonitor monitor) throws CoreException {
                                    block18: {
                                        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                                        try {
                                            final PatchResult result = parsedPatch.apply((IProgressMonitor)progress.newChild(100));
                                            int resolved = result.getSuccessfulOpCount();
                                            model.getRealm().asyncExec(new Runnable(){

                                                public void run() {
                                                    try {
                                                        for (LocalFileOp next : hunks) {
                                                            IStatus status = result.getResult(next.getFile().getVersionablePath(), next.getOp());
                                                            if (status == null) {
                                                                status = StatusUtil.newStatus((Object)this, (int)2, (String)Messages.AcceptHunksOperation_1);
                                                            }
                                                            if (status.isOK()) {
                                                                PatchModel.getDefault().removeHunk(next);
                                                                continue;
                                                            }
                                                            next.setStatus(status);
                                                        }
                                                    }
                                                    finally {
                                                        result.dispose();
                                                    }
                                                }
                                            });
                                            resolvedCount[0] = resolved;
                                        }
                                        catch (TeamRepositoryException e) {
                                            teamRepositoryExceptions[0] = e;
                                            parsedPatch.dispose();
                                            Object object = semaphore;
                                            synchronized (object) {
                                                finished[0] = true;
                                                semaphore.notifyAll();
                                                break block18;
                                            }
                                        }
                                        catch (FileSystemClientException e) {
                                            Object object;
                                            try {
                                                clientExceptions[0] = e;
                                                parsedPatch.dispose();
                                                object = semaphore;
                                            }
                                            catch (Throwable throwable) {
                                                parsedPatch.dispose();
                                                Object object2 = semaphore;
                                                synchronized (object2) {
                                                    finished[0] = true;
                                                    semaphore.notifyAll();
                                                }
                                                throw throwable;
                                            }
                                            synchronized (object) {
                                                finished[0] = true;
                                                semaphore.notifyAll();
                                                break block18;
                                            }
                                        }
                                        parsedPatch.dispose();
                                        Object object = semaphore;
                                        synchronized (object) {
                                            finished[0] = true;
                                            semaphore.notifyAll();
                                        }
                                    }
                                }
                            }, monitor);
                        }
                        catch (CoreException e) {
                            return e.getStatus();
                        }
                        return Status.OK_STATUS;
                    }
                };
                newJob.setUser(true);
                newJob.schedule();
            }
        });
        try {
            Object object = semaphore;
            synchronized (object) {
                if (!finished[0]) {
                    semaphore.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {}
        if (teamRepositoryExceptions[0] != null) {
            throw new TeamRepositoryException((Throwable)teamRepositoryExceptions[0]);
        }
        if (clientExceptions[0] != null) {
            throw new FileSystemClientException(StatusUtil.newStatus(AcceptHunksOperation.class, (Throwable)clientExceptions[0]));
        }
        return resolvedCount[0];
    }
}

