/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.changes.util.listeners;

import com.ibm.team.filesystem.rcp.core.internal.changes.util.ComponentSyncContext;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.client.util.IPropertyChangeEvent;
import java.util.List;

public class RepositoryListener
implements IListener {
    ComponentSyncContext model;
    ITeamRepository repo;

    public RepositoryListener(ComponentSyncContext model, ITeamRepository repo) {
        this.model = model;
        this.repo = repo;
        repo.addGenericListener((Object)"state", (IListener)this);
        repo.addGenericListener((Object)"error_state", (IListener)this);
    }

    public void dispose() {
        if (this.repo != null) {
            this.repo.removeGenericListener((Object)"state", (IListener)this);
            this.repo.removeGenericListener((Object)"error_state", (IListener)this);
        }
        this.model = null;
        this.repo = null;
    }

    public void handleEvents(List events) {
        if (this.model == null || this.model.isDisposed()) {
            return;
        }
        for (IPropertyChangeEvent event : events) {
            if (event.getProperty() != "state" && event.getProperty() != "error_state") continue;
            ITeamRepository server = (ITeamRepository)event.getObject();
            if (server.getState() == 1 && server.getErrorState() == 0) {
                this.model.setLoggedIn(true);
                continue;
            }
            this.model.setLoggedIn(false);
        }
    }
}

