/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.changes.util;

import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.common.ILogicalChange;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentConflictUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IConflictItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IUnresolvedFolder;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IUnresolvedItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IUnresolvedItemProvider;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IUnresolvedSource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.UnresolvedItemInfo;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ComponentSyncModel;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.UnresolvedFolder;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.UnresolvedItem;
import com.ibm.team.repository.client.util.Event;
import com.ibm.team.repository.client.util.EventSource;
import com.ibm.team.repository.client.util.IEventSource;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IComponentHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnresolvedSource
extends EventSource
implements IUnresolvedSource {
    ComponentSyncContext context;
    Collection<IUnresolvedFolder> folders;

    public UnresolvedSource(ComponentSyncContext context, EventSource parent) {
        super(parent);
        this.context = context;
        this.folders = new ArrayList<IUnresolvedFolder>();
    }

    @Override
    public Collection<IUnresolvedFolder> getFolders() {
        return Collections.unmodifiableCollection(this.folders);
    }

    @Override
    public IComponentSyncContext getModel() {
        return this.context;
    }

    public void update() {
        try {
            this.acquire();
            Collection<UnresolvedItem> newItems = this.createUnresolvedItems();
            Collection<UnresolvedFolder> newFolders = this.createFolders(newItems);
            ArrayList<IUnresolvedFolder> folders = new ArrayList<IUnresolvedFolder>(this.folders);
            UnresolvedSource.update(folders, newFolders);
            this.folders = folders;
            this.queueEvent(new Event((IEventSource)this, "refreshedUnresolvedCompleted"));
        }
        finally {
            this.release();
        }
    }

    public Collection<UnresolvedItem> createUnresolvedItems() {
        List localChanges = this.context.getLocalChangeSource().getLocalChanges();
        HashMap<Object, UnresolvedItem> unresolvedItems = new HashMap<Object, UnresolvedItem>();
        HashMap<UUID, UnresolvedItem> unresolvedItemsPerUUID = new HashMap<UUID, UnresolvedItem>();
        for (ILocalChange localChange : localChanges) {
            String key = UnresolvedSource.getPath(localChange, true);
            UnresolvedItem value = (UnresolvedItem)unresolvedItems.get(key);
            if (value == null) {
                value = new UnresolvedItem();
                unresolvedItems.put(key, value);
                unresolvedItemsPerUUID.put(localChange.getTarget().getItemId(), value);
            }
            value.localChanges.add(localChange);
        }
        Collection conflicts = this.context.getOutgoingActivitySource().getConflictItems();
        for (IConflictItem conflictItem : conflicts) {
            UUID key = conflictItem.getItem().getItemId();
            String path = UnresolvedSource.getPath(conflictItem, true);
            UnresolvedItem value = (UnresolvedItem)unresolvedItemsPerUUID.get(key);
            if (value == null) {
                value = (UnresolvedItem)unresolvedItems.get(path);
            }
            if (value == null) {
                value = new UnresolvedItem();
                unresolvedItems.put(path, value);
                unresolvedItemsPerUUID.put(key, value);
            }
            value.conflictItems.add(conflictItem);
        }
        Collection<IUnresolvedItemProvider> providers = ((ComponentSyncModel)this.context.getComponentSyncModel()).getEventManager().getItemProviders();
        for (IUnresolvedItemProvider provider : providers) {
            Collection<UnresolvedItemInfo> items = provider.unresolvedItems(this.context.getOutgoingTeamPlace(), (IComponentHandle)this.context.getComponent());
            for (UnresolvedItemInfo itemInfo : items) {
                String key = UnresolvedSource.getPath(itemInfo, true);
                UnresolvedItem value = (UnresolvedItem)unresolvedItems.get(key);
                if (value == null) {
                    value = new UnresolvedItem();
                    unresolvedItems.put(key, value);
                }
                value.patches.add(itemInfo);
            }
        }
        return unresolvedItems.values();
    }

    public Collection<UnresolvedFolder> createFolders(Collection<UnresolvedItem> items) {
        HashMap<String, UnresolvedFolder> newFolders = new HashMap<String, UnresolvedFolder>();
        for (UnresolvedItem item : items) {
            String key = UnresolvedSource.getPath(item, false);
            UnresolvedFolder value = (UnresolvedFolder)newFolders.get(key);
            if (value == null) {
                value = new UnresolvedFolder(this, key);
                newFolders.put(key, value);
            }
            item.folder = value;
            value.items.add(item);
        }
        return newFolders.values();
    }

    static String getPath(UnresolvedItem item, boolean includeName) {
        Collection<ILocalChange> localChanges = item.getLocalChanges();
        if (!localChanges.isEmpty()) {
            ILocalChange localChange = localChanges.iterator().next();
            String path = UnresolvedSource.getPath(localChange, includeName);
            return path != null ? path : "<unknown path>";
        }
        Collection<IConflictItem> conflictItems = item.getConflictItems();
        if (!conflictItems.isEmpty()) {
            IConflictItem conflictItem = conflictItems.iterator().next();
            String path = UnresolvedSource.getPath(conflictItem, includeName);
            return path != null ? path : "<unknown path>";
        }
        List<UnresolvedItemInfo> itemInfos = item.patches;
        if (!itemInfos.isEmpty()) {
            UnresolvedItemInfo itemInfo = (UnresolvedItemInfo)itemInfos.iterator().next();
            String path = UnresolvedSource.getPath(itemInfo, includeName);
            return path != null ? path : "<unknown path>";
        }
        return "<unknown path>";
    }

    static String getPath(UnresolvedItemInfo itemInfo, boolean includeName) {
        String result = itemInfo.folderPath;
        if (includeName) {
            result = String.valueOf(result) + "/" + itemInfo.name;
        }
        return result;
    }

    static String getPath(ILocalChange localChange, boolean includeName) {
        IPath p = localChange.getPath();
        if (!includeName) {
            p = p.removeLastSegments(1);
        }
        return p.makeRelative().toString();
    }

    static String getPath(IConflictItem conflictItem, boolean includeName) {
        ILogicalChange logicalChange = conflictItem != null ? conflictItem.getLogicalChange() : null;
        return logicalChange != null ? UnresolvedSource.getPath(logicalChange, includeName) : null;
    }

    static String getPath(ILogicalChange logicalChange, boolean includeName) {
        StringBuffer result = null;
        String[] path = logicalChange.getPathHint();
        result = new StringBuffer();
        int length = includeName ? path.length : path.length - 1;
        int i = 0;
        while (i < length) {
            result.append(path[i]);
            if (i < length - 1) {
                result.append('/');
            }
            ++i;
        }
        return result != null && result.length() > 0 ? result.toString() : null;
    }

    static String getResourceName(UnresolvedItem item) {
        UnresolvedItemInfo itemInfo;
        IConflictItem conflictItem;
        ILocalChange localChange;
        List<ILocalChange> localChanges = item.localChanges;
        ILocalChange iLocalChange = localChange = !localChanges.isEmpty() ? (ILocalChange)localChanges.iterator().next() : null;
        if (localChange != null) {
            return localChange.getPath().lastSegment();
        }
        IConflictItem iConflictItem = conflictItem = !item.getConflictItems().isEmpty() ? item.getConflictItems().iterator().next() : null;
        if (conflictItem != null) {
            return conflictItem.getResourceName(false);
        }
        List<UnresolvedItemInfo> patches = item.patches;
        UnresolvedItemInfo unresolvedItemInfo = itemInfo = !patches.isEmpty() ? (UnresolvedItemInfo)patches.iterator().next() : null;
        if (itemInfo != null) {
            return itemInfo.name;
        }
        return "<unknown name>";
    }

    public static void update(Collection<UnresolvedFolder> oldFolders, Collection<UnresolvedFolder> newFolders) {
        final ComponentConflictUtil.UpdateItem updateItem = new ComponentConflictUtil.UpdateItem(){

            public boolean sameItem(Object object, Object other) {
                return ((IUnresolvedItem)object).getId().equals(((IUnresolvedItem)other).getId());
            }

            public void updateSameItem(Object object, Object other) {
                UnresolvedItem i1 = (UnresolvedItem)object;
                UnresolvedItem i2 = (UnresolvedItem)other;
                i1.conflictItems = i2.conflictItems;
                i1.localChanges = i2.localChanges;
                i1.patches = i2.patches;
            }
        };
        ComponentConflictUtil.UpdateItem updateFolder = new ComponentConflictUtil.UpdateItem(){

            public boolean sameItem(Object object, Object other) {
                return ((IUnresolvedFolder)object).getPath().equals(((IUnresolvedFolder)other).getPath());
            }

            public void updateSameItem(Object object, Object other) {
                UnresolvedFolder f1 = (UnresolvedFolder)object;
                UnresolvedFolder f2 = (UnresolvedFolder)other;
                f1.setPath(f2.getPath());
                ArrayList<IUnresolvedItem> items = new ArrayList<IUnresolvedItem>(f1.items);
                ComponentConflictUtil.update(items, f2.items, updateItem);
                f1.items = items;
            }
        };
        ComponentConflictUtil.update(oldFolders, newFolders, updateFolder);
    }
}

