/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.changes.util;

import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ILocalChangeSource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ILocalFolder;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.LocalChangeSource;
import java.util.List;
import org.eclipse.core.runtime.IPath;

public class LocalFolderNode
implements ILocalFolder {
    final IPath path;
    final LocalChangeSource localchangeSource;

    public LocalFolderNode(IPath path, LocalChangeSource localChangeSource) {
        this.path = path;
        this.localchangeSource = localChangeSource;
    }

    public ILocalChangeSource getLocalChangeSource() {
        return this.localchangeSource;
    }

    public String getPath() {
        if (this.path == null) {
            return "";
        }
        return this.path.toString();
    }

    public boolean contains(ILocalChange change) {
        IPath otherPath = change.getPath();
        if (otherPath.segmentCount() != this.path.segmentCount() + 1) {
            return false;
        }
        return this.path.matchingFirstSegments(otherPath) == this.path.segmentCount();
    }

    boolean contains(IPath otherPath) {
        if (otherPath.segmentCount() != this.path.segmentCount() + 1) {
            return false;
        }
        return this.path.matchingFirstSegments(otherPath) == this.path.segmentCount();
    }

    static void add(List folders, ILocalChange change, LocalChangeSource localChangeSource) {
        IPath path = change.getPath();
        for (LocalFolderNode folder : folders) {
            if (!folder.contains(path)) continue;
            return;
        }
        LocalFolderNode folder = new LocalFolderNode(path.removeLastSegments(1).makeRelative(), localChangeSource);
        folders.add(folder);
    }
}

