/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.changes.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.DilemmaHandler;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.changes.ComponentSyncInfo;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ChangeInput;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.CompareInput;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentBaselineUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentFlowUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.SyncCache;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.SyncIDWorkspace;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.CompareToNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ComponentSyncModel;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ModelUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.MultiComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.mutator.IQueryContext;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IChangeHistory;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IFlowNodeConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.ComponentNotInWorkspaceException;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IChangeHistoryEntryChange;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.WorkspaceComparisonFlags;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class CompareToOperation
extends FileSystemOperation {
    List elements;
    IQueryContext context;

    public CompareToOperation(DilemmaHandler handler) {
        super(handler);
    }

    public void computeItemsAndChildren(List elements, IQueryContext context) {
        this.elements = elements;
        this.context = context;
    }

    protected void execute(IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        long traceBegin = 0L;
        if (ModelUtil.TRACE_REFRESH) {
            traceBegin = ModelUtil.logBegin("CompareToNode.computeItemsAndChildren elements size " + this.elements.size());
        }
        try {
            monitor.beginTask(Messages.CompareToNode_4, this.elements.size() * 100);
            for (CompareToNode node : this.elements) {
                int newFlags = ((ComponentSyncModel)node.model.getComponentSyncModel()).getCompareToFlags();
                int oldFlags = node.compareToFlags;
                SyncIDWorkspace[] vTimes = this.refreshConnections(node);
                if (newFlags == oldFlags && vTimes == null) continue;
                this.updateWorkspaceOwners(node, this.context, (IProgressMonitor)new SubProgressMonitor(monitor, 5));
                if (node.customQuery) {
                    this.compareCustomQuery(node, this.context, (IProgressMonitor)new SubProgressMonitor(monitor, 85));
                } else if (this.useActiveChangeSetsQuery(node)) {
                    this.activeChangeSetsQuery(node, this.context, (IProgressMonitor)new SubProgressMonitor(monitor, 85));
                } else {
                    this.compareChangeHistoryQuery(node, this.context, (IProgressMonitor)new SubProgressMonitor(monitor, 85));
                }
                this.update(node, this.context, (IProgressMonitor)new SubProgressMonitor(monitor, 5));
                this.updateBasis(node, this.context, (IProgressMonitor)new SubProgressMonitor(monitor, 5));
                node.fromWorkspaceNode.updateConflictItems();
                this.updateVTimes(node, vTimes, newFlags);
            }
        }
        finally {
            monitor.done();
            if (ModelUtil.TRACE_REFRESH) {
                ModelUtil.logEnd("CompareToNode.computeItemsAndChildren", traceBegin);
            }
        }
    }

    void updateVTimes(CompareToNode src, SyncIDWorkspace[] vTimes, int flags) {
        if (vTimes != null) {
            src.vTimeFrom = vTimes[0];
            src.vTimeTo = vTimes[1];
        }
        src.compareToFlags = flags;
    }

    void updateBasis(CompareToNode src, IQueryContext context, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.CompareToNode_6, (int)2);
        try {
            ComponentSyncInfo info = src.model.getComponentSyncInfo();
            if (info == null) {
                src.fromBasis = null;
                src.toBasis = null;
                return;
            }
            IChangeHistorySyncReport report = src.changeHistorySyncReport;
            IBaselineHandle fromBasis = null;
            IBaselineHandle toBasis = null;
            if (report == null) {
                if (src.teamPlaceFrom instanceof IWorkspaceConnection) {
                    try {
                        fromBasis = ((IWorkspaceConnection)src.teamPlaceFrom).getComponentInfo((IComponentHandle)info.getComponent()).basis();
                    }
                    catch (ComponentNotInWorkspaceException componentNotInWorkspaceException) {}
                }
                if (src.teamPlaceTo instanceof IWorkspaceConnection) {
                    try {
                        toBasis = ((IWorkspaceConnection)src.teamPlaceTo).getComponentInfo((IComponentHandle)info.getComponent()).basis();
                    }
                    catch (ComponentNotInWorkspaceException componentNotInWorkspaceException) {}
                }
            } else {
                fromBasis = (IBaselineHandle)report.localBases().get(info.getComponent());
                toBasis = (IBaselineHandle)report.remoteBases().get(info.getComponent());
            }
            src.fromBasis = fromBasis != null ? (IBaseline)context.getCache().fetchCurrent((IAuditableHandle)fromBasis, (IProgressMonitor)progress.newChild(1)) : null;
            src.toBasis = toBasis != null ? (IBaseline)context.getCache().fetchCurrent((IAuditableHandle)toBasis, (IProgressMonitor)progress.newChild(1)) : null;
        }
        finally {
            monitor.done();
        }
    }

    void updateWorkspaceOwners(CompareToNode src, IQueryContext context, IProgressMonitor monitor) {
        monitor.beginTask(Messages.CompareToNode_7, 100);
        try {
            src.fromOwnerHandle = CompareToNode.getOwner(src.from);
            src.toOwnerHandle = CompareToNode.getOwner(src.to);
            src.clean(context.getCache(), monitor);
            src.fromWorkspaceNode.update(src.outgoingFileChangeSets, src.outgoingBaselines, src.from, src.fromOwner);
            src.toWorkspaceNode.update(src.incomingFileChangeSets, src.incomingBaselines, src.to, src.toOwner);
            context.newState(src);
        }
        finally {
            monitor.done();
        }
    }

    void update(CompareToNode src, IQueryContext context, IProgressMonitor monitor) {
        monitor.beginTask(Messages.CompareToNode_8, 100);
        try {
            ArrayList outgoingFileChangeSets = new ArrayList(src.outgoingFileChangeSets);
            ArrayList incomingFileChangeSets = new ArrayList(src.incomingFileChangeSets);
            CompareToNode.update(outgoingFileChangeSets, src.outgoingChangeSetHandles, src.teamPlaceFrom, src.fromWorkspaceNode, context);
            CompareToNode.update(incomingFileChangeSets, src.incomingChangeSetHandles, src.teamPlaceTo, src.toWorkspaceNode, context);
            src.outgoingFileChangeSets = outgoingFileChangeSets;
            src.incomingFileChangeSets = incomingFileChangeSets;
            src.fromWorkspaceNode.update(src.outgoingFileChangeSets, src.outgoingBaselines, src.from, src.fromOwner);
            src.toWorkspaceNode.update(src.incomingFileChangeSets, src.incomingBaselines, src.to, src.toOwner);
            ArrayList newChangeSets = new ArrayList();
            newChangeSets.addAll(src.incomingFileChangeSets);
            newChangeSets.addAll(src.outgoingFileChangeSets);
            src.children[0] = newChangeSets;
        }
        finally {
            monitor.done();
        }
    }

    boolean useActiveChangeSetsQuery(CompareToNode src) throws TeamRepositoryException {
        if (src.customQuery) {
            return false;
        }
        if (src.teamPlaceFrom instanceof IBaselineConnection || src.teamPlaceTo instanceof IBaselineConnection) {
            return false;
        }
        if (src.teamPlaceFrom == src.teamPlaceTo) {
            return true;
        }
        ComponentSyncInfo info = src.model.getComponentSyncInfo();
        IComponent component = info.getComponent();
        boolean existsLocal = ModelUtil.hasComponent(src.teamPlaceFrom, (IComponentHandle)component);
        boolean existsRemote = ModelUtil.hasComponent(src.teamPlaceTo, (IComponentHandle)component);
        return !existsLocal || !existsRemote;
    }

    SyncIDWorkspace[] refreshConnections(CompareToNode src) throws TeamRepositoryException {
        SyncIDWorkspace vTimeTo;
        IFlowNodeConnection from = null;
        IFlowNodeConnection to = null;
        if (src.teamPlaceFrom instanceof IFlowNodeConnection) {
            from = (IFlowNodeConnection)src.teamPlaceFrom;
        }
        if (src.teamPlaceTo instanceof IFlowNodeConnection) {
            to = (IFlowNodeConnection)src.teamPlaceTo;
        }
        SyncIDWorkspace vTimeFrom = from != null ? new SyncIDWorkspace(from) : null;
        SyncIDWorkspace syncIDWorkspace = vTimeTo = to != null ? new SyncIDWorkspace(to) : null;
        if (!src.customQuery && vTimeFrom != null && vTimeFrom.equals(src.vTimeFrom) && vTimeTo != null && vTimeTo.equals(src.vTimeTo)) {
            return null;
        }
        return new SyncIDWorkspace[]{vTimeFrom, vTimeTo};
    }

    void activeChangeSetsQuery(CompareToNode src, IQueryContext context, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask(Messages.CompareToNode_9, 100);
        try {
            IWorkspaceConnection teamPlaceFrom = ComponentSyncContext.checkWorkspaceConnection(src.teamPlaceFrom);
            IWorkspaceConnection teamPlaceTo = ComponentSyncContext.checkWorkspaceConnection(src.teamPlaceTo);
            FlowNodeLock workspaceReadLock = WorkspaceLockUtil.acquireRead((IConnection)teamPlaceFrom);
            try {
                ComponentSyncInfo info = src.model.getComponentSyncInfo();
                src.componentFlowType = ComponentFlowUtil.getComponentFlowType(info);
                src.outgoingChangeSetHandles = teamPlaceFrom.activeChangeSets((IComponentHandle)info.getComponent());
                SyncCache.SyncDataWorkspace data = SyncCache.get().fetch(teamPlaceFrom, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                src.conflictReport = data.conflictReport;
                src.logicalConflictReport = data.logicalConflictReport;
                src.changeHistorySyncReport = null;
                src.freeFlightLogicalConflictReport = null;
            }
            finally {
                WorkspaceLockUtil.release((FlowNodeLock)workspaceReadLock);
            }
            src.incomingChangeSetHandles = teamPlaceTo != teamPlaceFrom ? (teamPlaceTo instanceof IWorkspaceConnection ? teamPlaceTo.activeChangeSets((IComponentHandle)src.model.getComponent()) : Collections.EMPTY_LIST) : Collections.EMPTY_LIST;
            context.setRemoved(src.incomingBaselines);
            context.setRemoved(src.outgoingBaselines);
            src.incomingBaselines = Collections.EMPTY_LIST;
            src.outgoingBaselines = Collections.EMPTY_LIST;
        }
        finally {
            monitor.done();
        }
    }

    boolean useNewComponentQuery(CompareToNode src) throws TeamRepositoryException {
        ComponentSyncInfo info = src.model.getComponentSyncInfo();
        if (info == null) {
            return false;
        }
        int type = ComponentFlowUtil.getComponentFlowType(info);
        return type == 3 || type == 5;
    }

    void newComponentQuery(CompareToNode src, IQueryContext context, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask(Messages.CompareToNode_10, 100);
        try {
            ArrayList<IChangeSetHandle> incoming;
            List<Object> outgoing;
            ComponentSyncInfo info = src.model.getComponentSyncInfo();
            if (info == null) {
                throw new IllegalArgumentException();
            }
            src.componentFlowType = ComponentFlowUtil.getComponentFlowType(info);
            IConnection connection = null;
            switch (src.componentFlowType) {
                case 3: {
                    connection = src.teamPlaceFrom;
                    break;
                }
                case 5: {
                    connection = src.teamPlaceTo;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            ArrayList<IChangeSetHandle> changeSets = new ArrayList<IChangeSetHandle>();
            IChangeHistory changeHistory = ModelUtil.changeHistory(connection, (IComponentHandle)info.getComponent());
            List recent = changeHistory.recent((IProgressMonitor)new SubProgressMonitor(monitor, 100));
            for (IChangeHistoryEntryChange entry : recent) {
                changeSets.add(entry.changeSet());
            }
            if (connection == src.teamPlaceFrom) {
                outgoing = changeSets;
                incoming = Collections.EMPTY_LIST;
            } else {
                outgoing = Collections.EMPTY_LIST;
                incoming = changeSets;
            }
            src.outgoingChangeSetHandles = outgoing;
            src.incomingChangeSetHandles = incoming;
        }
        finally {
            monitor.done();
        }
    }

    void compareCustomQuery(CompareToNode src, IQueryContext context, IProgressMonitor monitor) throws TeamRepositoryException {
        long traceBegin = 0L;
        if (ModelUtil.TRACE_REFRESH) {
            traceBegin = ModelUtil.logBegin(Messages.CompareToNode_11);
        }
        monitor.beginTask(Messages.CompareToNode_12, 100);
        try {
            MultiComponentSyncContext mcsc = (MultiComponentSyncContext)src.model.getParentContext();
            ChangeInput changeInput = mcsc.getChangeInput();
            if (changeInput instanceof CompareInput) {
                CompareInput input = (CompareInput)changeInput;
                if (!input.useCustomQuery()) {
                    throw new IllegalArgumentException("Must be a custom query");
                }
                src.changeHistorySyncReport = null;
                src.freeFlightLogicalConflictReport = null;
                src.outgoingChangeSetHandles = mcsc.getCustomChanges((IComponentHandle)src.component, true);
                src.incomingChangeSetHandles = mcsc.getCustomChanges((IComponentHandle)src.component, false);
            }
        }
        finally {
            monitor.done();
            if (ModelUtil.TRACE_REFRESH) {
                ModelUtil.logEnd("CompareToNode.compareCustomQuery", traceBegin);
            }
        }
    }

    void compareChangeHistoryQuery(CompareToNode src, IQueryContext context, IProgressMonitor monitor) throws TeamRepositoryException {
        long traceBegin = 0L;
        if (ModelUtil.TRACE_REFRESH) {
            traceBegin = ModelUtil.logBegin("CompareToNode.compareChangeHistoryQuery");
        }
        monitor.beginTask(Messages.CompareToNode_16, 100);
        try {
            boolean allWorkspaces = src.teamPlaceFrom instanceof IWorkspaceConnection && src.teamPlaceTo instanceof IWorkspaceConnection;
            FlowNodeLock workspaceLock = null;
            if (src.teamPlaceFrom instanceof IWorkspaceConnection) {
                workspaceLock = WorkspaceLockUtil.acquireRead((IConnection)src.teamPlaceFrom);
            }
            try {
                IChangeHistorySyncReport report;
                ComponentSyncInfo info = src.model.getComponentSyncInfo();
                src.componentFlowType = ComponentFlowUtil.getComponentFlowType(info);
                IComponent component = src.component;
                SyncCache.SyncDataFlow dataFlow = null;
                int flags = 0;
                if (allWorkspaces) {
                    flags = ((ComponentSyncModel)src.model.getComponentSyncModel()).getCompareToFlags();
                    dataFlow = SyncCache.get().fetch((IWorkspaceConnection)src.teamPlaceFrom, (IWorkspaceConnection)src.teamPlaceTo, flags, (IProgressMonitor)new SubProgressMonitor(monitor, 30));
                    report = dataFlow.syncReport;
                } else {
                    flags = WorkspaceComparisonFlags.CHANGE_SET_COMPARISON_ONLY;
                    report = ModelUtil.compareTo(src.teamPlaceFrom, src.teamPlaceTo, flags, (IComponentHandle)component, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                }
                src.compareToFlags = flags;
                src.changeHistorySyncReport = report;
                src.incomingChangeSetHandles = new ArrayList();
                src.outgoingChangeSetHandles = new ArrayList();
                if (allWorkspaces) {
                    src.outgoingChangeSetHandles = new ArrayList(report.outgoingChangeSetsAfterBasis((IComponentHandle)component));
                    src.incomingChangeSetHandles = new ArrayList(report.incomingChangeSetsAfterBasis((IComponentHandle)component));
                } else {
                    src.outgoingChangeSetHandles = new ArrayList(report.outgoingChangeSets((IComponentHandle)component));
                    src.incomingChangeSetHandles = new ArrayList(report.incomingChangeSets((IComponentHandle)component));
                }
                if (report.localComponents().isEmpty() && src.teamPlaceTo instanceof IBaselineConnection) {
                    src.outgoingChangeSetHandles.addAll(report.outgoingChangeSets());
                    src.incomingChangeSetHandles.addAll(report.incomingChangeSets());
                }
                if (allWorkspaces) {
                    List newBaselineHandles = report.outgoingBaselines((IComponentHandle)component);
                    ArrayList baselines = new ArrayList(src.outgoingBaselines);
                    IBaselineHandle oldestAncestor = report.commonBaseline((IComponentHandle)component);
                    List newBaselines = ComponentBaselineUtil.createBaselineGroups(newBaselineHandles, src.fromWorkspaceNode, oldestAncestor, null);
                    ComponentBaselineUtil.updateBaselineGroups(baselines, newBaselines);
                    context.setRemoved(src.outgoingBaselines);
                    src.outgoingBaselines = newBaselines;
                    context.setAdded(src.outgoingBaselines);
                    newBaselineHandles = report.incomingBaselines((IComponentHandle)component);
                    newBaselines = ComponentBaselineUtil.createBaselineGroups(newBaselineHandles, src.toWorkspaceNode, oldestAncestor, null);
                    baselines = new ArrayList(src.incomingBaselines);
                    ComponentBaselineUtil.updateBaselineGroups(baselines, newBaselines);
                    context.setRemoved(src.incomingBaselines);
                    src.incomingBaselines = newBaselines;
                    context.setAdded(src.incomingBaselines);
                    ArrayList children = new ArrayList();
                    children.addAll(src.outgoingBaselines);
                    children.addAll(src.incomingBaselines);
                    src.children[1] = children;
                    IWorkspaceConnection wcFrom = (IWorkspaceConnection)src.teamPlaceFrom;
                    SyncCache.SyncDataWorkspace data = SyncCache.get().fetch(wcFrom, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
                    src.conflictReport = data.conflictReport;
                    src.logicalConflictReport = data.logicalConflictReport;
                    src.freeFlightLogicalConflictReport = dataFlow.freeFlightLogicalConflictReport;
                } else {
                    src.freeFlightLogicalConflictReport = null;
                    monitor.worked(50);
                }
            }
            finally {
                if (src.teamPlaceFrom instanceof IWorkspaceConnection) {
                    WorkspaceLockUtil.release((FlowNodeLock)workspaceLock);
                }
            }
        }
        finally {
            monitor.done();
            if (ModelUtil.TRACE_REFRESH) {
                ModelUtil.logEnd("CompareToNode.compareChangeHistoryQuery", traceBegin);
            }
        }
    }
}

