/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.changes.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.IFileSystemView;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.operations.DilemmaHandler;
import com.ibm.team.filesystem.common.IChangeSetSummary;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.changes.QueryCache;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IFileSystemWorkItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ChangeSetNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ComponentSyncModel;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ModelUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.mutator.IQueryContext;
import com.ibm.team.links.common.ILink;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.NotLoggedInException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.transport.ConnectionException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.dto.IChangeSetLinkSummary;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeSetOperation
extends FileSystemOperation {
    List elements;
    IQueryContext context;

    public ChangeSetOperation(DilemmaHandler handler) {
        super(handler);
    }

    public void computeItemsAndChildren(List elements, IQueryContext context) {
        this.elements = elements;
        this.context = context;
    }

    protected void execute(IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ChangeSetNode_1, (int)(this.elements.size() * 3));
        long traceBegin = 0L;
        if (ModelUtil.TRACE_REFRESH) {
            traceBegin = ModelUtil.logBegin("ChangeSetNode.computeItemsAndChildren elements size " + this.elements.size());
        }
        try {
            if (this.elements.size() == 0) {
                return;
            }
            IConnection currentConnection = null;
            IFileSystemView currentFSV = null;
            ArrayList fileChangeSets = new ArrayList();
            List<IChangeSetHandle> changeSets = ComponentSyncUtil.getChangeSetHandles(this.elements);
            this.context.getCache().fetchCurrent(changeSets, 0, (IProgressMonitor)progress.newChild(1));
            changeSets.clear();
            ArrayList<ChangeSetNode> interpretElements = new ArrayList<ChangeSetNode>();
            for (ChangeSetNode elt : this.elements) {
                if (currentConnection == null) {
                    currentConnection = elt.teamPlace;
                    currentFSV = FileSystemCore.getFileSystemManager((ITeamRepository)currentConnection.teamRepository()).getFileSystemView(currentConnection);
                }
                List oldChanges = elt.changes;
                elt.changeSet = (IChangeSet)this.context.getCache().fetchCurrent((IAuditableHandle)elt.handle, (IProgressMonitor)progress.newChild(1));
                if (ComponentSyncModel.DEGRADED_NOCHANGES) continue;
                if (elt.changeSet == null) {
                    throw new FileSystemClientException(FileSystemStatus.getStatusFor((int)4, (int)602, (String)Messages.ChangeSetNode_2, (Throwable)this.context.getCache().lastException()));
                }
                int maxChanges = elt.getActivitySource().getModel().getComponentSyncModel().getMaxChangesPerChangeSet();
                if (maxChanges >= 0 && elt.changeSet.changes().size() >= maxChanges) {
                    elt.changes = null;
                    elt.changeSummaries = Collections.EMPTY_LIST;
                    elt.folders = Collections.EMPTY_LIST;
                    continue;
                }
                if (currentConnection != elt.teamPlace) {
                    fileChangeSets.addAll(this.interpretChanges(currentFSV, changeSets, (IProgressMonitor)progress.newChild(changeSets.size())));
                    currentConnection = elt.teamPlace;
                    currentFSV = FileSystemCore.getFileSystemManager((ITeamRepository)currentConnection.teamRepository()).getFileSystemView(currentConnection);
                    changeSets.clear();
                }
                if (ChangeSetOperation.sameChanges(oldChanges, elt.changeSet.changes())) continue;
                interpretElements.add(elt);
                changeSets.add(elt.handle);
            }
            fileChangeSets.addAll(this.interpretChanges(currentFSV, changeSets, (IProgressMonitor)progress.newChild(changeSets.size())));
            if (interpretElements.size() == fileChangeSets.size()) {
                Iterator iter = interpretElements.iterator();
                Iterator fileIter = fileChangeSets.iterator();
                while (iter.hasNext()) {
                    ChangeSetNode target = (ChangeSetNode)iter.next();
                    IChangeSetSummary newFileChangeSet = (IChangeSetSummary)fileIter.next();
                    target.changes = target.changeSet.changes();
                    target.updateFileChanges(newFileChangeSet.changes());
                }
            } else {
                for (ChangeSetNode target : interpretElements) {
                    target.changes = null;
                }
                LoggingHelper.log((IStatus)StatusUtil.newStatus((Object)((Object)this), (String)NLS.bind((String)Messages.ChangeSetNode_0, (Object)fileChangeSets.size(), (Object)interpretElements.size())));
            }
            progress.setWorkRemaining(100);
            if (!ComponentSyncModel.DEGRADED_NOWORKITEMS) {
                this.computeLinks(this.elements, currentConnection.teamRepository(), this.context, (IProgressMonitor)progress.newChild(100));
            }
        }
        finally {
            monitor.done();
            if (ModelUtil.TRACE_REFRESH) {
                ModelUtil.logEnd("ChangeSetNode.computeItemsAndChildren", traceBegin);
            }
        }
    }

    private List interpretChanges(IFileSystemView fsv, List changeSets, IProgressMonitor monitor) throws ConnectionException, NotLoggedInException {
        long traceBegin;
        block13: {
            traceBegin = 0L;
            if (ModelUtil.TRACE_REFRESH) {
                traceBegin = ModelUtil.logBegin("IConfiguration.interpretChanges changeSets size " + changeSets.size());
            }
            if (changeSets.isEmpty()) {
                return Collections.EMPTY_LIST;
            }
            try {
                IPath cfaRoot = FileSystemCore.getSharingManager().getDefaultCFARoot();
                List list = fsv.interpretChanges(cfaRoot, changeSets, monitor);
                return list;
            }
            catch (ConnectionException e) {
                throw e;
            }
            catch (NotLoggedInException e) {
                throw e;
            }
            catch (TeamRepositoryException e) {
                LoggingHelper.log((IStatus)StatusUtil.newStatus((Object)((Object)this), (String)(String.valueOf(Messages.ChangeSetNode_7) + fsv.connection().getName()), (Throwable)e));
                if (!(fsv.connection() instanceof IWorkspaceConnection)) break block13;
                IWorkspaceConnection w = (IWorkspaceConnection)fsv.connection();
                try {
                    List components = w.teamRepository().itemManager().fetchCompleteItems(w.getComponents(), 0, monitor);
                    MultiStatus ms = new MultiStatus("com.ibm.team.scm.client", 0, String.valueOf(Messages.ChangeSetNode_9) + w.getName(), null);
                    for (IComponent component : components) {
                        ms.add(StatusUtil.newStatus((Object)((Object)this), (String)component.getName()));
                    }
                    LoggingHelper.log((IStatus)ms);
                }
                catch (TeamRepositoryException teamRepositoryException) {
                    LoggingHelper.log((IStatus)StatusUtil.newStatus((Object)((Object)this), (String)(String.valueOf(Messages.ChangeSetNode_10) + fsv.connection().getName()), (Throwable)e));
                }
            }
        }
        List list = Collections.EMPTY_LIST;
        return list;
        finally {
            if (ModelUtil.TRACE_REFRESH) {
                ModelUtil.logEnd("IConfiguration.interpretChanges", traceBegin);
            }
        }
    }

    private void computeLinks(List elements, ITeamRepository repo, IQueryContext context, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            List<IChangeSetHandle> changeSetsToSearch = ComponentSyncUtil.getChangeSetHandles(elements);
            HashMap<UUID, IChangeSetLinkSummary> linkSummariesByChangeSet = new HashMap<UUID, IChangeSetLinkSummary>();
            QueryCache queryCache = ((ComponentSyncModel)((ChangeSetNode)elements.get((int)0)).getActivitySource().getModel().getComponentSyncModel()).cache;
            IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
            List<IChangeSetLinkSummary> linkSummaries = queryCache != null ? queryCache.getChangeSetLinkSummary(wm, changeSetsToSearch, (IProgressMonitor)progress.newChild(30)) : wm.getChangeSetLinkSummary(changeSetsToSearch, (IProgressMonitor)progress.newChild(30));
            ArrayList linkHandles = new ArrayList();
            for (IChangeSetLinkSummary changeSetLinkSummary : linkSummaries) {
                linkSummariesByChangeSet.put(changeSetLinkSummary.getChangeSet().getItemId(), changeSetLinkSummary);
                linkHandles.addAll(changeSetLinkSummary.getLinks());
            }
            IItemManager itemManager = context.teamRepository().itemManager();
            ArrayList<IAuditableHandle> targetRefHandles = new ArrayList<IAuditableHandle>();
            List allLinks = Collections.EMPTY_LIST;
            try {
                allLinks = itemManager.fetchCompleteItems(linkHandles, 0, (IProgressMonitor)progress.newChild(30));
            }
            catch (TeamRepositoryException e) {
                FileSystemResourcesPlugin.log(new FileSystemClientException(StatusUtil.newStatus((Object)((Object)this), (String)Messages.ChangeSetNode_3, (Throwable)e)));
            }
            for (ILink link : allLinks) {
                Object targetRef = link.getTargetRef().resolve();
                if (!(targetRef instanceof IAuditableHandle)) continue;
                targetRefHandles.add((IAuditableHandle)targetRef);
            }
            try {
                itemManager.fetchCompleteItems(targetRefHandles, 0, (IProgressMonitor)progress.newChild(30));
            }
            catch (TeamRepositoryException e) {
                FileSystemResourcesPlugin.log(new FileSystemClientException(StatusUtil.newStatus((Object)((Object)this), (String)Messages.ChangeSetNode_4, (Throwable)e)));
            }
            progress.setWorkRemaining(elements.size());
            for (ChangeSetNode changeSetNode : elements) {
                IChangeSetLinkSummary linkSummary = (IChangeSetLinkSummary)linkSummariesByChangeSet.get(changeSetNode.getChangeSetHandle().getItemId());
                if (linkSummary == null) continue;
                List links = repo.itemManager().fetchCompleteItems(linkSummary.getLinks(), 0, (IProgressMonitor)progress.newChild(1));
                ArrayList<IFileSystemWorkItem> newChildren = new ArrayList<IFileSystemWorkItem>();
                changeSetNode.updateLinks(links, context);
                newChildren.addAll(changeSetNode.links);
                changeSetNode.children[0] = newChildren;
            }
        }
        catch (TeamRepositoryException e) {
            FileSystemResourcesPlugin.log(new FileSystemClientException(StatusUtil.newStatus((Object)((Object)this), (String)Messages.ChangeSetNode_4, (Throwable)e)));
        }
    }

    static boolean sameChanges(List changes, List otherChanges) {
        if (changes == null) {
            return otherChanges == null || otherChanges.isEmpty();
        }
        if (otherChanges == null) {
            return changes.isEmpty();
        }
        if (changes.size() != otherChanges.size()) {
            return false;
        }
        for (IChange change : changes) {
            if (ChangeSetOperation.hasChange(change, otherChanges)) continue;
            return false;
        }
        return true;
    }

    static boolean hasChange(IChange change, List changes) {
        for (IChange other : changes) {
            if (!ChangeSetOperation.isSame(change, other)) continue;
            return true;
        }
        return false;
    }

    static boolean isSame(IChange change, IChange other) {
        if (!change.item().sameItemId((IItemHandle)other.item())) {
            return false;
        }
        if (change.beforeState() == null ? other.beforeState() != null : !change.beforeState().sameStateId((IItemHandle)other.beforeState())) {
            return false;
        }
        if (change.afterState() == null ? other.afterState() != null : !change.afterState().sameStateId((IItemHandle)other.afterState())) {
            return false;
        }
        if (change.kind() != other.kind()) {
            return false;
        }
        return ChangeSetOperation.isSame(change.mergeStates(), other.mergeStates());
    }

    static boolean isSame(List<IItemHandle> source, List<IItemHandle> other) {
        if (source.size() != other.size()) {
            return false;
        }
        for (IItemHandle item : source) {
            for (IItemHandle otherItem : other) {
                if ((item != null || otherItem == null) && (item == null || item.sameItemId(otherItem))) continue;
                return false;
            }
        }
        return true;
    }
}

