/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.changes.model;

import com.ibm.team.filesystem.client.util.ConnectionUtil;
import com.ibm.team.filesystem.common.changemodel.IPathResolver;
import com.ibm.team.filesystem.common.changemodel.VersionablePath;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.SiloedItemId;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemotePathResolver
implements IPathResolver {
    private IConnection connection;

    public RemotePathResolver(IConnection connection) {
        this.connection = connection;
    }

    public Map<SiloedItemId<IVersionable>, VersionablePath> resolve(Collection<SiloedItemId<IVersionable>> unresolved, IProgressMonitor monitor) throws TeamRepositoryException {
        List<Object> verIds;
        HashMap<IComponentHandle, LinkedList<ItemId>> cpVerMap = new HashMap<IComponentHandle, LinkedList<ItemId>>();
        for (SiloedItemId<IVersionable> siloedItemId : unresolved) {
            IComponentHandle cpHandle = siloedItemId.getComponentHandle();
            ItemId verId = ItemId.create((IItemHandle)siloedItemId.toHandle());
            verIds = (LinkedList<ItemId>)cpVerMap.get(cpHandle);
            if (verIds == null) {
                verIds = new LinkedList<ItemId>();
                cpVerMap.put(cpHandle, (LinkedList<ItemId>)verIds);
            }
            verIds.add(verId);
        }
        HashMap<SiloedItemId<IVersionable>, VersionablePath> toReturn = new HashMap<SiloedItemId<IVersionable>, VersionablePath>();
        for (Map.Entry entry : cpVerMap.entrySet()) {
            IComponentHandle cpHandle = (IComponentHandle)entry.getKey();
            verIds = (List)entry.getValue();
            IConfiguration config = null;
            if (this.connection instanceof IWorkspaceConnection) {
                config = ((IWorkspaceConnection)this.connection).configuration(cpHandle);
            } else if (this.connection instanceof IBaselineConnection) {
                config = ((IBaselineConnection)this.connection).configuration();
            }
            Map verIdPaths = ConnectionUtil.resolvePaths((IConfiguration)config, verIds, null);
            ItemId cpId = ItemId.create((IItemHandle)cpHandle);
            for (Map.Entry pEntry : verIdPaths.entrySet()) {
                SiloedItemId siloedVer = SiloedItemId.create((ItemId)((ItemId)pEntry.getKey()), (ItemId)cpId);
                toReturn.put((SiloedItemId<IVersionable>)siloedVer, (VersionablePath)pEntry.getValue());
            }
        }
        return toReturn;
    }
}

