/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.changes.model;

import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.common.changemodel.IPathResolver;
import com.ibm.team.filesystem.common.changemodel.VersionablePath;
import com.ibm.team.filesystem.common.changemodel.VersionablePathSegment;
import com.ibm.team.filesystem.rcp.core.internal.CoreShareablesUtil;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.internal.util.SiloedItemId;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyFileAreaPathResolver
implements IPathResolver {
    private boolean resolveConflicts;

    private CopyFileAreaPathResolver(boolean resolveConflicts) {
        this.resolveConflicts = resolveConflicts;
    }

    public static CopyFileAreaPathResolver create() {
        return CopyFileAreaPathResolver.create(true);
    }

    public static CopyFileAreaPathResolver create(boolean resolveConflicts) {
        return new CopyFileAreaPathResolver(resolveConflicts);
    }

    public Map<SiloedItemId<IVersionable>, VersionablePath> resolve(Collection<SiloedItemId<IVersionable>> unresolved, IProgressMonitor monitor) throws TeamRepositoryException {
        HashMap<SiloedItemId<IVersionable>, VersionablePath> result = new HashMap<SiloedItemId<IVersionable>, VersionablePath>();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Map<SiloedItemId<IVersionable>, List<IShareable>> shareablesMap = CoreShareablesUtil.findShareables(unresolved, (IProgressMonitor)progress.newChild(100));
        for (SiloedItemId<IVersionable> next : unresolved) {
            IResource resource;
            List<IShareable> shareables = shareablesMap.get(next);
            IShareable shareable = null;
            if (shareables.size() == 1 || shareables.size() > 1 && this.resolveConflicts) {
                shareable = shareables.iterator().next();
            }
            if ((resource = (IResource)Adapters.getAdapter((Object)shareable, IResource.class)) != null) {
                result.put(next, CoreShareablesUtil.getPathTo(resource, true));
                continue;
            }
            result.put(next, VersionablePath.create((VersionablePathSegment[])new VersionablePathSegment[0], next, (boolean)false));
        }
        return result;
    }
}

