/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.changes;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.ICopyFileAreaEvent;
import com.ibm.team.filesystem.client.ICopyFileAreaListener;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.LoadedConfigurationDescriptor;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.changes.ILocalSynchronizationManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.WorkspaceComponent;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncModel;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ComponentSyncModel;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.client.util.Event;
import com.ibm.team.repository.client.util.EventSource;
import com.ibm.team.repository.client.util.IEvent;
import com.ibm.team.repository.client.util.IEventSource;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.transport.ConnectionException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalSynchronizationManager
extends EventSource
implements ILocalSynchronizationManager {
    SharingManagerListener sharingManagerListener;
    ComponentSyncModel model;
    boolean autoSave;
    boolean autoComplete;
    List sharedComponentSyncInfos;
    IListener modelListener;
    volatile Collection<LoadedConfigurationDescriptor> loadedComponents = Collections.EMPTY_LIST;

    public LocalSynchronizationManager(ComponentSyncModel model) {
        super((EventSource)model);
        this.model = model;
    }

    @Override
    public boolean getAutoSave() {
        return this.autoSave;
    }

    @Override
    public boolean getAutoComplete() {
        return this.autoComplete;
    }

    @Override
    public void setAutoSave(boolean enable) {
        this.autoSave = enable;
        ComponentSyncUtil.setAutoSave(this.model, enable);
    }

    @Override
    public void setAutoComplete(boolean enable) {
        this.autoComplete = enable;
        ComponentSyncUtil.setAutoComplete(this.model, enable);
    }

    @Override
    public void update() {
        if (this.sharingManagerListener != null) {
            this.sharingManagerListener.update();
        }
    }

    @Override
    public boolean isShared(IWorkspaceHandle workspace, IComponentHandle component) {
        return this.sharingManagerListener != null ? this.sharingManagerListener.isShared(workspace, component) : false;
    }

    public Collection<WorkspaceComponent> getSharedWorkspaceComponents() {
        return this.sharingManagerListener != null ? this.sharingManagerListener.getSharedWorkspaceComponents() : Collections.EMPTY_LIST;
    }

    @Override
    public IComponentSyncModel getComponentSyncModel() {
        return this.model;
    }

    @Override
    public Collection<LoadedConfigurationDescriptor> getLoadedComponents() {
        return this.loadedComponents;
    }

    public void dispose() {
        if (this.sharingManagerListener != null) {
            this.sharingManagerListener.dispose();
        }
        this.sharingManagerListener = null;
    }

    public void init() {
        if (this.sharingManagerListener != null) {
            throw new IllegalStateException();
        }
        this.sharingManagerListener = new SharingManagerListener();
        this.sharingManagerListener.start();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SharingManagerListener
    implements ICopyFileAreaListener {
        private UpdateSharesJob updateSharesJob;
        private IListener serverListener = null;
        private Object sharedComponentsLock = new Object();
        private HashSet<WorkspaceComponent> sharedComponentWorkspaces = new HashSet();

        public SharingManagerListener() {
            this.updateSharesJob = new UpdateSharesJob();
            this.updateSharesJob.setPriority(50);
            this.serverListener = new IListener(){

                public void handleEvents(List events) {
                    Iterator i = events.iterator();
                    while (i.hasNext()) {
                        IEventSource notifier = ((IEvent)i.next()).getEventSource();
                        if (!(notifier instanceof ITeamRepository) || !((ITeamRepository)notifier).loggedIn()) continue;
                        SharingManagerListener.this.update();
                        return;
                    }
                }
            };
        }

        public void update() {
            if (this.updateSharesJob != null) {
                this.updateSharesJob.requestUpdate();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isShared(IWorkspaceHandle workspace, IComponentHandle component) {
            Object object = this.sharedComponentsLock;
            synchronized (object) {
                return this.sharedComponentWorkspaces.contains(new WorkspaceComponent(workspace, component));
            }
        }

        public void change(ICopyFileAreaEvent[] events) {
            ICopyFileAreaEvent[] iCopyFileAreaEventArray = events;
            int n = events.length;
            int n2 = 0;
            while (n2 < n) {
                ICopyFileAreaEvent event = iCopyFileAreaEventArray[n2];
                switch (event.getReason()) {
                    case 7: 
                    case 8: {
                        this.update();
                        return;
                    }
                }
                ++n2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection<WorkspaceComponent> getSharedWorkspaceComponents() {
            Object object = this.sharedComponentsLock;
            synchronized (object) {
                return Collections.unmodifiableSet(this.sharedComponentWorkspaces);
            }
        }

        public void start() {
            FileSystemCore.getSharingManager().addListener((ICopyFileAreaListener)this);
            TeamPlatform.getTeamRepositoryService().addGenericListener((Object)"state", this.serverListener);
            this.updateSharesJob.requestUpdate();
        }

        public void dispose() {
            FileSystemCore.getSharingManager().removeListener((ICopyFileAreaListener)this);
            TeamPlatform.getTeamRepositoryService().removeGenericListener((Object)"state", this.serverListener);
            this.updateSharesJob = null;
        }

        class UpdateSharesJob
        extends Job {
            public UpdateSharesJob() {
                super(Messages.LocalSynchronizationManager_JobName);
            }

            public void requestUpdate() {
                this.schedule(1000L);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                try {
                    Collection loadedComponents;
                    HashSet<WorkspaceComponent> newSharedComponentWorkspaces = new HashSet<WorkspaceComponent>();
                    ((SharingManagerListener)SharingManagerListener.this).LocalSynchronizationManager.this.loadedComponents = loadedComponents = CopyFileAreaStore.getDefaultCopyFileArea().allLoadedComponents(monitor);
                    for (ConfigurationDescriptor loadedComponent : loadedComponents) {
                        ITeamRepository repo;
                        if (!(loadedComponent.connectionHandle instanceof IWorkspaceHandle) || (repo = loadedComponent.getTeamRepository()) == null || !repo.loggedIn()) continue;
                        IWorkspaceHandle workspace = (IWorkspaceHandle)loadedComponent.connectionHandle;
                        IComponentHandle component = loadedComponent.componentHandle;
                        IWorkspaceConnection wc = null;
                        try {
                            wc = (IWorkspaceConnection)loadedComponent.getConnection(null);
                        }
                        catch (ItemNotFoundException itemNotFoundException) {
                        }
                        catch (ConnectionException connectionException) {}
                        if (wc == null) continue;
                        newSharedComponentWorkspaces.add(new WorkspaceComponent(workspace, component));
                    }
                    Object object = SharingManagerListener.this.sharedComponentsLock;
                    synchronized (object) {
                        if (!SharingManagerListener.this.sharedComponentWorkspaces.equals(newSharedComponentWorkspaces)) {
                            SharingManagerListener.this.sharedComponentWorkspaces = newSharedComponentWorkspaces;
                        }
                    }
                    LocalSynchronizationManager.this.queueEvent(new Event((IEventSource)LocalSynchronizationManager.this, "loadedComponents"));
                }
                catch (TeamRepositoryException e) {
                    return FileSystemStatus.getStatusFor((int)4, (String)"com.ibm.team.filesystem.client", (int)0, (String)Messages.LocalSynchronizationManager_ErrorRefreshingLoadedWorkspaceList, (Throwable)e);
                }
                catch (FileSystemClientException e) {
                    return FileSystemStatus.getStatusFor((int)4, (String)"com.ibm.team.filesystem.client", (int)0, (String)Messages.LocalSynchronizationManager_ErrorRefreshingLoadedWorkspaceList, (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        }
    }
}

