/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal;

import com.ibm.team.filesystem.common.changemodel.VersionablePath;
import com.ibm.team.filesystem.common.changemodel.VersionablePathSegment;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.core.preferences.PreferencesUtil;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.SiloedItemId;
import com.ibm.team.scm.common.internal.util.StateId;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalPreferencesUtil {
    private static final String UUID_ID = "uuid";
    private static final String TYPE_NAME_ID = "type";
    private static final String TYPE_NAMESPACE_ID = "namespace";
    private static final String COMPONENT_ID = "component";
    private static final String ATTR_ITEM = "item";
    private static final String ATTR_RESOLVED = "resolved";
    private static final String ATTR_SEGMENTCOUNT = "segmentCount";
    private static final String ATTR_CHILDNAME = "childName";
    private static final String STATE_ID = "stateid";

    public static <T extends IItem> ItemId<T> getItemId(Preferences pref, String key) throws CoreException {
        Preferences child = pref.node(key);
        return InternalPreferencesUtil.loadItemId(child);
    }

    public static <T extends IItem> void putItemId(Preferences pref, String key, ItemId<T> value) {
        Preferences child = pref.node(key);
        InternalPreferencesUtil.saveItemId(child, value);
    }

    public static <T extends IItem> ItemId<T> getItemId(Preferences pref, String key, ItemId defaultValue) {
        try {
            return InternalPreferencesUtil.getItemId(pref, key);
        }
        catch (CoreException coreException) {
            return defaultValue;
        }
    }

    private static <T extends IItem> ItemId<T> loadItemId(Preferences prefs) throws CoreException {
        UUID uuid = PreferencesUtil.getUUID((Preferences)prefs, (String)UUID_ID);
        String type = PreferencesUtil.getString((Preferences)prefs, (String)TYPE_NAME_ID);
        String typeNamespace = PreferencesUtil.getString((Preferences)prefs, (String)TYPE_NAMESPACE_ID);
        IItemType itemType = IItemType.IRegistry.INSTANCE.getItemType(type, typeNamespace);
        return new ItemId(itemType, uuid);
    }

    public static <T extends IVersionable> SiloedItemId<T> getSiloedItemId(Preferences pref, String key) throws CoreException {
        Preferences child = pref.node(key);
        ItemId<T> itemId = InternalPreferencesUtil.loadItemId(child);
        return SiloedItemId.create((IItemType)itemId.getItemType(), (UUID)itemId.getItemUUID(), (UUID)PreferencesUtil.getUUID((Preferences)child, (String)COMPONENT_ID));
    }

    public static void putSiloedItemId(Preferences pref, String key, SiloedItemId itemId) {
        Preferences child = pref.node(key);
        InternalPreferencesUtil.saveItemId(child, itemId.getItemId());
        PreferencesUtil.putUUID((Preferences)child, (String)COMPONENT_ID, (UUID)itemId.getComponentUUID());
    }

    private static void saveItemId(Preferences child, ItemId itemId) {
        PreferencesUtil.putUUID((Preferences)child, (String)UUID_ID, (UUID)itemId.getItemUUID());
        child.put(TYPE_NAME_ID, itemId.getItemType().getName());
        child.put(TYPE_NAMESPACE_ID, itemId.getItemType().getNamespaceURI());
    }

    public static VersionablePath getVersionablePath(Preferences br) throws CoreException {
        SiloedItemId siloedItemId = InternalPreferencesUtil.getSiloedItemId(br, ATTR_ITEM);
        boolean isResolved = PreferencesUtil.getBoolean((Preferences)br, (String)ATTR_RESOLVED);
        int segmentCount = PreferencesUtil.getInteger((Preferences)br, (String)ATTR_SEGMENTCOUNT);
        ArrayList<VersionablePathSegment> segments = new ArrayList<VersionablePathSegment>();
        int idx = 0;
        while (idx < segmentCount) {
            segments.add(InternalPreferencesUtil.getPathSegment(br, "" + idx));
            ++idx;
        }
        return VersionablePath.create(segments, siloedItemId, (boolean)isResolved);
    }

    public static VersionablePath getVersionablePath(Preferences br, String key, VersionablePath defaultValue) throws CoreException {
        try {
            if (!br.nodeExists(key)) {
                return defaultValue;
            }
            return InternalPreferencesUtil.getVersionablePath(br.node(key));
        }
        catch (CoreException coreException) {
            return defaultValue;
        }
        catch (BackingStoreException e) {
            throw new CoreException(StatusUtil.newStatus(InternalPreferencesUtil.class, (Throwable)e));
        }
    }

    public static void putVersionablePath(Preferences bw, VersionablePath versionablePath) {
        InternalPreferencesUtil.putSiloedItemId(bw, ATTR_ITEM, versionablePath.getSiloedItemId());
        PreferencesUtil.putBoolean((Preferences)bw, (String)ATTR_RESOLVED, (boolean)versionablePath.isAbsolute());
        PreferencesUtil.putInteger((Preferences)bw, (String)ATTR_SEGMENTCOUNT, (int)versionablePath.segmentCount());
        int idx = 0;
        while (idx < versionablePath.segmentCount()) {
            InternalPreferencesUtil.putPathSegment(bw, "" + idx, versionablePath.segment(idx));
            ++idx;
        }
    }

    public static VersionablePathSegment getPathSegment(Preferences br, String string) throws CoreException {
        Preferences prefs = br.node(string);
        return VersionablePathSegment.create(InternalPreferencesUtil.loadItemId(prefs), (String)PreferencesUtil.getString((Preferences)prefs, (String)ATTR_CHILDNAME));
    }

    public static void putPathSegment(Preferences bw, String attribute, VersionablePathSegment segment) {
        Preferences prefs = bw.node(attribute);
        InternalPreferencesUtil.saveItemId(prefs, segment.getParent());
        PreferencesUtil.putString((Preferences)prefs, (String)ATTR_CHILDNAME, (String)segment.lastSegment());
    }

    public static StateId getStateId(Preferences savedState, String string) throws CoreException {
        Preferences prefs = savedState.node(string);
        UUID uuid = PreferencesUtil.getUUID((Preferences)prefs, (String)UUID_ID);
        UUID stateId = PreferencesUtil.getUUID((Preferences)prefs, (String)STATE_ID);
        String type = PreferencesUtil.getString((Preferences)prefs, (String)TYPE_NAME_ID);
        String typeNamespace = PreferencesUtil.getString((Preferences)prefs, (String)TYPE_NAMESPACE_ID);
        IItemType itemType = IItemType.IRegistry.INSTANCE.getItemType(type, typeNamespace);
        return new StateId(itemType, uuid, stateId);
    }

    public static void putStateId(Preferences whereToSave, String key, StateId stateId) {
        Preferences child = whereToSave.node(key);
        PreferencesUtil.putUUID((Preferences)child, (String)UUID_ID, (UUID)stateId.getItemUUID());
        PreferencesUtil.putUUID((Preferences)child, (String)STATE_ID, (UUID)stateId.getStateUUID());
        child.put(TYPE_NAME_ID, stateId.getItemType().getName());
        child.put(TYPE_NAMESPACE_ID, stateId.getItemType().getNamespaceURI());
    }

    public static void putVersionablePath(Preferences whereToSave, String versionablePathId, VersionablePath path) {
        InternalPreferencesUtil.putVersionablePath(whereToSave.node(versionablePathId), path);
    }
}

