/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ILocalChangeManager;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ISharingManager;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.namespace.BaselineNamespace;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.namespace.WorkspaceNamespace;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.changemodel.VersionablePath;
import com.ibm.team.filesystem.common.changemodel.VersionablePathSegment;
import com.ibm.team.filesystem.common.internal.util.ItemUtil;
import com.ibm.team.filesystem.rcp.core.internal.FileStorageUtil;
import com.ibm.team.filesystem.rcp.core.internal.resources.EclipseFileStorage;
import com.ibm.team.filesystem.rcp.core.internal.resources.ResourceUtil;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.utils.IInputStreamProvider;
import com.ibm.team.repository.rcp.common.collection.CollectionUtil;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.NewCollection;
import com.ibm.team.scm.common.internal.util.SiloedItemId;
import com.ibm.team.scm.common.internal.util.StateId;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreShareablesUtil {
    public static VersionablePath getPathTo(IResource resource) {
        return CoreShareablesUtil.getPathTo(resource, true);
    }

    public static VersionablePath getPathTo(IResource resource, boolean stopAtFirstMissingSegment) {
        LinkedList<VersionablePathSegment> segments = new LinkedList<VersionablePathSegment>();
        boolean resolved = true;
        IResource current = resource;
        while (current.getParent() != null && !(current instanceof IWorkspaceRoot)) {
            VersionablePathSegment nextSegment = CoreShareablesUtil.getSegment(current);
            if (!(current instanceof IProject) && nextSegment.getParent().isNull() && stopAtFirstMissingSegment) {
                resolved = false;
                break;
            }
            segments.addFirst(nextSegment);
            current = current.getParent();
        }
        return VersionablePath.create(segments, CoreShareablesUtil.getSiloedItem(resource), (boolean)resolved);
    }

    public static VersionablePathSegment getSegment(IResource resource) {
        ItemId parent = CoreShareablesUtil.getItem((IResource)resource.getParent());
        if (resource instanceof IProject) {
            parent = ItemId.getNullItem((IItemType)IFolder.ITEM_TYPE);
        }
        return VersionablePathSegment.create((ItemId)parent, (String)resource.getName());
    }

    public static IResource getResourceFor(VersionablePath desiredPath, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(desiredPath.segmentCount() + 1));
        SiloedItemId itemId = desiredPath.getSiloedItemId();
        IResource res = CoreShareablesUtil.getResourceFor((SiloedItemId<IVersionable>)itemId, (IProgressMonitor)progress.newChild(1));
        if (res != null) {
            return res;
        }
        Path suffix = new Path("");
        int idx = desiredPath.segmentCount() - 1;
        while (idx >= 0) {
            VersionablePathSegment segment = desiredPath.segment(idx);
            suffix = new Path(segment.lastSegment()).append((IPath)suffix);
            ItemId parent = ItemId.upcast((ItemId)segment.getParent());
            res = CoreShareablesUtil.getResourceFor((SiloedItemId<IVersionable>)SiloedItemId.create((ItemId)parent, (ItemId)desiredPath.getSiloedItemId().getComponent()), (IProgressMonitor)progress.newChild(1));
            if (res != null) {
                return ResourceUtil.getResource(res.getFullPath().append((IPath)suffix));
            }
            --idx;
        }
        return ResourceUtil.getResource(desiredPath.toPath());
    }

    public static Map<SiloedItemId<IVersionable>, List<IShareable>> findShareables(Collection<SiloedItemId<IVersionable>> toFind, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)toFind.size());
        HashMap itemsByComponent = new HashMap();
        for (SiloedItemId<IVersionable> next : toFind) {
            CollectionUtil.addToMapOfLists(itemsByComponent, (Object)next.getComponent(), next);
        }
        HashMap<SiloedItemId<IVersionable>, List<IShareable>> result = new HashMap<SiloedItemId<IVersionable>, List<IShareable>>();
        for (Map.Entry next : itemsByComponent.entrySet()) {
            for (SiloedItemId nextItem : (List)next.getValue()) {
                result.put((SiloedItemId<IVersionable>)nextItem, CoreShareablesUtil.findShareables((SiloedItemId<IVersionable>)nextItem, (IProgressMonitor)progress.newChild(1)));
            }
        }
        return result;
    }

    public static List<IShareable> findShareables(SiloedItemId<IVersionable> versionable, IProgressMonitor monitor) throws TeamRepositoryException {
        ISharingManager mgr = FileSystemCore.getSharingManager();
        try {
            return mgr.findShareables(mgr.getDefaultCFARoot(), versionable.toHandle(), versionable.getComponentHandle(), monitor);
        }
        catch (FileSystemClientException e) {
            throw new TeamRepositoryException(e.getMessage(), StatusUtil.getCause((Throwable)e));
        }
    }

    public static ItemId<IVersionable> getItem(IResource resource) {
        IShareable shareable = (IShareable)resource.getAdapter(IShareable.class);
        return CoreShareablesUtil.getItem(shareable);
    }

    public static SiloedItemId<IVersionable> getSiloedItem(IResource resource) {
        IShareable shareable = (IShareable)resource.getAdapter(IShareable.class);
        if (shareable == null) {
            return SiloedItemId.getNullItem((IItemType)IFileItem.ITEM_TYPE);
        }
        IShare share = shareable.getShare();
        if (share == null) {
            return SiloedItemId.getNullItem((IItemType)IFileItem.ITEM_TYPE);
        }
        return SiloedItemId.create((ItemId)CoreShareablesUtil.getItem(shareable), CoreShareablesUtil.getComponent(shareable.getShare().getSharingDescriptor()));
    }

    public static ItemId getItem(IShareable shareable) {
        if (shareable == null) {
            return ItemId.getNullItem((IItemType)IFileItem.ITEM_TYPE);
        }
        IItemType itemType = ((Shareable)shareable).getFileStorage().isFolder() ? IFolder.ITEM_TYPE : IFileItem.ITEM_TYPE;
        IVersionableHandle remote = shareable.getVersionable();
        if (remote == null) {
            return ItemId.getNullItem((IItemType)itemType);
        }
        return new ItemId((IItemHandle)remote);
    }

    public static IResource getResourceFor(SiloedItemId<IVersionable> ver, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (ver.isNull()) {
            return null;
        }
        List<IShareable> shareables = CoreShareablesUtil.findShareables(ver, (IProgressMonitor)progress.newChild(50));
        for (IShareable next : shareables) {
            IResource resource = (IResource)next.getAdapter(IResource.class);
            if (resource == null) continue;
            return resource;
        }
        return null;
    }

    public static ItemId<IComponent> getComponent(ISharingDescriptor sharingDescriptor) {
        return ItemUtil.getComponent((IComponentHandle)sharingDescriptor.getComponent());
    }

    public static ItemId<IComponent> getComponent(IShareable shareable) {
        ISharingDescriptor descriptor;
        IShare share;
        if (shareable != null && (share = shareable.getShare()) != null && (descriptor = share.getSharingDescriptor()) != null) {
            return CoreShareablesUtil.getComponent(descriptor);
        }
        return ItemId.getNullItem((IItemType)IComponent.ITEM_TYPE);
    }

    public static ItemId<IComponent> getComponent(ILocalChange next) {
        return new ItemId((IItemHandle)next.getComponent());
    }

    public static SiloedItemId<IVersionable> getSiloedItem(ILocalChange next) {
        return SiloedItemId.create((IVersionableHandle)next.getTarget(), (IComponentHandle)next.getComponent());
    }

    public static StateId getBeforeState(ILocalChange next) {
        IVersionableHandle itemHandle = next.getTarget();
        if ((next.getType() & 2) != 0) {
            return new StateId(itemHandle.getItemType(), itemHandle.getItemId(), StateId.STATE_DELETED);
        }
        return new StateId((IItemHandle)itemHandle);
    }

    public static Map<ItemNamespace, List<IShareable>> groupByContributorPlace(Collection<IShareable> shareables) {
        Map resultMap = NewCollection.hashMap();
        for (IShareable next : shareables) {
            ItemNamespace nextNamespace = CoreShareablesUtil.getContributorPlace(next);
            if (nextNamespace == null) continue;
            CollectionUtil.addToMapOfLists((Map)resultMap, (Object)nextNamespace, (Object)next);
        }
        return resultMap;
    }

    public static ItemNamespace getContributorPlace(IShareable shareable) {
        ISharingDescriptor sd;
        IShare share = shareable.getShare();
        if (share != null && (sd = share.getSharingDescriptor()) != null) {
            return CoreShareablesUtil.getNamespace(sd);
        }
        return null;
    }

    public static Set<ItemNamespace> findDescriptors(ItemNamespace namespace, boolean workspacesOnly, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        ISharingManager mgr = FileSystemCore.getSharingManager();
        List allDescriptors = NewCollection.arrayList();
        IShare[] shares = mgr.allShares();
        int i = 0;
        while (i < shares.length) {
            IShare share = shares[i];
            ISharingDescriptor descriptor = share.getSharingDescriptor();
            if (!workspacesOnly || descriptor.associatedWithWorkspace()) {
                allDescriptors.add(CoreShareablesUtil.getNamespace(descriptor));
            }
            ++i;
        }
        return CoreShareablesUtil.findBestDescriptors(allDescriptors, namespace, monitor);
    }

    public static Set<ItemNamespace> findBestDescriptors(Collection<ItemNamespace> potentialDescriptors, ItemNamespace namespace, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Set exactMatches = NewCollection.hashSet();
        Set potentialMatches = NewCollection.hashSet();
        ItemId targetComponent = namespace.fetchComponentId(monitor);
        progress.setWorkRemaining(potentialDescriptors.size());
        for (ItemNamespace descriptor : potentialDescriptors) {
            SubMonitor iterationProgress = progress.newChild(1);
            if (descriptor.equals((Object)namespace)) {
                exactMatches.add(descriptor);
                continue;
            }
            ItemId nextComponent = descriptor.fetchComponentId((IProgressMonitor)iterationProgress);
            if (!nextComponent.equals((Object)targetComponent)) continue;
            potentialMatches.add(descriptor);
        }
        if (!exactMatches.isEmpty()) {
            return exactMatches;
        }
        return potentialMatches;
    }

    public static Set<ItemNamespace> getSharingDescriptors(Collection<IShareable> shareables) {
        Set result = NewCollection.hashSet();
        for (IShareable next : shareables) {
            result.add(CoreShareablesUtil.getNamespace(next.getShare().getSharingDescriptor()));
        }
        return result;
    }

    public static Set<IShareable> getShareablesFor(Collection<IShareable> inputShareables, Set<ItemNamespace> descriptors) {
        Set result = NewCollection.hashSet();
        for (IShareable next : inputShareables) {
            ItemNamespace namespace = CoreShareablesUtil.getNamespace(next.getShare().getSharingDescriptor());
            if (!descriptors.contains(namespace)) continue;
            result.add(next);
        }
        return result;
    }

    public static Set<IShareable> findShareables(ItemId versionable, ItemNamespace namespace, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ISharingManager mgr = FileSystemCore.getSharingManager();
        List shareables = mgr.findShareables(mgr.getDefaultCFARoot(), (IVersionableHandle)versionable.toHandle(), (IProgressMonitor)progress.newChild(50));
        if (shareables.size() == 1) {
            Set result = NewCollection.hashSet();
            result.addAll(shareables);
            return result;
        }
        Set<ItemNamespace> descriptors = CoreShareablesUtil.getSharingDescriptors(shareables);
        Set<ItemNamespace> bestMatches = CoreShareablesUtil.findBestDescriptors(descriptors, namespace, (IProgressMonitor)progress.newChild(50));
        return CoreShareablesUtil.getShareablesFor(shareables, bestMatches);
    }

    public static Set<IShareable> findShareables(ItemId versionable, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ISharingManager mgr = FileSystemCore.getSharingManager();
        List shareables = mgr.findShareables(mgr.getDefaultCFARoot(), (IVersionableHandle)versionable.toHandle(), (IProgressMonitor)progress.newChild(50));
        Set result = NewCollection.hashSet();
        result.addAll(shareables);
        return result;
    }

    public static List<ILocalChange> getLocalChanges(ItemNamespace namespace, boolean refresh, IProgressMonitor monitor) throws TeamRepositoryException {
        IContextHandle contextHandle = namespace.getContextHandle();
        SharingManager sharingManager = SharingManager.getInstance();
        ILocalChangeManager localChangeManager = sharingManager.getLocalChangeManager();
        if (contextHandle == null) {
            return Collections.emptyList();
        }
        IComponentHandle ch = (IComponentHandle)namespace.fetchComponentId(monitor).toHandle();
        if (refresh) {
            localChangeManager.syncPendingChanges(contextHandle, ch, SharingManager.getInstance().getDefaultCFARoot());
        }
        ILocalChange[] array = localChangeManager.getPendingChanges(contextHandle, ch, SharingManager.getInstance().getDefaultCFARoot());
        List result = NewCollection.arrayList();
        int i = 0;
        while (i < array.length) {
            ILocalChange localChange = array[i];
            result.add(localChange);
            ++i;
        }
        return result;
    }

    public static ItemNamespace getNamespace(ISharingDescriptor descriptor) {
        ITeamRepository repository = CoreShareablesUtil.getRepository(descriptor);
        if (descriptor.associatedWithWorkspace()) {
            ItemId workspace = new ItemId((IItemHandle)((IWorkspaceHandle)descriptor.getConnectionHandle()));
            ItemId component = new ItemId((IItemHandle)descriptor.getComponent());
            return WorkspaceNamespace.create((ITeamRepository)repository, (ItemId)workspace, (ItemId)component);
        }
        ItemId baseline = new ItemId((IItemHandle)((IBaselineHandle)descriptor.getConnectionHandle()));
        return BaselineNamespace.create((ITeamRepository)repository, (ItemId)baseline);
    }

    public static ITeamRepository getRepository(ISharingDescriptor descr) {
        return RepositoryUtils.getTeamRepository((String)descr.getRepositoryUri(), (UUID)descr.getRepositoryId());
    }

    public static ItemNamespace getContributorPlace(IResource resource) {
        return CoreShareablesUtil.getContributorPlace((IShareable)Adapters.getAdapter((Object)resource, IShareable.class));
    }

    public static void createFile(IFile theFile, IInputStreamProvider fileContents, VersionablePath verPath, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            InputStream theStream = fileContents.getInputStream((IProgressMonitor)progress.newChild(5));
            try {
                CoreShareablesUtil.createFile(theFile, theStream, verPath, (IProgressMonitor)progress.newChild(95));
            }
            finally {
                theStream.close();
            }
        }
        catch (IOException e) {
            throw new FileSystemClientException(StatusUtil.newStatus(CoreShareablesUtil.class, (Throwable)e));
        }
    }

    public static void createFile(IFile theFile, InputStream fileContents, VersionablePath verPath, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            CoreShareablesUtil.createFolder(theFile.getParent(), verPath.removeLastSegments(1), (IProgressMonitor)progress.newChild(20));
        }
        catch (CoreException e1) {
            throw new FileSystemClientException(StatusUtil.newStatus(CoreShareablesUtil.class, (Throwable)e1));
        }
        IPath fullPath = theFile.getFullPath();
        if (fullPath.lastSegment().equals(".project") && fullPath.segmentCount() == 2 && theFile.exists()) {
            try {
                theFile.delete(true, (IProgressMonitor)progress.newChild(50));
            }
            catch (CoreException e) {
                throw new FileSystemClientException(StatusUtil.newStatus(CoreShareablesUtil.class, (Throwable)e));
            }
            progress.setWorkRemaining(100);
        }
        ItemId itemId = verPath.getItemId();
        FileStorageUtil.createFile(new EclipseFileStorage((IResource)theFile), fileContents, (ItemId<IVersionable>)itemId, (IProgressMonitor)progress.newChild(80));
    }

    public static void createFolder(IContainer theFolder, ItemId itemId, IProgressMonitor monitor) throws FileSystemClientException {
        CoreShareablesUtil.createFolder(theFolder, VersionablePath.getUnresolvedPath((ItemId)itemId), monitor);
    }

    public static void createFolder(IContainer theFolder, VersionablePath path, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (theFolder.exists()) {
            return;
        }
        try {
            if (!(theFolder instanceof org.eclipse.core.resources.IFolder)) {
                ResourceUtil.createPath(theFolder, (IProgressMonitor)progress.newChild(100));
                return;
            }
            CoreShareablesUtil.createFolder(theFolder.getParent(), path.removeLastSegments(1), (IProgressMonitor)progress.newChild(50));
            ItemId itemId = path.getItemId();
            if (theFolder instanceof org.eclipse.core.resources.IFolder && !itemId.isNull()) {
                org.eclipse.core.resources.IFolder folder = (org.eclipse.core.resources.IFolder)theFolder;
                FileStorageUtil.createFolder(new EclipseFileStorage((IResource)folder), (ItemId<IFolder>)itemId, (IProgressMonitor)progress.newChild(50));
            } else {
                ResourceUtil.createPath(theFolder, (IProgressMonitor)progress.newChild(100));
            }
        }
        catch (CoreException e) {
            throw new FileSystemClientException(StatusUtil.newStatus(CoreShareablesUtil.class, (Throwable)e));
        }
    }
}

