/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.tools.verify;

import com.ibm.team.filesystem.cli.tools.verify.FileSystemComparator;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.rcp.core.internal.resources.EclipseFileStorage;
import junit.framework.Assert;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

public class EclipseWorkspaceComparator
extends FileSystemComparator {
    private IResource root;
    private IContainer cfaRoot;

    public EclipseWorkspaceComparator(IResource root) {
        super(ResourcesPlugin.getWorkspace().getRoot().getLocation(), (IFileStorage)new EclipseFileStorage(root));
        this.root = root;
        this.cfaRoot = ResourcesPlugin.getWorkspace().getRoot();
    }

    public EclipseWorkspaceComparator(IResource root, IContainer cfaRoot) {
        super(cfaRoot.getLocation(), (IFileStorage)new EclipseFileStorage((IResource)cfaRoot));
        this.root = root;
        this.cfaRoot = cfaRoot;
    }

    protected IFileStorage getStorage(String remoteName) {
        IResource resource = this.cfaRoot.findMember(remoteName);
        if (resource != null) {
            return new EclipseFileStorage(resource);
        }
        return null;
    }

    protected boolean rootExists() {
        return this.root.exists();
    }

    protected boolean exists(String stringPath) {
        return ResourcesPlugin.getWorkspace().getRoot().findMember(stringPath) != null;
    }

    protected void walkFileSystem(FileSystemComparator.FileSystemValidator validator) throws CoreException {
        ResourceVisitor visitor = new ResourceVisitor(validator);
        this.root.accept((IResourceVisitor)visitor);
    }

    private static class ResourceVisitor
    implements IResourceVisitor {
        private FileSystemComparator.FileSystemValidator validator;

        public ResourceVisitor(FileSystemComparator.FileSystemValidator validator) {
            this.validator = validator;
        }

        public boolean visit(IResource resource) throws CoreException {
            boolean isFolder = false;
            if (resource instanceof IFolder || resource instanceof IProject) {
                isFolder = true;
            } else if (!(resource instanceof IFile)) {
                Assert.fail((String)("Unexpected resource " + resource.getFullPath().toString()));
            }
            this.validator.validate(resource.getFullPath().toString(), isFolder);
            return true;
        }
    }
}

