/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.subcommands;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.subcommands.ResolveCmdOpts;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.ChattyRepoRunnable;
import com.ibm.team.filesystem.cli.core.util.ICopyFileAreaView;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.IFileSystemView;
import com.ibm.team.filesystem.client.internal.operations.ResolveConflictsOperation;
import com.ibm.team.filesystem.client.operations.ApplyAcceptedDilemmaHandler;
import com.ibm.team.filesystem.client.operations.MarkAsMergedDilemmaHandler;
import com.ibm.team.filesystem.common.ILogicalChange;
import com.ibm.team.filesystem.common.ILogicalConflict;
import com.ibm.team.filesystem.common.ILogicalConflictReport;
import com.ibm.team.filesystem.rcp.core.internal.operations.EclipseWorkspaceApplyAcceptedOperation;
import com.ibm.team.filesystem.rcp.core.internal.operations.EclipseWorkspaceMarkAsMergedOperation;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.dto.IUpdateReport;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolveCmd
extends AbstractSubcommand {
    public void run(IClientConfiguration config) throws FileSystemClientException {
        ICommandLine subargs = config.getSubcommandCommandLine();
        Mode mode = Mode.MERGED;
        List resources = null;
        int defined = 0;
        try {
            resources = subargs.getOptions((IOptionKey)ResolveCmdOpts.OPT_RESOLVE_MERGED);
            ++defined;
            mode = Mode.MERGED;
        }
        catch (NoSuchElementException noSuchElementException) {}
        try {
            resources = subargs.getOptions((IOptionKey)ResolveCmdOpts.OPT_RESOLVE_PROPOSED);
            ++defined;
            mode = Mode.PROPOSED;
        }
        catch (NoSuchElementException noSuchElementException) {}
        if (defined != 1) {
            throw StatusHelper.argSyntax((String)Messages.ResolveCmd_1);
        }
        if (resources.size() == 0) {
            throw StatusHelper.argSyntax((String)Messages.ResolveCmd_2);
        }
        ResourcesPlugin.getWorkspace();
        Resolver resolver = null;
        switch (mode) {
            case MERGED: {
                resolver = new MergedResolver();
                break;
            }
            case PROPOSED: {
                resolver = new ProposedResolver();
            }
        }
        ICopyFileAreaView cfa = SubcommandUtil.getAffectedComponentsAndShares((IClientConfiguration)config);
        PathContainer[] paths = new PathContainer[resources.size()];
        int i = 0;
        while (i < paths.length) {
            paths[i] = new PathContainer((String)resources.get(i));
            ++i;
        }
        List<ToResolve> workspaces = this.findToResolve(config, cfa, paths);
        this.ensureMatched(paths);
        this.resolve(resolver, workspaces);
    }

    private void resolve(Resolver resolver, List<ToResolve> workspaces) throws FileSystemClientException {
        for (ToResolve toResolve : workspaces) {
            ResolveConflictsOperation op = resolver.resolve(toResolve);
            try {
                op.run(null);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((TeamRepositoryException)e, (String)Messages.ResolveCmd_4);
            }
        }
    }

    private List<ToResolve> findToResolve(IClientConfiguration config, ICopyFileAreaView cfa, final PathContainer[] paths) throws FileSystemClientException {
        final LinkedList<ToResolve> workspaces = new LinkedList<ToResolve>();
        ChattyRepoRunnable runnable = new ChattyRepoRunnable(config){

            public void run(ICopyFileAreaView cfa, ICopyFileAreaView.IRepoView view, IWorkspaceConnection wsConn) throws FileSystemClientException {
                ILogicalConflictReport conflictReport;
                IUpdateReport report = wsConn.conflictReport();
                IFileSystemView fsv = FileSystemCore.getFileSystemManager((ITeamRepository)wsConn.teamRepository()).getFileSystemView((IConnection)wsConn);
                try {
                    conflictReport = fsv.interpretConflicts(cfa.getRoot(), report.conflicts(), null);
                }
                catch (TeamRepositoryException e) {
                    throw StatusHelper.wrap((TeamRepositoryException)e, (String)Messages.ResolveCmd_6);
                }
                ResolveCmd.this.findChangesToResolve(cfa, view, wsConn, report, conflictReport, paths, workspaces);
            }
        };
        cfa.runOnEachRepo((ICopyFileAreaView.IRepoRunnable)runnable, config, (IOptionKey)CommonOptions.OPT_USERNAME, (IOptionKey)CommonOptions.OPT_PASSWORD);
        if (runnable.hadLoginFailure()) {
            throw StatusHelper.login();
        }
        return workspaces;
    }

    private void ensureMatched(PathContainer[] paths) throws FileSystemClientException {
        LinkedList<PathContainer> unmatched = new LinkedList<PathContainer>();
        PathContainer[] pathContainerArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            PathContainer path = pathContainerArray[n2];
            if (!path.matched) {
                unmatched.add(path);
            }
            ++n2;
        }
        if (unmatched.size() > 0) {
            System.err.println(Messages.ResolveCmd_7);
            for (PathContainer path : unmatched) {
                System.err.println("  " + path.path.toString());
            }
            throw StatusHelper.ambiguousSelector((String)Messages.ResolveCmd_8);
        }
    }

    protected void findChangesToResolve(ICopyFileAreaView cfa, ICopyFileAreaView.IRepoView view, IWorkspaceConnection wsConn, IUpdateReport report, ILogicalConflictReport conflictReport, PathContainer[] paths, LinkedList<ToResolve> workspaces) {
        LinkedList<ILogicalConflict> conflicts = new LinkedList<ILogicalConflict>();
        for (ItemId item : cfa.getLoadedComponents(view)) {
            for (ILogicalConflict conflict : conflictReport.getConflictsForComponent((IComponentHandle)item.toHandle())) {
                PathContainer[] pathContainerArray = paths;
                int n = paths.length;
                int n2 = 0;
                while (n2 < n) {
                    PathContainer path = pathContainerArray[n2];
                    if (Arrays.equals(path.segments, conflict.getPathHint())) {
                        path.matched = true;
                        conflicts.add(conflict);
                    }
                    ++n2;
                }
            }
        }
        if (conflicts.size() > 0) {
            workspaces.add(new ToResolve(wsConn, conflictReport, conflicts));
        }
    }

    private static class MergedResolver
    extends Resolver {
        private MergedResolver() {
        }

        protected ResolveConflictsOperation resolve(ToResolve toResolve) throws FileSystemClientException {
            return new EclipseWorkspaceMarkAsMergedOperation(toResolve.wsConn, toResolve.report, toResolve.changes, (MarkAsMergedDilemmaHandler)new MyMarkAsMergedDilemmaHandler());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Mode {
        MERGED,
        PROPOSED;

    }

    private static class MyApplyAcceptedDilemmaHandler
    extends ApplyAcceptedDilemmaHandler {
        private MyApplyAcceptedDilemmaHandler() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyMarkAsMergedDilemmaHandler
    extends MarkAsMergedDilemmaHandler {
        private MyMarkAsMergedDilemmaHandler() {
        }

        public int unmergedChanges(Collection<ILogicalChange> changes) {
            return 0;
        }
    }

    private static class PathContainer {
        final String[] segments;
        final IPath path;
        boolean matched = false;

        public PathContainer(String stringPath) {
            this.path = new Path(stringPath);
            this.segments = this.path.segments();
        }
    }

    private static class ProposedResolver
    extends Resolver {
        private ProposedResolver() {
        }

        protected ResolveConflictsOperation resolve(ToResolve toResolve) throws FileSystemClientException {
            return new EclipseWorkspaceApplyAcceptedOperation(toResolve.wsConn, toResolve.report, toResolve.changes, (ApplyAcceptedDilemmaHandler)new MyApplyAcceptedDilemmaHandler());
        }
    }

    private static abstract class Resolver {
        private Resolver() {
        }

        protected abstract ResolveConflictsOperation resolve(ToResolve var1) throws FileSystemClientException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ToResolve {
        final IWorkspaceConnection wsConn;
        final ILogicalConflictReport report;
        final Collection<ILogicalConflict> changes;

        public ToResolve(IWorkspaceConnection wsConn, ILogicalConflictReport report, Collection<ILogicalConflict> changes) {
            this.wsConn = wsConn;
            this.report = report;
            this.changes = changes;
        }
    }
}

