/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.subcommands;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.operations.RebuildCFAOperation;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.UUID;
import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public class RepairCmd
extends AbstractSubcommand {
    public void run(IClientConfiguration config) throws FileSystemClientException {
        System.out.println(Messages.RepairCmd_0);
        final ITeamRepository repo = RepoUtil.login((IClientConfiguration)config, (ConnectionInfo)config.getConnectionInfo());
        IRepositoryResolver resolver = new IRepositoryResolver(){

            public ITeamRepository getRepoFor(String uri, UUID id) {
                if (!$assertionsDisabled && !repo.getAliasRepositoryURIs().contains(uri)) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && !repo.getId().equals((Object)id)) {
                    throw new AssertionError();
                }
                return repo;
            }
        };
        OperationParticipant participant = new OperationParticipant();
        try {
            RebuildCFAOperation.rebuildCFA((IPath)new Path(config.getEclipseWorkspaceRoot().getCanonicalPath()), (IRepositoryResolver)resolver, (RebuildCFAOperation.RebuildOperationParticipant)participant, null);
        }
        catch (IOException e) {
            throw StatusHelper.internalError((String)NLS.bind((String)Messages.RepairCmd_3, (Object)config.getEclipseWorkspaceRoot().toString(), (Object)e));
        }
        if (participant.hadProblem()) {
            throw StatusHelper.failure((String)Messages.RepairCmd_6, null);
        }
        System.out.println(Messages.RepairCmd_1);
    }

    private class OperationParticipant
    extends RebuildCFAOperation.RebuildOperationParticipant {
        private boolean problem = false;

        private OperationParticipant() {
        }

        private void setProblem() {
            this.problem = true;
        }

        boolean hadProblem() {
            return this.problem;
        }

        public void noDescriptorsFound() {
            this.setProblem();
            System.err.println(Messages.RepairCmd_4);
        }

        public void ignoredErrors(IStatus status) throws FileSystemClientException {
            this.setProblem();
            LoggingHelper.log((IStatus)status);
            System.err.println(Messages.RepairCmd_5);
        }
    }
}

