/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.subcommands;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.subcommands.MoveCmdOpts;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public class MoveCmd
extends AbstractSubcommand {
    public void run(IClientConfiguration config) throws FileSystemClientException {
        ICommandLine subargs = config.getSubcommandCommandLine();
        IPath source = SubcommandUtil.makePath((IClientConfiguration)config, (String)subargs.getOption((IOptionKey)MoveCmdOpts.OPT_SOURCE));
        if (source == null) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.MoveCmd_0, (Object)subargs.getOption((IOptionKey)MoveCmdOpts.OPT_SOURCE)));
        }
        IPath target = SubcommandUtil.makePath((IClientConfiguration)config, (String)subargs.getOption((IOptionKey)MoveCmdOpts.OPT_TARGET));
        if (target == null) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.MoveCmd_1, (Object)subargs.getOption((IOptionKey)MoveCmdOpts.OPT_TARGET)));
        }
        IResource src = ResourcesPlugin.getWorkspace().getRoot().findMember(source);
        if (src == null || !src.exists()) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.MoveCmd_2, (Object)source));
        }
        if (src.getType() == 4) {
            throw StatusHelper.moveFailure((String)NLS.bind((String)Messages.MoveCmd_9, (Object)source.toPortableString()));
        }
        IResource targetResource = ResourcesPlugin.getWorkspace().getRoot().findMember(target);
        if (targetResource != null) {
            if (targetResource instanceof IContainer) {
                target = new Path(String.valueOf(target.toPortableString()) + '/' + source.lastSegment());
                targetResource = ResourcesPlugin.getWorkspace().getRoot().findMember(target);
                if (targetResource != null) {
                    throw StatusHelper.moveFailure((String)NLS.bind((String)Messages.MoveCmd_3, (Object)target));
                }
            } else {
                throw StatusHelper.moveFailure((String)NLS.bind((String)Messages.MoveCmd_4, (Object)target));
            }
        }
        if ((target = target.makeAbsolute()).segmentCount() == 1) {
            throw StatusHelper.moveFailure((String)NLS.bind((String)Messages.MoveCmd_10, (Object)target));
        }
        if (src.getFullPath().isPrefixOf(target)) {
            throw StatusHelper.moveFailure((String)Messages.MoveCmd_5);
        }
        try {
            src.refreshLocal(2, null);
        }
        catch (CoreException e) {
            throw StatusHelper.failure((String)NLS.bind((String)Messages.MoveCmd_6, (Object)source), (Throwable)e);
        }
        if (config.isDryRun()) {
            return;
        }
        try {
            src.move(target, true, null);
        }
        catch (CoreException e) {
            String message = NLS.bind((String)Messages.MoveCmd_7, (Object)source, (Object)target);
            switch (e.getStatus().getCode()) {
                case 367: 
                case 374: {
                    message = NLS.bind((String)Messages.MoveCmd_8, (Object)target);
                }
            }
            throw StatusHelper.moveFailure((String)message);
        }
    }
}

