/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.subcommands;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.subcommands.LoadCmd;
import com.ibm.team.filesystem.cli.client.internal.subcommands.LoadCmdOptions;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import java.io.File;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadCmdLauncher
extends AbstractSubcommand {
    public void run(IClientConfiguration config) throws FileSystemClientException {
        try {
            this.execute(config);
        }
        finally {
            if (SubcommandUtil.isEclipseWorkspaceRootSet()) {
                try {
                    ResourcesPlugin.getWorkspace().save(true, null);
                }
                catch (CoreException e) {
                    throw StatusHelper.failure((String)Messages.LoadCmd_0, (Throwable)e);
                }
            }
        }
    }

    protected void execute(IClientConfiguration config) throws FileSystemClientException {
        List cSelectors = null;
        ICommandLine subargs = config.getSubcommandCommandLine();
        String wsSelector = subargs.getOption(LoadCmdOptions.OPT_WORKSPACE_SELECTOR);
        ConnectionInfo connectionInfo = config.getConnectionInfo();
        if (subargs.hasOption((IOptionKey)CommonOptions.OPT_COMPONENTS_SELECTOR)) {
            cSelectors = subargs.getOptions((IOptionKey)CommonOptions.OPT_COMPONENTS_SELECTOR);
        }
        boolean getAll = subargs.hasOption((IOptionKey)CommonOptions.OPT_ALL);
        boolean quiet = subargs.hasOption((IOptionKey)CommonOptions.OPT_QUIET);
        String dirStr = subargs.getOption((IOptionKey)CommonOptions.OPT_DIRECTORY, null);
        LoadRuleConfig loadRuleConfig = this.consumeLoadRuleArgs(subargs, cSelectors);
        File cwd = SubcommandUtil.canonicalize((File)new File(System.getProperty("user.dir")));
        File cfaRoot = dirStr == null ? new File(cwd, wsSelector) : SubcommandUtil.canonicalize((File)new File(dirStr));
        File cfaAncestor = SubcommandUtil.findAncestorCFARoot((File)cfaRoot);
        if (cfaAncestor != null && !cfaRoot.equals(cfaAncestor)) {
            throw StatusHelper.misconfiguredLocalFS((String)NLS.bind((String)Messages.LoadCmd_29, (Object)cfaAncestor));
        }
        if (!cfaRoot.exists() && !cfaRoot.mkdir()) {
            throw StatusHelper.misconfiguredLocalFS((String)NLS.bind((String)Messages.LoadCmd_27, (Object)cfaRoot.getAbsolutePath()));
        }
        Assert.isNotNull((Object)cfaRoot);
        SubcommandUtil.initializeEclipseWorkspaceRoot((File)cfaRoot);
        new LoadCmd().run(config, connectionInfo, wsSelector, cSelectors, getAll, loadRuleConfig, quiet);
    }

    private LoadRuleConfig consumeLoadRuleArgs(ICommandLine subargs, List<String> cSelectors) throws FileSystemClientException {
        LoadRuleConfig rule;
        boolean hasLocal = subargs.hasOption(LoadCmdOptions.OPT_LOCAL_LOADRULE_PATH);
        boolean hasRemote = subargs.hasOption(LoadCmdOptions.OPT_REMOTE_LOADRULE_PATH);
        if (!hasLocal && !hasRemote) {
            return null;
        }
        if (hasLocal && hasRemote) {
            String remoteName = subargs.getDefinition().getOption(LoadCmdOptions.OPT_REMOTE_LOADRULE_PATH).getName();
            String localName = subargs.getDefinition().getOption(LoadCmdOptions.OPT_LOCAL_LOADRULE_PATH).getName();
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.LoadCmdLauncher_1, (Object)localName, (Object)remoteName));
        }
        if (cSelectors == null || cSelectors.size() != 1) {
            throw StatusHelper.argSyntax((String)Messages.LoadCmdLauncher_2);
        }
        if (hasRemote) {
            rule = new RemoteLoadRuleConfig();
            rule.component = cSelectors.get(0);
            rule.remotePath = subargs.getOption(LoadCmdOptions.OPT_REMOTE_LOADRULE_PATH);
        } else {
            assert (hasLocal);
            rule = new LocalLoadRuleConfig();
            rule.component = cSelectors.get(0);
            ((LocalLoadRuleConfig)rule).localPath = subargs.getOption(LoadCmdOptions.OPT_LOCAL_LOADRULE_PATH);
        }
        return rule;
    }

    public static class LoadRuleConfig {
        public String component;
    }

    public static class LocalLoadRuleConfig
    extends LoadRuleConfig {
        public String localPath;
    }

    public static class RemoteLoadRuleConfig
    extends LoadRuleConfig {
        public String remotePath;
    }
}

