/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.subcommands;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.subcommands.HistoryCmdOpts;
import com.ibm.team.filesystem.cli.core.CommandLineCore;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.ICopyFileAreaView;
import com.ibm.team.filesystem.cli.core.util.IndentingPrintStream;
import com.ibm.team.filesystem.cli.core.util.PendingChangesUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IChangeHistory;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IChangeHistoryEntry;
import com.ibm.team.scm.common.IChangeHistoryEntryChange;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.runtime.IPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoryCmd
extends AbstractSubcommand {
    public void run(IClientConfiguration config) throws FileSystemClientException {
        String historySelector;
        int maxResults;
        ICommandLine subargs = config.getSubcommandCommandLine();
        String maxResultsStr = subargs.getOption((IOptionKey)HistoryCmdOpts.OPT_MAXRESULTS, "100");
        try {
            maxResults = Integer.parseInt(maxResultsStr);
        }
        catch (NumberFormatException numberFormatException) {
            throw StatusHelper.malformedInput((String)Messages.HistoryCmd_0);
        }
        if (maxResults < 0) {
            throw StatusHelper.malformedInput((String)Messages.HistoryCmd_0);
        }
        boolean selectComponent = subargs.hasOption((IOptionKey)HistoryCmdOpts.OPT_COMPONENT_HISTORY);
        boolean verbose = subargs.hasOption((IOptionKey)CommonOptions.OPT_VERBOSE);
        try {
            historySelector = subargs.getOption((IOptionKey)HistoryCmdOpts.OPT_HISTORY_SELECTOR);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw StatusHelper.malformedInput((String)Messages.HistoryCmd_1);
        }
        ICopyFileAreaView cfaView = SubcommandUtil.getAffectedComponentsAndShares((IClientConfiguration)config);
        List workspaces = RepoUtil.getWorkspaceConnections((ICopyFileAreaView)cfaView, (boolean)true);
        ITeamRepository repo = null;
        List<IChangeSetHandle> csHandles = null;
        if (selectComponent) {
            Map<IWorkspaceConnection, IComponentHandle> cpMap = this.getComponent(workspaces, historySelector);
            IWorkspaceConnection wsConn = null;
            IComponentHandle cpHandle = null;
            for (Map.Entry<IWorkspaceConnection, IComponentHandle> cpMapEntry : cpMap.entrySet()) {
                wsConn = cpMapEntry.getKey();
                cpHandle = cpMapEntry.getValue();
            }
            csHandles = this.getComponentHistory(wsConn, cpHandle, maxResults);
            repo = wsConn.teamRepository();
        } else {
            Map<ITeamRepository, List<IChangeSetHandle>> csMap = this.getFileHistory(config, cfaView, historySelector, maxResults);
            for (Map.Entry<ITeamRepository, List<IChangeSetHandle>> csMapEntry : csMap.entrySet()) {
                repo = csMapEntry.getKey();
                csHandles = csMapEntry.getValue();
            }
        }
        PendingChangesUtil.PendingChangesOptions pcOptions = new PendingChangesUtil.PendingChangesOptions();
        if (verbose) {
            pcOptions.enablePrinter(6);
            pcOptions.enablePrinter(7);
        }
        IndentingPrintStream ps = new IndentingPrintStream((OutputStream)System.out);
        for (IChangeSetHandle csHandle : csHandles) {
            PendingChangesUtil.printChangeSet((ITeamRepository)repo, (IChangeSetHandle)csHandle, (PendingChangesUtil.PendingChangesOptions)pcOptions, (IndentingPrintStream)ps);
        }
        if (csHandles.size() == maxResults) {
            System.out.println(Messages.HistoryCmd_10);
        }
    }

    private Map<IWorkspaceConnection, IComponentHandle> getComponent(Collection<IWorkspaceConnection> workspaces, String historySelector) throws FileSystemClientException {
        PendingChangesUtil.PendingChangesOptions pcOptions = new PendingChangesUtil.PendingChangesOptions();
        pcOptions.enablePrinter(0);
        pcOptions.enablePrinter(1);
        pcOptions.enableFilter(0);
        pcOptions.enableFilter(1);
        LinkedList cpHandles = new LinkedList();
        IWorkspaceConnection wsConnGood = null;
        for (IWorkspaceConnection wsConn : workspaces) {
            try {
                cpHandles.addAll(RepoUtil.findNamedComponents(Collections.singletonList(historySelector), (boolean)false, (IWorkspaceConnection)wsConn, (ITeamRepository)wsConn.teamRepository()));
                pcOptions.addFilter((IItemHandle)wsConn.getResolvedWorkspace(), 0);
                if (cpHandles.isEmpty()) continue;
                wsConnGood = wsConn;
            }
            catch (RepoUtil.UnmatchedSelectorException unmatchedSelectorException) {
            }
            catch (RepoUtil.AmbiguousSelectorException e) {
                cpHandles.addAll(e.getMatched());
                pcOptions.addFilter((IItemHandle)wsConn.getResolvedWorkspace(), 0);
            }
        }
        if (cpHandles.size() == 0) {
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.HistoryCmd_3, (Object[])new Object[]{historySelector}));
        }
        if (cpHandles.size() > 1) {
            pcOptions.addFilters(cpHandles, 1);
            PendingChangesUtil.printPendingChanges((PendingChangesUtil.PendingChangesOptions)pcOptions);
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.HistoryCmd_6, (Object[])new Object[]{historySelector}));
        }
        HashMap<IWorkspaceConnection, IComponentHandle> toReturn = new HashMap<IWorkspaceConnection, IComponentHandle>();
        toReturn.put(wsConnGood, (IComponentHandle)cpHandles.get(0));
        return toReturn;
    }

    private List<IChangeSetHandle> getComponentHistory(IWorkspaceConnection wsConn, IComponentHandle cpHandle, int maxResults) throws FileSystemClientException {
        ArrayList<IChangeSetHandle> toReturn = new ArrayList<IChangeSetHandle>();
        try {
            IChangeHistory history = wsConn.changeHistory(cpHandle);
            while (history != null) {
                List historyEntries = history.recent(null);
                ListIterator i = historyEntries.listIterator(historyEntries.size());
                while (i.previousIndex() != -1) {
                    IChangeHistoryEntry historyEntry = (IChangeHistoryEntry)i.previous();
                    if (!(historyEntry instanceof IChangeHistoryEntryChange)) continue;
                    toReturn.add(((IChangeHistoryEntryChange)historyEntry).changeSet());
                    if (maxResults != 0 && toReturn.size() >= maxResults) break;
                }
                if (maxResults == 0 || toReturn.size() < maxResults) {
                    history = history.previousHistory(null);
                    continue;
                }
                break;
            }
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((TeamRepositoryException)e, (String)Messages.HistoryCmd_9);
        }
        return toReturn;
    }

    private Map<ITeamRepository, List<IChangeSetHandle>> getFileHistory(IClientConfiguration config, ICopyFileAreaView cfaView, String fileSelector, int maxResults) throws FileSystemClientException {
        List historyChanges;
        IBaselineConnection blConn;
        IChangeHistory changeHistory;
        IPath changePath = SubcommandUtil.makePath((IClientConfiguration)CommandLineCore.getConfig(), (String)fileSelector);
        IShareable shareable = cfaView.findShareable(cfaView.getRoot().append(changePath));
        if (shareable == null) {
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.HistoryCmd_19, (Object[])new Object[]{fileSelector}));
        }
        String repoUri = shareable.getShare().getSharingDescriptor().getRepositoryUri();
        ConnectionInfo info = config.getConnectionInfo(repoUri);
        ITeamRepository repo = RepoUtil.login((IClientConfiguration)config, (ConnectionInfo)info);
        IShare share = shareable.getShare();
        if (share == null) {
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.HistoryCmd_22, (Object[])new Object[]{fileSelector}));
        }
        IVersionableHandle verHandle = shareable.getRemote();
        if (verHandle == null) {
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.HistoryCmd_29, (Object[])new Object[]{fileSelector}));
        }
        ISharingDescriptor shareDescriptor = share.getSharingDescriptor();
        IContextHandle cxHandle = shareDescriptor.getConnectionHandle();
        if (shareDescriptor.associatedWithWorkspace()) {
            IWorkspaceConnection wsConn;
            try {
                wsConn = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnection((IWorkspaceHandle)cxHandle, null);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((TeamRepositoryException)e, (String)Messages.HistoryCmd_13);
            }
            try {
                changeHistory = wsConn.changeHistory(shareDescriptor.getComponent());
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((TeamRepositoryException)e, (String)Messages.HistoryCmd_16);
            }
        }
        try {
            blConn = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getBaselineConnection((IBaselineHandle)cxHandle, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((TeamRepositoryException)e, (String)Messages.HistoryCmd_13);
        }
        changeHistory = blConn.changeHistory();
        try {
            historyChanges = changeHistory.getHistoryFor(verHandle, maxResults == 0 ? Integer.MAX_VALUE : maxResults, true, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((TeamRepositoryException)e, (String)Messages.HistoryCmd_25);
        }
        HashMap<ITeamRepository, List<IChangeSetHandle>> toReturn = new HashMap<ITeamRepository, List<IChangeSetHandle>>();
        ArrayList<IChangeSetHandle> changeSets = new ArrayList<IChangeSetHandle>(historyChanges.size());
        toReturn.put(repo, changeSets);
        for (IChangeHistoryEntryChange historyChange : historyChanges) {
            changeSets.add(historyChange.changeSet());
        }
        return toReturn;
    }
}

