/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.subcommands;

import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.rcp.core.operations.IDownloadMonitor;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

public class DownloadProgressWriter
extends ProgressMonitorWrapper
implements IDownloadMonitor {
    final Job job = new Job("ProgressWriter"){

        protected IStatus run(IProgressMonitor monitor) {
            return DownloadProgressWriter.this.showMessages(monitor);
        }
    };
    private final boolean verbose;
    private final boolean quiet;
    final LinkedList<String> toWrite = new LinkedList();
    static final double[] statisticalDivisors = new double[]{1024.0, 1048576.0, 1.073741824E9, 1.099511627776E12, 1.125899906842624E15};
    static final String[] statisticalSuffixes = new String[]{Messages.DownloadProgressWriter_2, Messages.DownloadProgressWriter_3, Messages.DownloadProgressWriter_4, Messages.DownloadProgressWriter_5, Messages.DownloadProgressWriter_6};

    public DownloadProgressWriter(IProgressMonitor m, boolean verbose, boolean quiet) {
        super(m);
        this.verbose = verbose;
        this.quiet = quiet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startDownload(IPath path, IContent content, IVersionableHandle fileItem) {
        if (this.quiet) {
            return;
        }
        LinkedList<String> linkedList = this.toWrite;
        synchronized (linkedList) {
            this.toWrite.add(NLS.bind((String)Messages.DownloadProgressWriter_1, (Object)path.toString(), (Object)DownloadProgressWriter.bytesAsHumanReadable(content.getEstimatedConvertedLength())));
        }
        this.job.schedule();
    }

    public IProgressMonitor getProgressMonitor() {
        return this.getWrappedProgressMonitor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus showMessages(IProgressMonitor monitor) {
        while (true) {
            String message;
            try {
                LinkedList<String> linkedList = this.toWrite;
                synchronized (linkedList) {
                    message = this.toWrite.removeLast();
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                return Status.OK_STATUS;
            }
            System.out.println(message);
        }
    }

    private static String bytesAsHumanReadable(long amt) {
        int i = statisticalDivisors.length - 1;
        while (i >= 0) {
            if ((double)amt > statisticalDivisors[i]) {
                return String.format("%,.1f %s", (double)amt / statisticalDivisors[i], statisticalSuffixes[i]);
            }
            --i;
        }
        return NLS.bind((String)Messages.DownloadProgressWriter_7, (Object)amt);
    }

    public void join() {
        try {
            this.job.join();
        }
        catch (InterruptedException interruptedException) {
            System.err.println(Messages.DownloadProgressWriter_8);
        }
    }
}

