/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.subcommands;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.ICopyFileAreaView;
import com.ibm.team.filesystem.cli.core.util.IndentingPrintStream;
import com.ibm.team.filesystem.cli.core.util.PendingChangesUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.rcp.core.operations.DiscardOperation;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.GapException;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.NWayConflictUnsupportedException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class DiscardCmd
extends AbstractSubcommand {
    public void run(IClientConfiguration config) throws FileSystemClientException {
        ICommandLine subargs = config.getSubcommandCommandLine();
        if (!subargs.hasOption((IOptionKey)CommonOptions.OPT_CHANGESET_SELECTORS)) {
            throw StatusHelper.argSyntax((String)Messages.DiscardCmd_13);
        }
        List csSelectors = subargs.getOptions((IOptionKey)CommonOptions.OPT_CHANGESET_SELECTORS);
        boolean verbose = subargs.hasOption((IOptionKey)CommonOptions.OPT_VERBOSE);
        ICopyFileAreaView cfaView = SubcommandUtil.getAffectedComponentsAndShares((IClientConfiguration)config);
        List workspaces = RepoUtil.getWorkspaceConnections((ICopyFileAreaView)cfaView, (boolean)true);
        HashMap<IWorkspaceConnection, List> changeSets = new HashMap<IWorkspaceConnection, List>();
        for (String csSelector : csSelectors) {
            HashMap<IWorkspaceConnection, List> changeSetsTmp = new HashMap<IWorkspaceConnection, List>();
            for (IWorkspaceConnection wsConn : workspaces) {
                try {
                    changeSetsTmp.put(wsConn, RepoUtil.findNamedChangeSetsForWorkspace((IWorkspaceConnection)wsConn, (String)csSelector));
                }
                catch (TeamRepositoryException e) {
                    throw StatusHelper.wrap((TeamRepositoryException)e, (String)Messages.DiscardCmd_2);
                }
            }
            int numTmpChangesets = 0;
            for (IWorkspaceConnection wsConn : changeSetsTmp.keySet()) {
                numTmpChangesets += ((List)changeSetsTmp.get(wsConn)).size();
            }
            if (numTmpChangesets == 0) {
                RepoUtil.UnmatchedSelectorException e = new RepoUtil.UnmatchedSelectorException(RepoUtil.SelectorException.Type.CHANGESET, csSelector, Collections.EMPTY_LIST);
                SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)((Object)e));
                throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.DiscardCmd_3, (Object)e.getSelector()));
            }
            if (1 < numTmpChangesets) {
                IndentingPrintStream ps = new IndentingPrintStream((OutputStream)System.out);
                ps.println((CharSequence)Messages.DiscardCmd_4);
                PendingChangesUtil.PendingChangesOptions options = new PendingChangesUtil.PendingChangesOptions();
                options.setVerbose(verbose);
                options.enablePrinter(0);
                options.enablePrinter(1);
                options.enablePrinter(8);
                options.enablePrinter(4);
                options.enablePrinter(6);
                options.enablePrinter(7);
                options.enableFilter(0);
                options.enableFilter(1);
                options.enableFilter(4);
                for (IWorkspaceConnection wsConn : changeSetsTmp.keySet()) {
                    List changeSetsForCP;
                    options.addFilter((IItemHandle)wsConn.getResolvedWorkspace(), 0);
                    List csHandles = (List)changeSetsTmp.get(wsConn);
                    options.addFilters((Collection)csHandles, 4);
                    try {
                        changeSetsForCP = wsConn.teamRepository().itemManager().fetchPartialItems(csHandles, 0, (Collection)Collections.singleton(IChangeSet.COMPONENT_PROPERTY), null);
                    }
                    catch (TeamRepositoryException e) {
                        throw StatusHelper.wrap((TeamRepositoryException)e, (String)Messages.DiscardCmd_12);
                    }
                    for (IChangeSet cs : changeSetsForCP) {
                        options.addFilter((IItemHandle)cs.getComponent(), 1);
                    }
                }
                PendingChangesUtil.printPendingChanges((boolean)false, (PendingChangesUtil.PendingChangesOptions)options, (IndentingPrintStream)ps.indent());
                throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.DiscardCmd_5, (Object)csSelector));
            }
            for (IWorkspaceConnection wsConn : changeSetsTmp.keySet()) {
                if (!changeSets.containsKey(wsConn)) {
                    changeSets.put(wsConn, (List)changeSetsTmp.get(wsConn));
                    continue;
                }
                ((List)changeSets.get(wsConn)).addAll((Collection)changeSetsTmp.get(wsConn));
            }
        }
        if (verbose) {
            IndentingPrintStream ps = new IndentingPrintStream((OutputStream)System.out);
            if (config.isDryRun()) {
                ps.println((CharSequence)Messages.DiscardCmd_6);
            } else {
                ps.println((CharSequence)Messages.DiscardCmd_7);
            }
            PendingChangesUtil.PendingChangesOptions options = new PendingChangesUtil.PendingChangesOptions();
            options.setVerbose(verbose);
            options.enablePrinter(0);
            options.enablePrinter(1);
            options.enablePrinter(8);
            options.enablePrinter(4);
            options.enablePrinter(6);
            options.enablePrinter(7);
            options.enableFilter(0);
            options.enableFilter(1);
            options.enableFilter(4);
            for (IWorkspaceConnection wsConn : changeSets.keySet()) {
                List changeSetsForCP;
                options.addFilter((IItemHandle)wsConn.getResolvedWorkspace(), 0);
                List csHandles = (List)changeSets.get(wsConn);
                options.addFilters((Collection)csHandles, 4);
                try {
                    changeSetsForCP = wsConn.teamRepository().itemManager().fetchPartialItems(csHandles, 0, (Collection)Collections.singleton(IChangeSet.COMPONENT_PROPERTY), null);
                }
                catch (TeamRepositoryException e) {
                    throw StatusHelper.wrap((TeamRepositoryException)e, (String)Messages.DiscardCmd_12);
                }
                for (IChangeSet cs : changeSetsForCP) {
                    options.addFilter((IItemHandle)cs.getComponent(), 1);
                }
            }
            PendingChangesUtil.printPendingChanges((boolean)false, (PendingChangesUtil.PendingChangesOptions)options, (IndentingPrintStream)ps.indent());
        }
        if (!config.isDryRun()) {
            for (IWorkspaceConnection wsConn : changeSets.keySet()) {
                DiscardOperation discardOperation = new DiscardOperation(wsConn, (Collection)changeSets.get(wsConn), null);
                try {
                    discardOperation.run(null);
                }
                catch (GapException gapException) {
                    throw StatusHelper.gap((String)Messages.DiscardCmd_9);
                }
                catch (NWayConflictUnsupportedException nWayConflictUnsupportedException) {
                    throw StatusHelper.nWayConflict((String)Messages.DiscardCmd_10);
                }
                catch (TeamRepositoryException e) {
                    throw StatusHelper.wrap((TeamRepositoryException)e, (String)Messages.DiscardCmd_11);
                }
            }
        }
    }
}

