/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.subcommands;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.subcommands.DiffCmdOpts;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.ICopyFileAreaView;
import com.ibm.team.filesystem.cli.core.util.IndentingPrintStream;
import com.ibm.team.filesystem.cli.core.util.PendingChangesUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ILocalChangeManager;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.ClientConfigurationChangeFactory;
import com.ibm.team.filesystem.common.changemodel.ChangeDescription;
import com.ibm.team.filesystem.common.changemodel.ConfigurationChange;
import com.ibm.team.filesystem.common.changemodel.FileChange;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.filesystem.common.changemodel.IPathResolver;
import com.ibm.team.filesystem.common.changemodel.ResolvedConfigurationChangePaths;
import com.ibm.team.filesystem.common.internal.patch.CreatePatchDilemmaHandler;
import com.ibm.team.filesystem.common.internal.patch.CreatePatchUtil;
import com.ibm.team.filesystem.rcp.core.internal.CoreShareablesUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.CompareInput;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentBaselineSetUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentFlowUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ConfigurationChangeFactory;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.CopyFileAreaPathResolver;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.FallbackPathResolver;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IBaselineGroup;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteChangeSummary;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.RemotePathResolver;
import com.ibm.team.filesystem.rcp.core.internal.patches.FileStateFactory;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IChangeHistory;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.ComponentNotInWorkspaceException;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeHistoryEntryChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFlowNodeHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.SiloedItemId;
import com.ibm.team.scm.common.internal.util.StateId;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffCmd
extends AbstractSubcommand {
    public void run(IClientConfiguration config) throws FileSystemClientException {
        StateSelector before = null;
        StateSelector after = null;
        boolean fullPatch = false;
        ICommandLine subargs = config.getSubcommandCommandLine();
        if (!subargs.hasOption((IOptionKey)DiffCmdOpts.OPT_AFTER_TYPE) || !subargs.hasOption((IOptionKey)DiffCmdOpts.OPT_AFTER_SELECTOR)) {
            throw StatusHelper.argSyntax((String)Messages.DiffCmd_1);
        }
        after = new StateSelector(subargs.getOption((IOptionKey)DiffCmdOpts.OPT_AFTER_TYPE), subargs.getOption((IOptionKey)DiffCmdOpts.OPT_AFTER_SELECTOR));
        if (subargs.hasOption((IOptionKey)DiffCmdOpts.OPT_BEFORE_TYPE)) {
            if (!subargs.hasOption((IOptionKey)DiffCmdOpts.OPT_BEFORE_SELECTOR)) {
                throw StatusHelper.argSyntax((String)Messages.DiffCmd_0);
            }
            before = new StateSelector(subargs.getOption((IOptionKey)DiffCmdOpts.OPT_BEFORE_TYPE), subargs.getOption((IOptionKey)DiffCmdOpts.OPT_BEFORE_SELECTOR));
        }
        fullPatch = subargs.hasOption((IOptionKey)DiffCmdOpts.OPT_FULL_PATCH);
        ResourcesPlugin.getWorkspace();
        if (after.getType().equalsIgnoreCase("file")) {
            this.singleFileDiff(config, after.getSelector(), before, fullPatch);
            return;
        }
        if (after.getType().equalsIgnoreCase("workspace")) {
            this.workspaceDiff(config, after.getSelector(), false, before, fullPatch);
            return;
        }
        if (after.getType().equalsIgnoreCase("stream")) {
            this.workspaceDiff(config, after.getSelector(), true, before, fullPatch);
            return;
        }
    }

    private static ILocalChange getFromChange(ILocalChange nextChange) {
        if (nextChange.isType(8)) {
            ILocalChange result = nextChange.getCounterpart();
            if (result == null) {
                return nextChange;
            }
            return result;
        }
        return nextChange;
    }

    private FileState getBaselineFileState(ITeamRepository repo, IBaselineHandle blHandle, IVersionableHandle verHandle) throws FileSystemClientException {
        IBaselineConnection blConn;
        try {
            blConn = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getBaselineConnection(blHandle, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((TeamRepositoryException)e, (String)Messages.DiffCmd_26);
        }
        return this.getFileStateFromChangeHistory(repo, blConn.changeHistory(), verHandle);
    }

    private FileState getWorkspaceFileState(ITeamRepository repo, IWorkspaceHandle wsHandle, SiloedItemId<IVersionable> siloedVerHandle) throws FileSystemClientException {
        IWorkspaceConnection wsConn;
        try {
            wsConn = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnection(wsHandle, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((TeamRepositoryException)e, (String)Messages.DiffCmd_27);
        }
        try {
            return this.getFileStateFromChangeHistory(repo, wsConn.changeHistory(siloedVerHandle.getComponentHandle()), siloedVerHandle.toHandle());
        }
        catch (ItemNotFoundException itemNotFoundException) {
            throw StatusHelper.itemNotFound((String)Messages.DiffCmd_28);
        }
        catch (ComponentNotInWorkspaceException componentNotInWorkspaceException) {
            throw StatusHelper.itemNotFound((String)Messages.DiffCmd_29);
        }
    }

    private FileState getFileStateFromChangeHistory(ITeamRepository repo, IChangeHistory history, IVersionableHandle verHandle) throws FileSystemClientException {
        List changeHistories;
        try {
            changeHistories = history.getHistoryFor(verHandle, 1, true, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((TeamRepositoryException)e, (String)Messages.DiffCmd_31);
        }
        if (changeHistories.isEmpty()) {
            return FileState.getDeletedState();
        }
        IChangeHistoryEntryChange changeHistory = (IChangeHistoryEntryChange)changeHistories.get(0);
        return this.getFileStateFromChangeSet(repo, changeHistory.changeSet(), verHandle);
    }

    private FileState getFileStateFromChangeSet(ITeamRepository repo, IChangeSetHandle csHandle, IVersionableHandle verHandle) throws FileSystemClientException {
        IVersionable afterState;
        IChangeSet cs;
        try {
            cs = (IChangeSet)repo.itemManager().fetchCompleteItem((IItemHandle)csHandle, 0, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((TeamRepositoryException)e, (String)Messages.DiffCmd_32);
        }
        IVersionableHandle afterStateHandle = null;
        for (IChange change : cs.changes()) {
            if (!change.item().getItemId().equals((Object)verHandle.getItemId())) continue;
            afterStateHandle = change.afterState();
        }
        if (afterStateHandle == null) {
            return null;
        }
        try {
            afterState = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).versionableManager().fetchCompleteState(afterStateHandle, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((TeamRepositoryException)e, (String)Messages.DiffCmd_33);
        }
        return FileStateFactory.create((ITeamRepository)repo, (IVersionable)afterState);
    }

    private void singleFileDiff(IClientConfiguration config, String changeSelector, StateSelector before, boolean fullPatch) throws FileSystemClientException {
        IShare share;
        IShareable shareable;
        String beforeBaselineSelector = null;
        String beforeWorkspaceSelector = null;
        String beforeStreamSelector = null;
        String beforeChangeSetSelector = null;
        if (before != null) {
            if (before.getType().equalsIgnoreCase("workspace")) {
                beforeWorkspaceSelector = before.getSelector();
            } else if (before.getType().equalsIgnoreCase("baseline")) {
                beforeBaselineSelector = before.getSelector();
            } else if (before.getType().equalsIgnoreCase("stream")) {
                beforeStreamSelector = before.getSelector();
            } else if (before.getType().equalsIgnoreCase("changeset")) {
                beforeChangeSetSelector = before.getSelector();
            } else {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.DiffCmd_36, (Object)before.getSelector()));
            }
        }
        ICopyFileAreaView cfaView = SubcommandUtil.getAffectedComponentsAndShares((IClientConfiguration)config);
        List workspaces = RepoUtil.getWorkspaceConnections((ICopyFileAreaView)cfaView, (boolean)true);
        ILocalChangeManager lcm = FileSystemCore.getSharingManager().getLocalChangeManager();
        for (IWorkspaceConnection wsConn : workspaces) {
            List cpHandles;
            try {
                cpHandles = wsConn.getComponents();
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((TeamRepositoryException)e, (String)Messages.DiffCmd_3);
            }
            for (IComponentHandle cpHandle : cpHandles) {
                lcm.syncPendingChanges((IContextHandle)wsConn.getResolvedWorkspace(), cpHandle, cfaView.getRoot());
            }
        }
        IPath changePath = SubcommandUtil.makePath((IClientConfiguration)config, (String)changeSelector);
        if (changePath == null) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.DiffCmd_34, (Object)changeSelector));
        }
        SiloedItemId siloedVer = null;
        FileState afterState = null;
        FileState beforeState = null;
        ITeamRepository repo = null;
        IWorkspaceConnection connection = null;
        for (IWorkspaceConnection wsConn : workspaces) {
            List cpHandles;
            repo = wsConn.teamRepository();
            connection = wsConn;
            try {
                cpHandles = wsConn.getComponents();
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((TeamRepositoryException)e, (String)Messages.DiffCmd_4);
            }
            Iterator iterator = cpHandles.iterator();
            while (iterator.hasNext()) {
                ILocalChange[] tmpLocalChanges;
                IComponentHandle cpHandle = (IComponentHandle)iterator.next();
                ILocalChange[] iLocalChangeArray = tmpLocalChanges = lcm.getPendingChanges((IContextHandle)wsConn.getResolvedWorkspace(), cpHandle, cfaView.getRoot());
                int n = tmpLocalChanges.length;
                int n2 = 0;
                while (n2 < n) {
                    ILocalChange localChange = iLocalChangeArray[n2];
                    if (localChange.getType() == 4 && localChange.getOriginalPath().equals((Object)changePath.makeAbsolute()) || localChange.getPath().equals((Object)changePath.makeAbsolute())) {
                        IItem item;
                        siloedVer = CoreShareablesUtil.getSiloedItem((ILocalChange)localChange);
                        if (localChange.getType() == 4) {
                            afterState = FileState.getDeletedState();
                        } else {
                            IShareable shareable2 = localChange.getShareable();
                            IResource resource = (IResource)Adapters.getAdapter((Object)shareable2, IResource.class);
                            try {
                                afterState = FileStateFactory.create((IResource)resource);
                            }
                            catch (CoreException e) {
                                throw StatusHelper.failure((String)Messages.DiffCmd_9, (Throwable)e);
                            }
                        }
                        if (localChange.getType() == 2) {
                            beforeState = FileState.getDeletedState();
                            break;
                        }
                        try {
                            item = RepoFetcher.fetchItem((ITeamRepository)repo, (StateId)CoreShareablesUtil.getBeforeState((ILocalChange)DiffCmd.getFromChange(localChange)), null);
                        }
                        catch (TeamRepositoryException e) {
                            throw StatusHelper.wrap((TeamRepositoryException)e, (String)Messages.DiffCmd_20);
                        }
                        beforeState = FileStateFactory.create((ITeamRepository)repo, (IVersionable)((IVersionable)item));
                        break;
                    }
                    ++n2;
                }
                if (siloedVer != null) break;
            }
            if (siloedVer != null) break;
        }
        if (siloedVer == null) {
            for (IWorkspaceConnection wsConn : workspaces) {
                List changes;
                repo = wsConn.teamRepository();
                connection = wsConn;
                try {
                    changes = RepoUtil.findChangeSummariesByPath((IClientConfiguration)config, (IWorkspaceConnection)wsConn, (String)changeSelector, (boolean)true);
                }
                catch (TeamRepositoryException e) {
                    throw StatusHelper.wrap((TeamRepositoryException)e, (String)Messages.DiffCmd_5);
                }
                if (changes.isEmpty()) continue;
                IRemoteChangeSummary change = (IRemoteChangeSummary)changes.get(0);
                IComponent cpHandle = change.getActivity().getActivitySource().getModel().getComponent();
                siloedVer = SiloedItemId.create((IVersionableHandle)change.getItem(), (IComponentHandle)cpHandle);
                IVersionableHandle verAfterHandle = change.getChange().afterState();
                IVersionable verAfter = null;
                if (verAfterHandle != null) {
                    try {
                        verAfter = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).versionableManager().fetchCompleteState(verAfterHandle, null);
                    }
                    catch (TeamRepositoryException e) {
                        throw StatusHelper.wrap((TeamRepositoryException)e, (String)Messages.DiffCmd_10);
                    }
                }
                afterState = FileStateFactory.create((ITeamRepository)repo, verAfter);
                IVersionableHandle verBeforeHandle = change.getChange().beforeState();
                IVersionable verBefore = null;
                if (verBeforeHandle != null) {
                    try {
                        verBefore = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).versionableManager().fetchCompleteState(verBeforeHandle, null);
                    }
                    catch (TeamRepositoryException e) {
                        throw StatusHelper.wrap((TeamRepositoryException)e, (String)Messages.DiffCmd_21);
                    }
                }
                beforeState = FileStateFactory.create((ITeamRepository)repo, verBefore);
                break;
            }
        }
        if (siloedVer == null && (shareable = cfaView.findShareable(cfaView.getRoot().append(changePath))) != null && (share = shareable.getShare()) != null) {
            IComponentHandle cpHandle = share.getSharingDescriptor().getComponent();
            IVersionableHandle verHandle = shareable.getVersionable();
            if (verHandle != null) {
                siloedVer = SiloedItemId.create((IVersionableHandle)verHandle, (IComponentHandle)cpHandle);
                IResource resource = (IResource)Adapters.getAdapter((Object)shareable, IResource.class);
                try {
                    afterState = FileStateFactory.create((IResource)resource);
                }
                catch (CoreException e) {
                    throw StatusHelper.failure((String)Messages.DiffCmd_9, (Throwable)e);
                }
                beforeState = afterState;
                repo = TeamPlatform.getTeamRepositoryService().getTeamRepository(share.getSharingDescriptor().getRepositoryUri());
                IContextHandle ctxHandle = share.getSharingDescriptor().getConnectionHandle();
                if (share.getSharingDescriptor().associatedWithWorkspace()) {
                    IWorkspaceHandle wsHandle = (IWorkspaceHandle)ctxHandle;
                    try {
                        connection = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnection(wsHandle, null);
                    }
                    catch (TeamRepositoryException e) {
                        throw StatusHelper.wrap((TeamRepositoryException)e, (String)Messages.DiffCmd_84);
                    }
                }
                IBaselineHandle blHandle = (IBaselineHandle)ctxHandle;
                try {
                    connection = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getBaselineConnection(blHandle, null);
                }
                catch (TeamRepositoryException e) {
                    throw StatusHelper.wrap((TeamRepositoryException)e, (String)Messages.DiffCmd_85);
                }
            }
        }
        if (siloedVer == null || repo == null) {
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.DiffCmd_7, (Object)changeSelector));
        }
        if (beforeBaselineSelector != null) {
            List blHandles;
            try {
                blHandles = RepoUtil.findBaseline((ITeamRepository)repo, (IComponentHandle)siloedVer.getComponentHandle(), (String)beforeBaselineSelector);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((TeamRepositoryException)e, (String)Messages.DiffCmd_11);
            }
            if (blHandles.isEmpty()) {
                throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.DiffCmd_12, (Object)beforeBaselineSelector));
            }
            if (blHandles.size() > 1) {
                List baselines;
                try {
                    baselines = repo.itemManager().fetchPartialItems(blHandles, 0, (Collection)Collections.singleton(IBaseline.COMMENT_PROPERTY), null);
                }
                catch (TeamRepositoryException e) {
                    throw StatusHelper.wrap((TeamRepositoryException)e, (String)Messages.DiffCmd_13);
                }
                System.out.println(Messages.DiffCmd_14);
                for (IBaseline baseline : baselines) {
                    System.out.println("  (" + baseline.getItemId() + ") - " + baseline.getComment());
                }
                throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.DiffCmd_15, (Object)beforeBaselineSelector));
            }
            IBaselineHandle blHandle = (IBaselineHandle)blHandles.get(0);
            beforeState = this.getBaselineFileState(repo, blHandle, siloedVer.toHandle());
        } else if (beforeWorkspaceSelector != null) {
            IWorkspaceHandle wsHandle;
            try {
                wsHandle = RepoUtil.findNamedWorkspace((String)beforeWorkspaceSelector, (boolean)true, (boolean)false, (ITeamRepository)repo);
            }
            catch (RepoUtil.UnmatchedSelectorException unmatchedSelectorException) {
                throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.DiffCmd_16, (Object)beforeWorkspaceSelector));
            }
            catch (RepoUtil.AmbiguousSelectorException ambiguousSelectorException) {
                throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.DiffCmd_17, (Object)beforeWorkspaceSelector));
            }
            beforeState = this.getWorkspaceFileState(repo, wsHandle, siloedVer);
        } else if (beforeStreamSelector != null) {
            IWorkspaceHandle stHandle;
            try {
                stHandle = RepoUtil.findNamedWorkspace((String)beforeStreamSelector, (boolean)false, (boolean)true, (ITeamRepository)repo);
            }
            catch (RepoUtil.UnmatchedSelectorException unmatchedSelectorException) {
                throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.DiffCmd_18, (Object)beforeStreamSelector));
            }
            catch (RepoUtil.AmbiguousSelectorException ambiguousSelectorException) {
                throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.DiffCmd_19, (Object)beforeStreamSelector));
            }
            beforeState = this.getWorkspaceFileState(repo, stHandle, siloedVer);
        } else if (beforeChangeSetSelector != null) {
            IChangeSetHandle csHandle;
            try {
                csHandle = RepoUtil.findNamedChangeSet((ITeamRepository)repo, (String)beforeChangeSetSelector);
            }
            catch (RepoUtil.UnmatchedSelectorException unmatchedSelectorException) {
                throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.DiffCmd_46, (Object)beforeChangeSetSelector));
            }
            catch (RepoUtil.AmbiguousSelectorException ambiguousSelectorException) {
                throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.DiffCmd_41, (Object)beforeChangeSetSelector));
            }
            beforeState = this.getFileStateFromChangeSet(repo, csHandle, siloedVer.toHandle());
        }
        FileChange fileChange = new FileChange(beforeState, afterState, siloedVer);
        ConfigurationChange confChange = new ConfigurationChange();
        confChange.addChange(fileChange);
        ChangeDescription changeDesc = new ChangeDescription("", (Collection)Collections.EMPTY_LIST, new ItemId((IItemHandle)siloedVer.getComponentHandle()), (Collection)Collections.EMPTY_LIST, new Date());
        this.doDiff((IConnection)connection, confChange, changeDesc, fullPatch);
    }

    /*
     * Unable to fully structure code
     */
    private void workspaceDiff(IClientConfiguration config, String workspaceSelector, boolean isStream, StateSelector before, boolean fullPatch) throws FileSystemClientException {
        block28: {
            block27: {
                repo = RepoUtil.login((IClientConfiguration)config, (ConnectionInfo)config.getConnectionInfo());
                beforeWsHandle = null;
                if (before != null) {
                    if (before.getType().equalsIgnoreCase("workspace")) {
                        try {
                            beforeWsHandle = RepoUtil.findNamedWorkspace((String)before.getSelector(), (boolean)true, (boolean)false, (ITeamRepository)repo);
                            break block27;
                        }
                        catch (RepoUtil.UnmatchedSelectorException v0) {
                            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.DiffCmd_58, (Object)before.getSelector()));
                        }
                        catch (RepoUtil.AmbiguousSelectorException e) {
                            pcOptions = new PendingChangesUtil.PendingChangesOptions();
                            pcOptions.enableFilter(0);
                            ps = new IndentingPrintStream((OutputStream)System.out);
                            ** for (workspace : e.getPossibilities())
                        }
lbl-1000:
                        // 1 sources

                        {
                            PendingChangesUtil.printWorkspace((ITeamRepository)repo, (IWorkspaceHandle)workspace, (PendingChangesUtil.PendingChangesOptions)pcOptions, (IndentingPrintStream)ps);
                            continue;
                        }
lbl17:
                        // 1 sources

                        throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.DiffCmd_52, (Object)before.getSelector()));
                    }
                    if (before.getType().equalsIgnoreCase("stream")) {
                        try {
                            beforeWsHandle = RepoUtil.findNamedWorkspace((String)before.getSelector(), (boolean)false, (boolean)true, (ITeamRepository)repo);
                            break block27;
                        }
                        catch (RepoUtil.UnmatchedSelectorException v1) {
                            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.DiffCmd_64, (Object)before.getSelector()));
                        }
                        catch (RepoUtil.AmbiguousSelectorException e) {
                            pcOptions = new PendingChangesUtil.PendingChangesOptions();
                            pcOptions.enableFilter(0);
                            ps = new IndentingPrintStream((OutputStream)System.out);
                            ** for (workspace : e.getPossibilities())
                        }
lbl-1000:
                        // 1 sources

                        {
                            PendingChangesUtil.printWorkspace((ITeamRepository)repo, (IWorkspaceHandle)workspace, (PendingChangesUtil.PendingChangesOptions)pcOptions, (IndentingPrintStream)ps);
                            continue;
                        }
lbl31:
                        // 1 sources

                        throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.DiffCmd_65, (Object)before.getSelector()));
                    }
                    throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.DiffCmd_36, (Object)before.getSelector()));
                }
            }
            try {
                afterWsConn = RepoUtil.findNamedWorkspaceConnection((String)workspaceSelector, (boolean)(isStream == false), (boolean)isStream, (ITeamRepository)repo);
                break block28;
            }
            catch (RepoUtil.UnmatchedSelectorException v2) {
                throw StatusHelper.ambiguousSelector((String)NLS.bind((String)(isStream != false ? Messages.DiffCmd_64 : Messages.DiffCmd_58), (Object)workspaceSelector));
            }
            catch (RepoUtil.AmbiguousSelectorException e) {
                pcOptions = new PendingChangesUtil.PendingChangesOptions();
                pcOptions.enableFilter(0);
                ps = new IndentingPrintStream((OutputStream)System.out);
                ** for (workspace : e.getPossibilities())
            }
lbl-1000:
            // 1 sources

            {
                PendingChangesUtil.printWorkspace((ITeamRepository)repo, (IWorkspaceHandle)workspace, (PendingChangesUtil.PendingChangesOptions)pcOptions, (IndentingPrintStream)ps);
                continue;
            }
lbl46:
            // 1 sources

            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)(isStream != false ? Messages.DiffCmd_65 : Messages.DiffCmd_52), (Object)workspaceSelector));
        }
        if (beforeWsHandle == null) {
            beforeWsHandle = ComponentFlowUtil.getCurrentCollaboration((IWorkspaceConnection)afterWsConn);
        }
        outgoingChanges = new ArrayList<ItemId>();
        incomingChanges = new ArrayList<ItemId>();
        v3 = scopes = beforeWsHandle == null ? null : afterWsConn.getFlowTable().getComponentScopes((IFlowNodeHandle)beforeWsHandle);
        if (scopes == null || scopes.isEmpty()) {
            scopes = null;
        }
        compareInput = new CompareInput((Object)afterWsConn, (Object)beforeWsHandle, (List)(scopes == null ? null : new ArrayList<E>(scopes)));
        try {
            model = ComponentBaselineSetUtil.create((CompareInput)compareInput, null);
            model.refresh(true, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((TeamRepositoryException)e, (String)Messages.DiffCmd_72);
        }
        outgoingActivities = new ArrayList<E>();
        incomingActivities = new ArrayList<E>();
        var20_34 = contexts = model.getComponentSyncContexts();
        var19_35 = contexts.length;
        var18_36 = 0;
        while (var18_36 < var19_35) {
            context = var20_34[var18_36];
            source = context.getOutgoingActivitySource();
            outgoingActivities.addAll(source.getActivities());
            baselineGroups = source.getBaselines();
            for (IBaselineGroup baseline : baselineGroups) {
                outgoingActivities.addAll(baseline.getActivities());
            }
            source = context.getIncomingActivitySource();
            incomingActivities.addAll(source.getActivities());
            baselineGroups = source.getBaselines();
            for (IBaselineGroup baseline : baselineGroups) {
                incomingActivities.addAll(baseline.getActivities());
            }
            ++var18_36;
        }
        for (IRemoteActivity activity : outgoingActivities) {
            outgoingChanges.add(new ItemId((IItemHandle)activity.getChangeSetHandle()));
        }
        for (IRemoteActivity activity : incomingActivities) {
            incomingChanges.add(new ItemId((IItemHandle)activity.getChangeSetHandle()));
        }
        if (outgoingChanges.isEmpty() && incomingChanges.isEmpty()) {
            return;
        }
        try {
            outgoingConfChange = ClientConfigurationChangeFactory.createChangeForHandles((ITeamRepository)repo, outgoingChanges, null);
            incomingConfChange = ClientConfigurationChangeFactory.createChangeForHandles((ITeamRepository)repo, incomingChanges, null);
            changeDesc = ConfigurationChangeFactory.getDescriptionForHandles((ITeamRepository)repo, outgoingChanges.isEmpty() != false ? incomingChanges : outgoingChanges, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((TeamRepositoryException)e, (String)Messages.DiffCmd_79);
        }
        confChange = outgoingConfChange.merge(incomingConfChange.reverse());
        this.doDiff((IConnection)afterWsConn, confChange, changeDesc, fullPatch);
    }

    private void doDiff(IConnection connection, ConfigurationChange confChange, ChangeDescription changeDesc, boolean fullPatch) throws FileSystemClientException {
        ResolvedConfigurationChangePaths paths;
        LinkedList<Object> resolvers = new LinkedList<Object>();
        resolvers.add(CopyFileAreaPathResolver.create());
        resolvers.add(new RemotePathResolver(connection));
        FallbackPathResolver resolver = new FallbackPathResolver(resolvers);
        if (fullPatch) {
            try {
                CreatePatchUtil.createPatch((CreatePatchDilemmaHandler)new CreatePatchDilemmaHandler(){}, (OutputStream)System.out, (ConfigurationChange)confChange, (ChangeDescription)changeDesc, (IPathResolver)resolver, null);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((TeamRepositoryException)e, (String)Messages.DiffCmd_22);
            }
        }
        try {
            paths = ResolvedConfigurationChangePaths.resolve((IPathResolver)resolver, (ConfigurationChange)confChange, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((TeamRepositoryException)e, (String)Messages.DiffCmd_23);
        }
        for (FileChange fileChange : confChange.getChanges()) {
            try {
                CreatePatchUtil.writeDiff((OutputStream)System.out, (FileChange)fileChange, (ResolvedConfigurationChangePaths)paths, null);
            }
            catch (IOException e) {
                throw StatusHelper.failure((String)Messages.DiffCmd_24, (Throwable)e);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((TeamRepositoryException)e, (String)Messages.DiffCmd_25);
            }
        }
    }

    private static class StateSelector {
        public static final String TYPE_FILE = "file";
        public static final String TYPE_WORKSPACE = "workspace";
        public static final String TYPE_STREAM = "stream";
        public static final String TYPE_BASELINE = "baseline";
        public static final String TYPE_CHANGESET = "changeset";
        private String type;
        private String selector;

        public StateSelector(String type, String selector) {
            this.type = type;
            this.selector = selector;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getSelector() {
            return this.selector;
        }

        public void setSelector(String selector) {
            this.selector = selector;
        }
    }
}

