/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.sharecommand;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.sharecommand.CliShareDilemmaHandler;
import com.ibm.team.filesystem.cli.client.internal.sharecommand.IShareWriter;
import com.ibm.team.filesystem.cli.client.internal.sharecommand.ShareCmdOpts;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.IndentingPrintStream;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.rcp.core.IEclipseFileSystemManager;
import com.ibm.team.filesystem.rcp.core.operations.IShareProjectsOperation;
import com.ibm.team.filesystem.rcp.core.operations.ShareDilemmaHandler;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShareCmd
extends AbstractSubcommand {
    boolean hasWorkspaceRoot = false;
    File shareRoot = null;
    List<File> toShare = null;

    public void run(IClientConfiguration config) throws FileSystemClientException {
        ICommandLine cli = config.getSubcommandCommandLine();
        ConnectionInfo info = config.getConnectionInfo();
        List projectRoots = cli.getOptions((IOptionKey)ShareCmdOpts.OPT_TO_SHARE);
        this.initializeRoots(config, projectRoots);
        SubcommandUtil.initializeEclipseWorkspaceRoot((File)this.shareRoot);
        IShareWriter writer = this.getWriter(config);
        writer.validated(this.shareRoot, this.toShare, this.hasWorkspaceRoot);
        this.doShare(config, info, cli.getOption((IOptionKey)ShareCmdOpts.OPT_WORKSPACE_SELECTOR), cli.getOption((IOptionKey)ShareCmdOpts.OPT_COMPONENT_SELECTOR), cli.hasOption((IOptionKey)ShareCmdOpts.OPT_IGNORE_EXISTING_SHARE), writer);
    }

    private void initializeRoots(IClientConfiguration config, List<String> projectRoots) throws FileSystemClientException {
        ArrayList<File> roots = new ArrayList<File>(projectRoots.size());
        for (String stringRoot : projectRoots) {
            File root = new File(stringRoot);
            if (!root.isAbsolute()) {
                root = new File(System.getProperty("user.dir"), stringRoot);
            }
            try {
                roots.add(root.getCanonicalFile());
            }
            catch (IOException e) {
                throw StatusHelper.internalError((String)NLS.bind((String)Messages.ShareCmd_0, (Object)root.toString()), (Exception)e);
            }
        }
        File commonParent = ((File)roots.get(0)).getParentFile();
        for (File root : roots) {
            File potentialParent = root.getParentFile();
            if (potentialParent == null) {
                potentialParent = new File(System.getProperty("user.dir"));
            }
            if (commonParent == null) {
                commonParent = potentialParent;
            }
            if (!commonParent.equals(potentialParent)) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ShareCmd_1, (Object)commonParent, (Object)root));
            }
            if (root.isDirectory()) continue;
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ShareCmd_2, (Object)root));
        }
        File workspaceRoot = SubcommandUtil.findAncestorCFARoot((File)commonParent);
        if (workspaceRoot != null && !commonParent.equals(workspaceRoot)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ShareCmd_3, (Object)commonParent, (Object)workspaceRoot));
        }
        this.hasWorkspaceRoot = workspaceRoot != null;
        this.shareRoot = commonParent;
        this.toShare = roots;
    }

    IShareWriter getWriter(IClientConfiguration config) {
        DefaultShareWriter writer = new DefaultShareWriter();
        ICommandLine cli = config.getSubcommandCommandLine();
        writer.setVerbose(cli.hasOption((IOptionKey)CommonOptions.OPT_VERBOSE));
        return writer;
    }

    private void doShare(IClientConfiguration config, ConnectionInfo info, String wsSelector, String compSelector, final boolean ignoreExistingShare, final IShareWriter writer) throws FileSystemClientException {
        final ITeamRepository repo = RepoUtil.login((IClientConfiguration)config, (ConnectionInfo)info);
        final ArrayList<IProject> projects = new ArrayList<IProject>(this.toShare.size());
        for (File root : this.toShare) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(root.getName());
            if (!project.exists()) {
                try {
                    project.create(null);
                }
                catch (CoreException e) {
                    throw StatusHelper.failure((String)NLS.bind((String)Messages.ShareCmd_7, (Object)root, (Object)e.getMessage()), (Throwable)e);
                }
            }
            assert (project.exists());
            try {
                project.open(null);
            }
            catch (CoreException e) {
                throw StatusHelper.failure((String)NLS.bind((String)Messages.ShareCmd_8, (Object)root), (Throwable)e);
            }
            try {
                project.refreshLocal(2, null);
            }
            catch (CoreException e) {
                throw StatusHelper.failure((String)NLS.bind((String)Messages.ShareCmd_9, (Object)root), (Throwable)e);
            }
            projects.add(project);
        }
        final IWorkspaceConnection ws = ShareCmd.findWorkspace(wsSelector, repo);
        final IComponentHandle comp = ShareCmd.findComponent(compSelector, ws, repo);
        final FileSystemClientException[] exception = new FileSystemClientException[1];
        new Runnable(){

            public void run() {
                IShareProjectsOperation shareOp = IEclipseFileSystemManager.instance.getShareProjectsOperation((ShareDilemmaHandler)new CliShareDilemmaHandler());
                shareOp.share(ws, null, comp, projects, ignoreExistingShare);
                try {
                    try {
                        System.out.println(Messages.ShareCmd_16);
                        shareOp.run(null);
                        writer.successfulShare(shareOp, repo);
                        return;
                    }
                    catch (TeamRepositoryException e) {
                        throw StatusHelper.wrap((TeamRepositoryException)e, (String)Messages.ShareCmd_10);
                    }
                }
                catch (FileSystemClientException e) {
                    if (e.getStatus() != null && e.getStatus().getCode() == 204) {
                        e = StatusHelper.disallowed((String)NLS.bind((String)Messages.ShareCmd_11, (Object)ShareCmdOpts.OPT_IGNORE_EXISTING_SHARE.getLongOpt()));
                    }
                    exception[0] = e;
                    return;
                }
            }
        }.run();
        if (exception[0] != null) {
            throw exception[0];
        }
    }

    private static IWorkspaceConnection findWorkspace(String wsSelector, ITeamRepository repo) throws FileSystemClientException {
        try {
            return RepoUtil.findNamedWorkspaceConnection((String)wsSelector, (boolean)true, (boolean)false, (ITeamRepository)repo);
        }
        catch (RepoUtil.UnmatchedSelectorException e) {
            SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)((Object)e));
            throw StatusHelper.ambiguousSelector((String)Messages.ShareCmd_12);
        }
        catch (RepoUtil.AmbiguousSelectorException e) {
            SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)((Object)e));
            throw StatusHelper.ambiguousSelector((String)Messages.ShareCmd_13);
        }
    }

    private static IComponentHandle findComponent(String compSelector, IWorkspaceConnection ws, ITeamRepository repo) throws FileSystemClientException {
        try {
            return (IComponentHandle)RepoUtil.findNamedComponents(Collections.singletonList(compSelector), (boolean)false, (IWorkspaceConnection)ws, (ITeamRepository)repo).get(0);
        }
        catch (RepoUtil.UnmatchedSelectorException e) {
            SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)((Object)e));
            throw StatusHelper.ambiguousSelector((String)Messages.ShareCmd_14);
        }
        catch (RepoUtil.AmbiguousSelectorException e) {
            SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)((Object)e));
            throw StatusHelper.ambiguousSelector((String)Messages.ShareCmd_15);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultShareWriter
    implements IShareWriter {
        boolean verbose = false;
        IndentingPrintStream out = new IndentingPrintStream((OutputStream)System.out);

        DefaultShareWriter() {
        }

        @Override
        public void setVerbose(boolean isVerbose) {
            this.verbose = isVerbose;
        }

        @Override
        public void validated(File shareRoot, List<File> toShare, boolean hasWorkspaceRoot) {
            if (!this.verbose) {
                return;
            }
            if (hasWorkspaceRoot) {
                this.out.println((CharSequence)NLS.bind((String)Messages.ShareCmd_4, (Object)shareRoot));
            } else {
                this.out.println((CharSequence)NLS.bind((String)Messages.ShareCmd_5, (Object)shareRoot));
            }
            IndentingPrintStream indented = this.out.indent();
            for (File share : toShare) {
                indented.println((CharSequence)share.toString());
            }
        }

        @Override
        public void successfulShare(IShareProjectsOperation shareOp, ITeamRepository repo) {
            this.out.println((CharSequence)Messages.ShareCmd_6);
        }
    }
}

